/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.CircleWithCenterAndRadius;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AlgebraicSumOfThreeSegments;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.Vector;

public class TouchingCircles
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public TouchingCircles(Circle firstCircle, Circle secondCircle) {
        this.geoObjects = new Vector();
        this.geoObjects.add(firstCircle);
        this.geoObjects.add(secondCircle);
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 2) {
            OpenGeoProver.settings.getLogger().error("There should be two circles.");
            return false;
        }
        Circle firstCircle = (Circle)this.geoObjects.get(0);
        Circle secondCircle = (Circle)this.geoObjects.get(1);
        if (firstCircle == null || secondCircle == null) {
            OpenGeoProver.settings.getLogger().error("Some circle is null.");
            return false;
        }
        if (firstCircle.getCenter() == null || secondCircle.getCenter() == null) {
            OpenGeoProver.settings.getLogger().error("Each circle must have constructed center.");
            return false;
        }
        if (firstCircle.getPoints().size() == 0 && !(firstCircle instanceof CircleWithCenterAndRadius) || secondCircle.getPoints().size() == 0 && !(secondCircle instanceof CircleWithCenterAndRadius)) {
            OpenGeoProver.settings.getLogger().error("Each circle must have defined radius.");
            return false;
        }
        return true;
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial bestCondition = null;
        int degreeOfBestCondition = 0;
        XPolynomial currCondition = null;
        int degreeOfCurrCondition = 0;
        Circle firstCircle = (Circle)this.geoObjects.get(0);
        Circle secondCircle = (Circle)this.geoObjects.get(1);
        Point O1 = firstCircle.getCenter();
        Point O2 = secondCircle.getCenter();
        AlgebraicSumOfThreeSegments segSum = null;
        if (firstCircle instanceof CircleWithCenterAndRadius) {
            Point A1 = ((CircleWithCenterAndRadius)firstCircle).getRadius().getFirstEndPoint();
            Point B1 = ((CircleWithCenterAndRadius)firstCircle).getRadius().getSecondEndPoint();
            if (secondCircle instanceof CircleWithCenterAndRadius) {
                Point A2 = ((CircleWithCenterAndRadius)secondCircle).getRadius().getFirstEndPoint();
                Point B2 = ((CircleWithCenterAndRadius)secondCircle).getRadius().getSecondEndPoint();
                segSum = new AlgebraicSumOfThreeSegments(O1, O2, A1, B1, A2, B2);
                currCondition = segSum.getAlgebraicForm();
                degreeOfCurrCondition = currCondition.getPolynomialDegree();
                if (bestCondition == null || degreeOfCurrCondition < degreeOfBestCondition || degreeOfCurrCondition == degreeOfBestCondition && currCondition.getTerms().size() < bestCondition.getTerms().size()) {
                    bestCondition = currCondition;
                    degreeOfBestCondition = degreeOfCurrCondition;
                }
            }
            int jj2 = secondCircle.getPoints().size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                segSum = new AlgebraicSumOfThreeSegments(O1, O2, A1, B1, O2, secondCircle.getPoints().get(ii2));
                currCondition = segSum.getAlgebraicForm();
                degreeOfCurrCondition = currCondition.getPolynomialDegree();
                if (bestCondition != null && degreeOfCurrCondition >= degreeOfBestCondition && (degreeOfCurrCondition != degreeOfBestCondition || currCondition.getTerms().size() >= bestCondition.getTerms().size())) continue;
                bestCondition = currCondition;
                degreeOfBestCondition = degreeOfCurrCondition;
            }
        }
        int jj1 = firstCircle.getPoints().size();
        for (int ii1 = 0; ii1 < jj1; ++ii1) {
            Point B1 = firstCircle.getPoints().get(ii1);
            if (secondCircle instanceof CircleWithCenterAndRadius) {
                Point A2 = ((CircleWithCenterAndRadius)secondCircle).getRadius().getFirstEndPoint();
                Point B2 = ((CircleWithCenterAndRadius)secondCircle).getRadius().getSecondEndPoint();
                segSum = new AlgebraicSumOfThreeSegments(O1, O2, O1, B1, A2, B2);
                currCondition = segSum.getAlgebraicForm();
                degreeOfCurrCondition = currCondition.getPolynomialDegree();
                if (bestCondition == null || degreeOfCurrCondition < degreeOfBestCondition || degreeOfCurrCondition == degreeOfBestCondition && currCondition.getTerms().size() < bestCondition.getTerms().size()) {
                    bestCondition = currCondition;
                    degreeOfBestCondition = degreeOfCurrCondition;
                }
            }
            int jj2 = secondCircle.getPoints().size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                segSum = new AlgebraicSumOfThreeSegments(O1, O2, O1, B1, O2, secondCircle.getPoints().get(ii2));
                currCondition = segSum.getAlgebraicForm();
                degreeOfCurrCondition = currCondition.getPolynomialDegree();
                if (bestCondition != null && degreeOfCurrCondition >= degreeOfBestCondition && (degreeOfCurrCondition != degreeOfBestCondition || currCondition.getTerms().size() >= bestCondition.getTerms().size())) continue;
                bestCondition = currCondition;
                degreeOfBestCondition = degreeOfCurrCondition;
            }
        }
        return bestCondition;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Circles ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        sb.append(" and ");
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        sb.append(" are touching each other");
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("Area method cannot deal with such statement for now.");
        return null;
    }
}

