/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.Power;
import com.ogprover.polynomials.SymbolicPolynomial;
import com.ogprover.polynomials.SymbolicTerm;
import com.ogprover.polynomials.SymbolicVariable;
import com.ogprover.polynomials.UXVariable;
import com.ogprover.polynomials.Variable;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.geoconstruction.Circle;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.IntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.HashMap;
import java.util.Vector;

public class TwoInversePoints
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";
    private static final String ALabel = "A";
    private static final String BLabel = "B";
    private static final String OLabel = "O";
    private static final String SLabel = "S";
    private Point intersectionPointS = null;

    public Point getIntersectionPointS() {
        return this.intersectionPointS;
    }

    public void setIntersectionPointS(Point intersectionPointS) {
        this.intersectionPointS = intersectionPointS;
    }

    public TwoInversePoints(Point firstPoint, Point secondPoint, Circle circle) {
        this.geoObjects = new Vector();
        this.geoObjects.add(firstPoint);
        this.geoObjects.add(secondPoint);
        this.geoObjects.add(circle);
    }

    private SymbolicPolynomial getXCondition() {
        SymbolicPolynomial xCondition = new SymbolicPolynomial();
        SymbolicVariable xA = new SymbolicVariable(2, ALabel);
        SymbolicVariable xB = new SymbolicVariable(2, BLabel);
        SymbolicVariable xO = new SymbolicVariable(2, OLabel);
        SymbolicVariable xS = new SymbolicVariable(2, SLabel);
        SymbolicTerm t = new SymbolicTerm(1.0);
        t.addPower(new Power(xA, 1));
        t.addPower(new Power(xB, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(xA, 1));
        t.addPower(new Power(xO, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(xB, 1));
        t.addPower(new Power(xO, 1));
        xCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(xS, 2));
        xCondition.addTerm(t);
        t = new SymbolicTerm(2.0);
        t.addPower(new Power(xS, 1));
        t.addPower(new Power(xO, 1));
        xCondition.addTerm(t);
        return xCondition;
    }

    private SymbolicPolynomial getYCondition() {
        SymbolicPolynomial yCondition = new SymbolicPolynomial();
        SymbolicVariable yA = new SymbolicVariable(3, ALabel);
        SymbolicVariable yB = new SymbolicVariable(3, BLabel);
        SymbolicVariable yO = new SymbolicVariable(3, OLabel);
        SymbolicVariable yS = new SymbolicVariable(3, SLabel);
        SymbolicTerm t = new SymbolicTerm(1.0);
        t.addPower(new Power(yA, 1));
        t.addPower(new Power(yB, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(yA, 1));
        t.addPower(new Power(yO, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(yB, 1));
        t.addPower(new Power(yO, 1));
        yCondition.addTerm(t);
        t = new SymbolicTerm(-1.0);
        t.addPower(new Power(yS, 2));
        yCondition.addTerm(t);
        t = new SymbolicTerm(2.0);
        t.addPower(new Power(yS, 1));
        t.addPower(new Power(yO, 1));
        yCondition.addTerm(t);
        return yCondition;
    }

    @Override
    public boolean isValid() {
        if (!super.isValid()) {
            return false;
        }
        if (this.geoObjects.size() < 3) {
            OpenGeoProver.settings.getLogger().error("There must be two points and one circle.");
            return false;
        }
        if (((Circle)this.getGeoObjects().get(2)).getCenter() == null) {
            OpenGeoProver.settings.getLogger().error("Circle must have constructed center.");
            return false;
        }
        return true;
    }

    private int setIntersectionPoint() {
        Point A = (Point)this.getGeoObjects().get(0);
        Point B = (Point)this.getGeoObjects().get(1);
        Circle k = (Circle)this.getGeoObjects().get(2);
        Point O = k.getCenter();
        if (this.intersectionPointS == null) {
            Line AB = null;
            boolean isExisting = false;
            for (GeoConstruction geoCons : this.consProtocol.getConstructionSteps()) {
                Vector<Point> linePoints;
                if (!(geoCons instanceof Line) || (linePoints = ((Line)geoCons).getPoints()).indexOf(A) < 0 || linePoints.indexOf(B) < 0) continue;
                AB = (Line)geoCons;
                isExisting = true;
                break;
            }
            if (AB == null) {
                AB = new LineThroughTwoPoints("SecantOfInversePoints", A, B);
                this.consProtocol.addGeoConstruction(AB);
                if (!((GeoConstruction)AB).isValidConstructionStep()) {
                    OpenGeoProver.settings.getLogger().error("Failed to validate the construction of secant of inverse points.");
                    return -1;
                }
                AB.addPointToSet(O);
            }
            if (isExisting) {
                Vector<Point> kPoints = k.getPoints();
                for (Point P : AB.getPoints()) {
                    if (kPoints.indexOf(P) < 0) continue;
                    this.intersectionPointS = P;
                    break;
                }
            }
            if (this.intersectionPointS == null) {
                this.intersectionPointS = new IntersectionPoint("tempPoint-S", AB, k);
                this.consProtocol.addGeoConstruction(this.intersectionPointS);
                if (!this.intersectionPointS.isValidConstructionStep()) {
                    OpenGeoProver.settings.getLogger().error("Failed to validate the construction of intersection point of circle and line through two given points.");
                    return -1;
                }
                if (((IntersectionPoint)this.intersectionPointS).transformToAlgebraicFormWithOutputPrintFlag(false) != 0) {
                    return -1;
                }
            }
        }
        return 0;
    }

    public XPolynomial getXAlgebraicForm() {
        if (this.setIntersectionPoint() != 0) {
            return null;
        }
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.getGeoObjects().get(0));
        pointsMap.put(BLabel, (Point)this.getGeoObjects().get(1));
        pointsMap.put(OLabel, ((Circle)this.getGeoObjects().get(2)).getCenter());
        pointsMap.put(SLabel, this.intersectionPointS);
        return OGPTP.instantiateCondition(this.getXCondition(), pointsMap);
    }

    public XPolynomial getYAlgebraicForm() {
        if (this.setIntersectionPoint() != 0) {
            return null;
        }
        HashMap<String, Point> pointsMap = new HashMap<String, Point>();
        pointsMap.put(ALabel, (Point)this.getGeoObjects().get(0));
        pointsMap.put(BLabel, (Point)this.getGeoObjects().get(1));
        pointsMap.put(OLabel, ((Circle)this.getGeoObjects().get(2)).getCenter());
        pointsMap.put(SLabel, this.intersectionPointS);
        return OGPTP.instantiateCondition(this.getYCondition(), pointsMap);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        Point A = (Point)this.getGeoObjects().get(0);
        Point B = (Point)this.getGeoObjects().get(1);
        UXVariable xA = A.getX();
        UXVariable xB = B.getX();
        if (((Variable)xA).getVariableType() == ((Variable)xB).getVariableType() && xA.getIndex() == xB.getIndex()) {
            return this.getYAlgebraicForm();
        }
        return this.getXAlgebraicForm();
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Point ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        sb.append(" is inverse to point ");
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        sb.append(" with respect to circle ");
        sb.append(((GeoConstruction)this.geoObjects.get(2)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        OpenGeoProver.settings.getLogger().error("The area method cannot deal with circle inversion.");
        return null;
    }
}

