/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.pp.tp.thmstatement;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.auxiliary.PointSetRelationshipManager;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.Difference;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.Line;
import com.ogprover.pp.tp.geoconstruction.LineThroughTwoPoints;
import com.ogprover.pp.tp.geoconstruction.PerpendicularLine;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.geoconstruction.RandomPointFromLine;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.PositionThmStatement;
import java.util.Vector;

public class TwoPerpendicularLines
extends PositionThmStatement {
    public static final String VERSION_NUM = "1.00";

    public TwoPerpendicularLines(Line firstLine, Line secondLine) {
        this.geoObjects = new Vector();
        this.geoObjects.add(firstLine);
        this.geoObjects.add(secondLine);
    }

    @Override
    public XPolynomial getAlgebraicForm() {
        XPolynomial bestCondition = null;
        int degreeOfBestCondition = 0;
        Line firstLine = (Line)this.geoObjects.get(0);
        Line secondLine = (Line)this.geoObjects.get(1);
        while (firstLine.getPoints().size() < 2) {
            RandomPointFromLine firstTempPoint = new RandomPointFromLine("tempPoint-" + firstLine.getPoints().size() + firstLine.getGeoObjectLabel(), firstLine);
            this.consProtocol.addGeoConstruction(firstTempPoint);
            if (!((GeoConstruction)firstTempPoint).isValidConstructionStep()) {
                OpenGeoProver.settings.getLogger().error("Failed to validate the construction of random point from line " + firstLine.getGeoObjectLabel());
                return null;
            }
            ((Point)firstTempPoint).transformToAlgebraicForm();
        }
        while (secondLine.getPoints().size() < 2) {
            RandomPointFromLine secondTempPoint = new RandomPointFromLine("tempPoint-" + secondLine.getPoints().size() + secondLine.getGeoObjectLabel(), secondLine);
            this.consProtocol.addGeoConstruction(secondTempPoint);
            if (!((GeoConstruction)secondTempPoint).isValidConstructionStep()) {
                OpenGeoProver.settings.getLogger().error("Failed to validate the construction of random point from line " + secondLine.getGeoObjectLabel());
                return null;
            }
            ((Point)secondTempPoint).transformToAlgebraicForm();
        }
        Vector<Point> firstLinePoints = firstLine.getPoints();
        int jj1 = firstLinePoints.size();
        for (int ii1 = 0; ii1 < jj1; ++ii1) {
            Point A = firstLinePoints.get(ii1);
            int jj2 = firstLinePoints.size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                Point B = firstLinePoints.get(ii2);
                if (B.getGeoObjectLabel().equals(A.getGeoObjectLabel())) continue;
                PerpendicularLine p = new PerpendicularLine("tempParallelLine", secondLine, A);
                this.consProtocol.addGeoConstruction(p);
                PointSetRelationshipManager manager = new PointSetRelationshipManager(p, B, 1);
                XPolynomial instantiatedCondition = manager.retrieveInstantiatedCondition();
                int tempDegree = instantiatedCondition.getPolynomialDegree();
                if (bestCondition == null || tempDegree < degreeOfBestCondition || tempDegree == degreeOfBestCondition && instantiatedCondition.getTerms().size() < bestCondition.getTerms().size()) {
                    bestCondition = instantiatedCondition;
                    degreeOfBestCondition = tempDegree;
                }
                this.consProtocol.getConstructionSteps().remove(this.consProtocol.getConstructionSteps().size() - 1);
            }
        }
        Vector<Point> secondLinePoints = secondLine.getPoints();
        int jj12 = secondLinePoints.size();
        for (int ii1 = 0; ii1 < jj12; ++ii1) {
            Point A = secondLinePoints.get(ii1);
            int jj2 = secondLinePoints.size();
            for (int ii2 = 0; ii2 < jj2; ++ii2) {
                Point B = secondLinePoints.get(ii2);
                if (B.getGeoObjectLabel().equals(A.getGeoObjectLabel())) continue;
                PerpendicularLine p = new PerpendicularLine("tempParallelLine", firstLine, A);
                this.consProtocol.addGeoConstruction(p);
                PointSetRelationshipManager manager = new PointSetRelationshipManager(p, B, 1);
                XPolynomial instantiatedCondition = manager.retrieveInstantiatedCondition();
                int tempDegree = instantiatedCondition.getPolynomialDegree();
                if (bestCondition == null || tempDegree < degreeOfBestCondition || tempDegree == degreeOfBestCondition && instantiatedCondition.getTerms().size() < bestCondition.getTerms().size()) {
                    bestCondition = instantiatedCondition;
                    degreeOfBestCondition = tempDegree;
                }
                this.consProtocol.getConstructionSteps().remove(this.consProtocol.getConstructionSteps().size() - 1);
            }
        }
        return bestCondition;
    }

    @Override
    public String getStatementDesc() {
        StringBuilder sb = new StringBuilder();
        sb.append("Line ");
        sb.append(((GeoConstruction)this.geoObjects.get(0)).getGeoObjectLabel());
        sb.append(" is perpendicular to line ");
        sb.append(((GeoConstruction)this.geoObjects.get(1)).getGeoObjectLabel());
        return sb.toString();
    }

    @Override
    public AreaMethodTheoremStatement getAreaMethodStatement() {
        LineThroughTwoPoints firstLine = (LineThroughTwoPoints)this.geoObjects.get(0);
        LineThroughTwoPoints secondLine = (LineThroughTwoPoints)this.geoObjects.get(1);
        Point a = firstLine.getPoints().get(0);
        Point b = firstLine.getPoints().get(1);
        Point c = secondLine.getPoints().get(0);
        Point d = secondLine.getPoints().get(1);
        PythagorasDifference areaOfABC = new PythagorasDifference(a, c, d);
        PythagorasDifference areaOfABD = new PythagorasDifference(b, c, d);
        Vector<AMExpression> statements = new Vector<AMExpression>();
        statements.add(new Difference(areaOfABC, areaOfABD));
        return new AreaMethodTheoremStatement(this.getStatementDesc(), statements);
    }
}

