/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.thmprover;

import com.ogprover.main.OpenGeoProver;
import com.ogprover.pp.tp.OGPTP;
import com.ogprover.pp.tp.auxiliary.UnknownStatementException;
import com.ogprover.pp.tp.expressions.AMExpression;
import com.ogprover.pp.tp.expressions.Fraction;
import com.ogprover.pp.tp.expressions.PythagorasDifference;
import com.ogprover.pp.tp.geoconstruction.AMFootPoint;
import com.ogprover.pp.tp.geoconstruction.AMIntersectionPoint;
import com.ogprover.pp.tp.geoconstruction.FreePoint;
import com.ogprover.pp.tp.geoconstruction.GeoConstruction;
import com.ogprover.pp.tp.geoconstruction.PRatioPoint;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.pp.tp.ndgcondition.SimpleNDGCondition;
import com.ogprover.pp.tp.thmstatement.AreaMethodTheoremStatement;
import com.ogprover.pp.tp.thmstatement.IdenticalPoints;
import com.ogprover.thmprover.TheoremProver;
import com.ogprover.utilities.logger.ILogger;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Vector;

public class AreaMethodProver
implements TheoremProver {
    private static boolean firstLaunch = true;
    private static HashMap<AreaMethodTheoremStatement, Boolean> alreadyProvedStatements;
    private static HashMap<Point, Point> replacementMap;
    private static HashSet<HashSet<Point>> knownCollinearPoints;
    public static boolean debugMode;
    public static boolean optimizeAreaOfCollinearPoints;
    public static boolean optimizeCouplesOfPoints;
    protected boolean transformToIndependantVariables = true;
    protected AreaMethodTheoremStatement statement;
    protected Vector<GeoConstruction> constructions;
    protected int nextPointToEliminate;
    protected Vector<AMExpression> steps = new Vector();
    protected Vector<SimpleNDGCondition> ndgConditions;

    public AreaMethodTheoremStatement getStatement() {
        return this.statement;
    }

    public Vector<GeoConstruction> getConstructions() {
        return this.constructions;
    }

    public Vector<SimpleNDGCondition> getNDGConditions() {
        return this.ndgConditions;
    }

    public void setTransformToIndependantVariables(boolean b) {
        this.transformToIndependantVariables = b;
    }

    public AreaMethodProver(OGPTP thmProtocol) {
        this.statement = thmProtocol.getTheoremStatement().getAreaMethodStatement();
        this.constructions = thmProtocol.getConstructionSteps();
        this.nextPointToEliminate = this.constructions.size() - 1;
        this.ndgConditions = thmProtocol.getSimpleNDGConditions();
        this.computeNextPointToEliminate();
    }

    public AreaMethodProver(AreaMethodTheoremStatement statement, Vector<GeoConstruction> constructions, Vector<SimpleNDGCondition> ndgConditions) {
        this.statement = statement;
        this.constructions = constructions;
        this.nextPointToEliminate = constructions.size() - 1;
        this.ndgConditions = ndgConditions;
        this.computeNextPointToEliminate();
    }

    @Override
    public int prove() {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (firstLaunch) {
            firstLaunch = false;
            if (optimizeCouplesOfPoints) {
                this.computeCoupleOfPoints();
            }
            if (optimizeAreaOfCollinearPoints) {
                this.computeCollinearPoints();
            }
        }
        if (alreadyProvedStatements.containsKey(this.statement)) {
            AreaMethodProver.debug("Statement to prove : " + this.statement.getName());
            if (alreadyProvedStatements.get(this.statement).booleanValue()) {
                AreaMethodProver.debug("-> We have already proved that it was true");
                return 1;
            }
            AreaMethodProver.debug("-> We have already proved that it was false");
            return 0;
        }
        AreaMethodProver.debug("Description of the intern representation of the construction :");
        for (GeoConstruction cons : this.constructions) {
            AreaMethodProver.debug("  " + cons.getConstructionDesc());
        }
        AreaMethodProver.debug("Description of the NDGs conditions :");
        if (this.ndgConditions != null) {
            for (SimpleNDGCondition ndgCons : this.ndgConditions) {
                AreaMethodProver.debug("  " + ndgCons.print());
            }
        }
        AreaMethodProver.debug("Statement to prove " + this.statement.getName());
        if (this.statement == null) {
            logger.error("Statement is null");
            return 2;
        }
        AreaMethodProver.debug("Number of expressions in the statement : " + Integer.toString(this.statement.getStatements().size()));
        this.grosDebug();
        for (AMExpression expr : this.statement.getStatements()) {
            AreaMethodProver.debug("We must prove that : " + expr.print() + " = 0");
            this.steps.add(expr);
            AMExpression current = expr;
            if (optimizeCouplesOfPoints) {
                AreaMethodProver.debug("After couples of point deletion : ", expr);
                current = current.replace(replacementMap);
            }
            this.computeNextPointToEliminate();
            while (this.nextPointToEliminate >= 0 && !current.isZero()) {
                AreaMethodProver.debug("Uniformization of : ", current);
                current = current.uniformize(knownCollinearPoints);
                AreaMethodProver.debug("Simplification of : ", current);
                current = current.simplify();
                String label = this.constructions.get(this.nextPointToEliminate).getGeoObjectLabel();
                AreaMethodProver.debug("Removing the point " + label + " of the formula : ", current);
                try {
                    current = current.eliminate((Point)this.constructions.get(this.nextPointToEliminate), this);
                }
                catch (UnknownStatementException e) {
                    logger.error("The point elimination required a intermediary lemma to be proved, and the sub-process crashed.");
                    logger.error("It occured on : " + e.getMessage());
                    return 2;
                }
                --this.nextPointToEliminate;
                this.computeNextPointToEliminate();
                AreaMethodProver.debug("Second uniformization of : ", current);
                current = current.uniformize(knownCollinearPoints);
                AreaMethodProver.debug("Second simplification of : ", current);
                current = current.simplify();
                AreaMethodProver.debug("Reducing into a single fraction of : ", current);
                current = current.reduceToSingleFraction();
                if (current instanceof Fraction) {
                    AreaMethodProver.debug("Removing of the denominator of : ", current);
                    current = ((Fraction)current).getNumerator();
                }
                AreaMethodProver.debug("Last simplification of : ", current);
                current = current.simplify();
                AreaMethodProver.debug("Reducing into a right associative form of : ", current);
            }
            AreaMethodProver.debug("Reducing into a single fraction of : ", current);
            current = current.reduceToSingleFraction();
            if (current instanceof Fraction) {
                AreaMethodProver.debug("Removing of the denominator of : ", current);
                current = ((Fraction)current).getNumerator();
            }
            AreaMethodProver.debug("Last simplification of : ", current);
            current = current.simplify();
            AreaMethodProver.debug("Transforming into a sum of products of geometrical quantities of : ", current);
            current = current.toSumOfProducts();
            AreaMethodProver.debug("Simplification of : ", current);
            if ((current = current.simplify()).isZero()) continue;
            if (!this.transformToIndependantVariables) {
                AreaMethodProver.debug("The expression is non-null and transformToIndependantVariable is false : aborting.");
                if (current.size() > 20) {
                    return 2;
                }
                AreaMethodProver.debug("Oh, well, actually, this expression is small, let's try to extend it anyway.");
            }
            AreaMethodProver.debug("Transformation to a formula with only independant variables of : ", current);
            try {
                current = current.toIndependantVariables(this);
            }
            catch (UnknownStatementException e) {
                logger.error("The transformation to a formula with independant variables required a intermediary lemma to be proved, and the sub-process crashed.");
                logger.error("It occured on : " + e.getMessage());
                return 2;
            }
            AreaMethodProver.debug("Uniformization of : ", current);
            current = current.uniformize(knownCollinearPoints);
            AreaMethodProver.debug("Simplification of : ", current);
            current = current.simplify();
            AreaMethodProver.debug("Reducing into a single fraction of : ", current);
            current = current.reduceToSingleFraction();
            if (current instanceof Fraction) {
                AreaMethodProver.debug("Removing of the denominator of : ", current);
                current = ((Fraction)current).getNumerator();
            }
            AreaMethodProver.debug("Simplification of : ", current);
            current = current.simplify();
            AreaMethodProver.debug("Transforming into a sum of products of geometrical quantities of : ", current);
            current = current.toSumOfProducts();
            AreaMethodProver.debug("Uniformization of : ", current);
            current = current.uniformize(knownCollinearPoints);
            AreaMethodProver.debug("Very last simplification of : ", current);
            current = current.simplify();
            AreaMethodProver.debug("Result : ", current);
            if (current.isZero()) {
                AreaMethodProver.debug("The formula equals zero : the statement is then proved");
                continue;
            }
            return 0;
        }
        return 1;
    }

    private void computeNextPointToEliminate() {
        while (this.nextPointToEliminate >= 0 && (!(this.constructions.get(this.nextPointToEliminate) instanceof Point) || this.constructions.get(this.nextPointToEliminate) instanceof FreePoint)) {
            --this.nextPointToEliminate;
        }
    }

    public static void debug(String str, AMExpression expr) {
        if (debugMode) {
            int MAX_SIZE;
            ILogger logger = OpenGeoProver.settings.getLogger();
            int size = expr.size();
            if (size >= (MAX_SIZE = 200)) {
                logger.debug(str + "Too large to be printed");
            } else {
                logger.debug(str + expr.print());
            }
            logger.debug("  (Size = " + Integer.toString(size) + ")");
        }
    }

    public static void debug(String str) {
        if (debugMode) {
            ILogger logger = OpenGeoProver.settings.getLogger();
            logger.debug(str);
        }
    }

    private void computeCollinearPoints() {
        if (knownCollinearPoints != null) {
            return;
        }
        knownCollinearPoints = new HashSet();
        int numberOfConstructions = this.constructions.size();
        for (int i = 0; i < numberOfConstructions; ++i) {
            for (int j = 0; j < numberOfConstructions; ++j) {
                for (int k = 0; k < numberOfConstructions; ++k) {
                    Point v;
                    Point u;
                    if (!(this.constructions.get(k) instanceof Point) || this.constructions.get(k) instanceof FreePoint) continue;
                    Point current = (Point)this.constructions.get(k);
                    if (current instanceof AMIntersectionPoint) {
                        u = ((AMIntersectionPoint)current).getU();
                        v = ((AMIntersectionPoint)current).getV();
                        this.addCollinearPoints(u, v, current);
                        Point p = ((AMIntersectionPoint)current).getP();
                        Point q = ((AMIntersectionPoint)current).getQ();
                        this.addCollinearPoints(p, q, current);
                        continue;
                    }
                    if (current instanceof AMFootPoint) {
                        u = ((AMFootPoint)current).getU();
                        v = ((AMFootPoint)current).getV();
                        this.addCollinearPoints(u, v, current);
                        continue;
                    }
                    if (!(current instanceof PRatioPoint)) continue;
                    Point w = ((PRatioPoint)current).getW();
                    Point u2 = ((PRatioPoint)current).getU();
                    Point v2 = ((PRatioPoint)current).getV();
                    HashSet<Point> wuv = new HashSet<Point>();
                    wuv.add(w);
                    wuv.add(u2);
                    wuv.add(v2);
                    if (!w.equals(u2) && !w.equals(v2) && !knownCollinearPoints.contains(wuv)) continue;
                    this.addCollinearPoints(u2, v2, current);
                    this.addCollinearPoints(u2, w, current);
                    this.addCollinearPoints(v2, w, current);
                }
            }
        }
    }

    private void addCollinearPoints(Point a, Point b, Point c) {
        HashSet<Point> set = new HashSet<Point>();
        set.add(a);
        set.add(b);
        set.add(c);
        Vector toAdd = new Vector();
        toAdd.add(set);
        for (HashSet<Point> s : knownCollinearPoints) {
            HashSet points = (HashSet)s.clone();
            if (!points.remove(a) || !points.remove(b)) continue;
            Point d = (Point)points.toArray()[0];
            HashSet<Point> newSet = new HashSet<Point>();
            newSet.add(a);
            newSet.add(c);
            newSet.add(d);
            toAdd.add(newSet);
            newSet = new HashSet();
            newSet.add(b);
            newSet.add(c);
            newSet.add(d);
            toAdd.add(newSet);
        }
        knownCollinearPoints.addAll(toAdd);
    }

    private void computeCoupleOfPoints() {
        int size = this.constructions.size();
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < i; ++j) {
                GeoConstruction cons1 = this.constructions.get(i);
                GeoConstruction cons2 = this.constructions.get(j);
                if (!(cons1 instanceof Point) || cons1 instanceof FreePoint || !(cons2 instanceof Point) || cons2 instanceof FreePoint) continue;
                Point pt1 = (Point)cons1;
                Point pt2 = (Point)cons2;
                AreaMethodTheoremStatement stat = new IdenticalPoints(pt1, pt2).getAreaMethodStatement();
                AreaMethodProver prover = new AreaMethodProver(stat, this.constructions, this.ndgConditions);
                prover.setTransformToIndependantVariables(false);
                AreaMethodProver.debug("=========== Calling a prover for a sub theorem ============");
                if (prover.prove() == 1) {
                    AreaMethodProver.debug("---> Couple of geometrically identical points found : " + pt1.getGeoObjectLabel() + " and " + pt2.getGeoObjectLabel() + " !");
                    replacementMap.put(pt2, pt1);
                    for (int k = j + 1; k < j; ++k) {
                        GeoConstruction pt = this.constructions.get(k);
                        if (!(pt instanceof Point)) continue;
                        Point newPt = ((Point)pt).replace(replacementMap);
                        this.constructions.set(k, newPt);
                        replacementMap.put((Point)pt, newPt);
                    }
                }
                AreaMethodProver.debug("=========== The sub-theorem prover just returned ============");
            }
        }
    }

    private void grosDebug() {
        AreaMethodProver.debug("===============DEBUG=================");
        FreePoint a = new FreePoint("a");
        FreePoint b = new FreePoint("b");
        FreePoint c = new FreePoint("c");
        PythagorasDifference pabc = new PythagorasDifference(a, b, c);
        PythagorasDifference pacb = new PythagorasDifference(a, c, b);
        PythagorasDifference pbac = new PythagorasDifference(b, a, c);
        PythagorasDifference pbca = new PythagorasDifference(b, c, a);
        PythagorasDifference pcab = new PythagorasDifference(c, a, b);
        PythagorasDifference pcba = new PythagorasDifference(c, b, a);
        PythagorasDifference expr = pabc;
        AreaMethodProver.debug("pabc : ", expr);
        AMExpression uniformized = ((AMExpression)expr).uniformize(knownCollinearPoints);
        AreaMethodProver.debug("uniformized : ", uniformized);
        expr = pacb;
        AreaMethodProver.debug("pacb : ", expr);
        uniformized = ((AMExpression)expr).uniformize(knownCollinearPoints);
        AreaMethodProver.debug("uniformized : ", uniformized);
        expr = pbac;
        AreaMethodProver.debug("pbac : ", expr);
        uniformized = ((AMExpression)expr).uniformize(knownCollinearPoints);
        AreaMethodProver.debug("uniformized : ", uniformized);
        expr = pbca;
        AreaMethodProver.debug("pbca : ", expr);
        uniformized = ((AMExpression)expr).uniformize(knownCollinearPoints);
        AreaMethodProver.debug("uniformized : ", uniformized);
        expr = pcab;
        AreaMethodProver.debug("pcab : ", expr);
        uniformized = ((AMExpression)expr).uniformize(knownCollinearPoints);
        AreaMethodProver.debug("uniformized : ", uniformized);
        expr = pcba;
        AreaMethodProver.debug("pcba : ", expr);
        uniformized = ((AMExpression)expr).uniformize(knownCollinearPoints);
        AreaMethodProver.debug("uniformized : ", uniformized);
        AreaMethodProver.debug("=====================================");
    }

    static {
        debugMode = false;
        optimizeAreaOfCollinearPoints = false;
        optimizeCouplesOfPoints = false;
        alreadyProvedStatements = new HashMap();
        replacementMap = new HashMap();
    }
}

