/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.thmprover;

import com.ogprover.main.OGPParameters;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.polynomials.GeoTheorem;
import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.thmprover.AlgebraicMethodProver;
import com.ogprover.utilities.io.OGPOutput;
import com.ogprover.utilities.logger.ILogger;
import java.io.IOException;

public class WuMethodProver
extends AlgebraicMethodProver {
    public WuMethodProver(GeoTheorem theorem) {
        this.theorem = theorem;
    }

    @Override
    public int prove() {
        StringBuilder sb;
        OGPParameters parameters = OpenGeoProver.settings.getParameters();
        OGPOutput output = OpenGeoProver.settings.getOutput();
        ILogger logger = OpenGeoProver.settings.getLogger();
        XPolySystem hypotheses = this.theorem.getHypotheses();
        XPolynomial statement = this.theorem.getStatement();
        boolean isSystemLinear = hypotheses.isSystemLinear();
        boolean writeToReport = parameters.createReport();
        logger.info("Triangulation of system...");
        if (writeToReport) {
            try {
                output.openSection("Invoking the theorem prover");
                sb = new StringBuilder();
                sb.append("The used proving method is ");
                if (parameters.getProver() == 0) {
                    sb.append("Wu's method.\n\n");
                } else if (parameters.getProver() == 1) {
                    sb.append("Groebner basis method.\n\n");
                }
                output.writePlainText(sb.toString());
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        int retCode = hypotheses.triangulate();
        if (writeToReport) {
            try {
                if (retCode == -3) {
                    output.openParagraph();
                    output.writePlainText("Triangulation has failed because large polynomial has been obtained during calculation.");
                    output.closeParagraph();
                } else if (retCode == -2) {
                    output.openParagraph();
                    output.writePlainText("Triangulation has failed because time for execution has been expired.");
                    output.closeParagraph();
                }
                output.closeSection();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        if (retCode < 0) {
            logger.error("Wu's prove method has failed to triangulate the system of hypotheses.");
            return retCode;
        }
        retCode = this.theorem.fillNDGConditionsForWuProver();
        if (retCode < 0 && writeToReport) {
            try {
                output.openParagraph();
                output.writePlainText("Failed reading of NDG Conditions.");
                output.closeParagraph();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        logger.info("Calculation of final reminder...");
        if (writeToReport) {
            try {
                output.openSection("Final Remainder");
                output.openSubSection("Final remainder for conjecture " + this.theorem.getName(), true);
                output.writePlainText("Calculating final remainder of the conclusion:\n");
                output.writePolynomial(-1, statement);
                output.writePlainText("with respect to the triangular system.\n\n");
                if (hypotheses.numOfPols() > 0) {
                    output.openEnum("enumerate");
                }
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        XPolynomial finalReminder = (XPolynomial)statement.clone();
        for (int ii = hypotheses.numOfPols() - 1; ii >= 0; --ii) {
            int varIndex = hypotheses.getVariableList().get(ii);
            if (writeToReport) {
                try {
                    output.openItem();
                    sb = new StringBuilder();
                    sb.append("Pseudo remainder with <ind_text><label>p</label><ind>");
                    sb.append(ii + 1);
                    sb.append("</ind></ind_text> over variable <ind_text><label>x</label><ind>");
                    sb.append(varIndex);
                    sb.append("</ind></ind_text>:\n");
                    output.writePlainText(sb.toString());
                    output.closeItem();
                }
                catch (IOException e) {
                    logger.error("Failed to write to output file(s).");
                    output.close();
                    return -1;
                }
            }
            if ((finalReminder = finalReminder.pseudoReminder(hypotheses.getXPoly(ii), varIndex)) == null) {
                logger.error("Wu's prove method has failed to calculate the final reminder due to error in pseudo division operation.");
                return OpenGeoProver.settings.getRetCodeOfPseudoDivision();
            }
            int numOfTerms = finalReminder.getTerms().size();
            if (numOfTerms > parameters.getSpaceLimit()) {
                logger.error("Polynomial exceeds maximal allowed number of terms.");
                if (writeToReport) {
                    try {
                        output.openParagraph();
                        output.writePlainText("Calculation of final reminder has failed because large polynomial has been obtained during calculation.");
                        output.closeParagraph();
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                        return -1;
                    }
                }
                return -3;
            }
            if (numOfTerms > OpenGeoProver.settings.getMaxNumOfTerms()) {
                OpenGeoProver.settings.setMaxNumOfTerms(numOfTerms);
            }
            if (OpenGeoProver.settings.getTimer().isTimeIsUp()) {
                logger.error("Time for execution of prover has been expired.");
                if (writeToReport) {
                    try {
                        output.openParagraph();
                        output.writePlainText("Calculation of final reminder has failed because time for prover execution has been expired.");
                        output.closeParagraph();
                    }
                    catch (IOException e) {
                        logger.error("Failed to write to output file(s).");
                        output.close();
                        return -1;
                    }
                }
                return -2;
            }
            if (!writeToReport) continue;
            try {
                output.writePolynomial(-1, finalReminder);
                continue;
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        if (writeToReport) {
            try {
                if (hypotheses.numOfPols() > 0) {
                    output.closeEnum("enumerate");
                }
                output.closeSubSection();
                output.closeSection();
            }
            catch (IOException e) {
                logger.error("Failed to write to output file(s).");
                output.close();
                return -1;
            }
        }
        if (finalReminder.isZero()) {
            return 1;
        }
        if (isSystemLinear) {
            return 0;
        }
        return 2;
    }
}

