/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.io;

import java.io.File;

public abstract class CustomFile {
    public static final String VERSION_NUM = "1.00";
    protected String destinationDirectoryPath = null;
    protected String baseFileName = null;
    protected String fileExtension = null;

    public String getDestinationDirectoryPath() {
        return this.destinationDirectoryPath;
    }

    public void setDestinationDirectoryPath(String destinationDirectoryPath) {
        this.destinationDirectoryPath = destinationDirectoryPath;
    }

    public String getBaseFileName() {
        return this.baseFileName;
    }

    public void setBaseFileName(String baseFileName) {
        this.baseFileName = baseFileName;
    }

    public String getFileExtension() {
        return this.fileExtension;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    protected void initFilePathElements(String dirName, String fileName, String fileExtension) {
        this.destinationDirectoryPath = dirName == null ? System.getProperty("user.dir") : CustomFile.buildAbsolutePath(dirName);
        this.baseFileName = fileExtension != null && fileName.endsWith('.' + fileExtension) ? fileName.substring(0, fileName.lastIndexOf(46)) : fileName;
        this.fileExtension = fileExtension;
    }

    protected void extractFilePathElementsFromAbsFilePath(String absoluteFilePath) {
        if (absoluteFilePath == null || absoluteFilePath.length() == 0 || !CustomFile.isFilePathAbsolute(absoluteFilePath)) {
            return;
        }
        int lastFileSeparatorIdx = absoluteFilePath.lastIndexOf(File.separatorChar);
        if (lastFileSeparatorIdx == absoluteFilePath.length() - 1) {
            return;
        }
        this.destinationDirectoryPath = lastFileSeparatorIdx == 0 ? CustomFile.getRootDirPath() : absoluteFilePath.substring(0, lastFileSeparatorIdx);
        String baseFileNameWithExt = absoluteFilePath.substring(lastFileSeparatorIdx + 1);
        int lastDotIdx = baseFileNameWithExt.lastIndexOf(46);
        if (lastDotIdx == -1) {
            this.baseFileName = baseFileNameWithExt;
            this.fileExtension = null;
        } else {
            this.baseFileName = baseFileNameWithExt.substring(0, lastDotIdx);
            this.fileExtension = lastDotIdx == baseFileNameWithExt.length() - 1 ? null : baseFileNameWithExt.substring(lastDotIdx + 1);
        }
    }

    public static String getRootDirPath() {
        char fileSeparatorChar = File.separatorChar;
        if (fileSeparatorChar == '\\') {
            return "C:" + File.separator;
        }
        if (fileSeparatorChar == '/') {
            return "" + File.separator;
        }
        return null;
    }

    public static boolean isFilePathAbsolute(String filePath) {
        if (filePath == null) {
            return false;
        }
        char fileSeparatorChar = File.separatorChar;
        if (fileSeparatorChar == '\\') {
            char ch3;
            char ch1 = filePath.length() > 0 ? filePath.charAt(0) : (char)'\u0000';
            char ch2 = filePath.length() > 1 ? filePath.charAt(1) : (char)'\u0000';
            char c = ch3 = filePath.length() > 2 ? filePath.charAt(2) : (char)'\u0000';
            return (ch1 >= 'A' && ch1 <= 'Z' || ch1 >= 'a' && ch1 <= 'z') && ch2 == ':' && ch3 == fileSeparatorChar;
        }
        if (fileSeparatorChar == '/') {
            char ch1;
            char c = ch1 = filePath.length() > 0 ? filePath.charAt(0) : (char)'\u0000';
            return ch1 == fileSeparatorChar;
        }
        return false;
    }

    public static String buildAbsolutePath(String path) {
        if (path == null) {
            return null;
        }
        if (CustomFile.isFilePathAbsolute(path)) {
            return path;
        }
        String currDirPath = System.getProperty("user.dir");
        if (!currDirPath.endsWith(File.separator)) {
            currDirPath = currDirPath + File.separator;
        }
        return currDirPath + path;
    }

    public static String getFileAbsolutePath(File file) {
        return file.getAbsolutePath();
    }

    public static String buildBaseFileName(String fileNameWithoutExtension, String fileExtension) {
        return fileExtension != null && fileExtension.length() > 0 ? fileNameWithoutExtension + "." + fileExtension : fileNameWithoutExtension;
    }

    public static String buildAbsoluteFilePath(String destDirPath, String baseFileName) {
        if (destDirPath == null || destDirPath.length() == 0) {
            return CustomFile.buildAbsolutePath(baseFileName);
        }
        if (destDirPath.endsWith(File.separator)) {
            return CustomFile.buildAbsolutePath(destDirPath + baseFileName);
        }
        return CustomFile.buildAbsolutePath(destDirPath + File.separator + baseFileName);
    }
}

