/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.io;

import com.ogprover.utilities.io.CustomFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;

public class CustomFileReader
extends CustomFile {
    public static final String VERSION_NUM = "1.00";
    public static final String INPUT_DIR_NAME = "input";
    private File inputFile = null;
    private InputStreamReader inputSR = null;
    private BufferedReader buffReader = null;

    public File getInputFile() {
        return this.inputFile;
    }

    private void initInputFile() throws IOException {
        File inDir = new File(this.destinationDirectoryPath);
        if (!inDir.exists() || !inDir.isDirectory()) {
            throw new IllegalArgumentException("File with path " + this.destinationDirectoryPath + " doesn't exist or is not a directory.");
        }
        this.inputFile = new File(inDir, CustomFile.buildBaseFileName(this.baseFileName, this.fileExtension));
        this.inputSR = new InputStreamReader((InputStream)new FileInputStream(this.inputFile), Charset.forName("UTF-8"));
        this.buffReader = new BufferedReader(this.inputSR);
    }

    public CustomFileReader(String dirName, String fileName, String fileExtension) throws IOException {
        this.initFilePathElements(dirName, fileName, fileExtension);
        this.initInputFile();
    }

    public CustomFileReader(String fileName, String fileExtension) throws IOException {
        this(INPUT_DIR_NAME, fileName, fileExtension);
    }

    public CustomFileReader(String fileName) throws IOException {
        if (CustomFile.isFilePathAbsolute(fileName)) {
            this.extractFilePathElementsFromAbsFilePath(fileName);
        } else {
            this.initFilePathElements(INPUT_DIR_NAME, fileName, null);
        }
        this.initInputFile();
    }

    public String readLine() throws IOException {
        if (this.buffReader != null) {
            return this.buffReader.readLine();
        }
        return null;
    }

    public void close() {
        if (this.buffReader != null) {
            try {
                this.buffReader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

