/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.io;

import com.ogprover.utilities.io.CustomFile;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CustomFileWriter
extends CustomFile {
    public static final String VERSION_NUM = "1.00";
    public static final int BUFFER_SIZE = 4096;
    public static final String OUTPUT_DIR_NAME = "output";
    private File outputFile = null;
    private OutputStream outputStream = null;
    private BufferedOutputStream buffOS = null;

    public File getOutputFile() {
        return this.outputFile;
    }

    private void initOutputFile() throws IOException {
        File outDir = new File(this.destinationDirectoryPath);
        if (!outDir.exists()) {
            outDir.mkdir();
        } else if (!outDir.isDirectory()) {
            throw new IllegalArgumentException("File with path " + this.destinationDirectoryPath + " is not a directory.");
        }
        this.outputFile = new File(outDir, CustomFile.buildBaseFileName(this.baseFileName, this.fileExtension));
        this.outputStream = new FileOutputStream(this.outputFile);
        this.buffOS = new BufferedOutputStream(this.outputStream);
    }

    public CustomFileWriter(String dirName, String fileName, String fileExtension) throws IOException {
        this.initFilePathElements(dirName, fileName, fileExtension);
        this.initOutputFile();
    }

    public CustomFileWriter(String fileName, String fileExtension) throws IOException {
        this(OUTPUT_DIR_NAME, fileName, fileExtension);
    }

    public CustomFileWriter(String fileName) throws IOException {
        if (CustomFile.isFilePathAbsolute(fileName)) {
            this.extractFilePathElementsFromAbsFilePath(fileName);
        } else {
            this.initFilePathElements(OUTPUT_DIR_NAME, fileName, null);
        }
        this.initOutputFile();
    }

    public void write(String s) throws IOException {
        if (s == null) {
            return;
        }
        char[] charBuffer = s.toCharArray();
        byte[] byteBuffer = new byte[4096];
        int bytesRemaining = 0;
        int size = s.length();
        for (int ii = 0; ii < size; ++ii) {
            if (bytesRemaining >= 4096) {
                this.outputStream.write(byteBuffer);
                this.buffOS.flush();
                bytesRemaining = 0;
            }
            byteBuffer[bytesRemaining] = (byte)charBuffer[ii];
            ++bytesRemaining;
        }
        if (bytesRemaining > 0) {
            this.outputStream.write(byteBuffer, 0, bytesRemaining);
        }
        this.buffOS.flush();
    }

    public void close() {
        if (this.outputStream != null) {
            try {
                this.outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

