/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.io;

import com.ogprover.polynomials.XPolySystem;
import com.ogprover.polynomials.XPolynomial;
import com.ogprover.pp.tp.geoconstruction.Point;
import com.ogprover.utilities.io.CustomFileWriter;
import com.ogprover.utilities.io.SpecialFileFormatting;
import java.io.IOException;
import java.util.Vector;

public class LaTeXFileWriter
extends CustomFileWriter
implements SpecialFileFormatting {
    private boolean documentOpened = false;
    private boolean sectionOpened = false;
    private boolean subSectionOpened = false;
    private boolean paragraphOpened = false;
    private Vector<String> lastEnumCommandList = new Vector();

    public LaTeXFileWriter(String fileName) throws IOException {
        super(fileName, "tex");
    }

    @Override
    public void openDocument(String documentType, String title, String author) throws IOException {
        if (this.documentOpened) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("\\documentclass[a4paper]{");
        if (documentType != null) {
            sb.append(documentType);
        } else {
            sb.append("article");
        }
        sb.append("}\n\\usepackage{gclc_proof}\n\n\n\\begin{document}\n\n\\title{");
        if (title != null) {
            sb.append(title);
        } else {
            sb.append("[theorem title not provided]");
        }
        sb.append("}\n\n\\author{");
        if (author != null) {
            sb.append(author);
        } else {
            sb.append("[author name not provided]");
        }
        sb.append("}\n\n\\maketitle\n\n\n\n\n\n");
        this.write(sb.toString());
        this.documentOpened = true;
    }

    @Override
    public void closeDocument() throws IOException {
        if (!this.documentOpened) {
            return;
        }
        if (this.lastEnumCommandList != null) {
            while (this.lastEnumCommandList.size() > 0) {
                this.closeEnum(this.lastEnumCommandList.get(0));
            }
            this.lastEnumCommandList.clear();
        }
        if (this.paragraphOpened) {
            this.closeParagraph();
        }
        if (this.subSectionOpened) {
            this.closeSubSection();
        }
        if (this.sectionOpened) {
            this.closeSection();
        }
        this.write("\n\\end{document}\n");
        this.documentOpened = false;
    }

    @Override
    public void openSection(String title) throws IOException {
        if (this.lastEnumCommandList != null) {
            while (this.lastEnumCommandList.size() > 0) {
                this.closeEnum(this.lastEnumCommandList.get(0));
            }
            this.lastEnumCommandList.clear();
        }
        if (this.paragraphOpened) {
            this.closeParagraph();
        }
        if (this.subSectionOpened) {
            this.closeSubSection();
        }
        if (this.sectionOpened) {
            this.closeSection();
        }
        this.sectionOpened = true;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n\n\n\\section{");
        sb.append(title);
        sb.append("}\n\n");
        this.write(sb.toString());
    }

    @Override
    public void closeSection() throws IOException {
        this.sectionOpened = false;
    }

    @Override
    public void openSubSection(String title, boolean hasNumeration) throws IOException {
        if (this.lastEnumCommandList != null) {
            while (this.lastEnumCommandList.size() > 0) {
                this.closeEnum(this.lastEnumCommandList.get(0));
            }
            this.lastEnumCommandList.clear();
        }
        if (this.paragraphOpened) {
            this.closeParagraph();
        }
        if (this.subSectionOpened) {
            this.closeSubSection();
        }
        this.subSectionOpened = true;
        StringBuilder sb = new StringBuilder();
        sb.append("\n\n\n\n\\subsection");
        if (hasNumeration) {
            sb.append("{");
        } else {
            sb.append("*{");
        }
        sb.append(title);
        sb.append("}\n\n");
        this.write(sb.toString());
    }

    @Override
    public void closeSubSection() throws IOException {
        this.subSectionOpened = false;
    }

    @Override
    public void openParagraph() throws IOException {
        if (this.lastEnumCommandList != null) {
            while (this.lastEnumCommandList.size() > 0) {
                this.closeEnum(this.lastEnumCommandList.get(0));
            }
            this.lastEnumCommandList.clear();
        }
        if (this.paragraphOpened) {
            this.closeParagraph();
        }
        this.paragraphOpened = true;
        this.write("\n\n");
    }

    @Override
    public void closeParagraph() throws IOException {
        this.write("\n");
        this.paragraphOpened = false;
    }

    @Override
    public void openEnum(String enumCommand) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\\begin{");
        sb.append(enumCommand);
        sb.append("}\n\n");
        this.write(sb.toString());
        if (this.lastEnumCommandList != null) {
            this.lastEnumCommandList.add(0, new String(enumCommand));
        }
    }

    @Override
    public void closeEnum(String enumCommand) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\\end{");
        sb.append(enumCommand);
        sb.append("}\n\n");
        this.write(sb.toString());
        if (this.lastEnumCommandList != null) {
            this.lastEnumCommandList.remove(0);
        }
    }

    @Override
    public void openItem() throws IOException {
        this.write("\\item ");
    }

    @Override
    public void closeItem() throws IOException {
    }

    @Override
    public void openItemWithDesc(String desc) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\\item [");
        sb.append(this.processTextWithIndices(desc));
        sb.append("] ");
        this.write(sb.toString());
    }

    @Override
    public void closeItemWithDesc(String desc) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(" ");
        sb.append(this.processTextWithIndices(desc));
        this.write(sb.toString());
    }

    private String processTextWithIndices(String text) {
        StringBuilder sb = new StringBuilder();
        int indexOfOpenIndTextTag = -1;
        int indexOfCloseIndTextTag = -1;
        int startIndexOfResidualPart = 0;
        int indexOfOpenLabelTag = -1;
        int indexOfCloseLabelTag = -1;
        int indexOfOpenIndTag = -1;
        int indexOfCloseIndTag = -1;
        String firstPart = null;
        String tagPart = null;
        String residualPart = text;
        boolean endOfLoop = false;
        do {
            indexOfOpenIndTextTag = residualPart.indexOf("<ind_text>");
            indexOfCloseIndTextTag = residualPart.indexOf("</ind_text>");
            startIndexOfResidualPart = indexOfCloseIndTextTag + 11;
            if (indexOfOpenIndTextTag == -1 || indexOfCloseIndTextTag == -1 || indexOfCloseIndTextTag <= indexOfOpenIndTextTag) {
                sb.append(residualPart);
                endOfLoop = true;
                continue;
            }
            firstPart = residualPart.substring(0, indexOfOpenIndTextTag);
            tagPart = residualPart.substring(indexOfOpenIndTextTag, startIndexOfResidualPart);
            residualPart = residualPart.substring(startIndexOfResidualPart);
            sb.append(firstPart);
            indexOfOpenLabelTag = tagPart.indexOf("<label>");
            indexOfCloseLabelTag = tagPart.indexOf("</label>");
            indexOfOpenIndTag = tagPart.indexOf("<ind>");
            indexOfCloseIndTag = tagPart.indexOf("</ind>");
            if (indexOfOpenLabelTag == -1 || indexOfCloseLabelTag == -1 || indexOfCloseLabelTag <= indexOfOpenLabelTag || indexOfOpenIndTag == -1 || indexOfCloseIndTag == -1 || indexOfCloseIndTag <= indexOfOpenIndTag) {
                sb.append(tagPart);
                continue;
            }
            sb.append("$");
            sb.append(tagPart.substring(indexOfOpenLabelTag + 7, indexOfCloseLabelTag));
            sb.append("_{");
            sb.append(tagPart.substring(indexOfOpenIndTag + 5, indexOfCloseIndTag));
            sb.append("}$");
        } while (!endOfLoop);
        return sb.toString();
    }

    @Override
    public void writePlainText(String text) throws IOException {
        this.write(this.processTextWithIndices(text));
    }

    @Override
    public void writeFormattedText(String text, int formatType) throws IOException {
        StringBuilder sb = new StringBuilder();
        switch (formatType) {
            case 0: {
                sb.append(text);
                break;
            }
            case 1: {
                sb.append(text);
                sb.append("\n");
                break;
            }
            case 2: {
                sb.append("\\textbf{");
                sb.append(text);
                sb.append("}\n\n");
                break;
            }
            default: {
                sb.append(text);
            }
        }
        this.write(sb.toString());
    }

    @Override
    public void writeProofText(String text) throws IOException {
        this.writeFormattedText(text, 0);
    }

    @Override
    public void writeSingleLine(String text) throws IOException {
        this.writeFormattedText(text, 1);
    }

    @Override
    public void writeBoldText(String text) throws IOException {
        this.writeFormattedText(text, 2);
    }

    @Override
    public void writeEnumDescription(String desc) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(desc);
        sb.append("] ");
        this.write(sb.toString());
    }

    @Override
    public void writeEnumItem(String text) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("\\item ");
        sb.append(text);
        sb.append("\n\n");
        this.write(sb.toString());
    }

    @Override
    public void writePointCoordinatesAssignment(Point P) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("Point ");
        sb.append(P.getGeoObjectLabel());
        sb.append(" has been assigned following coordinates: ($");
        sb.append(P.getX().printToLaTeX());
        sb.append("$, $");
        sb.append(P.getY().printToLaTeX());
        sb.append("$)\n");
        this.write(sb.toString());
    }

    @Override
    public void writePointWithCoordinates(Point P) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append(P.getGeoObjectLabel());
        sb.append("($");
        sb.append(P.getX().printToLaTeX());
        sb.append("$, $");
        sb.append(P.getY().printToLaTeX());
        sb.append("$)");
        this.write(sb.toString());
    }

    @Override
    public void writePolynomial(int index, XPolynomial xpoly) throws IOException {
        StringBuilder sb = new StringBuilder();
        int outIndex = index + 1;
        int numOfTerms = xpoly.getTerms().size();
        if (numOfTerms > 255) {
            sb.append("\n\\hspace*{2em} \\parbox{0.65\\textwidth}{\\textit{Polynomial too big for output (number of terms is $");
            sb.append(numOfTerms);
            sb.append("$)}}\n\n");
        } else {
            String latexXPoly = xpoly.printToLaTeX();
            int len = latexXPoly.length();
            if (len > 2000 || latexXPoly.startsWith("??")) {
                sb.append("\n\\hspace*{2em} \\parbox{0.65\\textwidth}{\\textit{Polynomial too big for output (text size is ");
                if (latexXPoly.startsWith("??")) {
                    sb.append("greater than $");
                    sb.append(2000);
                } else {
                    sb.append("$");
                    sb.append(len);
                }
                sb.append("$ characters, number of terms is $");
                sb.append(numOfTerms);
                sb.append("$)}}\n\n");
            } else {
                sb.append("\n\\begin{eqnarray*}\n");
                if (index < -1) {
                    sb.append("p & = & ");
                } else if (index <= -1) {
                    sb.append("g & = & ");
                } else {
                    sb.append("p_{" + outIndex + "} & = & ");
                }
                int startIndex = 0;
                String tempPolyOutput = latexXPoly;
                int endIndex = tempPolyOutput.indexOf("$$");
                boolean firstChunk = true;
                while (endIndex >= 0) {
                    if (!firstChunk) {
                        sb.append("\\\\ \n & & ");
                    } else {
                        firstChunk = false;
                    }
                    sb.append(tempPolyOutput.substring(startIndex, endIndex));
                    startIndex = endIndex + 2;
                    if (startIndex < tempPolyOutput.length()) {
                        tempPolyOutput = tempPolyOutput.substring(startIndex);
                        endIndex = tempPolyOutput.indexOf("$$");
                        startIndex = 0;
                        continue;
                    }
                    tempPolyOutput = null;
                    endIndex = -1;
                }
                if (tempPolyOutput != null && tempPolyOutput.length() > 0) {
                    if (!firstChunk) {
                        sb.append("\\\\ \n & & ");
                    }
                    sb.append(tempPolyOutput);
                }
                sb.append("\n\\end{eqnarray*}\n");
            }
        }
        this.write(sb.toString());
    }

    @Override
    public void writePolynomial(XPolynomial xpoly) throws IOException {
        this.writePolynomial(-2, xpoly);
    }

    @Override
    public void writePolySystem(XPolySystem xpolySys) throws IOException {
        if (xpolySys == null || xpolySys.getPolynomials().size() == 0) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        int ii = 1;
        boolean firstPoly = true;
        sb.append("\n\\begin{eqnarray*}\n");
        for (XPolynomial xp : xpolySys.getPolynomials()) {
            int numOfTerms = xp.getTerms().size();
            if (!firstPoly) {
                sb.append("\\\\ \n");
            } else {
                firstPoly = false;
            }
            sb.append("p_{" + ii + "} & = & ");
            if (numOfTerms > 255) {
                sb.append("\\ldots");
            } else {
                String latexXPoly = xp.printToLaTeX();
                int len = latexXPoly.length();
                if (len > 2000 || latexXPoly.startsWith("??")) {
                    sb.append("\\ldots");
                } else {
                    int startIndex = 0;
                    String tempPolyOutput = latexXPoly;
                    int endIndex = tempPolyOutput.indexOf("$$");
                    boolean firstChunk = true;
                    while (endIndex >= 0) {
                        if (!firstChunk) {
                            sb.append("\\\\ \n & & ");
                        } else {
                            firstChunk = false;
                        }
                        sb.append(tempPolyOutput.substring(startIndex, endIndex));
                        startIndex = endIndex + 2;
                        if (startIndex < tempPolyOutput.length()) {
                            tempPolyOutput = tempPolyOutput.substring(startIndex);
                            endIndex = tempPolyOutput.indexOf("$$");
                            startIndex = 0;
                            continue;
                        }
                        tempPolyOutput = null;
                        endIndex = -1;
                    }
                    if (tempPolyOutput != null && tempPolyOutput.length() > 0) {
                        if (!firstChunk) {
                            sb.append("\\\\ \n & & ");
                        }
                        sb.append(tempPolyOutput);
                    }
                }
            }
            ++ii;
        }
        sb.append("\n\\end{eqnarray*}\n");
        this.write(sb.toString());
    }

    @Override
    public boolean isDocumentOpened() {
        return this.documentOpened;
    }

    @Override
    public boolean isSectionOpened() {
        return this.sectionOpened;
    }

    @Override
    public boolean isSubSectionOpened() {
        return this.subSectionOpened;
    }

    @Override
    public boolean isParagraphOpened() {
        return this.paragraphOpened;
    }
}

