/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.io;

import com.ogprover.geogebra.GeoGebraTheorem;
import com.ogprover.geogebra.command.GeoGebraCommand;
import com.ogprover.geogebra.command.GeoGebraCommandFactory;
import com.ogprover.geogebra.command.ProveCmd;
import com.ogprover.geogebra.command.construction.FreePointCmd;
import com.ogprover.geogebra.command.construction.GeoGebraConstructionCommand;
import com.ogprover.geogebra.command.statement.GeoGebraStatementCommand;
import com.ogprover.main.OpenGeoProver;
import com.ogprover.utilities.io.DocHandler;
import com.ogprover.utilities.logger.ILogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Vector;
import org.xml.sax.SAXException;

public class OGPDocHandler
implements DocHandler {
    public static final String VERSION_NUM = "1.00";
    public static final int TAG_TYPE_UNKNOWN = -1;
    public static final int TAG_TYPE_NONE = 0;
    public static final int TAG_TYPE_CONSTRUCTION = 1;
    public static final int TAG_TYPE_ELEMENT = 2;
    public static final int TAG_TYPE_COMMAND = 3;
    public static final int TAG_TYPE_SUB_ELEMENT = 4;
    public static final int TAG_TYPE_SUB_COMMAND = 5;
    public static final int TAG_TYPE_EXPRESSION = 6;
    public static final String TAG_NAME_CONSTRUCTION = "construction";
    public static final String TAG_NAME_ELEMENT = "element";
    public static final String TAG_NAME_COMMAND = "command";
    public static final String TAG_NAME_INPUT = "input";
    public static final String TAG_NAME_OUTPUT = "output";
    public static final String TAG_NAME_EXPRESSION = "expression";
    public static final String ATTR_NAME_TITLE = "title";
    public static final String ATTR_NAME_LABEL = "label";
    public static final String ATTR_NAME_NAME = "name";
    public static final String ATTR_NAME_TYPE = "type";
    public static final String ATTR_NAME_EXP = "exp";
    public static final String ATTR_NAME_GEN = "a";
    public static final char CH_QUESTION_EQ = '\u225f';
    public static final char CH_PARALLEL_TO = '\u2225';
    public static final char CH_PERPENDICULAR = '\u22a5';
    private GeoGebraTheorem ggThm = null;
    private Map<String, GeoGebraCommand> ggObjMap = new HashMap<String, GeoGebraCommand>();
    private int currentTagType;
    private String currentTagName;
    private String currCmdName;
    private ArrayList<String> currCmdInputArgs;
    private ArrayList<String> currCmdOutputArgs;
    private Map<String, String> expMap = new HashMap<String, String>();
    private boolean bSuccess = true;

    public GeoGebraTheorem getTheorem() {
        return this.ggThm;
    }

    public boolean isSuccess() {
        return this.bSuccess;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void startElement(String tag, LinkedHashMap<String, String> h) throws Exception {
        if (!this.bSuccess) {
            return;
        }
        ILogger logger = OpenGeoProver.settings.getLogger();
        this.currentTagName = tag;
        if (tag.equalsIgnoreCase(TAG_NAME_CONSTRUCTION)) {
            if (this.currentTagType != 0) {
                logger.error("Construction tag encountered when not expected.");
                this.bSuccess = false;
                return;
            }
            String theoremName = h.get(ATTR_NAME_TITLE);
            if (theoremName == null) {
                theoremName = "";
            }
            this.ggThm.setTheoremName(theoremName);
            this.currentTagType = 1;
            return;
        }
        if (tag.equalsIgnoreCase(TAG_NAME_ELEMENT)) {
            if (this.currentTagType != 1) {
                logger.error("Element tag encountered when not expected.");
                this.bSuccess = false;
                return;
            }
            String elementType = h.get(ATTR_NAME_TYPE);
            if (elementType == null) {
                logger.error("Not found \"type\" attribute of element tag.");
                this.bSuccess = false;
                return;
            }
            String elementLabel = h.get(ATTR_NAME_LABEL);
            if (elementLabel == null) {
                logger.error("Not found \"label\" attribute of element tag.");
                this.bSuccess = false;
                return;
            }
            GeoGebraCommand ggCmd = this.ggObjMap.get(elementLabel);
            if (ggCmd == null) {
                if (this.expMap.get(elementLabel) == null) {
                    if (!elementType.equalsIgnoreCase("point")) {
                        logger.error("Definition of object which is not introduced by command");
                        this.bSuccess = false;
                        return;
                    }
                    FreePointCmd newGGCmd = new FreePointCmd(elementLabel);
                    if (this.ggThm.getStatement() != null || this.ggThm.getProveCmd() != null) {
                        logger.error("Construction command read after statement or prove command");
                        this.bSuccess = false;
                        return;
                    }
                    this.ggThm.getConstructionList().add(newGGCmd);
                    this.ggObjMap.put(elementLabel, newGGCmd);
                }
            } else if (ggCmd instanceof GeoGebraConstructionCommand) {
                String cmdName = ggCmd.getCommandName();
                GeoGebraConstructionCommand consCmd = (GeoGebraConstructionCommand)ggCmd;
                if ((cmdName.equals("Mirror") || cmdName.equals("Rotate") || cmdName.equals("Translate") || cmdName.equals("Dilate")) && consCmd.getObjectType().equals("")) {
                    consCmd.setObjectType(elementType);
                }
            }
            this.currentTagType = 2;
            return;
        }
        if (tag.equalsIgnoreCase(TAG_NAME_COMMAND)) {
            if (this.currentTagType != 1) {
                logger.error("Command tag encountered when not expected.");
                this.bSuccess = false;
                return;
            }
            String commandName = h.get(ATTR_NAME_NAME);
            if (commandName == null) {
                logger.error("Failed to find name attribute of command tag.");
                this.bSuccess = false;
                return;
            }
            this.currCmdName = commandName;
            this.currentTagType = 3;
            return;
        }
        if (tag.equalsIgnoreCase(TAG_NAME_INPUT)) {
            if (this.currentTagType != 3) {
                logger.error("Input tag encountered when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currCmdInputArgs = new ArrayList();
            String genArg = null;
            Integer argNum = new Integer(0);
            while (true) {
                if ((genArg = h.get(ATTR_NAME_GEN + argNum.toString())) == null) {
                    this.currentTagType = 5;
                    return;
                }
                this.currCmdInputArgs.add(genArg);
                Integer n = argNum;
                Integer n2 = argNum = Integer.valueOf(argNum + 1);
            }
        }
        if (tag.equalsIgnoreCase(TAG_NAME_OUTPUT)) {
            if (this.currentTagType != 3) {
                logger.error("Output tag encountered when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currCmdOutputArgs = new ArrayList();
            String genArg = null;
            Integer argNum = new Integer(0);
            while (true) {
                if ((genArg = h.get(ATTR_NAME_GEN + argNum.toString())) == null) {
                    this.currentTagType = 5;
                    return;
                }
                this.currCmdOutputArgs.add(genArg);
                Integer n = argNum;
                Integer n3 = argNum = Integer.valueOf(argNum + 1);
            }
        }
        if (tag.equalsIgnoreCase(TAG_NAME_EXPRESSION)) {
            if (this.currentTagType != 1) {
                logger.error("Expression tag encountered when not expected.");
                this.bSuccess = false;
                return;
            }
            this.expMap.put(h.get(ATTR_NAME_LABEL), h.get(ATTR_NAME_EXP));
            this.currentTagType = 6;
            return;
        }
        if (this.currentTagType != 2) {
            logger.error("Unknown tag encountered.");
            this.currentTagType = -1;
            this.bSuccess = false;
            return;
        }
        this.currentTagType = 4;
    }

    @Override
    public void endElement(String tag) throws Exception {
        if (!this.bSuccess) {
            return;
        }
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (tag.equalsIgnoreCase(TAG_NAME_CONSTRUCTION)) {
            if (this.currentTagType != 1) {
                logger.error("Trying to close construction tag when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currentTagType = 0;
        } else if (tag.equalsIgnoreCase(TAG_NAME_ELEMENT)) {
            if (this.currentTagType != 2) {
                logger.error("Trying to close element tag when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currentTagType = 1;
        } else if (tag.equalsIgnoreCase(TAG_NAME_COMMAND)) {
            if (this.currentTagType != 3) {
                logger.error("Trying to close command tag when not expected.");
                this.bSuccess = false;
                return;
            }
            GeoGebraCommand ggCmd = GeoGebraCommandFactory.createGeoGebraCommand(this.currCmdName, this.currCmdInputArgs, this.currCmdOutputArgs, "");
            if (ggCmd == null) {
                logger.error("Failed to create command object for current command tag");
                this.bSuccess = false;
                return;
            }
            if (ggCmd instanceof GeoGebraConstructionCommand) {
                if (this.ggThm.getStatement() != null || this.ggThm.getProveCmd() != null) {
                    logger.error("Construction command read after statement or prove command");
                    this.bSuccess = false;
                    return;
                }
                this.ggThm.getConstructionList().add((GeoGebraConstructionCommand)ggCmd);
            } else if (ggCmd instanceof GeoGebraStatementCommand) {
                if (this.ggThm.getStatement() != null || this.ggThm.getProveCmd() != null) {
                    logger.error("Statament command read after statement or prove command");
                    this.bSuccess = false;
                    return;
                }
                this.ggThm.setStatement((GeoGebraStatementCommand)ggCmd);
            } else if (ggCmd instanceof ProveCmd) {
                if (this.ggThm.getProveCmd() != null) {
                    logger.error("Prove command read after prove command");
                    this.bSuccess = false;
                    return;
                }
                this.ggThm.setProveCmd((ProveCmd)ggCmd);
            } else {
                logger.error("Unknown GeoGebra command type");
                this.bSuccess = false;
                return;
            }
            for (String outLabel : this.currCmdOutputArgs) {
                if (outLabel.length() <= 0) continue;
                this.ggObjMap.put(outLabel, ggCmd);
            }
            this.currCmdName = null;
            this.currCmdInputArgs = null;
            this.currCmdOutputArgs = null;
            this.currentTagType = 1;
        } else if (tag.equalsIgnoreCase(TAG_NAME_INPUT)) {
            if (this.currentTagType != 5) {
                logger.error("Trying to close input tag when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currentTagType = 3;
        } else if (tag.equalsIgnoreCase(TAG_NAME_OUTPUT)) {
            if (this.currentTagType != 5) {
                logger.error("Trying to close output tag when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currentTagType = 3;
        } else if (tag.equalsIgnoreCase(TAG_NAME_EXPRESSION)) {
            if (this.currentTagType != 6) {
                logger.error("Trying to close expression tag when not expected.");
                this.bSuccess = false;
                return;
            }
            this.currentTagType = 1;
        } else {
            if (this.currentTagType != 4) {
                logger.error("Trying to close unknown tag.");
                this.currentTagType = -1;
                this.bSuccess = false;
                return;
            }
            this.currentTagType = 2;
        }
    }

    @Override
    public void startDocument() throws Exception {
        this.ggThm = new GeoGebraTheorem();
        this.ggObjMap.clear();
        this.currentTagType = 0;
        this.currentTagName = null;
        this.currCmdName = null;
        this.currCmdInputArgs = null;
        this.currCmdOutputArgs = null;
        this.expMap.clear();
        this.bSuccess = true;
    }

    @Override
    public void endDocument() throws Exception {
        ILogger logger = OpenGeoProver.settings.getLogger();
        if (this.currentTagType != 0) {
            String message = "XML input not valid.";
            this.bSuccess = false;
            logger.error(message);
            throw new SAXException(message);
        }
        if (!this.bSuccess) {
            String message = "Failed parsing";
            logger.error(message);
            throw new SAXException(message);
        }
        boolean bValidThm = true;
        if (this.ggThm == null) {
            bValidThm = false;
        } else {
            Vector<GeoGebraConstructionCommand> consList = this.ggThm.getConstructionList();
            if (consList == null) {
                bValidThm = false;
            } else if (this.ggThm.getProveCmd() == null) {
                bValidThm = false;
            } else if (this.ggThm.getStatement() == null) {
                GeoGebraStatementCommand ggStmCmd = this.createStatementFromProveCmd();
                if (ggStmCmd == null) {
                    bValidThm = false;
                } else {
                    this.ggThm.setStatement(ggStmCmd);
                }
            }
        }
        if (!bValidThm) {
            String message = "Parsed theorem is in incorrect format";
            logger.error(message);
            this.bSuccess = false;
            throw new SAXException(message);
        }
    }

    @Override
    public void text(String str) throws Exception {
    }

    @Override
    public int getConsStep() {
        return 0;
    }

    private GeoGebraStatementCommand createStatementFromProveCmd() {
        String statementName;
        ILogger logger = OpenGeoProver.settings.getLogger();
        String proveCmdInputText = this.ggThm.getProveCmd().getInputArg();
        if (proveCmdInputText == null) {
            logger.error("Statement in bad format - missing statement text");
            return null;
        }
        ArrayList<String> statementArgs = new ArrayList<String>();
        String uppperCaseStatText = new String(proveCmdInputText).toUpperCase();
        if (uppperCaseStatText.equals("TRUE") || uppperCaseStatText.equals("FALSE")) {
            statementName = "boolean";
            statementArgs.add(uppperCaseStatText);
        } else {
            String statementText = this.expMap.get(proveCmdInputText);
            if (statementText == null) {
                statementText = proveCmdInputText;
            }
            if (statementText.indexOf(8799) != -1) {
                String[] strArr = statementText.split(new Character('\u225f').toString());
                if (strArr.length != 2) {
                    logger.error("Statement in bad format - incorrect number of statement arguments in infix notation");
                    return null;
                }
                statementName = "AreEqual";
                statementArgs.add(strArr[0].trim());
                statementArgs.add(strArr[1].trim());
            } else if (statementText.indexOf(8741) != -1) {
                String[] strArr = statementText.split(new Character('\u2225').toString());
                if (strArr.length != 2) {
                    logger.error("Statement in bad format - incorrect number of statement arguments in infix notation");
                    return null;
                }
                statementName = "AreParallel";
                statementArgs.add(strArr[0].trim());
                statementArgs.add(strArr[1].trim());
            } else if (statementText.indexOf(8869) != -1) {
                String[] strArr = statementText.split(new Character('\u22a5').toString());
                if (strArr.length != 2) {
                    logger.error("Statement in bad format - incorrect number of statement arguments in infix notation");
                    return null;
                }
                statementName = "ArePerpendicular";
                statementArgs.add(strArr[0].trim());
                statementArgs.add(strArr[1].trim());
            } else {
                int length = statementText.length();
                int lbracIdx = statementText.indexOf(91);
                int rbracIdx = statementText.lastIndexOf(93);
                if (lbracIdx == -1 || rbracIdx == -1) {
                    logger.error("Statement in bad format - missing bracket");
                    return null;
                }
                if (length != rbracIdx + 1) {
                    logger.error("Statement in bad format - statement text doesn't end with right bracket");
                    return null;
                }
                statementName = statementText.substring(0, lbracIdx);
                if (statementName.length() == 0) {
                    logger.error("Statement in bad format - missing statement name");
                    return null;
                }
                String args = statementText.substring(lbracIdx + 1, rbracIdx);
                OpenGeoProver.settings.getLogger().debug("Args before parsing : " + args);
                int openBrackets = 0;
                int beginningOfArgument = 0;
                int s = args.length();
                for (int i = 0; i < s; ++i) {
                    if (args.charAt(i) == ',' && openBrackets == 0) {
                        statementArgs.add(args.substring(beginningOfArgument, i).trim());
                        beginningOfArgument = i + 1;
                        continue;
                    }
                    if (args.charAt(i) == '(' || args.charAt(i) == '[') {
                        ++openBrackets;
                        continue;
                    }
                    if (args.charAt(i) != ')' && args.charAt(i) != ']') continue;
                    --openBrackets;
                }
                statementArgs.add(args.substring(beginningOfArgument, args.length()).trim());
            }
        }
        Long rndLabelNum = new Long(Math.round(Math.random() * 1000.0));
        String statResultLabel = "statRes_" + rndLabelNum.toString();
        ArrayList<String> outputArgs = new ArrayList<String>();
        outputArgs.add(statResultLabel);
        GeoGebraCommand ggCmd = GeoGebraCommandFactory.createGeoGebraCommand(statementName, statementArgs, outputArgs, "");
        if (ggCmd == null || !(ggCmd instanceof GeoGebraStatementCommand)) {
            return null;
        }
        return (GeoGebraStatementCommand)ggCmd;
    }
}

