/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.io;

import com.ogprover.utilities.io.DocHandler;
import java.io.Reader;
import java.util.LinkedHashMap;
import java.util.Stack;

public class QDParser {
    private LinkedHashMap<String, String> attrs = new LinkedHashMap();
    private Stack<Integer> stack = new Stack();
    private StringBuilder sb = new StringBuilder();
    private StringBuilder etag = new StringBuilder();
    private final int CHAR_SPACE = 32;
    private final int CHAR_TAB = 9;
    private final int CHAR_CR = 13;
    private final int CHAR_NL = 10;
    private static final int TEXT = 1;
    private static final int ENTITY = 2;
    private static final int OPEN_TAG = 3;
    private static final int CLOSE_TAG = 4;
    private static final int START_TAG = 5;
    private static final int ATTRIBUTE_LVALUE = 6;
    private static final int ATTRIBUTE_EQUAL = 9;
    private static final int ATTRIBUTE_RVALUE = 10;
    private static final int QUOTE = 7;
    private static final int IN_TAG = 8;
    private static final int SINGLE_TAG = 12;
    private static final int COMMENT = 13;
    private static final int DONE = 11;
    private static final int DOCTYPE = 14;
    private static final int PRE = 15;
    private static final int CDATA = 16;

    private boolean isWhitespace(char c) {
        return c == ' ' || c == '\t' || c == '\r' || c == '\n';
    }

    public void reset() {
        this.attrs.clear();
        this.stack.clear();
        this.sb = new StringBuilder();
        this.etag = new StringBuilder();
        System.gc();
    }

    private static int popMode(Stack<Integer> st) {
        if (!st.empty()) {
            return st.pop();
        }
        return 15;
    }

    public final void parse(DocHandler doc, Reader r) throws Exception {
        this.stack.clear();
        int depth = 0;
        int mode = 15;
        int c = 0;
        int quotec = 34;
        depth = 0;
        this.sb.setLength(0);
        this.etag.setLength(0);
        String tagName = null;
        String lvalue = null;
        String rvalue = null;
        this.attrs.clear();
        doc.startDocument();
        int line = 1;
        int col = 0;
        boolean eol = false;
        while ((c = r.read()) != -1) {
            if (c == 10 && eol) {
                eol = false;
                continue;
            }
            if (eol) {
                eol = false;
            } else if (c == 10) {
                ++line;
                col = 0;
            } else if (c == 13) {
                eol = true;
                c = 10;
                ++line;
                col = 0;
            } else {
                ++col;
            }
            block0 : switch (mode) {
                case 11: {
                    doc.endDocument();
                    return;
                }
                case 1: {
                    switch (c) {
                        case 60: {
                            this.stack.push(new Integer(mode));
                            mode = 5;
                            if (this.sb.length() <= 0) break block0;
                            doc.text(this.sb.toString());
                            this.sb.setLength(0);
                            break block0;
                        }
                        case 38: {
                            this.stack.push(new Integer(mode));
                            mode = 2;
                            this.etag.setLength(0);
                            break block0;
                        }
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 4: {
                    switch (c) {
                        case 62: {
                            mode = QDParser.popMode(this.stack);
                            tagName = this.sb.toString();
                            this.sb.setLength(0);
                            if (--depth == 0) {
                                mode = 11;
                            }
                            doc.endElement(tagName);
                            break block0;
                        }
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 16: {
                    if (c == 62 && this.sb.toString().endsWith("]]")) {
                        this.sb.setLength(this.sb.length() - 2);
                        doc.text(this.sb.toString());
                        this.sb.setLength(0);
                        mode = QDParser.popMode(this.stack);
                        break;
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 13: {
                    if (c == 62 && this.sb.toString().endsWith("--")) {
                        this.sb.setLength(0);
                        mode = QDParser.popMode(this.stack);
                        break;
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 15: {
                    if (c != 60) break;
                    mode = 1;
                    this.stack.push(new Integer(mode));
                    mode = 5;
                    break;
                }
                case 14: {
                    if (c != 62 || (mode = QDParser.popMode(this.stack)) != 1) break;
                    mode = 15;
                    break;
                }
                case 5: {
                    mode = QDParser.popMode(this.stack);
                    switch (c) {
                        case 47: {
                            this.stack.push(new Integer(mode));
                            mode = 4;
                            break block0;
                        }
                        case 63: {
                            mode = 14;
                            break block0;
                        }
                    }
                    this.stack.push(new Integer(mode));
                    mode = 3;
                    tagName = null;
                    this.sb.append((char)c);
                    break;
                }
                case 2: {
                    if (c == 59) {
                        mode = QDParser.popMode(this.stack);
                        String cent = this.etag.toString();
                        this.etag.setLength(0);
                        if (cent.equals("lt")) {
                            this.sb.append('<');
                            break;
                        }
                        if (cent.equals("gt")) {
                            this.sb.append('>');
                            break;
                        }
                        if (cent.equals("amp")) {
                            this.sb.append('&');
                            break;
                        }
                        if (cent.equals("quot")) {
                            this.sb.append('\"');
                            break;
                        }
                        if (cent.equals("apos")) {
                            this.sb.append('\'');
                            break;
                        }
                        if (cent.startsWith("#x")) {
                            this.sb.append((char)Integer.parseInt(cent.substring(2), 16));
                            break;
                        }
                        if (cent.startsWith("#")) {
                            this.sb.append((char)Integer.parseInt(cent.substring(1)));
                            break;
                        }
                        QDParser.exc("Unknown entity: &" + cent + ";", line, col);
                        break;
                    }
                    this.etag.append((char)c);
                    break;
                }
                case 12: {
                    if (tagName == null) {
                        tagName = this.sb.toString();
                    }
                    if (c != 62) {
                        QDParser.exc("Expected > for tag: <" + tagName + "/>", line, col);
                    }
                    doc.startElement(tagName, this.attrs);
                    doc.endElement(tagName);
                    if (depth == 0) {
                        doc.endDocument();
                        return;
                    }
                    this.sb.setLength(0);
                    this.attrs.clear();
                    tagName = null;
                    mode = QDParser.popMode(this.stack);
                    break;
                }
                case 3: {
                    switch (c) {
                        case 62: {
                            if (tagName == null) {
                                tagName = this.sb.toString();
                            }
                            this.sb.setLength(0);
                            ++depth;
                            doc.startElement(tagName, this.attrs);
                            tagName = null;
                            this.attrs.clear();
                            mode = QDParser.popMode(this.stack);
                            break block0;
                        }
                        case 47: {
                            mode = 12;
                            break block0;
                        }
                        case 45: {
                            if (this.sb.toString().equals("!-")) {
                                mode = 13;
                                break block0;
                            }
                            this.sb.append((char)c);
                            break block0;
                        }
                        case 91: {
                            if (!this.sb.toString().equals("![CDATA")) break block0;
                            mode = 16;
                            this.sb.setLength(0);
                            break block0;
                        }
                        case 69: {
                            if (!this.sb.toString().equals("!DOCTYP")) break block0;
                            this.sb.setLength(0);
                            mode = 14;
                            break block0;
                        }
                    }
                    if (this.isWhitespace((char)c)) {
                        tagName = this.sb.toString();
                        this.sb.setLength(0);
                        mode = 8;
                        break;
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 7: {
                    if (c == quotec) {
                        rvalue = this.sb.toString();
                        this.sb.setLength(0);
                        this.attrs.put(lvalue, rvalue);
                        mode = 8;
                        break;
                    }
                    if (c == 38) {
                        this.stack.push(new Integer(mode));
                        mode = 2;
                        this.etag.setLength(0);
                        break;
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 10: {
                    if (c == 34 || c == 39) {
                        quotec = c;
                        mode = 7;
                        break;
                    }
                    if (this.isWhitespace((char)c)) break;
                    QDParser.exc("Error in attribute processing", line, col);
                    break;
                }
                case 6: {
                    if (this.isWhitespace((char)c)) {
                        lvalue = this.sb.toString();
                        this.sb.setLength(0);
                        mode = 9;
                        break;
                    }
                    if (c == 61) {
                        lvalue = this.sb.toString();
                        this.sb.setLength(0);
                        mode = 10;
                        break;
                    }
                    this.sb.append((char)c);
                    break;
                }
                case 9: {
                    if (c == 61) {
                        mode = 10;
                        break;
                    }
                    if (this.isWhitespace((char)c)) break;
                    QDParser.exc("Error in attribute processing.", line, col);
                    break;
                }
                case 8: {
                    switch (c) {
                        case 62: {
                            mode = QDParser.popMode(this.stack);
                            doc.startElement(tagName, this.attrs);
                            ++depth;
                            tagName = null;
                            this.attrs.clear();
                            break block0;
                        }
                        case 47: {
                            mode = 12;
                            break block0;
                        }
                    }
                    if (this.isWhitespace((char)c)) break;
                    mode = 6;
                    this.sb.append((char)c);
                }
            }
        }
        if (mode == 11) {
            doc.endDocument();
        } else {
            QDParser.exc("missing end tag", line, col);
        }
    }

    private static void exc(String s, int line, int col) throws Exception {
        throw new Exception(s + " near line " + line + ", column " + col);
    }
}

