/*
 * Decompiled with CFR 0.152.
 */
package com.ogprover.utilities.logger;

import com.ogprover.utilities.io.CustomFile;
import com.ogprover.utilities.logger.ILogger;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TreeSet;

public class GeoGebraLogger
implements ILogger {
    public static final String VERSION_NUM = "1.00";
    public static final String DEFAULT_LOG_DIR = "log";
    private static Set<String> reportedImplementationNeeded = new TreeSet<String>();
    public static Level EMERGENCY = new Level(0, "EMERGENCY");
    public static Level ALERT = new Level(1, "ALERT");
    public static Level CRITICAL = new Level(2, "CRITICAL");
    public static Level ERROR = new Level(3, "ERROR");
    public static Level WARN = new Level(4, "WARN");
    public static Level NOTICE = new Level(5, "NOTICE");
    public static Level INFO = new Level(7, "INFO");
    public static Level DEBUG = new Level(8, "DEBUG");
    public static Level TRACE = new Level(9, "TRACE");
    private Level logLevel = DEBUG;
    private LogDestination logDestination = LogDestination.CONSOLES;
    private boolean timeShown = true;
    private boolean callerShown = true;
    private File logFile = null;
    private FileWriter logFileWriter = null;

    @Override
    public synchronized void fatal(String msg) {
        this.log(EMERGENCY, msg);
    }

    @Override
    public synchronized void error(String msg) {
        this.log(ERROR, msg);
    }

    @Override
    public synchronized void warn(String msg) {
        this.log(WARN, msg);
    }

    @Override
    public synchronized void info(String msg) {
        this.log(INFO, msg);
    }

    @Override
    public synchronized void debug(String msg) {
        this.log(DEBUG, msg);
    }

    @Override
    public synchronized void trace(String msg) {
        this.log(TRACE, msg);
    }

    public void setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
    }

    public void setLogLevel(String logLevel) {
        if (logLevel == null) {
            return;
        }
        if ("ALERT".equals(logLevel)) {
            this.logLevel = ALERT;
        }
        if ("EMERGENCY".equals(logLevel)) {
            this.logLevel = EMERGENCY;
        }
        if ("CRITICAL".equals(logLevel)) {
            this.logLevel = CRITICAL;
        }
        if ("ERROR".equals(logLevel)) {
            this.logLevel = ERROR;
        }
        if ("WARN".equals(logLevel)) {
            this.logLevel = WARN;
        }
        if ("INFO".equals(logLevel)) {
            this.logLevel = INFO;
        }
        if ("NOTICE".equals(logLevel)) {
            this.logLevel = NOTICE;
        }
        if ("DEBUG".equals(logLevel)) {
            this.logLevel = DEBUG;
        }
        if ("TRACE".equals(logLevel)) {
            this.logLevel = TRACE;
        }
    }

    public Level getLogLevel() {
        return this.logLevel;
    }

    public void setLogDestination(LogDestination logDestination) {
        this.logDestination = logDestination;
    }

    public LogDestination getLogDestination() {
        return this.logDestination;
    }

    public boolean isTimeShown() {
        return this.timeShown;
    }

    public void setTimeShown(boolean timeShown) {
        this.timeShown = timeShown;
    }

    public boolean isCallerShown() {
        return this.callerShown;
    }

    public void setCallerShown(boolean callerShown) {
        this.callerShown = callerShown;
    }

    public void log(Level level, String message) {
        if (message == null) {
            message = "*null*";
        }
        if (this.logLevel.getPriority() >= level.getPriority()) {
            String caller = "";
            if (this.callerShown) {
                caller = this.getCaller();
                if (message.length() >= 21 && message.toLowerCase().substring(0, 21).equals("implementation needed") && !reportedImplementationNeeded.contains(caller)) {
                    reportedImplementationNeeded.add(caller);
                }
                caller = caller + ": ";
            }
            String timeInfo = "";
            if (this.timeShown && (timeInfo = this.getTimeInfo()) != "") {
                timeInfo = timeInfo + " ";
            }
            String logEntry = timeInfo + level.text + ": " + caller + message;
            this.print(logEntry, level);
        }
    }

    protected void print(String logEntry, Level level) {
        if (this.getLogDestination() == LogDestination.WEB_CONSOLE || this.getLogDestination() == LogDestination.CONSOLES) {
            this.setLogDestination(LogDestination.CONSOLE);
            this.log(WARN, "WEB_CONSOLE logging is not supported in desktop, falling back to use CONSOLE instead");
        }
        if (this.getLogDestination() == LogDestination.FILE) {
            if (this.logFileWriter != null) {
                try {
                    this.logFileWriter.append(logEntry + "\n");
                    this.logFileWriter.flush();
                    return;
                }
                catch (IOException e) {
                    this.setLogDestination(LogDestination.CONSOLE);
                    this.log(WARN, "Error writing log file");
                    this.print(logEntry, level);
                    return;
                }
            }
            this.setLogDestination(LogDestination.CONSOLE);
        }
        if (this.getLogDestination() == LogDestination.CONSOLE) {
            if (level.getPriority() <= ERROR.getPriority()) {
                System.err.println(logEntry);
            } else {
                System.out.println(logEntry);
            }
            return;
        }
    }

    public void setLogFile(String logFileName) {
        if (this.logFile != null && this.logFileWriter != null) {
            try {
                this.logFileWriter.close();
            }
            catch (IOException e) {
                this.log(WARN, "Previous log file cannot be closed");
            }
        }
        this.logFile = new File(logFileName);
        try {
            this.logFileWriter = new FileWriter(this.logFile);
        }
        catch (IOException e) {
            this.log(WARN, "Log file " + logFileName + "cannot be opened");
        }
    }

    protected String getTimeInfo() {
        String msecS;
        GregorianCalendar calendar = new GregorianCalendar();
        int min = calendar.get(12);
        String minS = min < 10 ? "0" + min : "" + min;
        int sec = calendar.get(13);
        String secS = sec < 10 ? "0" + sec : "" + sec;
        int msec = calendar.get(14);
        String string = msecS = msec < 100 ? "0" + msec : "" + msec;
        if (msec < 10) {
            msecS = "0" + msecS;
        }
        return calendar.get(11) + ":" + minS + ":" + secS + "." + msecS;
    }

    public String getMemoryInfo() {
        System.gc();
        System.gc();
        System.gc();
        System.gc();
        long usedK = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L;
        return "\n free memory: " + Runtime.getRuntime().freeMemory() + " total memory: " + Runtime.getRuntime().totalMemory() + " max memory: " + Runtime.getRuntime().maxMemory() + "\n used memory (total-free): " + usedK + "K";
    }

    public String getCaller() {
        int callerLineNumber;
        String callerMethodName = null;
        String callerClassName = null;
        try {
            Throwable t = new Throwable();
            StackTraceElement[] elements = t.getStackTrace();
            int ce = 3;
            callerMethodName = elements[ce].getMethodName();
            if ("debug".equals(callerMethodName)) {
                callerMethodName = elements[++ce].getMethodName();
            }
            callerClassName = elements[ce].getClassName();
            callerLineNumber = elements[ce].getLineNumber();
            if (callerClassName.equals("Unknown")) {
                if (callerMethodName.equals("$fillInStackTrace")) {
                    if (elements.length < 10) {
                        return "?";
                    }
                    return elements[9].getMethodName();
                }
                if (callerMethodName.equals("fillInStackTrace")) {
                    if (elements.length < 11) {
                        return "?";
                    }
                    return elements[10].getMethodName();
                }
                return callerMethodName;
            }
        }
        catch (Throwable t) {
            return "?";
        }
        return callerClassName + "." + callerMethodName + "[" + callerLineNumber + "]";
    }

    public static GeoGebraLogger factory(String logFileName, String logFileRootDirectory) {
        GeoGebraLogger logger = new GeoGebraLogger();
        logger.setLogLevel(INFO);
        logger.setLogDestination(LogDestination.FILE);
        String rootDirPath = logFileRootDirectory == null || logFileRootDirectory.length() == 0 ? DEFAULT_LOG_DIR : logFileRootDirectory;
        String baseFileName = !logFileName.contains(".") ? CustomFile.buildBaseFileName(logFileName, DEFAULT_LOG_DIR) : logFileName;
        String logPath = CustomFile.buildAbsoluteFilePath(rootDirPath, baseFileName);
        logger.setLogFile(logPath);
        return logger;
    }

    public static enum LogDestination {
        FILE,
        CONSOLE,
        WEB_CONSOLE,
        CONSOLES;

    }

    public static class Level {
        int priority;
        String text;

        Level(int priority, String text) {
            this.priority = priority;
            this.text = text;
        }

        public int getPriority() {
            return this.priority;
        }
    }
}

