/*
 * Copyright (c) 2012, 2022, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_br extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Africa_Central = new String[] {
               "eur Kreizafrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "eur c\u02bchoa\u00f1v Moskov",
               "",
               "eur ha\u00f1v Moskov",
               "",
               "eur Moskov",
               "",
            };
        final String[] Japan = new String[] {
               "eur c\u02bchoa\u00f1v Japan",
               "",
               "eur ha\u00f1v Japan",
               "",
               "eur Japan",
               "",
            };
        final String[] Pakistan = new String[] {
               "eur c\u02bchoa\u00f1v Pakistan",
               "",
               "eur ha\u00f1v Pakistan",
               "",
               "eur Pakistan",
               "",
            };
        final String[] Taipei = new String[] {
               "eur c\u02bchoa\u00f1v Taipei",
               "",
               "eur ha\u00f1v Taipei",
               "",
               "eur Taipei",
               "",
            };
        final String[] Australia_CentralWestern = new String[] {
               "eur c\u02bchoa\u00f1v Kreizaostralia ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Kreizaostralia ar C\u02bchorn\u00f4g",
               "",
               "eur Kreizaostralia ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Europe_Central = new String[] {
               "eur c\u02bchoa\u00f1v Kreizeuropa",
               "",
               "eur ha\u00f1v Kreizeuropa",
               "",
               "eur Kreizeuropa",
               "",
            };
        final String[] Sakhalin = new String[] {
               "eur c\u02bchoa\u00f1v Sakhalin",
               "",
               "eur ha\u00f1v Sakhalin",
               "",
               "eur Sakhalin",
               "",
            };
        final String[] Paraguay = new String[] {
               "eur c\u02bchoa\u00f1v Paraguay",
               "",
               "eur ha\u00f1v Paraguay",
               "",
               "eur Paraguay",
               "",
            };
        final String[] Malaysia = new String[] {
               "eur Malaysia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] America_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v ar Reter",
               "",
               "eur ha\u00f1v ar Reter",
               "",
               "eur ar Reter",
               "",
            };
        final String[] New_Zealand = new String[] {
               "eur c\u02bchoa\u00f1v Zeland-Nevez",
               "",
               "eur ha\u00f1v Zeland-Nevez",
               "",
               "eur Zeland-Nevez",
               "",
            };
        final String[] Yakutsk = new String[] {
               "eur c\u02bchoa\u00f1v Yakutsk",
               "",
               "eur ha\u00f1v Yakutsk",
               "",
               "eur Yakutsk",
               "",
            };
        final String[] Mauritius = new String[] {
               "eur c\u02bchoa\u00f1v Moris",
               "",
               "eur ha\u00f1v Moris",
               "",
               "eur Moris",
               "",
            };
        final String[] Africa_Eastern = new String[] {
               "eur Afrika ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] East_Timor = new String[] {
               "eur Timor ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "eur Inizi Salomon",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Marshall_Islands = new String[] {
               "eur Inizi Marshall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Europa ar Reter",
               "",
               "eur ha\u00f1v Europa ar Reter",
               "",
               "eur Europa ar Reter",
               "",
            };
        final String[] Newfoundland = new String[] {
               "eur c\u02bchoa\u00f1v Newfoundland",
               "",
               "eur ha\u00f1v Newfoundland",
               "",
               "eur Newfoundland",
               "",
            };
        final String[] Afghanistan = new String[] {
               "eur Afghanistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "eur c\u02bchoa\u00f1v Hong Kong",
               "",
               "eur ha\u00f1v Hong Kong",
               "",
               "eur Hong Kong",
               "",
            };
        final String[] Argentina_Western = new String[] {
               "eur c\u02bchoa\u00f1v Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "",
               "eur Arc\u02bchantina ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Bolivia = new String[] {
               "eur Bolivia",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "eur c\u02bchoa\u00f1v Sant-P\u00ear-ha-Mikelon",
               "",
               "eur ha\u00f1v Sant-P\u00ear-ha-Mikelon",
               "",
               "eur Sant-P\u00ear-ha-Mikelon",
               "",
            };
        final String[] Indochina = new String[] {
               "eur Indez-Sina",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "eur c\u02bchoa\u00f1v Yekaterinbourg",
               "",
               "eur ha\u00f1v Yekaterinbourg",
               "",
               "eur Yekaterinbourg",
               "",
            };
        final String[] Maldives = new String[] {
               "eur ar Maldivez",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "eur Tahiti",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "eur c\u02bchoa\u00f1v Israel",
               "",
               "eur ha\u00f1v Israel",
               "",
               "eur Israel",
               "",
            };
        final String[] Wallis = new String[] {
               "eur Wallis ha Futuna",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Africa_Southern = new String[] {
               "eur c\u02bchoa\u00f1v Suafrika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "eur c\u02bchoa\u00f1v Ouzbekistan",
               "",
               "eur ha\u00f1v Ouzbekistan",
               "",
               "eur Ouzbekistan",
               "",
            };
        final String[] Seychelles = new String[] {
               "eur Sechelez",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "eur c\u02bchoa\u00f1v Uruguay",
               "",
               "eur ha\u00f1v Uruguay",
               "",
               "eur Uruguay",
               "",
            };
        final String[] Nepal = new String[] {
               "eur Nepal",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "eur c\u02bchoa\u00f1v Ulaanbaatar",
               "",
               "eur ha\u00f1v Ulaanbaatar",
               "",
               "eur Ulaanbaatar",
               "",
            };
        final String[] Niue = new String[] {
               "eur Niue",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Falkland = new String[] {
               "eur c\u02bchoa\u00f1v Inizi Falkland",
               "",
               "eur ha\u00f1v Inizi Falkland",
               "",
               "eur Inizi Falkland",
               "",
            };
        final String[] Vanuatu = new String[] {
               "eur c\u02bchoa\u00f1v Vanuatu",
               "",
               "eur ha\u00f1v Vanuatu",
               "",
               "eur Vanuatu",
               "",
            };
        final String[] Novosibirsk = new String[] {
               "eur c\u02bchoa\u00f1v Novosibirsk",
               "",
               "eur ha\u00f1v Novosibirsk",
               "",
               "eur Novosibirsk",
               "",
            };
        final String[] Singapore = new String[] {
               "eur c\u02bchoa\u00f1v Singapour",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azores = new String[] {
               "eur c\u02bchoa\u00f1v an Azorez",
               "",
               "eur ha\u00f1v an Azorez",
               "",
               "eur an Azorez",
               "",
            };
        final String[] Apia = new String[] {
               "eur c\u02bchoa\u00f1v Apia",
               "",
               "eur ha\u00f1v Apia",
               "",
               "eur Apia",
               "",
            };
        final String[] Bhutan = new String[] {
               "eur Bhoutan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "eur Surinam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nauru = new String[] {
               "eur Nauru",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan_Western = new String[] {
               "eur Kazakstan ar C\u02bchorn\u00f4g",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Myanmar = new String[] {
               "eur Myanmar",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Christmas = new String[] {
               "eur Enez Christmas",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "eur c\u02bchoa\u00f1v an Amazon",
               "",
               "eur ha\u00f1v an Amazon",
               "",
               "eur an Amazon",
               "",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "eur Kazakstan ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Fiji = new String[] {
               "eur c\u02bchoa\u00f1v Fidji",
               "",
               "eur ha\u00f1v Fidji",
               "",
               "eur Fidji",
               "",
            };
        final String[] Reunion = new String[] {
               "eur ar Re\u00fcnion",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cocos = new String[] {
               "eur Inizi Kokoz",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "eur c\u02bchoa\u00f1v Chatham",
               "",
               "eur ha\u00f1v Chatham",
               "",
               "eur Chatham",
               "",
            };
        final String[] Argentina = new String[] {
               "eur c\u02bchoa\u00f1v Arc\u02bchantina",
               "",
               "eur ha\u00f1v Arc\u02bchantina",
               "",
               "eur Arc\u02bchantina",
               "",
            };
        final String[] Gambier = new String[] {
               "eur Gambier",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tuvalu = new String[] {
               "eur Tuvalu",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "eur Inizi Gal\u00e1pagos",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Macquarie = new String[] {
               "eur Enez Macquarie",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "eur Venezuela",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "eur c\u02bchoa\u00f1v Kreizaostralia",
               "",
               "eur ha\u00f1v Kreizaostralia",
               "",
               "eur Kreizaostralia",
               "",
            };
        final String[] Turkmenistan = new String[] {
               "eur c\u02bchoa\u00f1v Turkmenistan",
               "",
               "eur ha\u00f1v Turkmenistan",
               "",
               "eur Turkmenistan",
               "",
            };
        final String[] Europe_Western = new String[] {
               "eur c\u02bchoa\u00f1v Europa ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Europa ar C\u02bchorn\u00f4g",
               "",
               "eur Europa ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "eur c\u02bchoa\u00f1v ar C\u02bchab-Glas",
               "",
               "eur ha\u00f1v ar C\u02bchab-Glas",
               "",
               "eur ar C\u02bchab-Glas",
               "",
            };
        final String[] Norfolk = new String[] {
               "eur Enez Norfolk",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Guyana = new String[] {
               "eur Guyana",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pitcairn = new String[] {
               "eur Pitcairn",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "eur c\u02bchoa\u00f1v Samoa",
               "",
               "eur ha\u00f1v Samoa",
               "",
               "eur Samoa",
               "",
            };
        final String[] Palau = new String[] {
               "eur Palau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "eur c\u02bchoa\u00f1v Azerbaidjan",
               "",
               "eur ha\u00f1v Azerbaidjan",
               "",
               "eur Azerbaidjan",
               "",
            };
        final String[] Cuba = new String[] {
               "eur c\u02bchoa\u00f1v Kuba",
               "",
               "eur ha\u00f1v Kuba",
               "",
               "eur Kuba",
               "",
            };
        final String[] Africa_Western = new String[] {
               "eur c\u02bchoa\u00f1v Afrika ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Afrika ar C\u02bchorn\u00f4g",
               "",
               "eur Afrika ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] GMT = new String[] {
               "Amzer keitat Greenwich (AKG)",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Philippines = new String[] {
               "eur c\u02bchoa\u00f1v ar Filipinez",
               "",
               "eur ha\u00f1v ar Filipinez",
               "",
               "eur ar Filipinez",
               "",
            };
        final String[] French_Southern = new String[] {
               "eur Douaro\u00f9 aostral Fra\u00f1s hag Antarktika",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] South_Georgia = new String[] {
               "eur Georgia ar Su",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "eur c\u02bchoa\u00f1v Kaledonia Nevez",
               "",
               "eur ha\u00f1v Kaledonia Nevez",
               "",
               "eur Kaledonia Nevez",
               "",
            };
        final String[] Brunei = new String[] {
               "eur Brunei Darussalam",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "eur c\u02bchoa\u00f1v Iran",
               "",
               "eur ha\u00f1v Iran",
               "",
               "eur Iran",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "eur c\u02bchoa\u00f1v Enez Pask",
               "",
               "eur ha\u00f1v Enez Pask",
               "",
               "eur Enez Pask",
               "",
            };
        final String[] Mexico_Northwest = new String[] {
               "eur c\u02bchoa\u00f1v Gwalarn Mec\u02bchiko",
               "",
               "eur ha\u00f1v Gwalarn Mec\u02bchiko",
               "",
               "eur Gwalarn Mec\u02bchiko",
               "",
            };
        final String[] Tajikistan = new String[] {
               "eur Tadjikistan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "eur c\u02bchoa\u00f1v Tonga",
               "",
               "eur ha\u00f1v Tonga",
               "",
               "eur Tonga",
               "",
            };
        final String[] Bangladesh = new String[] {
               "eur c\u02bchoa\u00f1v Bangladesh",
               "",
               "eur ha\u00f1v Bangladesh",
               "",
               "eur Bangladesh",
               "",
            };
        final String[] Peru = new String[] {
               "eur c\u02bchoa\u00f1v Perou",
               "",
               "eur ha\u00f1v Perou",
               "",
               "eur Perou",
               "",
            };
        final String[] Greenland_Western = new String[] {
               "eur c\u02bchoa\u00f1v Greunland ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Greunland ar C\u02bchorn\u00f4g",
               "",
               "eur Greunland ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Ecuador = new String[] {
               "eur Ecuador",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Greenland_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Greunland ar Reter",
               "",
               "eur ha\u00f1v Greunland ar Reter",
               "",
               "eur Greunland ar Reter",
               "",
            };
        final String[] Gulf = new String[] {
               "eur c\u02bchoa\u00f1v ar Pleg-mor Arab-ha-Pers",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Eastern = new String[] {
               "eur Indonezia ar Reter",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Korea = new String[] {
               "eur c\u02bchoa\u00f1v Korea",
               "",
               "eur ha\u00f1v Korea",
               "",
               "eur Korea",
               "",
            };
        final String[] Australia_Western = new String[] {
               "eur c\u02bchoa\u00f1v Aostralia ar C\u02bchorn\u00f4g",
               "",
               "eur ha\u00f1v Aostralia ar C\u02bchorn\u00f4g",
               "",
               "eur Aostralia ar C\u02bchorn\u00f4g",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "eur Kyrgyzstan",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Indonesia_Western = new String[] {
               "eur Indonezia ar C\u02bchorn\u00f4g",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Eastern = new String[] {
               "eur c\u02bchoa\u00f1v Aostralia ar Reter",
               "",
               "eur ha\u00f1v Aostralia ar Reter",
               "",
               "eur Aostralia ar Reter",
               "",
            };
        final String[] French_Guiana = new String[] {
               "eur Gwiana c\u02bchall",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Colombia = new String[] {
               "eur c\u02bchoa\u00f1v Kolombia",
               "",
               "eur ha\u00f1v Kolombia",
               "",
               "eur Kolombia",
               "",
            };
        final String[] Chile = new String[] {
               "eur c\u02bchoa\u00f1v Chile",
               "",
               "eur ha\u00f1v Chile",
               "",
               "eur Chile",
               "",
            };
        final String[] America_Mountain = new String[] {
               "eur c\u02bchoa\u00f1v ar Menezio\u00f9",
               "",
               "eur ha\u00f1v ar Menezio\u00f9",
               "",
               "eur ar Menezio\u00f9",
               "",
            };
        final String[] Marquesas = new String[] {
               "eur Inizi Markiz",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "eur c\u02bchoa\u00f1v Arabia",
               "",
               "eur ha\u00f1v Arabia",
               "",
               "eur Arabia",
               "",
            };
        final String[] Alaska = new String[] {
               "eur c\u02bchoa\u00f1v Alaska",
               "",
               "eur ha\u00f1v Alaska",
               "",
               "eur Alaska",
               "",
            };
        final String[] Vladivostok = new String[] {
               "eur c\u02bchoa\u00f1v Vladivostok",
               "",
               "eur ha\u00f1v Vladivostok",
               "",
               "eur Vladivostok",
               "",
            };
        final String[] Irkutsk = new String[] {
               "eur c\u02bchoa\u00f1v Irkutsk",
               "",
               "eur ha\u00f1v Irkutsk",
               "",
               "eur Irkutsk",
               "",
            };
        final String[] Georgia = new String[] {
               "eur c\u02bchoa\u00f1v Jorjia",
               "",
               "eur ha\u00f1v Jorjia",
               "",
               "eur Jorjia",
               "",
            };
        final String[] Tokelau = new String[] {
               "eur Tokelau",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brasilia = new String[] {
               "eur c\u02bchoa\u00f1v Bras\u00edlia",
               "",
               "eur ha\u00f1v Bras\u00edlia",
               "",
               "eur Bras\u00edlia",
               "",
            };
        final String[] China = new String[] {
               "eur c\u02bchoa\u00f1v Sina",
               "",
               "eur ha\u00f1v Sina",
               "",
               "eur Sina",
               "",
            };
        final String[] Armenia = new String[] {
               "eur c\u02bchoa\u00f1v Armenia",
               "",
               "eur ha\u00f1v Armenia",
               "",
               "eur Armenia",
               "",
            };
        final String[] Anadyr = new String[] {
               "eur c\u02bchoa\u00f1v Anadyr\u02bc",
               "",
               "eur ha\u00f1v Anadyr\u02bc",
               "",
               "eur Anadyr\u02bc",
               "",
            };
        final String[] India = new String[] {
               "eur c\u02bchoa\u00f1v India",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Cook = new String[] {
               "eur c\u02bchoa\u00f1v Inizi Cook",
               "",
               "eur ha\u00f1v Inizi Cook",
               "",
               "eur Inizi Cook",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "America/Anchorage", Alaska },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Africa/Casablanca", Europe_Western },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", EMPTY_ZONE },
            { "Asia/Aden", Arabian },
            { "America/Cuiaba", Amazon },
            { "timezone.excity.Europe/San_Marino", "San Marino" },
            { "Africa/Nairobi", Africa_Eastern },
            { "timezone.excity.America/Antigua", "Antigua" },
            { "timezone.excity.Europe/Ljubljana", "Ljubljana" },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "timezone.excity.Asia/Irkutsk", "Irkutsk" },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "timezone.excity.Pacific/Marquesas", "Markiz" },
            { "timezone.excity.America/Buenos_Aires", "Buenos Aires" },
            { "Asia/Pontianak", Indonesia_Western },
            { "Africa/Cairo", Europe_Eastern },
            { "Pacific/Pago_Pago", Samoa },
            { "timezone.excity.America/Anchorage", "Anchorage" },
            { "Africa/Mbabane", Africa_Southern },
            { "Asia/Kuching", Malaysia },
            { "Pacific/Rarotonga", Cook },
            { "Australia/Hobart", Australia_Eastern },
            { "Europe/London",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "",
                    "eur ha\u00f1v Breizh-Veur",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Europe/Skopje", "Skopje" },
            { "America/Panama", America_Eastern },
            { "America/Indiana/Petersburg", America_Eastern },
            { "Asia/Yerevan", Armenia },
            { "Europe/Brussels", Europe_Central },
            { "timezone.excity.Atlantic/Reykjavik", "Reykjav\u00edk" },
            { "JST", Japan },
            { "timezone.excity.Pacific/Fiji", "Fidji" },
            { "timezone.excity.Europe/Gibraltar", "Jibraltar" },
            { "Europe/Warsaw", Europe_Central },
            { "timezone.excity.Asia/Yakutsk", "Yakutsk" },
            { "timezone.excity.Africa/Djibouti", "Djibouti" },
            { "Europe/Jersey", GMT },
            { "timezone.excity.Africa/Malabo", "Malabo" },
            { "timezone.excity.America/Recife", "Recife" },
            { "timezone.excity.Pacific/Wallis", "Wallis" },
            { "America/Miquelon", Pierre_Miquelon },
            { "Europe/Luxembourg", Europe_Central },
            { "timezone.excity.Africa/Porto-Novo", "Porto-Novo" },
            { "timezone.excity.Africa/Libreville", "Libreville" },
            { "timezone.excity.Asia/Tashkent", "Toshkent" },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "timezone.excity.Africa/Dakar", "Dakar" },
            { "Atlantic/St_Helena", GMT },
            { "timezone.excity.Asia/Shanghai", "Shanghai" },
            { "timezone.excity.Africa/Addis_Ababa", "Adis Abeba" },
            { "timezone.excity.Africa/Kinshasa", "Kinshasa" },
            { "timezone.excity.Asia/Dushanbe", "Dushanbe" },
            { "Europe/Guernsey", GMT },
            { "timezone.excity.Pacific/Bougainville", "Bougainville" },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Samarkand", Uzbekistan },
            { "timezone.excity.Europe/Tallinn", "Tallinn" },
            { "timezone.excity.Pacific/Apia", "Apia" },
            { "Asia/Phnom_Penh", Indochina },
            { "Africa/Kigali", Africa_Central },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "timezone.excity.America/El_Salvador", "Salvador" },
            { "Asia/Dubai", Gulf },
            { "Europe/Isle_of_Man", GMT },
            { "BET", Brasilia },
            { "America/Araguaina", Brasilia },
            { "timezone.excity.Pacific/Easter", "Enez Pask" },
            { "ACT", Australia_Central },
            { "timezone.excity.Pacific/Guam", "Guam" },
            { "Asia/Novosibirsk", Novosibirsk },
            { "timezone.excity.Europe/Vaduz", "Vaduz" },
            { "America/Argentina/Salta", Argentina },
            { "Africa/Tunis", Europe_Central },
            { "Pacific/Fakaofo", Tokelau },
            { "Africa/Tripoli", Europe_Eastern },
            { "Africa/Banjul", GMT },
            { "Indian/Comoro", Africa_Eastern },
            { "timezone.excity.Pacific/Niue", "Niue" },
            { "Indian/Reunion", Reunion },
            { "timezone.excity.Africa/Maseru", "Maseru" },
            { "Pacific/Palau", Palau },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "timezone.excity.Europe/London", "Londrez" },
            { "America/Montevideo", Uruguay },
            { "Africa/Windhoek", Africa_Central },
            { "Asia/Karachi", Pakistan },
            { "timezone.excity.Atlantic/Canary", "Kanariez" },
            { "Africa/Mogadishu", Africa_Eastern },
            { "timezone.excity.Pacific/Pitcairn", "Pitcairn" },
            { "timezone.excity.Africa/Casablanca", "Dar el Beida (Casablanca)" },
            { "Australia/Perth", Australia_Western },
            { "Etc/GMT", GMT },
            { "Asia/Chita", Yakutsk },
            { "Pacific/Easter", Easter },
            { "Antarctica/McMurdo", New_Zealand },
            { "America/Manaus", Amazon },
            { "Africa/Freetown", GMT },
            { "Asia/Macau", China },
            { "Europe/Malta", Europe_Central },
            { "Pacific/Tahiti", Tahiti },
            { "timezone.excity.Asia/Yerevan", "Yerevan" },
            { "timezone.excity.America/Vancouver", "Vancouver" },
            { "Africa/Asmera", Africa_Eastern },
            { "Europe/Busingen", Europe_Central },
            { "timezone.excity.Africa/Cairo", "Kaero" },
            { "AET", Australia_Eastern },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "timezone.excity.America/Inuvik", "Inuvik" },
            { "Africa/Malabo", Africa_Western },
            { "timezone.excity.Europe/Warsaw", "Varsovia" },
            { "Europe/Skopje", Europe_Central },
            { "America/Catamarca", Argentina },
            { "America/Godthab", Greenland_Western },
            { "Europe/Sarajevo", Europe_Central },
            { "timezone.excity.America/St_Lucia", "Saint Lucia" },
            { "timezone.excity.Europe/Berlin", "Berlin" },
            { "Africa/Lagos", Africa_Western },
            { "timezone.excity.Pacific/Midway", "Midway" },
            { "America/Cordoba", Argentina },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mauritius", Mauritius },
            { "timezone.excity.America/Godthab", "Nuuk (Godth\u00e5b)" },
            { "timezone.excity.America/Martinique", "Martinik" },
            { "America/Dawson_Creek", America_Mountain },
            { "Africa/Algiers", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Zurich", Europe_Central },
            { "Asia/Dili", East_Timor },
            { "timezone.excity.Australia/Perth", "Perth" },
            { "Africa/Bamako", GMT },
            { "timezone.excity.Arctic/Longyearbyen", "Longyearbyen" },
            { "Pacific/Wallis", Wallis },
            { "timezone.excity.America/Tegucigalpa", "Tegucigalpa" },
            { "Europe/Gibraltar", Europe_Central },
            { "timezone.excity.Africa/Windhoek", "Windhoek" },
            { "Africa/Conakry", GMT },
            { "Africa/Lubumbashi", Africa_Central },
            { "America/Havana", Cuba },
            { "timezone.excity.America/Edmonton", "Edmonton" },
            { "timezone.excity.Africa/Sao_Tome", "S\u00e3o Tom\u00e9" },
            { "timezone.excity.Africa/Abidjan", "Abidjan" },
            { "Europe/Vaduz", Europe_Central },
            { "timezone.excity.Africa/Banjul", "Banjul" },
            { "Asia/Dhaka", Bangladesh },
            { "timezone.excity.America/Guadeloupe", "Gwadeloup" },
            { "timezone.excity.America/Miquelon", "Mikelon" },
            { "timezone.excity.Africa/Freetown", "Freetown" },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Louisville", America_Eastern },
            { "timezone.excity.Europe/Vatican", "Vatikan" },
            { "timezone.excity.Asia/Almaty", "Almaty" },
            { "timezone.excity.Asia/Tbilisi", "Tbilisi" },
            { "timezone.excity.America/Cayenne", "Cayenne" },
            { "Pacific/Chatham", Chatham },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Sao_Paulo", Brasilia },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "timezone.excity.America/Belize", "Belize" },
            { "timezone.excity.Europe/Andorra", "Andorra" },
            { "timezone.excity.Europe/Minsk", "Mensk" },
            { "Asia/Dushanbe", Tajikistan },
            { "America/Guyana", Guyana },
            { "timezone.excity.Africa/Monrovia", "Monrovia" },
            { "America/Guayaquil", Ecuador },
            { "timezone.excity.Africa/Mbabane", "Mbabane" },
            { "Europe/Berlin", Europe_Central },
            { "timezone.excity.Asia/Bangkok", "Bangkok" },
            { "Europe/Moscow", Moscow },
            { "timezone.excity.Asia/Beirut", "Bayrut" },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Australia/Eucla", Australia_CentralWestern },
            { "timezone.excity.America/Adak", "Adak" },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Helsinki", Europe_Eastern },
            { "Asia/Beirut", Europe_Eastern },
            { "timezone.excity.Asia/Baghdad", "Baghdad" },
            { "timezone.excity.America/Montevideo", "Montevideo" },
            { "Africa/Sao_Tome", Africa_Western },
            { "America/Cayenne", French_Guiana },
            { "Asia/Yakutsk", Yakutsk },
            { "timezone.excity.Europe/Jersey", "Jerzenez" },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ndjamena", Africa_Western },
            { "timezone.excity.Atlantic/South_Georgia", "Georgia ar Su" },
            { "timezone.excity.America/St_Vincent", "Sant Visant" },
            { "Pacific/Fiji", Fiji },
            { "timezone.excity.Africa/Juba", "Juba" },
            { "Indian/Maldives", Maldives },
            { "timezone.excity.America/Panama", "Panam\u00e1" },
            { "timezone.excity.America/Havana", "La Habana" },
            { "timezone.excity.Europe/Madrid", "Madrid" },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Yellowknife", America_Mountain },
            { "America/Juneau", Alaska },
            { "timezone.excity.Indian/Kerguelen", "Kergelenn" },
            { "CNT", Newfoundland },
            { "America/Indiana/Vevay", America_Eastern },
            { "timezone.excity.America/Grenada", "Grenada" },
            { "timezone.excity.Europe/Volgograd", "Volgograd" },
            { "timezone.excity.Asia/Phnom_Penh", "Phnum P\u00e9nh" },
            { "timezone.excity.Europe/Monaco", "Monaco" },
            { "timezone.excity.Europe/Rome", "Roma" },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Jakarta", Indonesia_Western },
            { "Africa/Ceuta", Europe_Central },
            { "timezone.excity.America/La_Paz", "La Paz" },
            { "timezone.excity.Asia/Karachi", "Karachi" },
            { "timezone.excity.Africa/Nouakchott", "Nouakchott" },
            { "timezone.excity.Africa/Bamako", "Bamako" },
            { "America/Recife", Brasilia },
            { "America/Buenos_Aires", Argentina },
            { "timezone.excity.Asia/Muscat", "Masqat" },
            { "timezone.excity.Africa/Tripoli", "Tarabulus (Tripoli)" },
            { "timezone.excity.Asia/Pyongyang", "P\u02bcyongyang" },
            { "timezone.excity.Africa/El_Aaiun", "La\u02bcYoun" },
            { "Australia/Adelaide", Australia_Central },
            { "timezone.excity.Europe/Bucharest", "Bukarest" },
            { "timezone.excity.America/Lima", "Lima" },
            { "America/Metlakatla", Alaska },
            { "timezone.excity.Europe/Athens", "Aten" },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Paramaribo", Suriname },
            { "Europe/Simferopol", Moscow },
            { "timezone.excity.Asia/Bishkek", "Bishkek" },
            { "Europe/Sofia", Europe_Eastern },
            { "Africa/Nouakchott", GMT },
            { "Europe/Prague", Europe_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "timezone.excity.America/Paramaribo", "Paramaribo" },
            { "timezone.excity.America/Managua", "Managua" },
            { "Antarctica/Troll", GMT },
            { "Indian/Christmas", Christmas },
            { "NET", Armenia },
            { "timezone.excity.America/Sao_Paulo", "S\u00e3o Paulo" },
            { "Pacific/Gambier", Gambier },
            { "America/Inuvik", America_Mountain },
            { "America/Iqaluit", America_Eastern },
            { "Pacific/Funafuti", Tuvalu },
            { "Antarctica/Macquarie", Macquarie },
            { "timezone.excity.America/Montserrat", "Montserrat" },
            { "timezone.excity.Europe/Copenhagen", "Kopenhagen" },
            { "Africa/Gaborone", Africa_Central },
            { "timezone.excity.America/New_York", "New York" },
            { "timezone.excity.Australia/Darwin", "Darwin" },
            { "Asia/Gaza", Europe_Eastern },
            { "timezone.excity.Africa/Accra", "Accra" },
            { "timezone.excity.Etc/Unknown", "k\u00ear dianav" },
            { "timezone.excity.Asia/Jerusalem", "Jeruzalem" },
            { "Atlantic/Faeroe", Europe_Western },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "timezone.excity.America/Thule", "Q\u00e2n\u00e2q" },
            { "timezone.excity.Asia/Riyadh", "Riyadh" },
            { "America/Yakutat", Alaska },
            { "Europe/Copenhagen", Europe_Central },
            { "timezone.excity.Africa/Bangui", "Bangui" },
            { "timezone.excity.Africa/Lusaka", "Lusaka" },
            { "Atlantic/Azores", Azores },
            { "Europe/Vienna", Europe_Central },
            { "timezone.excity.America/Winnipeg", "Winnipeg" },
            { "timezone.excity.Antarctica/Macquarie", "Macquarie" },
            { "timezone.excity.Asia/Damascus", "Damask" },
            { "timezone.excity.America/Caracas", "Caracas" },
            { "timezone.excity.America/Bogota", "Bogot\u00e1" },
            { "Pacific/Pitcairn", Pitcairn },
            { "timezone.excity.Asia/Baku", "Bakou" },
            { "timezone.excity.Africa/Harare", "Harare" },
            { "Pacific/Nauru", Nauru },
            { "Europe/Tirane", Europe_Central },
            { "timezone.excity.Africa/Brazzaville", "Brazzaville" },
            { "SystemV/MST7", America_Mountain },
            { "timezone.excity.Africa/Algiers", "Aljer" },
            { "Australia/Broken_Hill", Australia_Central },
            { "Europe/Riga", Europe_Eastern },
            { "timezone.excity.Africa/Khartoum", "Khartoum" },
            { "Africa/Abidjan", GMT },
            { "America/Mendoza", Argentina },
            { "timezone.excity.Asia/Tehran", "Tehran" },
            { "timezone.excity.Pacific/Tahiti", "Tahiti" },
            { "America/Santarem", Brasilia },
            { "timezone.excity.America/St_Kitts", "Saint Kitts" },
            { "America/Asuncion", Paraguay },
            { "America/Boise", America_Mountain },
            { "Australia/Currie", Australia_Eastern },
            { "EST5EDT", America_Eastern },
            { "timezone.excity.Africa/Dar_es_Salaam", "Dar es Salaam" },
            { "timezone.excity.America/Monterrey", "Monterrey" },
            { "timezone.excity.Pacific/Galapagos", "Gal\u00e1pagos" },
            { "timezone.excity.America/Belem", "Bel\u00e9m" },
            { "Asia/Chongqing", China },
            { "Europe/Amsterdam", Europe_Central },
            { "timezone.excity.Asia/Saigon", "K\u00ear H\u00f4-Chi-Minh" },
            { "PLT", Pakistan },
            { "Africa/Accra", GMT },
            { "timezone.excity.Africa/Niamey", "Niamey" },
            { "timezone.excity.Indian/Mayotte", "Mayotte" },
            { "America/Maceio", Brasilia },
            { "Pacific/Apia", Apia },
            { "Pacific/Niue", Niue },
            { "timezone.excity.Asia/Yekaterinburg", "Yekaterinbourg" },
            { "timezone.excity.Europe/Sofia", "Sofia" },
            { "Europe/Dublin",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "",
                    "eur c\u02bchoa\u00f1v Iwerzhon",
                    "",
                    "",
                    "",
                }
            },
            { "MST7MDT", America_Mountain },
            { "America/Nassau", America_Eastern },
            { "timezone.excity.Africa/Conakry", "Conakry" },
            { "timezone.excity.Asia/Jakarta", "Jakarta" },
            { "SST", Solomon },
            { "America/Jamaica", America_Eastern },
            { "Asia/Bishkek", Kyrgystan },
            { "Atlantic/Stanley", Falkland },
            { "timezone.excity.Europe/Belgrade", "Beograd" },
            { "timezone.excity.America/Puerto_Rico", "Puerto Rico" },
            { "timezone.excity.America/Denver", "Denver" },
            { "timezone.excity.Asia/Calcutta", "Calcutta" },
            { "Indian/Mahe", Seychelles },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "CTT", China },
            { "timezone.excity.Asia/Gaza", "Gaza" },
            { "Asia/Vladivostok", Vladivostok },
            { "Africa/Libreville", Africa_Western },
            { "timezone.excity.Atlantic/St_Helena", "Saint Helena" },
            { "Africa/Maputo", Africa_Central },
            { "America/Kentucky/Monticello", America_Eastern },
            { "Africa/El_Aaiun", Europe_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Coral_Harbour", America_Eastern },
            { "Pacific/Marquesas", Marquesas },
            { "timezone.excity.Pacific/Rarotonga", "Rarotonga" },
            { "timezone.excity.Europe/Luxembourg", "Luksembourg" },
            { "PNT", America_Mountain },
            { "America/Cayman", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Baghdad", Arabian },
            { "timezone.excity.Asia/Bahrain", "Bahrein" },
            { "timezone.excity.Asia/Hong_Kong", "Hong Kong" },
            { "timezone.excity.America/Port-au-Prince", "Port-au-Prince" },
            { "Europe/San_Marino", Europe_Central },
            { "BST", Bangladesh },
            { "timezone.excity.America/Mexico_City", "K\u00ear Vec\u02bchiko" },
            { "timezone.excity.Europe/Isle_of_Man", "Manav" },
            { "SystemV/YST9", Gambier },
            { "timezone.excity.Pacific/Nauru", "Nauru" },
            { "Africa/Douala", Africa_Western },
            { "America/Ojinaga", America_Mountain },
            { "timezone.excity.Europe/Lisbon", "Lisboa" },
            { "timezone.excity.Pacific/Pago_Pago", "Pago Pago" },
            { "timezone.excity.Pacific/Gambier", "Gambier" },
            { "timezone.excity.America/Guyana", "Guyana" },
            { "Asia/Damascus", Europe_Eastern },
            { "MIT", Apia },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "timezone.excity.Europe/Paris", "Pariz" },
            { "America/Santiago", Chile },
            { "Asia/Baku", Azerbaijan },
            { "timezone.excity.Europe/Zagreb", "Zagreb" },
            { "ART", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "Atlantic/Reykjavik", GMT },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/La_Paz", Bolivia },
            { "timezone.excity.America/Dominica", "Dominica" },
            { "Asia/Taipei", Taipei },
            { "Antarctica/South_Pole", New_Zealand },
            { "Asia/Manila", Philippines },
            { "timezone.excity.Africa/Kampala", "Kampala" },
            { "Asia/Bangkok", Indochina },
            { "timezone.excity.Pacific/Chatham", "Chatham" },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Atlantic/Madeira", Europe_Western },
            { "America/Thunder_Bay", America_Eastern },
            { "timezone.excity.Europe/Budapest", "Budapest" },
            { "timezone.excity.America/Port_of_Spain", "Port of Spain" },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "AST", Alaska },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "timezone.excity.Asia/Colombo", "Kolamba" },
            { "America/Indiana/Marengo", America_Eastern },
            { "timezone.excity.Pacific/Port_Moresby", "Port Moresby" },
            { "America/Creston", America_Mountain },
            { "timezone.excity.Europe/Helsinki", "Helsinki" },
            { "Europe/Andorra", Europe_Central },
            { "timezone.excity.Asia/Anadyr", "Anadyr\u02bc" },
            { "timezone.excity.Asia/Urumqi", "\u00dcr\u00fcmqi" },
            { "timezone.excity.America/Costa_Rica", "Costa Rica" },
            { "Asia/Vientiane", Indochina },
            { "timezone.excity.Africa/Lagos", "Lagos" },
            { "timezone.excity.Africa/Bissau", "Bissau" },
            { "timezone.excity.Asia/Sakhalin", "Sakhalin" },
            { "timezone.excity.Europe/Guernsey", "Gwernenez" },
            { "Asia/Riyadh", Arabian },
            { "timezone.excity.Europe/Riga", "Riga" },
            { "Atlantic/South_Georgia", South_Georgia },
            { "Europe/Lisbon", Europe_Western },
            { "Asia/Harbin", China },
            { "Europe/Oslo", Europe_Central },
            { "timezone.excity.Africa/Mogadishu", "Muqdisho" },
            { "timezone.excity.Asia/Jayapura", "Jayapura" },
            { "Atlantic/Canary", Europe_Western },
            { "Asia/Kuwait", Arabian },
            { "Pacific/Efate", Vanuatu },
            { "Africa/Lome", GMT },
            { "America/Bogota", Colombia },
            { "Pacific/Norfolk", Norfolk },
            { "timezone.excity.Europe/Malta", "Malta" },
            { "timezone.excity.Australia/Sydney", "Sydney" },
            { "timezone.excity.Asia/Qatar", "Qatar" },
            { "timezone.excity.Africa/Lome", "Lom\u00e9" },
            { "timezone.excity.America/Nassau", "Nassau" },
            { "Africa/Kampala", Africa_Eastern },
            { "timezone.excity.Asia/Kuwait", "Koweit" },
            { "SystemV/EST5", America_Eastern },
            { "America/Edmonton", America_Mountain },
            { "Europe/Podgorica", Europe_Central },
            { "timezone.excity.Europe/Moscow", "Moskov" },
            { "Africa/Bujumbura", Africa_Central },
            { "timezone.excity.America/Aruba", "Aruba" },
            { "Europe/Minsk", Moscow },
            { "Pacific/Auckland", New_Zealand },
            { "timezone.excity.Asia/Taipei", "Taipei" },
            { "Asia/Qatar", Arabian },
            { "Europe/Kiev", Europe_Eastern },
            { "SystemV/PST8", Pitcairn },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Belfast",
                new String[] {
                    "Amzer keitat Greenwich (AKG)",
                    "",
                    "eur ha\u00f1v Breizh-Veur",
                    "",
                    "",
                    "",
                }
            },
            { "timezone.excity.Indian/Mauritius", "Moris" },
            { "Asia/Ashgabat", Turkmenistan },
            { "Africa/Luanda", Africa_Western },
            { "America/Nipigon", America_Eastern },
            { "timezone.excity.Europe/Mariehamn", "Marjehamn" },
            { "timezone.excity.America/St_Johns", "Saint John\u02bcs" },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "timezone.excity.America/St_Barthelemy", "Saint Barth\u00e9lemy" },
            { "timezone.excity.America/Santiago", "Santiago" },
            { "Asia/Muscat", Gulf },
            { "Asia/Bahrain", Arabian },
            { "Europe/Vilnius", Europe_Eastern },
            { "America/Fortaleza", Brasilia },
            { "America/Cancun", America_Eastern },
            { "timezone.excity.Asia/Manila", "Manila" },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Kinshasa", Africa_Western },
            { "Asia/Seoul", Korea },
            { "Australia/Sydney", Australia_Eastern },
            { "America/Lima", Peru },
            { "Europe/Madrid", Europe_Central },
            { "Asia/Brunei", Brunei },
            { "America/Santa_Isabel", Mexico_Northwest },
            { "America/Cambridge_Bay", America_Mountain },
            { "timezone.excity.Asia/Seoul", "Seoul" },
            { "Asia/Colombo", India },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Australia/Brisbane", Australia_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Europe/Volgograd", Moscow },
            { "timezone.excity.Europe/Istanbul", "Istanbul" },
            { "Africa/Blantyre", Africa_Central },
            { "timezone.excity.Europe/Sarajevo", "Sarajevo" },
            { "America/Danmarkshavn", GMT },
            { "America/Detroit", America_Eastern },
            { "timezone.excity.Africa/Ndjamena", "N\u02bcDjamena" },
            { "timezone.excity.Africa/Kigali", "Kigali" },
            { "timezone.excity.Asia/Vladivostok", "Vladivostok" },
            { "timezone.excity.Africa/Lubumbashi", "Lubumbashi" },
            { "Africa/Lusaka", Africa_Central },
            { "Asia/Hong_Kong", Hong_Kong },
            { "timezone.excity.Africa/Tunis", "Tuniz" },
            { "timezone.excity.Asia/Ulaanbaatar", "Ulaanbaatar" },
            { "timezone.excity.Asia/Macau", "Macau" },
            { "America/Argentina/La_Rioja", Argentina },
            { "Africa/Dakar", GMT },
            { "America/Porto_Velho", Amazon },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Scoresbysund", Greenland_Eastern },
            { "timezone.excity.Asia/Novosibirsk", "Novosibirsk" },
            { "Africa/Harare", Africa_Central },
            { "America/Nome", Alaska },
            { "NST", New_Zealand },
            { "timezone.excity.Africa/Nairobi", "Nairobi" },
            { "Europe/Tallinn", Europe_Eastern },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Johannesburg", Africa_Southern },
            { "EAT", Africa_Eastern },
            { "Africa/Bangui", Africa_Western },
            { "timezone.excity.Australia/Adelaide", "Adelaide" },
            { "timezone.excity.Asia/Singapore", "Singapour" },
            { "Europe/Belgrade", Europe_Central },
            { "timezone.excity.Europe/Vienna", "Vienna" },
            { "Africa/Bissau", GMT },
            { "timezone.excity.America/Cayman", "Cayman" },
            { "timezone.excity.Europe/Bratislava", "Bratislava" },
            { "Asia/Tehran", Iran },
            { "timezone.excity.America/Barbados", "Barbados" },
            { "timezone.excity.Asia/Nicosia", "Levkos\u00eda" },
            { "timezone.excity.Europe/Kiev", "Kiev" },
            { "Africa/Juba", Africa_Eastern },
            { "America/Campo_Grande", Amazon },
            { "America/Belem", Brasilia },
            { "timezone.excity.Asia/Tokyo", "Tokyo" },
            { "timezone.excity.Africa/Bujumbura", "Bujumbura" },
            { "Asia/Saigon", Indochina },
            { "Pacific/Midway", Samoa },
            { "America/Jujuy", Argentina },
            { "timezone.excity.Africa/Johannesburg", "Johannesburg" },
            { "timezone.excity.Asia/Brunei", "Brunei" },
            { "timezone.excity.Atlantic/Faeroe", "Faero" },
            { "Africa/Timbuktu", GMT },
            { "America/Bahia", Brasilia },
            { "timezone.excity.Europe/Dublin", "Dulenn" },
            { "America/Pangnirtung", America_Eastern },
            { "timezone.excity.Pacific/Palau", "Palau" },
            { "timezone.excity.Atlantic/Cape_Verde", "Kab Glas" },
            { "timezone.excity.Africa/Maputo", "Maputo" },
            { "Asia/Katmandu", Nepal },
            { "timezone.excity.Africa/Luanda", "Luanda" },
            { "timezone.excity.Pacific/Auckland", "Auckland" },
            { "timezone.excity.America/Los_Angeles", "Los Angeles" },
            { "Africa/Niamey", Africa_Western },
            { "Pacific/Noumea", New_Caledonia },
            { "timezone.excity.Pacific/Norfolk", "Norfolk" },
            { "Asia/Tbilisi", Georgia },
            { "ECT", Europe_Central },
            { "timezone.excity.Atlantic/Azores", "Azorez" },
            { "timezone.excity.Asia/Ashgabat", "Ashgabat" },
            { "timezone.excity.Australia/Melbourne", "Melbourne" },
            { "America/Montreal", America_Eastern },
            { "timezone.excity.America/Anguilla", "Anguilla" },
            { "timezone.excity.Pacific/Honolulu", "Honolulu" },
            { "America/Argentina/San_Juan", Argentina },
            { "timezone.excity.America/Jamaica", "Jamaika" },
            { "timezone.excity.Europe/Podgorica", "Podgorica" },
            { "timezone.excity.Indian/Reunion", "Re\u00fcnion" },
            { "Asia/Nicosia", Europe_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "timezone.excity.Australia/Brisbane", "Brisbane" },
            { "timezone.excity.Indian/Antananarivo", "Antananarivo" },
            { "timezone.excity.Pacific/Noumea", "Noumea" },
            { "SystemV/MST7MDT", America_Mountain },
            { "timezone.excity.Asia/Aden", "Aden" },
            { "timezone.excity.America/Manaus", "Manaus" },
            { "timezone.excity.Asia/Vientiane", "Viangchan" },
            { "timezone.excity.Europe/Oslo", "Oslo" },
            { "America/Boa_Vista", Amazon },
            { "Asia/Atyrau", Kazakhstan_Western },
            { "Australia/Darwin", Australia_Central },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Rangoon", Myanmar },
            { "Europe/Bratislava", Europe_Central },
            { "timezone.excity.Indian/Christmas", "Christmas" },
            { "Asia/Calcutta", India },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Kabul", Afghanistan },
            { "Indian/Cocos", Cocos },
            { "Pacific/Tongatapu", Tonga },
            { "SystemV/YST9YDT", Alaska },
            { "timezone.excity.Asia/Thimphu", "Thimphu" },
            { "CAT", Africa_Central },
            { "Arctic/Longyearbyen", Europe_Central },
            { "timezone.excity.Asia/Kuala_Lumpur", "Kuala Lumpur" },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Caracas", Venezuela },
            { "Asia/Hebron", Europe_Eastern },
            { "Indian/Kerguelen", French_Southern },
            { "timezone.excity.Africa/Ouagadougou", "Ouagadougou" },
            { "Africa/Monrovia", GMT },
            { "Asia/Ust-Nera", Vladivostok },
            { "timezone.excity.Africa/Gaborone", "Gaborone" },
            { "timezone.excity.Europe/Kaliningrad", "Kaliningrad" },
            { "Asia/Anadyr", Anadyr },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Irkutsk", Irkutsk },
            { "timezone.excity.Indian/Chagos", "Chagos" },
            { "timezone.excity.Asia/Kabul", "Kaboul" },
            { "America/Shiprock", America_Mountain },
            { "timezone.excity.Europe/Tirane", "Tiran\u00eb" },
            { "timezone.excity.Europe/Amsterdam", "Amsterdam" },
            { "timezone.excity.Europe/Prague", "Praha" },
            { "timezone.excity.Atlantic/Bermuda", "Bermudez" },
            { "Europe/Vatican", Europe_Central },
            { "timezone.excity.Indian/Cocos", "Kokoz" },
            { "timezone.excity.America/Asuncion", "Asunci\u00f3n" },
            { "Asia/Amman", Europe_Eastern },
            { "timezone.excity.Europe/Chisinau", "Chisinau" },
            { "timezone.excity.Asia/Amman", "Amman" },
            { "America/Toronto", America_Eastern },
            { "Asia/Singapore", Singapore },
            { "timezone.excity.Europe/Brussels", "Brusel" },
            { "Australia/Lindeman", Australia_Eastern },
            { "timezone.excity.Atlantic/Madeira", "Madeira" },
            { "timezone.excity.Indian/Comoro", "Komorez" },
            { "timezone.excity.America/Guatemala", "Guatemala" },
            { "SystemV/EST5EDT", America_Eastern },
            { "Pacific/Majuro", Marshall_Islands },
            { "timezone.excity.Europe/Stockholm", "Stockholm" },
            { "Pacific/Guadalcanal", Solomon },
            { "Europe/Athens", Europe_Eastern },
            { "timezone.excity.Europe/Vilnius", "Vilnius" },
            { "Europe/Monaco", Europe_Central },
            { "timezone.excity.America/Chicago", "Chicago" },
            { "timezone.excity.Indian/Maldives", "Maldivez" },
        };
        return data;
    }
}
