/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.gc_implementation.shenandoah;

import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.VMObject;
import sun.jvm.hotspot.types.AddressField;
import sun.jvm.hotspot.types.CIntegerField;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;

public class ShenandoahHeapRegion
extends VMObject {
    private static CIntegerField RegionSizeBytes;
    private static AddressField BottomField;
    private static AddressField TopField;
    private static AddressField EndField;

    private static synchronized void initialize(TypeDataBase db) {
        Type type = db.lookupType("ShenandoahHeapRegion");
        RegionSizeBytes = type.getCIntegerField("RegionSizeBytes");
        BottomField = type.getAddressField("_bottom");
        TopField = type.getAddressField("_top");
        EndField = type.getAddressField("_end");
    }

    public static long regionSizeBytes() {
        return RegionSizeBytes.getValue();
    }

    public ShenandoahHeapRegion(Address addr) {
        super(addr);
    }

    public Address bottom() {
        return BottomField.getValue(this.addr);
    }

    public Address top() {
        return TopField.getValue(this.addr);
    }

    public Address end() {
        return EndField.getValue(this.addr);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ShenandoahHeapRegion.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

