/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.fs;

import java.io.IOException;
import java.nio.file.attribute.DosFileAttributeView;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.FileTime;
import java.util.Map;
import java.util.Set;
import sun.misc.Unsafe;
import sun.nio.fs.AbstractBasicFileAttributeView;
import sun.nio.fs.LinuxNativeDispatcher;
import sun.nio.fs.NativeBuffer;
import sun.nio.fs.NativeBuffers;
import sun.nio.fs.UnixException;
import sun.nio.fs.UnixFileAttributeViews;
import sun.nio.fs.UnixFileAttributes;
import sun.nio.fs.UnixNativeDispatcher;
import sun.nio.fs.UnixPath;
import sun.nio.fs.Util;

class LinuxDosFileAttributeView
extends UnixFileAttributeViews.Basic
implements DosFileAttributeView {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final String READONLY_NAME = "readonly";
    private static final String ARCHIVE_NAME = "archive";
    private static final String SYSTEM_NAME = "system";
    private static final String HIDDEN_NAME = "hidden";
    private static final String DOS_XATTR_NAME = "user.DOSATTRIB";
    private static final byte[] DOS_XATTR_NAME_AS_BYTES = Util.toBytes("user.DOSATTRIB");
    private static final int DOS_XATTR_READONLY = 1;
    private static final int DOS_XATTR_HIDDEN = 2;
    private static final int DOS_XATTR_SYSTEM = 4;
    private static final int DOS_XATTR_ARCHIVE = 32;
    private static final Set<String> dosAttributeNames = Util.newSet(basicAttributeNames, new String[]{"readonly", "archive", "system", "hidden"});

    LinuxDosFileAttributeView(UnixPath unixPath, boolean bl) {
        super(unixPath, bl);
    }

    @Override
    public String name() {
        return "dos";
    }

    @Override
    public void setAttribute(String string, Object object) throws IOException {
        if (string.equals(READONLY_NAME)) {
            this.setReadOnly((Boolean)object);
            return;
        }
        if (string.equals(ARCHIVE_NAME)) {
            this.setArchive((Boolean)object);
            return;
        }
        if (string.equals(SYSTEM_NAME)) {
            this.setSystem((Boolean)object);
            return;
        }
        if (string.equals(HIDDEN_NAME)) {
            this.setHidden((Boolean)object);
            return;
        }
        super.setAttribute(string, object);
    }

    @Override
    public Map<String, Object> readAttributes(String[] stringArray) throws IOException {
        AbstractBasicFileAttributeView.AttributesBuilder attributesBuilder = AbstractBasicFileAttributeView.AttributesBuilder.create(dosAttributeNames, stringArray);
        DosFileAttributes dosFileAttributes = this.readAttributes();
        this.addRequestedBasicAttributes(dosFileAttributes, attributesBuilder);
        if (attributesBuilder.match(READONLY_NAME)) {
            attributesBuilder.add(READONLY_NAME, dosFileAttributes.isReadOnly());
        }
        if (attributesBuilder.match(ARCHIVE_NAME)) {
            attributesBuilder.add(ARCHIVE_NAME, dosFileAttributes.isArchive());
        }
        if (attributesBuilder.match(SYSTEM_NAME)) {
            attributesBuilder.add(SYSTEM_NAME, dosFileAttributes.isSystem());
        }
        if (attributesBuilder.match(HIDDEN_NAME)) {
            attributesBuilder.add(HIDDEN_NAME, dosFileAttributes.isHidden());
        }
        return attributesBuilder.unmodifiableMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DosFileAttributes readAttributes() throws IOException {
        this.file.checkRead();
        int n = this.file.openForAttributeAccess(this.followLinks);
        try {
            final UnixFileAttributes unixFileAttributes = UnixFileAttributes.get(n);
            final int n2 = this.getDosAttribute(n);
            DosFileAttributes dosFileAttributes = new DosFileAttributes(){

                @Override
                public FileTime lastModifiedTime() {
                    return unixFileAttributes.lastModifiedTime();
                }

                @Override
                public FileTime lastAccessTime() {
                    return unixFileAttributes.lastAccessTime();
                }

                @Override
                public FileTime creationTime() {
                    return unixFileAttributes.creationTime();
                }

                @Override
                public boolean isRegularFile() {
                    return unixFileAttributes.isRegularFile();
                }

                @Override
                public boolean isDirectory() {
                    return unixFileAttributes.isDirectory();
                }

                @Override
                public boolean isSymbolicLink() {
                    return unixFileAttributes.isSymbolicLink();
                }

                @Override
                public boolean isOther() {
                    return unixFileAttributes.isOther();
                }

                @Override
                public long size() {
                    return unixFileAttributes.size();
                }

                @Override
                public Object fileKey() {
                    return unixFileAttributes.fileKey();
                }

                @Override
                public boolean isReadOnly() {
                    return (n2 & 1) != 0;
                }

                @Override
                public boolean isHidden() {
                    return (n2 & 2) != 0;
                }

                @Override
                public boolean isArchive() {
                    return (n2 & 0x20) != 0;
                }

                @Override
                public boolean isSystem() {
                    return (n2 & 4) != 0;
                }
            };
            return dosFileAttributes;
        }
        catch (UnixException unixException) {
            unixException.rethrowAsIOException(this.file);
            DosFileAttributes dosFileAttributes = null;
            return dosFileAttributes;
        }
        finally {
            UnixNativeDispatcher.close(n);
        }
    }

    @Override
    public void setReadOnly(boolean bl) throws IOException {
        this.updateDosAttribute(1, bl);
    }

    @Override
    public void setHidden(boolean bl) throws IOException {
        this.updateDosAttribute(2, bl);
    }

    @Override
    public void setArchive(boolean bl) throws IOException {
        this.updateDosAttribute(32, bl);
    }

    @Override
    public void setSystem(boolean bl) throws IOException {
        this.updateDosAttribute(4, bl);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int getDosAttribute(int n) throws UnixException {
        NativeBuffer nativeBuffer = NativeBuffers.getNativeBuffer(24);
        try {
            int n2 = LinuxNativeDispatcher.fgetxattr(n, DOS_XATTR_NAME_AS_BYTES, nativeBuffer.address(), 24);
            if (n2 <= 0) throw new UnixException("Value of user.DOSATTRIB attribute is invalid");
            if (unsafe.getByte(nativeBuffer.address() + (long)n2 - 1L) == 0) {
                --n2;
            }
            byte[] byArray = new byte[n2];
            unsafe.copyMemory(null, nativeBuffer.address(), byArray, Unsafe.ARRAY_BYTE_BASE_OFFSET, n2);
            String string = Util.toString(byArray);
            if (string.length() < 3 || !string.startsWith("0x")) throw new UnixException("Value of user.DOSATTRIB attribute is invalid");
            try {
                int n3 = Integer.parseInt(string.substring(2), 16);
                return n3;
            }
            catch (NumberFormatException numberFormatException) {
                try {
                    throw new UnixException("Value of user.DOSATTRIB attribute is invalid");
                }
                catch (UnixException unixException) {
                    if (unixException.errno() != 61) throw unixException;
                    int n4 = 0;
                    return n4;
                }
            }
        }
        finally {
            nativeBuffer.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateDosAttribute(int n, boolean bl) throws IOException {
        block8: {
            this.file.checkWrite();
            int n2 = this.file.openForAttributeAccess(this.followLinks);
            try {
                int n3;
                int n4 = n3 = this.getDosAttribute(n2);
                n4 = bl ? (n4 |= n) : (n4 &= ~n);
                if (n4 == n3) break block8;
                byte[] byArray = Util.toBytes("0x" + Integer.toHexString(n4));
                NativeBuffer nativeBuffer = NativeBuffers.asNativeBuffer(byArray);
                try {
                    LinuxNativeDispatcher.fsetxattr(n2, DOS_XATTR_NAME_AS_BYTES, nativeBuffer.address(), byArray.length + 1);
                }
                finally {
                    nativeBuffer.release();
                }
            }
            catch (UnixException unixException) {
                unixException.rethrowAsIOException(this.file);
            }
            finally {
                UnixNativeDispatcher.close(n2);
            }
        }
    }
}

