/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.cs;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_cs extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "Greenwichsk\u00fd st\u0159edn\u00ed \u010das",
               "GMT",
               "Greenwich Summer Time",
               "GST",
               "Greenwich Time",
               "GT",
            };
        final String[] Moscow = new String[] {
               "Moskevsk\u00fd standardn\u00ed \u010das",
               "MST",
               "Moskevsk\u00fd letn\u00ed \u010das",
               "MST",
               "Moskevsk\u00fd \u010das",
               "MT",
            };
        final String[] Omsk = new String[] {
               "Omsk\u00fd standardn\u00ed \u010das",
               "OST",
               "Omsk\u00fd letn\u00ed \u010das",
               "OST",
               "Omsk\u00fd \u010das",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Havajsko-aleutsk\u00fd standardn\u00ed \u010das",
               "HAST",
               "Havajsko-aleutsk\u00fd letn\u00ed \u010das",
               "HADT",
               "Havajsko-aleutsk\u00fd \u010das",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Sachalinsk\u00fd standardn\u00ed \u010das",
               "SST",
               "Sachalinsk\u00fd letn\u00ed \u010das",
               "SST",
               "Sachalinsk\u00fd \u010das",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Jakutsk\u00fd standardn\u00ed \u010das",
               "YST",
               "Jakutsk\u00fd letn\u00ed \u010das",
               "YST",
               "Jakutsk\u00fd \u010das",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "V\u00fdchodokazachst\u00e1nsk\u00fd \u010das",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Japan = new String[] {
               "Japonsk\u00fd standardn\u00ed \u010das",
               "JST",
               "Japonsk\u00fd letn\u00ed \u010das",
               "JDT",
               "Japonsk\u00fd \u010das",
               "JT",
            };
        final String[] Vladivostok = new String[] {
               "Vladivostock\u00fd standardn\u00ed \u010das",
               "VST",
               "Vladivostock\u00fd letn\u00ed \u010das",
               "VST",
               "Vladivostock\u00fd \u010das",
               "VT",
            };
        final String[] Brasilia = new String[] {
               "Brasilia standardn\u00ed \u010das",
               "BST",
               "Brasilia letn\u00ed \u010das",
               "BST",
               "Brasilia \u010das",
               "BT",
            };
        final String[] Hovd = new String[] {
               "Hovdsk\u00fd standardn\u00ed \u010das",
               "HST",
               "Hovdsk\u00fd letn\u00ed \u010das",
               "HST",
               "Hovdsk\u00fd \u010das",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "Western Indonesia Time",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Z\u00e1padoindon\u00e9sk\u00fd \u010das",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "Amazonsk\u00fd standardn\u00ed \u010das",
               "AST",
               "Amazonsk\u00fd letn\u00ed \u010das",
               "AST",
               "Amazonsk\u00fd \u010das",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "Ul\u00e1nb\u00e1tarsk\u00fd standardn\u00ed \u010das",
               "UBST",
               "Ul\u00e1nb\u00e1tarsk\u00fd letn\u00ed \u010das",
               "UBST",
               "Ul\u00e1nb\u00e1tarsk\u00fd \u010das",
               "UBT",
            };
        final String[] Indonesia_Central = new String[] {
               "Central Indonesia Time",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "St\u0159edoindon\u00e9sk\u00fd \u010das",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "Pacifick\u00fd standardn\u00ed \u010das",
               "PST",
               "Pacifick\u00fd letn\u00ed \u010das",
               "PDT",
               "Pacifick\u00fd \u010das",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Z\u00e1padoargentinsk\u00fd standardn\u00ed \u010das",
               "WAST",
               "Z\u00e1padoargentinsk\u00fd letn\u00ed \u010das",
               "WAST",
               "Z\u00e1padoargentinsk\u00fd \u010das",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "Newfoundlandsk\u00fd standardn\u00ed \u010das",
               "NST",
               "Newfoundlandsk\u00fd letn\u00ed \u010das",
               "NDT",
               "Newfoundlandsk\u00fd \u010das",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "Volgogradsk\u00fd standardn\u00ed \u010das",
               "VST",
               "Volgogradsk\u00fd letn\u00ed \u010das",
               "VST",
               "Volgogradsk\u00fd \u010das",
               "VT",
            };
        final String[] America_Central = new String[] {
               "Centr\u00e1ln\u00ed standardn\u00ed \u010das",
               "CST",
               "Centr\u00e1ln\u00ed letn\u00ed \u010das",
               "CDT",
               "Centr\u00e1ln\u00ed \u010das",
               "CT",
            };
        final String[] Argentina = new String[] {
               "Argentinsk\u00fd standardn\u00ed \u010das",
               "AST",
               "Argentinsk\u00fd letn\u00ed \u010das",
               "AST",
               "Argentinsk\u00fd \u010das",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "Jekat\u011brinburgsk\u00fd standardn\u00ed \u010das",
               "YST",
               "Jekat\u011brinburgsk\u00fd letn\u00ed \u010das",
               "YST",
               "Jekat\u011brinburgsk\u00fd \u010das",
               "YT",
            };
        final String[] China = new String[] {
               "\u010c\u00ednsk\u00fd standardn\u00ed \u010das",
               "CST",
               "\u010c\u00ednsk\u00fd letn\u00ed \u010das",
               "CDT",
               "\u010c\u00ednsk\u00fd \u010das",
               "CT",
            };
        final String[] Lord_Howe = new String[] {
               "Standardn\u00ed \u010das na Ostrov\u011b lorda Howa",
               "LHST",
               "Letn\u00ed \u010das na Ostrov\u011b lorda Howa",
               "LHDT",
               "\u010cas na Ostrov\u011b lorda Howa",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "Macquarie Island Time",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarijsk\u00fd \u010das",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "V\u00fdchodoaustralsk\u00fd standardn\u00ed \u010das",
               "AEST",
               "V\u00fdchodoaustralsk\u00fd letn\u00ed \u010das",
               "AEDT",
               "V\u00fdchodoaustralsk\u00fd \u010das",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Irkutsk\u00fd standardn\u00ed \u010das",
               "IST",
               "Irkutsk\u00fd letn\u00ed \u010das",
               "IST",
               "Irkutsk\u00fd \u010das",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "\u010cojbalsansk\u00fd standardn\u00ed \u010das",
               "CST",
               "\u010cojbalsansk\u00fd letn\u00ed \u010das",
               "CST",
               "\u010cojbalsansk\u00fd \u010das",
               "CT",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Z\u00e1padokazachst\u00e1nsk\u00fd \u010das",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] America_Eastern = new String[] {
               "V\u00fdchodn\u00ed standardn\u00ed \u010das",
               "EST",
               "V\u00fdchodn\u00ed letn\u00ed \u010das",
               "EDT",
               "V\u00fdchodn\u00ed \u010das",
               "ET",
            };
        final String[] Israel = new String[] {
               "Izraelsk\u00fd standardn\u00ed \u010das",
               "IST",
               "Izraelsk\u00fd letn\u00ed \u010das",
               "IDT",
               "Izraelsk\u00fd \u010das",
               "IT",
            };
        final String[] Australia_Western = new String[] {
               "Z\u00e1padoaustralsk\u00fd standardn\u00ed \u010das",
               "AWST",
               "Z\u00e1padoaustralsk\u00fd letn\u00ed \u010das",
               "AWDT",
               "Z\u00e1padoaustralsk\u00fd \u010das",
               "WAT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd standardn\u00ed \u010das",
               "ACWST",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd letn\u00ed \u010das",
               "ACWDT",
               "St\u0159edoz\u00e1padn\u00ed australsk\u00fd \u010das",
               "ACWT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Krasnojarsk\u00fd standardn\u00ed \u010das",
               "KST",
               "Krasnojarsk\u00fd letn\u00ed \u010das",
               "KST",
               "Krasnojarsk\u00fd \u010das",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Eastern Indonesia Time",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "V\u00fdchodoindon\u00e9sk\u00fd \u010das",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "Standardn\u00ed \u010das na ostrov\u011b Fernando de Noronha",
               "FNST",
               "Letn\u00ed \u010das na ostrov\u011b Fernando de Noronha",
               "FNST",
               "\u010cas na ostrov\u011b Fernando de Noronha",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Novosibirsk\u00fd standardn\u00ed \u010das",
               "NST",
               "Novosibirsk\u00fd letn\u00ed \u010das",
               "NST",
               "Novosibirsk\u00fd \u010das",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Horsk\u00fd standardn\u00ed \u010das",
               "MST",
               "Horsk\u00fd letn\u00ed \u010das",
               "MDT",
               "Horsk\u00fd \u010das",
               "MT",
            };
        final String[] Europe_Central = new String[] {
               "St\u0159edoevropsk\u00fd standardn\u00ed \u010das",
               "CEST",
               "St\u0159edoevropsk\u00fd letn\u00ed \u010das",
               "CEST",
               "St\u0159edoevropsk\u00fd \u010das",
               "CET",
            };
        final String[] Alaska = new String[] {
               "Alja\u0161sk\u00fd standardn\u00ed \u010das",
               "AKST",
               "Alja\u0161sk\u00fd letn\u00ed \u010das",
               "AKDT",
               "Alja\u0161sk\u00fd \u010das",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "St\u0159edoaustralsk\u00fd standardn\u00ed \u010das",
               "ACST",
               "St\u0159edoaustralsk\u00fd letn\u00ed \u010das",
               "ACDT",
               "St\u0159edoaustralsk\u00fd \u010das",
               "CAT",
            };
        final String[] Europe_Eastern = new String[] {
               "V\u00fdchodoevropsk\u00fd standardn\u00ed \u010das",
               "EEST",
               "V\u00fdchodoevropsk\u00fd letn\u00ed \u010das",
               "EEST",
               "V\u00fdchodoevropsk\u00fd \u010das",
               "EET",
            };
        final String[] Atlantic = new String[] {
               "Atlantick\u00fd standardn\u00ed \u010das",
               "AST",
               "Atlantick\u00fd letn\u00ed \u010das",
               "ADT",
               "Atlantick\u00fd \u010das",
               "AT",
            };
        final String[] Magadan = new String[] {
               "Magadansk\u00fd standardn\u00ed \u010das",
               "MST",
               "Magadansk\u00fd letn\u00ed \u010das",
               "MST",
               "Magadansk\u00fd \u010das",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "Europe/Samara", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Monaco", Europe_Central },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "Europe/Vienna", Europe_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "Atlantic/St_Helena", GMT },
            { "Europe/Mariehamn", Europe_Eastern },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Asia/Nicosia", Europe_Eastern },
            { "Europe/Zurich", Europe_Central },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Danmarkshavn", GMT },
            { "Asia/Macau", China },
            { "Europe/Dublin", GMT },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Amman", Europe_Eastern },
            { "Asia/Vladivostok", Vladivostok },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Europe/Simferopol", Europe_Eastern },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Africa/Monrovia", GMT },
            { "Europe/Istanbul", Europe_Eastern },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "Europe/Copenhagen", Europe_Central },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Europe/Amsterdam", Europe_Central },
            { "Asia/Hebron", Europe_Eastern },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "PST8PDT", America_Pacific },
            { "Antarctica/Casey", Australia_Western },
            { "America/Cayman", America_Eastern },
            { "Europe/Stockholm", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Europe/Berlin", Europe_Central },
            { "Asia/Omsk", Omsk },
            { "Asia/Novosibirsk", Novosibirsk },
            { "Europe/Chisinau", Europe_Eastern },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Europe/Budapest", Europe_Central },
            { "Asia/Choibalsan", Choibalsan },
            { "Africa/Tunis", Europe_Central },
            { "America/Indiana/Winamac", America_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Europe/Jersey", GMT },
            { "America/Thunder_Bay", America_Eastern },
            { "Europe/Prague", Europe_Central },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "Africa/Sao_Tome", GMT },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Mexico_City", America_Central },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "Europe/Kaliningrad", GMT },
            { "Asia/Kashgar", China },
            { "Asia/Damascus", Europe_Eastern },
            { "Africa/Ouagadougou", GMT },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "EST5EDT", America_Eastern },
            { "America/Managua", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Nome", Alaska },
            { "America/Moncton", Atlantic },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "Africa/Dakar", GMT },
            { "Europe/Podgorica", Europe_Central },
            { "America/Belize", America_Central },
            { "America/Vancouver", America_Pacific },
            { "America/Cuiaba", Amazon },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "America/Guatemala", America_Central },
            { "Europe/Vatican", Europe_Central },
            { "America/Montreal", America_Eastern },
            { "Asia/Harbin", China },
            { "America/Glace_Bay", Atlantic },
            { "Europe/Tallinn", Europe_Eastern },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ojinaga", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Asia/Urumqi", China },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Asia/Gaza", Europe_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "Africa/Accra", GMT },
            { "Europe/Sarajevo", Europe_Central },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Kiev", Europe_Eastern },
            { "Africa/Cairo", Europe_Eastern },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Isle_of_Man", GMT },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "Africa/Bissau", GMT },
            { "America/Jamaica", America_Eastern },
            { "Africa/Abidjan", GMT },
            { "Europe/Malta", Europe_Central },
            { "Europe/Madrid", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Europe/Luxembourg", Europe_Central },
            { "Africa/Banjul", GMT },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Jujuy", Argentina },
            { "Europe/Rome", Europe_Central },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "Europe/Helsinki", Europe_Eastern },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "Europe/Athens", Europe_Eastern },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Hermosillo", America_Mountain },
            { "America/Boise", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Europe/Guernsey", GMT },
            { "Europe/San_Marino", Europe_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "Europe/Ljubljana", Europe_Central },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "Africa/Algiers", Europe_Central },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Africa/Conakry", GMT },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "Europe/Gibraltar", Europe_Central },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "Africa/Freetown", GMT },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Europe/Minsk", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Europe/Riga", Europe_Eastern },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "Africa/Nouakchott", GMT },
            { "America/Noronha", Noronha },
            { "Europe/Tirane", Europe_Central },
            { "America/Nipigon", America_Eastern },
            { "Asia/Chongqing", China },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Europe/Skopje", Europe_Central },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Ceuta", Europe_Central },
            { "Europe/Andorra", Europe_Central },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "Asia/Beirut", Europe_Eastern },
            { "Europe/Bratislava", Europe_Central },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "Europe/Zagreb", Europe_Central },
            { "America/Eirunepe", Amazon },
            { "Europe/Warsaw", Europe_Central },
            { "Africa/Lome", GMT },
            { "America/Monterrey", America_Central },
            { "Europe/London", GMT },
        };
        return data;
    }
}
