/*
 * Copyright (c) 2012, 2021, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2012 Unicode, Inc. All rights reserved. Distributed under
 * the Terms of Use in http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of the Unicode data files and any associated documentation (the "Data
 * Files") or Unicode software and any associated documentation (the
 * "Software") to deal in the Data Files or Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, and/or sell copies of the Data Files or Software, and
 * to permit persons to whom the Data Files or Software are furnished to do so,
 * provided that (a) the above copyright notice(s) and this permission notice
 * appear with all copies of the Data Files or Software, (b) both the above
 * copyright notice(s) and this permission notice appear in associated
 * documentation, and (c) there is clear notice in each modified Data File or
 * in the Software as well as in the documentation associated with the Data
 * File(s) or Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS
 * INCLUDED IN THIS NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR
 * CONSEQUENTIAL DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall not
 * be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written authorization
 * of the copyright holder.
 */

package sun.util.resources.cldr.sw;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_sw extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] Moscow = new String[] {
               "Saa za Wastani za Moscow",
               "MST",
               "Saa za Kiangazi za Moscow",
               "MST",
               "Saa za Moscow",
               "MT",
            };
        final String[] Omsk = new String[] {
               "Saa za Wastani za Omsk",
               "OST",
               "Saa za Kiangazi za Omsk",
               "OST",
               "Saa za Omsk",
               "OT",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "Saa za Wastani za Hawaii na Aleutia",
               "HAST",
               "Saa za Mchana za Hawaii na Aleutia",
               "HADT",
               "Saa za Hawaii na Aleutia",
               "HAT",
            };
        final String[] Sakhalin = new String[] {
               "Saa za Wastani za Sakhalin",
               "SST",
               "Saa za Kiangazi za Sakhalin",
               "SST",
               "Saa za Sakhalin",
               "ST",
            };
        final String[] Yakutsk = new String[] {
               "Saa za Wastani za Yakutsk",
               "YST",
               "Saa za Kiangazi za Yakutsk",
               "YST",
               "Saa za Yakutsk",
               "YT",
            };
        final String[] Kazakhstan_Eastern = new String[] {
               "Saa za Kazakistani Mashariki",
               "EKT",
               "East Kazakhstan Summer Time",
               "EKST",
               "East Kazakhstan Time",
               "EKT",
            };
        final String[] Vladivostok = new String[] {
               "Saa za Wastani za Vladivostok",
               "VST",
               "Saa za Kiangazi za Vladivostok",
               "VST",
               "Saa za Vladivostok",
               "VT",
            };
        final String[] Brasilia = new String[] {
               "Saa za Wastani za Brasilia",
               "BST",
               "Saa za Kiangazi za Brasilia",
               "BST",
               "Saa za Brasilia",
               "BT",
            };
        final String[] Hovd = new String[] {
               "Saa za Wastani za Hovd",
               "HST",
               "Saa za Kiangazi za Hovd",
               "HST",
               "Saa za Hovd",
               "HT",
            };
        final String[] Indonesia_Western = new String[] {
               "Saa za Indonesia Magharibi",
               "WIT",
               "Western Indonesia Summer Time",
               "WIST",
               "Western Indonesia Time",
               "WIT",
            };
        final String[] Amazon = new String[] {
               "Saa Wastani za Amazon",
               "AST",
               "Saa za Mchana za Amazon",
               "AST",
               "Saa za Amazon",
               "AT",
            };
        final String[] Mongolia = new String[] {
               "Saa za Wastani za Ulan Bator",
               "UBST",
               "Saa za Kiangazi za Ulan Bator",
               "UBST",
               "Saa za Ulan Bator",
               "UBT",
            };
        final String[] Indonesia_Central = new String[] {
               "Saa za Indonesia ya Kati",
               "CIT",
               "Central Indonesia Summer Time",
               "CIST",
               "Central Indonesia Time",
               "CIT",
            };
        final String[] America_Pacific = new String[] {
               "Saa za Wastani za Pasifiki",
               "PST",
               "Saa za Mchana za Pasifiki",
               "PDT",
               "Saa za Pasifiki",
               "PT",
            };
        final String[] Argentina_Western = new String[] {
               "Saa za Wastani za Ajentina Magharibi",
               "WAST",
               "Saa za Kiangazi za Ajentina Magharibi",
               "WAST",
               "Saa za Ajentina Magharibi",
               "WAT",
            };
        final String[] Newfoundland = new String[] {
               "Saa za Wastani za Newfoundland",
               "NST",
               "Saa za Mchana za Newfoundland",
               "NDT",
               "Saa za Newfoundland",
               "NT",
            };
        final String[] Volgograd = new String[] {
               "Saa za Wastani za Volgograd",
               "VST",
               "Saa za Kiangazi za Volgograd",
               "VST",
               "Saa za Volgograd",
               "VT",
            };
        final String[] America_Central = new String[] {
               "Saa za Wastani za Kati",
               "CST",
               "Saa za Mchana za Kati",
               "CDT",
               "Saa za Kati",
               "CT",
            };
        final String[] Africa_Eastern = new String[] {
               "Saa za Africa Mashariki",
               "EAT",
               "East Africa Summer Time",
               "EAST",
               "East Africa Time",
               "EAT",
            };
        final String[] Argentina = new String[] {
               "Saa za Wastani za Ajentina",
               "AST",
               "Saa za Kiangazi za Ajentina",
               "AST",
               "Saa za Ajentina",
               "AT",
            };
        final String[] Yekaterinburg = new String[] {
               "Saa za Wastani za Yekaterinburg",
               "YST",
               "Saa za Kiangazi za Yekaterinburg",
               "YST",
               "Saa za Yekaterinburg",
               "YT",
            };
        final String[] Lord_Howe = new String[] {
               "Saa za Wastani za Lord Howe",
               "LHST",
               "Saa za Mchana za Lord Howe",
               "LHDT",
               "Saa za Lord Howe",
               "LHT",
            };
        final String[] Macquarie = new String[] {
               "Saa za Macquarie",
               "MIT",
               "Macquarie Island Summer Time",
               "MIST",
               "Macquarie Island Time",
               "MIT",
            };
        final String[] Australia_Eastern = new String[] {
               "Saa Wastani za Mashariki mwa Australia",
               "AEST",
               "Saa za Mchana za Mashariki mwa Australia",
               "AEDT",
               "Saa za Australia Mashariki",
               "EAT",
            };
        final String[] Irkutsk = new String[] {
               "Saa za Wastani za Irkutsk",
               "IST",
               "Saa za Kiangazi za Irkutsk",
               "IST",
               "Saa za Irkutsk",
               "IT",
            };
        final String[] Choibalsan = new String[] {
               "Saa za Wastani za Choibalsan",
               "CST",
               "Saa za Kiangazi za Choibalsan",
               "CST",
               "Saa za Choibalsan",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "Saa za Wastani za Mashariki",
               "EST",
               "Saa za Mchana za Mashariki",
               "EDT",
               "Saa za Mashariki",
               "ET",
            };
        final String[] Kazakhstan_Western = new String[] {
               "Saa za Kazakistani Magharibi",
               "WKT",
               "West Kazakhstan Summer Time",
               "WKST",
               "West Kazakhstan Time",
               "WKT",
            };
        final String[] Australia_CentralWestern = new String[] {
               "Saa za Wastani za Magharibi ya Kati ya Australia",
               "ACWST",
               "Saa za Mchana za Magharibi ya Kati ya Australia",
               "ACWDT",
               "Saa za Magharibi ya Kati ya Australia",
               "ACWT",
            };
        final String[] Australia_Western = new String[] {
               "Saa za Wastani za Australia Magharibi",
               "AWST",
               "Saa za Mchana za Australia Magharibi",
               "AWDT",
               "Saa za Australia Magharibi",
               "WAT",
            };
        final String[] Krasnoyarsk = new String[] {
               "Saa za Wastani za Krasnoyarsk",
               "KST",
               "Saa za Kiangazi za Krasnoyarsk",
               "KST",
               "Saa za Krasnoyarsk",
               "KT",
            };
        final String[] Indonesia_Eastern = new String[] {
               "Saa za Indonesia Mashariki",
               "EIT",
               "Eastern Indonesia Summer Time",
               "EIST",
               "Eastern Indonesia Time",
               "EIT",
            };
        final String[] Noronha = new String[] {
               "Saa za Wastani za Fernando de Noronha",
               "FNST",
               "Saa za Kiangazi za Fernando de Noronha",
               "FNST",
               "Saa za Fernando de Noronha",
               "FNT",
            };
        final String[] Novosibirsk = new String[] {
               "Saa za Wastani za Novosibirsk",
               "NST",
               "Saa za Kiangazi za Novosibirsk",
               "NST",
               "Saa za Novosibirsk",
               "NT",
            };
        final String[] America_Mountain = new String[] {
               "Saa za Wastani za Mountain",
               "MST",
               "Saa za Mchana za Mountain",
               "MDT",
               "Saa za Mountain",
               "MT",
            };
        final String[] Alaska = new String[] {
               "Saa Wastani za Alaska",
               "AKST",
               "Saa za Mchana za Alaska",
               "AKDT",
               "Saa za Alaska",
               "AKT",
            };
        final String[] Australia_Central = new String[] {
               "Saa za Wastani za Australia ya Kati",
               "ACST",
               "Saa za Mchana za Australia ya Kati",
               "ACDT",
               "Saa za Australia ya Kati",
               "CAT",
            };
        final String[] Atlantic = new String[] {
               "Saa za Wastani za Atlantiki",
               "AST",
               "Saa za Mchana za Atlantiki",
               "ADT",
               "Saa za Atlantiki",
               "AT",
            };
        final String[] Magadan = new String[] {
               "Saa za Wastani za Magadan",
               "MST",
               "Saa za Kiangazi za Magadan",
               "MST",
               "Saa za Magadan",
               "MT",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii_Aleutian },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Samara", Moscow },
            { "Atlantic/Bermuda", Atlantic },
            { "America/Yakutat", Alaska },
            { "America/Catamarca", Argentina },
            { "America/Dawson", America_Pacific },
            { "America/St_Vincent", Atlantic },
            { "America/Port-au-Prince", America_Eastern },
            { "Africa/Kampala", Africa_Eastern },
            { "Europe/Volgograd", Volgograd },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Antigua", Atlantic },
            { "Australia/Lord_Howe", Lord_Howe },
            { "America/Resolute", America_Central },
            { "America/Winnipeg", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Anguilla", Atlantic },
            { "America/Regina", America_Central },
            { "Asia/Vladivostok", Vladivostok },
            { "America/Argentina/Ushuaia", Argentina },
            { "Indian/Mayotte", Africa_Eastern },
            { "America/North_Dakota/Center", America_Central },
            { "America/Tijuana", America_Pacific },
            { "Asia/Qyzylorda", Kazakhstan_Eastern },
            { "America/Thule", Atlantic },
            { "America/Bahia_Banderas", America_Central },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Chihuahua", America_Mountain },
            { "America/Yellowknife", America_Mountain },
            { "Antarctica/Casey", Australia_Western },
            { "PST8PDT", America_Pacific },
            { "America/Cayman", America_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Asia/Omsk", Omsk },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "Asia/Novosibirsk", Novosibirsk },
            { "America/Argentina/Tucuman", Argentina },
            { "Asia/Sakhalin", Sakhalin },
            { "America/Curacao", Atlantic },
            { "Asia/Choibalsan", Choibalsan },
            { "America/Indiana/Winamac", America_Eastern },
            { "Asia/Ulaanbaatar", Mongolia },
            { "America/Thunder_Bay", America_Eastern },
            { "Africa/Djibouti", Africa_Eastern },
            { "America/Toronto", America_Eastern },
            { "America/Montserrat", Atlantic },
            { "America/Merida", America_Central },
            { "America/Recife", Brasilia },
            { "America/Porto_Velho", Amazon },
            { "America/Costa_Rica", America_Central },
            { "America/Fortaleza", Brasilia },
            { "Asia/Oral", Kazakhstan_Western },
            { "America/Mexico_City", America_Central },
            { "America/El_Salvador", America_Central },
            { "America/Tortola", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Tegucigalpa", America_Central },
            { "Asia/Novokuznetsk", Novosibirsk },
            { "America/Kentucky/Monticello", America_Eastern },
            { "CST6CDT", America_Central },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/Managua", America_Central },
            { "EST5EDT", America_Eastern },
            { "America/Moncton", Atlantic },
            { "America/Nome", Alaska },
            { "America/Maceio", Brasilia },
            { "America/Rio_Branco", Amazon },
            { "America/Belize", America_Central },
            { "America/Cuiaba", Amazon },
            { "America/Vancouver", America_Pacific },
            { "America/Rankin_Inlet", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "America/Guatemala", America_Central },
            { "America/Montreal", America_Eastern },
            { "America/Glace_Bay", Atlantic },
            { "America/Cambridge_Bay", America_Mountain },
            { "Australia/Brisbane", Australia_Eastern },
            { "America/Ojinaga", America_Mountain },
            { "America/Barbados", Atlantic },
            { "America/Grenada", Atlantic },
            { "Africa/Nairobi", Africa_Eastern },
            { "America/Louisville", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "Asia/Irkutsk", Irkutsk },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Metlakatla", America_Pacific },
            { "Africa/Juba", Africa_Eastern },
            { "America/Marigot", Atlantic },
            { "America/Indiana/Knox", America_Central },
            { "Europe/Moscow", Moscow },
            { "America/Inuvik", America_Mountain },
            { "America/Jamaica", America_Eastern },
            { "Indian/Comoro", Africa_Eastern },
            { "America/Manaus", Amazon },
            { "America/Indiana/Vevay", America_Eastern },
            { "Australia/Hobart", Australia_Eastern },
            { "Asia/Magadan", Magadan },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "Australia/Melbourne", Australia_Eastern },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Aqtobe", Kazakhstan_Western },
            { "Australia/Sydney", Australia_Eastern },
            { "Asia/Makassar", Indonesia_Central },
            { "Australia/Currie", Australia_Eastern },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Cancun", America_Central },
            { "Africa/Khartoum", Africa_Eastern },
            { "America/Jujuy", Argentina },
            { "America/Buenos_Aires", Argentina },
            { "America/Dawson_Creek", America_Mountain },
            { "Asia/Anadyr", Magadan },
            { "America/Matamoros", America_Central },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Puerto_Rico", Atlantic },
            { "America/Coral_Harbour", America_Eastern },
            { "Australia/Eucla", Australia_CentralWestern },
            { "America/Cordoba", Argentina },
            { "America/Detroit", America_Eastern },
            { "America/Nassau", America_Eastern },
            { "America/Swift_Current", America_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Hermosillo", America_Mountain },
            { "America/Whitehorse", America_Pacific },
            { "America/Boise", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "America/Pangnirtung", America_Eastern },
            { "America/Santa_Isabel", America_Pacific },
            { "Asia/Almaty", Kazakhstan_Eastern },
            { "America/Rainy_River", America_Central },
            { "America/Belem", Brasilia },
            { "America/Sao_Paulo", Brasilia },
            { "America/Menominee", America_Central },
            { "America/Boa_Vista", Amazon },
            { "America/Mazatlan", America_Mountain },
            { "America/Indiana/Petersburg", America_Eastern },
            { "America/Iqaluit", America_Eastern },
            { "America/Juneau", Alaska },
            { "America/Araguaina", Brasilia },
            { "America/Martinique", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/St_Lucia", Atlantic },
            { "Asia/Yakutsk", Yakutsk },
            { "America/Panama", America_Eastern },
            { "America/Aruba", Atlantic },
            { "America/North_Dakota/New_Salem", America_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Argentina/San_Luis", Argentina_Western },
            { "America/St_Thomas", Atlantic },
            { "Australia/Lindeman", Australia_Eastern },
            { "Asia/Hovd", Hovd },
            { "America/Bahia", Brasilia },
            { "America/Shiprock", America_Mountain },
            { "Australia/Perth", Australia_Western },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "America/Grand_Turk", America_Eastern },
            { "Asia/Jakarta", Indonesia_Western },
            { "America/Edmonton", America_Mountain },
            { "America/Santo_Domingo", Atlantic },
            { "America/Creston", America_Mountain },
            { "America/Goose_Bay", Atlantic },
            { "America/Noronha", Noronha },
            { "America/Nipigon", America_Eastern },
            { "America/Dominica", Atlantic },
            { "Antarctica/Macquarie", Macquarie },
            { "Australia/Darwin", Australia_Central },
            { "MST7MDT", America_Mountain },
            { "Australia/Adelaide", Australia_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "America/St_Barthelemy", Atlantic },
            { "Pacific/Johnston", Hawaii_Aleutian },
            { "America/Argentina/Salta", Argentina },
            { "America/Kralendijk", Atlantic },
            { "America/Guadeloupe", Atlantic },
            { "Asia/Kamchatka", Magadan },
            { "Asia/Aqtau", Kazakhstan_Western },
            { "America/Eirunepe", Amazon },
            { "America/Monterrey", America_Central },
        };
        return data;
    }
}
