/*---------------------------------------------------------------------------*
 |              PDFlib - A library for generating PDF on the fly             |
 +---------------------------------------------------------------------------+
 | Copyright (c) 1997-2006 Thomas Merz and PDFlib GmbH. All rights reserved. |
 +---------------------------------------------------------------------------+
 |                                                                           |
 |    This software is subject to the PDFlib license. It is NOT in the       |
 |    public domain. Extended versions and commercial licenses are           |
 |    available, please check http://www.pdflib.com.                         |
 |                                                                           |
 *---------------------------------------------------------------------------*/

/* $Id: ft_corefont.h,v 1.14 2006/09/25 09:39:41 kurt Exp $
 *
 * This file contains the metric for the base and
 * pre-installed CID fonts of PDF
 *
 * ft_corefont.h is included only in ft_corefont.c.
 *
 */

#ifndef FT_COREMETR_H
#define FT_COREMETR_H

#ifdef PDF_BUILTINMETRIC_SUPPORTED

/* -------- Generated from CourierStd.otf -------- */

static fnt_interwidth fnt_glyph_width_01[203] =
{
    {0x0000, 600}, {0x0001,   0}, {0x0020, 600}, {0x007F,   0},
    {0x00A0, 600}, {0x0100,   0}, {0x0111, 600}, {0x0112,   0},
    {0x0126, 600}, {0x0128,   0}, {0x0131, 600}, {0x0134,   0},
    {0x0138, 600}, {0x0139,   0}, {0x013F, 600}, {0x0143,   0},
    {0x0149, 600}, {0x014C,   0}, {0x0152, 600}, {0x0154,   0},
    {0x0160, 600}, {0x0162,   0}, {0x0166, 600}, {0x0168,   0},
    {0x0178, 600}, {0x0179,   0}, {0x017D, 600}, {0x017F,   0},
    {0x0192, 600}, {0x0193,   0}, {0x02C6, 600}, {0x02C8,   0},
    {0x02C9, 600}, {0x02CA,   0}, {0x02D8, 600}, {0x02DE,   0},
    {0x0393, 600}, {0x0394,   0}, {0x0398, 600}, {0x0399,   0},
    {0x03A6, 600}, {0x03A7,   0}, {0x03A9, 600}, {0x03AA,   0},
    {0x03B1, 600}, {0x03B2,   0}, {0x03B4, 600}, {0x03B6,   0},
    {0x03BC, 600}, {0x03BD,   0}, {0x03C0, 600}, {0x03C1,   0},
    {0x03C3, 600}, {0x03C5,   0}, {0x03D5, 600}, {0x03D6,   0},
    {0x2013, 600}, {0x2015,   0}, {0x2017, 600}, {0x201F,   0},
    {0x2020, 600}, {0x2023,   0}, {0x2026, 600}, {0x2027,   0},
    {0x2030, 600}, {0x2031,   0}, {0x2039, 600}, {0x203B,   0},
    {0x203C, 600}, {0x203D,   0}, {0x203E, 600}, {0x203F,   0},
    {0x2044, 600}, {0x2045,   0}, {0x207F, 600}, {0x2080,   0},
    {0x20A3, 600}, {0x20A4,   0}, {0x20A7, 600}, {0x20A8,   0},
    {0x20AC, 600}, {0x20AD,   0}, {0x2113, 600}, {0x2114,   0},
    {0x2122, 600}, {0x2123,   0}, {0x2126, 600}, {0x2127,   0},
    {0x212E, 600}, {0x212F,   0}, {0x215B, 600}, {0x215F,   0},
    {0x2190, 600}, {0x2196,   0}, {0x21A8, 600}, {0x21A9,   0},
    {0x2202, 600}, {0x2203,   0}, {0x2206, 600}, {0x2207,   0},
    {0x220F, 600}, {0x2210,   0}, {0x2211, 600}, {0x2213,   0},
    {0x2215, 600}, {0x2216,   0}, {0x2219, 600}, {0x221B,   0},
    {0x221E, 600}, {0x221F,   0}, {0x2229, 600}, {0x222A,   0},
    {0x222B, 600}, {0x222C,   0}, {0x2248, 600}, {0x2249,   0},
    {0x2260, 600}, {0x2262,   0}, {0x2264, 600}, {0x2266,   0},
    {0x22C5, 600}, {0x22C6,   0}, {0x2302, 600}, {0x2303,   0},
    {0x2304, 600}, {0x2305,   0}, {0x2310, 600}, {0x2311,   0},
    {0x2319, 600}, {0x231A,   0}, {0x2320, 600}, {0x2322,   0},
    {0x2500, 600}, {0x2501,   0}, {0x2502, 600}, {0x2503,   0},
    {0x250C, 600}, {0x250D,   0}, {0x2510, 600}, {0x2511,   0},
    {0x2514, 600}, {0x2515,   0}, {0x2518, 600}, {0x2519,   0},
    {0x251C, 600}, {0x251D,   0}, {0x2524, 600}, {0x2525,   0},
    {0x252C, 600}, {0x252D,   0}, {0x2534, 600}, {0x2535,   0},
    {0x253C, 600}, {0x253D,   0}, {0x2550, 600}, {0x256D,   0},
    {0x2580, 600}, {0x2581,   0}, {0x2584, 600}, {0x2585,   0},
    {0x2588, 600}, {0x2589,   0}, {0x258C, 600}, {0x258D,   0},
    {0x2590, 600}, {0x2594,   0}, {0x25A0, 600}, {0x25A1,   0},
    {0x25B2, 600}, {0x25B3,   0}, {0x25B6, 600}, {0x25B7,   0},
    {0x25BC, 600}, {0x25BD,   0}, {0x25C0, 600}, {0x25C1,   0},
    {0x25CA, 600}, {0x25CC,   0}, {0x25D8, 600}, {0x25DA,   0},
    {0x263A, 600}, {0x263D,   0}, {0x2640, 600}, {0x2641,   0},
    {0x2642, 600}, {0x2643,   0}, {0x2660, 600}, {0x2661,   0},
    {0x2662, 600}, {0x2664,   0}, {0x2665, 600}, {0x2667,   0},
    {0x266A, 600}, {0x266B,   0}, {0x266C, 600}, {0x266D,   0},
    {0xE000, 600}, {0xE002,   0}, {0xF638, 600}, {0xF639,   0},
    {0xFB01, 600}, {0xFB03,   0}, {0xFFFF,   0}
};

static const fnt_font_metric fnt_font_metric_01 =
{
    "Courier",
    35L,
    fnt_Type1,
    cc_none,
    0,
    1,
    -56,
    -250,
    678,
    857,
    -198,
    52,
    573,
    435,
    627,
    -373,
    109,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    203,
    fnt_glyph_width_01,
    0,
    NULL,

};

/* -------- Generated from CourierStd-Bold.otf -------- */

static fnt_interwidth fnt_glyph_width_02[203] =
{
    {0x0000, 600}, {0x0001,   0}, {0x0020, 600}, {0x007F,   0},
    {0x00A0, 600}, {0x0100,   0}, {0x0111, 600}, {0x0112,   0},
    {0x0126, 600}, {0x0128,   0}, {0x0131, 600}, {0x0134,   0},
    {0x0138, 600}, {0x0139,   0}, {0x013F, 600}, {0x0143,   0},
    {0x0149, 600}, {0x014C,   0}, {0x0152, 600}, {0x0154,   0},
    {0x0160, 600}, {0x0162,   0}, {0x0166, 600}, {0x0168,   0},
    {0x0178, 600}, {0x0179,   0}, {0x017D, 600}, {0x017F,   0},
    {0x0192, 600}, {0x0193,   0}, {0x02C6, 600}, {0x02C8,   0},
    {0x02C9, 600}, {0x02CA,   0}, {0x02D8, 600}, {0x02DE,   0},
    {0x0393, 600}, {0x0394,   0}, {0x0398, 600}, {0x0399,   0},
    {0x03A6, 600}, {0x03A7,   0}, {0x03A9, 600}, {0x03AA,   0},
    {0x03B1, 600}, {0x03B2,   0}, {0x03B4, 600}, {0x03B6,   0},
    {0x03BC, 600}, {0x03BD,   0}, {0x03C0, 600}, {0x03C1,   0},
    {0x03C3, 600}, {0x03C5,   0}, {0x03D5, 600}, {0x03D6,   0},
    {0x2013, 600}, {0x2015,   0}, {0x2017, 600}, {0x201F,   0},
    {0x2020, 600}, {0x2023,   0}, {0x2026, 600}, {0x2027,   0},
    {0x2030, 600}, {0x2031,   0}, {0x2039, 600}, {0x203B,   0},
    {0x203C, 600}, {0x203D,   0}, {0x203E, 600}, {0x203F,   0},
    {0x2044, 600}, {0x2045,   0}, {0x207F, 600}, {0x2080,   0},
    {0x20A3, 600}, {0x20A4,   0}, {0x20A7, 600}, {0x20A8,   0},
    {0x20AC, 600}, {0x20AD,   0}, {0x2113, 600}, {0x2114,   0},
    {0x2122, 600}, {0x2123,   0}, {0x2126, 600}, {0x2127,   0},
    {0x212E, 600}, {0x212F,   0}, {0x215B, 600}, {0x215F,   0},
    {0x2190, 600}, {0x2196,   0}, {0x21A8, 600}, {0x21A9,   0},
    {0x2202, 600}, {0x2203,   0}, {0x2206, 600}, {0x2207,   0},
    {0x220F, 600}, {0x2210,   0}, {0x2211, 600}, {0x2213,   0},
    {0x2215, 600}, {0x2216,   0}, {0x2219, 600}, {0x221B,   0},
    {0x221E, 600}, {0x221F,   0}, {0x2229, 600}, {0x222A,   0},
    {0x222B, 600}, {0x222C,   0}, {0x2248, 600}, {0x2249,   0},
    {0x2260, 600}, {0x2262,   0}, {0x2264, 600}, {0x2266,   0},
    {0x22C5, 600}, {0x22C6,   0}, {0x2302, 600}, {0x2303,   0},
    {0x2304, 600}, {0x2305,   0}, {0x2310, 600}, {0x2311,   0},
    {0x2319, 600}, {0x231A,   0}, {0x2320, 600}, {0x2322,   0},
    {0x2500, 600}, {0x2501,   0}, {0x2502, 600}, {0x2503,   0},
    {0x250C, 600}, {0x250D,   0}, {0x2510, 600}, {0x2511,   0},
    {0x2514, 600}, {0x2515,   0}, {0x2518, 600}, {0x2519,   0},
    {0x251C, 600}, {0x251D,   0}, {0x2524, 600}, {0x2525,   0},
    {0x252C, 600}, {0x252D,   0}, {0x2534, 600}, {0x2535,   0},
    {0x253C, 600}, {0x253D,   0}, {0x2550, 600}, {0x256D,   0},
    {0x2580, 600}, {0x2581,   0}, {0x2584, 600}, {0x2585,   0},
    {0x2588, 600}, {0x2589,   0}, {0x258C, 600}, {0x258D,   0},
    {0x2590, 600}, {0x2594,   0}, {0x25A0, 600}, {0x25A1,   0},
    {0x25B2, 600}, {0x25B3,   0}, {0x25B6, 600}, {0x25B7,   0},
    {0x25BC, 600}, {0x25BD,   0}, {0x25C0, 600}, {0x25C1,   0},
    {0x25CA, 600}, {0x25CC,   0}, {0x25D8, 600}, {0x25DA,   0},
    {0x263A, 600}, {0x263D,   0}, {0x2640, 600}, {0x2641,   0},
    {0x2642, 600}, {0x2643,   0}, {0x2660, 600}, {0x2661,   0},
    {0x2662, 600}, {0x2664,   0}, {0x2665, 600}, {0x2667,   0},
    {0x266A, 600}, {0x266B,   0}, {0x266C, 600}, {0x266D,   0},
    {0xE000, 600}, {0xE002,   0}, {0xF638, 600}, {0xF639,   0},
    {0xFB01, 600}, {0xFB03,   0}, {0xFFFF,   0}
};

static const fnt_font_metric fnt_font_metric_02 =
{
    "Courier-Bold",
    262179L,
    fnt_Type1,
    cc_none,
    0,
    1,
    -88,
    -250,
    697,
    854,
    -198,
    52,
    573,
    435,
    627,
    -373,
    166,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    203,
    fnt_glyph_width_02,
    0,
    NULL,

};

/* -------- Generated from CourierStd-Oblique.otf -------- */

static fnt_interwidth fnt_glyph_width_03[203] =
{
    {0x0000, 600}, {0x0001,   0}, {0x0020, 600}, {0x007F,   0},
    {0x00A0, 600}, {0x0100,   0}, {0x0111, 600}, {0x0112,   0},
    {0x0126, 600}, {0x0128,   0}, {0x0131, 600}, {0x0134,   0},
    {0x0138, 600}, {0x0139,   0}, {0x013F, 600}, {0x0143,   0},
    {0x0149, 600}, {0x014C,   0}, {0x0152, 600}, {0x0154,   0},
    {0x0160, 600}, {0x0162,   0}, {0x0166, 600}, {0x0168,   0},
    {0x0178, 600}, {0x0179,   0}, {0x017D, 600}, {0x017F,   0},
    {0x0192, 600}, {0x0193,   0}, {0x02C6, 600}, {0x02C8,   0},
    {0x02C9, 600}, {0x02CA,   0}, {0x02D8, 600}, {0x02DE,   0},
    {0x0393, 600}, {0x0394,   0}, {0x0398, 600}, {0x0399,   0},
    {0x03A6, 600}, {0x03A7,   0}, {0x03A9, 600}, {0x03AA,   0},
    {0x03B1, 600}, {0x03B2,   0}, {0x03B4, 600}, {0x03B6,   0},
    {0x03BC, 600}, {0x03BD,   0}, {0x03C0, 600}, {0x03C1,   0},
    {0x03C3, 600}, {0x03C5,   0}, {0x03D5, 600}, {0x03D6,   0},
    {0x2013, 600}, {0x2015,   0}, {0x2017, 600}, {0x201F,   0},
    {0x2020, 600}, {0x2023,   0}, {0x2026, 600}, {0x2027,   0},
    {0x2030, 600}, {0x2031,   0}, {0x2039, 600}, {0x203B,   0},
    {0x203C, 600}, {0x203D,   0}, {0x203E, 600}, {0x203F,   0},
    {0x2044, 600}, {0x2045,   0}, {0x207F, 600}, {0x2080,   0},
    {0x20A3, 600}, {0x20A4,   0}, {0x20A7, 600}, {0x20A8,   0},
    {0x20AC, 600}, {0x20AD,   0}, {0x2113, 600}, {0x2114,   0},
    {0x2122, 600}, {0x2123,   0}, {0x2126, 600}, {0x2127,   0},
    {0x212E, 600}, {0x212F,   0}, {0x215B, 600}, {0x215F,   0},
    {0x2190, 600}, {0x2196,   0}, {0x21A8, 600}, {0x21A9,   0},
    {0x2202, 600}, {0x2203,   0}, {0x2206, 600}, {0x2207,   0},
    {0x220F, 600}, {0x2210,   0}, {0x2211, 600}, {0x2213,   0},
    {0x2215, 600}, {0x2216,   0}, {0x2219, 600}, {0x221B,   0},
    {0x221E, 600}, {0x221F,   0}, {0x2229, 600}, {0x222A,   0},
    {0x222B, 600}, {0x222C,   0}, {0x2248, 600}, {0x2249,   0},
    {0x2260, 600}, {0x2262,   0}, {0x2264, 600}, {0x2266,   0},
    {0x22C5, 600}, {0x22C6,   0}, {0x2302, 600}, {0x2303,   0},
    {0x2304, 600}, {0x2305,   0}, {0x2310, 600}, {0x2311,   0},
    {0x2319, 600}, {0x231A,   0}, {0x2320, 600}, {0x2322,   0},
    {0x2500, 600}, {0x2501,   0}, {0x2502, 600}, {0x2503,   0},
    {0x250C, 600}, {0x250D,   0}, {0x2510, 600}, {0x2511,   0},
    {0x2514, 600}, {0x2515,   0}, {0x2518, 600}, {0x2519,   0},
    {0x251C, 600}, {0x251D,   0}, {0x2524, 600}, {0x2525,   0},
    {0x252C, 600}, {0x252D,   0}, {0x2534, 600}, {0x2535,   0},
    {0x253C, 600}, {0x253D,   0}, {0x2550, 600}, {0x256D,   0},
    {0x2580, 600}, {0x2581,   0}, {0x2584, 600}, {0x2585,   0},
    {0x2588, 600}, {0x2589,   0}, {0x258C, 600}, {0x258D,   0},
    {0x2590, 600}, {0x2594,   0}, {0x25A0, 600}, {0x25A1,   0},
    {0x25B2, 600}, {0x25B3,   0}, {0x25B6, 600}, {0x25B7,   0},
    {0x25BC, 600}, {0x25BD,   0}, {0x25C0, 600}, {0x25C1,   0},
    {0x25CA, 600}, {0x25CC,   0}, {0x25D8, 600}, {0x25DA,   0},
    {0x263A, 600}, {0x263D,   0}, {0x2640, 600}, {0x2641,   0},
    {0x2642, 600}, {0x2643,   0}, {0x2660, 600}, {0x2661,   0},
    {0x2662, 600}, {0x2664,   0}, {0x2665, 600}, {0x2667,   0},
    {0x266A, 600}, {0x266B,   0}, {0x266C, 600}, {0x266D,   0},
    {0xE000, 600}, {0xE002,   0}, {0xF638, 600}, {0xF639,   0},
    {0xFB01, 600}, {0xFB03,   0}, {0xFFFF,   0}
};

static const fnt_font_metric fnt_font_metric_03 =
{
    "Courier-Oblique",
    99L,
    fnt_Type1,
    cc_none,
    -11,
    1,
    -48,
    -250,
    748,
    857,
    -198,
    52,
    573,
    435,
    627,
    -373,
    109,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    203,
    fnt_glyph_width_03,
    0,
    NULL,

};

/* -------- Generated from CourierStd-BoldOblique.otf -------- */

static fnt_interwidth fnt_glyph_width_04[203] =
{
    {0x0000, 600}, {0x0001,   0}, {0x0020, 600}, {0x007F,   0},
    {0x00A0, 600}, {0x0100,   0}, {0x0111, 600}, {0x0112,   0},
    {0x0126, 600}, {0x0128,   0}, {0x0131, 600}, {0x0134,   0},
    {0x0138, 600}, {0x0139,   0}, {0x013F, 600}, {0x0143,   0},
    {0x0149, 600}, {0x014C,   0}, {0x0152, 600}, {0x0154,   0},
    {0x0160, 600}, {0x0162,   0}, {0x0166, 600}, {0x0168,   0},
    {0x0178, 600}, {0x0179,   0}, {0x017D, 600}, {0x017F,   0},
    {0x0192, 600}, {0x0193,   0}, {0x02C6, 600}, {0x02C8,   0},
    {0x02C9, 600}, {0x02CA,   0}, {0x02D8, 600}, {0x02DE,   0},
    {0x0393, 600}, {0x0394,   0}, {0x0398, 600}, {0x0399,   0},
    {0x03A6, 600}, {0x03A7,   0}, {0x03A9, 600}, {0x03AA,   0},
    {0x03B1, 600}, {0x03B2,   0}, {0x03B4, 600}, {0x03B6,   0},
    {0x03BC, 600}, {0x03BD,   0}, {0x03C0, 600}, {0x03C1,   0},
    {0x03C3, 600}, {0x03C5,   0}, {0x03D5, 600}, {0x03D6,   0},
    {0x2013, 600}, {0x2015,   0}, {0x2017, 600}, {0x201F,   0},
    {0x2020, 600}, {0x2023,   0}, {0x2026, 600}, {0x2027,   0},
    {0x2030, 600}, {0x2031,   0}, {0x2039, 600}, {0x203B,   0},
    {0x203C, 600}, {0x203D,   0}, {0x203E, 600}, {0x203F,   0},
    {0x2044, 600}, {0x2045,   0}, {0x207F, 600}, {0x2080,   0},
    {0x20A3, 600}, {0x20A4,   0}, {0x20A7, 600}, {0x20A8,   0},
    {0x20AC, 600}, {0x20AD,   0}, {0x2113, 600}, {0x2114,   0},
    {0x2122, 600}, {0x2123,   0}, {0x2126, 600}, {0x2127,   0},
    {0x212E, 600}, {0x212F,   0}, {0x215B, 600}, {0x215F,   0},
    {0x2190, 600}, {0x2196,   0}, {0x21A8, 600}, {0x21A9,   0},
    {0x2202, 600}, {0x2203,   0}, {0x2206, 600}, {0x2207,   0},
    {0x220F, 600}, {0x2210,   0}, {0x2211, 600}, {0x2213,   0},
    {0x2215, 600}, {0x2216,   0}, {0x2219, 600}, {0x221B,   0},
    {0x221E, 600}, {0x221F,   0}, {0x2229, 600}, {0x222A,   0},
    {0x222B, 600}, {0x222C,   0}, {0x2248, 600}, {0x2249,   0},
    {0x2260, 600}, {0x2262,   0}, {0x2264, 600}, {0x2266,   0},
    {0x22C5, 600}, {0x22C6,   0}, {0x2302, 600}, {0x2303,   0},
    {0x2304, 600}, {0x2305,   0}, {0x2310, 600}, {0x2311,   0},
    {0x2319, 600}, {0x231A,   0}, {0x2320, 600}, {0x2322,   0},
    {0x2500, 600}, {0x2501,   0}, {0x2502, 600}, {0x2503,   0},
    {0x250C, 600}, {0x250D,   0}, {0x2510, 600}, {0x2511,   0},
    {0x2514, 600}, {0x2515,   0}, {0x2518, 600}, {0x2519,   0},
    {0x251C, 600}, {0x251D,   0}, {0x2524, 600}, {0x2525,   0},
    {0x252C, 600}, {0x252D,   0}, {0x2534, 600}, {0x2535,   0},
    {0x253C, 600}, {0x253D,   0}, {0x2550, 600}, {0x256D,   0},
    {0x2580, 600}, {0x2581,   0}, {0x2584, 600}, {0x2585,   0},
    {0x2588, 600}, {0x2589,   0}, {0x258C, 600}, {0x258D,   0},
    {0x2590, 600}, {0x2594,   0}, {0x25A0, 600}, {0x25A1,   0},
    {0x25B2, 600}, {0x25B3,   0}, {0x25B6, 600}, {0x25B7,   0},
    {0x25BC, 600}, {0x25BD,   0}, {0x25C0, 600}, {0x25C1,   0},
    {0x25CA, 600}, {0x25CC,   0}, {0x25D8, 600}, {0x25DA,   0},
    {0x263A, 600}, {0x263D,   0}, {0x2640, 600}, {0x2641,   0},
    {0x2642, 600}, {0x2643,   0}, {0x2660, 600}, {0x2661,   0},
    {0x2662, 600}, {0x2664,   0}, {0x2665, 600}, {0x2667,   0},
    {0x266A, 600}, {0x266B,   0}, {0x266C, 600}, {0x266D,   0},
    {0xE000, 600}, {0xE002,   0}, {0xF638, 600}, {0xF639,   0},
    {0xFB01, 600}, {0xFB03,   0}, {0xFFFF,   0}
};

static const fnt_font_metric fnt_font_metric_04 =
{
    "Courier-BoldOblique",
    262243L,
    fnt_Type1,
    cc_none,
    -11,
    1,
    -48,
    -250,
    757,
    854,
    -198,
    52,
    573,
    435,
    627,
    -373,
    166,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    203,
    fnt_glyph_width_04,
    0,
    NULL,

};

/* -------- Generated from ARIAL.TTF -------- */

static fnt_interwidth fnt_glyph_width_05[268] =
{
    {0x0000,   0}, {0x0020, 278}, {0x0022, 355}, {0x0023, 556},
    {0x0025, 889}, {0x0026, 667}, {0x0027, 191}, {0x0028, 333},
    {0x002A, 389}, {0x002B, 584}, {0x002C, 278}, {0x002D, 333},
    {0x002E, 278}, {0x0030, 556}, {0x003A, 278}, {0x003C, 584},
    {0x003F, 556}, {0x0040,1015}, {0x0041, 667}, {0x0043, 722},
    {0x0045, 667}, {0x0046, 611}, {0x0047, 778}, {0x0048, 722},
    {0x0049, 278}, {0x004A, 500}, {0x004B, 667}, {0x004C, 556},
    {0x004D, 833}, {0x004E, 722}, {0x004F, 778}, {0x0050, 667},
    {0x0051, 778}, {0x0052, 722}, {0x0053, 667}, {0x0054, 611},
    {0x0055, 722}, {0x0056, 667}, {0x0057, 944}, {0x0058, 667},
    {0x005A, 611}, {0x005B, 278}, {0x005E, 469}, {0x005F, 556},
    {0x0060, 333}, {0x0061, 556}, {0x0063, 500}, {0x0064, 556},
    {0x0066, 278}, {0x0067, 556}, {0x0069, 222}, {0x006B, 500},
    {0x006C, 222}, {0x006D, 833}, {0x006E, 556}, {0x0072, 333},
    {0x0073, 500}, {0x0074, 278}, {0x0075, 556}, {0x0076, 500},
    {0x0077, 722}, {0x0078, 500}, {0x007B, 334}, {0x007C, 260},
    {0x007D, 334}, {0x007E, 584}, {0x007F,   0}, {0x00A0, 278},
    {0x00A1, 333}, {0x00A2, 556}, {0x00A6, 260}, {0x00A7, 556},
    {0x00A8, 333}, {0x00A9, 737}, {0x00AA, 370}, {0x00AB, 556},
    {0x00AC, 584}, {0x00AD, 333}, {0x00AE, 737}, {0x00AF, 552},
    {0x00B0, 400}, {0x00B1, 549}, {0x00B2, 333}, {0x00B5, 576},
    {0x00B6, 537}, {0x00B7, 278}, {0x00B8, 333}, {0x00BA, 365},
    {0x00BB, 556}, {0x00BC, 834}, {0x00BF, 611}, {0x00C0, 667},
    {0x00C6,1000}, {0x00C7, 722}, {0x00C8, 667}, {0x00CC, 278},
    {0x00D0, 722}, {0x00D2, 778}, {0x00D7, 584}, {0x00D8, 778},
    {0x00D9, 722}, {0x00DD, 667}, {0x00DF, 611}, {0x00E0, 556},
    {0x00E6, 889}, {0x00E7, 500}, {0x00E8, 556}, {0x00EC, 278},
    {0x00F0, 556}, {0x00F7, 549}, {0x00F8, 611}, {0x00F9, 556},
    {0x00FD, 500}, {0x00FE, 556}, {0x00FF, 500}, {0x0100, 667},
    {0x0101, 556}, {0x0102, 667}, {0x0103, 556}, {0x0104, 667},
    {0x0105, 556}, {0x0106, 722}, {0x0107, 500}, {0x0108,   0},
    {0x010C, 722}, {0x010D, 500}, {0x010E, 722}, {0x010F, 615},
    {0x0110, 722}, {0x0111, 556}, {0x0112, 667}, {0x0113, 556},
    {0x0114,   0}, {0x0116, 667}, {0x0117, 556}, {0x0118, 667},
    {0x0119, 556}, {0x011A, 667}, {0x011B, 556}, {0x011C,   0},
    {0x011E, 778}, {0x011F, 556}, {0x0120,   0}, {0x0122, 778},
    {0x0123, 556}, {0x0124,   0}, {0x0128, 278}, {0x012C,   0},
    {0x012E, 278}, {0x012F, 222}, {0x0130, 278}, {0x0132,   0},
    {0x0136, 667}, {0x0137, 500}, {0x0139, 556}, {0x013A, 222},
    {0x013B, 556}, {0x013C, 222}, {0x013D, 556}, {0x013E, 292},
    {0x013F,   0}, {0x0141, 556}, {0x0142, 222}, {0x0143, 722},
    {0x0144, 556}, {0x0145, 722}, {0x0146, 556}, {0x0147, 722},
    {0x0148, 556}, {0x0149,   0}, {0x014A, 723}, {0x014B, 556},
    {0x014C, 778}, {0x014D, 556}, {0x014E,   0}, {0x0150, 778},
    {0x0151, 556}, {0x0152,1000}, {0x0153, 944}, {0x0154, 722},
    {0x0155, 333}, {0x0156, 722}, {0x0157, 333}, {0x0158, 722},
    {0x0159, 333}, {0x015A, 667}, {0x015B, 500}, {0x015C,   0},
    {0x015E, 667}, {0x015F, 500}, {0x0160, 667}, {0x0161, 500},
    {0x0162, 611}, {0x0163, 278}, {0x0164, 611}, {0x0165, 375},
    {0x0166, 611}, {0x0167, 278}, {0x0168, 722}, {0x0169, 556},
    {0x016A, 722}, {0x016B, 556}, {0x016C,   0}, {0x016E, 722},
    {0x016F, 556}, {0x0170, 722}, {0x0171, 556}, {0x0172, 722},
    {0x0173, 556}, {0x0174,   0}, {0x0178, 667}, {0x0179, 611},
    {0x017A, 500}, {0x017B, 611}, {0x017C, 500}, {0x017D, 611},
    {0x017E, 500}, {0x017F,   0}, {0x0192, 556}, {0x0193,   0},
    {0x0218, 750}, {0x021A, 611}, {0x021B, 278}, {0x021C,   0},
    {0x02C6, 333}, {0x02C8,   0}, {0x02D8, 333}, {0x02DA,   0},
    {0x02DB, 333}, {0x02DE,   0}, {0x2013, 556}, {0x2014,1000},
    {0x2016,   0}, {0x2018, 222}, {0x201B,   0}, {0x201C, 333},
    {0x201F,   0}, {0x2020, 556}, {0x2022, 350}, {0x2023,   0},
    {0x2026,1000}, {0x2027,   0}, {0x2030,1000}, {0x2031,   0},
    {0x2039, 333}, {0x203B,   0}, {0x20AC, 556}, {0x20AD,   0},
    {0x2122,1000}, {0x2123,   0}, {0x2202, 494}, {0x2203,   0},
    {0x2211, 713}, {0x2212, 584}, {0x2213,   0}, {0x221A, 549},
    {0x221B,   0}, {0x2260, 549}, {0x2261,   0}, {0x2264, 549},
    {0x2266,   0}, {0x25CA, 494}, {0x25CB,   0}, {0xF6C3, 750},
    {0xF6C4,   0}, {0xFB01, 500}, {0xFB03,   0}, {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_05 =
{
    "Helvetica",
    32L,
    fnt_Type1,
    cc_none,
    0,
    0,
    -665,
    -325,
    2028,
    1037,
    -106,
    73,
    718,
    523,
    718,
    -207,
    88,
    0,
    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    268,
    fnt_glyph_width_05,
    0,
    NULL,

};

/* -------- Generated from ARIALBD.TTF -------- */

static fnt_interwidth fnt_glyph_width_06[269] =
{
    {0x0000,   0}, {0x0020, 278}, {0x0021, 333}, {0x0022, 474},
    {0x0023, 556}, {0x0025, 889}, {0x0026, 722}, {0x0027, 238},
    {0x0028, 333}, {0x002A, 389}, {0x002B, 584}, {0x002C, 278},
    {0x002D, 333}, {0x002E, 278}, {0x0030, 556}, {0x003A, 333},
    {0x003C, 584}, {0x003F, 611}, {0x0040, 975}, {0x0041, 722},
    {0x0045, 667}, {0x0046, 611}, {0x0047, 778}, {0x0048, 722},
    {0x0049, 278}, {0x004A, 556}, {0x004B, 722}, {0x004C, 611},
    {0x004D, 833}, {0x004E, 722}, {0x004F, 778}, {0x0050, 667},
    {0x0051, 778}, {0x0052, 722}, {0x0053, 667}, {0x0054, 611},
    {0x0055, 722}, {0x0056, 667}, {0x0057, 944}, {0x0058, 667},
    {0x005A, 611}, {0x005B, 333}, {0x005C, 278}, {0x005D, 333},
    {0x005E, 584}, {0x005F, 556}, {0x0060, 333}, {0x0061, 556},
    {0x0062, 611}, {0x0063, 556}, {0x0064, 611}, {0x0065, 556},
    {0x0066, 333}, {0x0067, 611}, {0x0069, 278}, {0x006B, 556},
    {0x006C, 278}, {0x006D, 889}, {0x006E, 611}, {0x0072, 389},
    {0x0073, 556}, {0x0074, 333}, {0x0075, 611}, {0x0076, 556},
    {0x0077, 778}, {0x0078, 556}, {0x007A, 500}, {0x007B, 389},
    {0x007C, 280}, {0x007D, 389}, {0x007E, 584}, {0x007F,   0},
    {0x00A0, 278}, {0x00A1, 333}, {0x00A2, 556}, {0x00A6, 280},
    {0x00A7, 556}, {0x00A8, 333}, {0x00A9, 737}, {0x00AA, 370},
    {0x00AB, 556}, {0x00AC, 584}, {0x00AD, 333}, {0x00AE, 737},
    {0x00AF, 552}, {0x00B0, 400}, {0x00B1, 549}, {0x00B2, 333},
    {0x00B5, 576}, {0x00B6, 556}, {0x00B7, 278}, {0x00B8, 333},
    {0x00BA, 365}, {0x00BB, 556}, {0x00BC, 834}, {0x00BF, 611},
    {0x00C0, 722}, {0x00C6,1000}, {0x00C7, 722}, {0x00C8, 667},
    {0x00CC, 278}, {0x00D0, 722}, {0x00D2, 778}, {0x00D7, 584},
    {0x00D8, 778}, {0x00D9, 722}, {0x00DD, 667}, {0x00DF, 611},
    {0x00E0, 556}, {0x00E6, 889}, {0x00E7, 556}, {0x00EC, 278},
    {0x00F0, 611}, {0x00F7, 549}, {0x00F8, 611}, {0x00FD, 556},
    {0x00FE, 611}, {0x00FF, 556}, {0x0100, 722}, {0x0101, 556},
    {0x0102, 722}, {0x0103, 556}, {0x0104, 722}, {0x0105, 556},
    {0x0106, 722}, {0x0107, 556}, {0x0108,   0}, {0x010C, 722},
    {0x010D, 556}, {0x010E, 722}, {0x010F, 719}, {0x0110, 722},
    {0x0111, 611}, {0x0112, 667}, {0x0113, 556}, {0x0114,   0},
    {0x0116, 667}, {0x0117, 556}, {0x0118, 667}, {0x0119, 556},
    {0x011A, 667}, {0x011B, 556}, {0x011C,   0}, {0x011E, 778},
    {0x011F, 611}, {0x0120,   0}, {0x0122, 778}, {0x0123, 611},
    {0x0124,   0}, {0x0128, 278}, {0x012C,   0}, {0x012E, 278},
    {0x0132,   0}, {0x0136, 722}, {0x0137, 556}, {0x0139, 611},
    {0x013A, 278}, {0x013B, 611}, {0x013C, 278}, {0x013D, 611},
    {0x013E, 385}, {0x013F,   0}, {0x0141, 611}, {0x0142, 278},
    {0x0143, 722}, {0x0144, 611}, {0x0145, 722}, {0x0146, 611},
    {0x0147, 722}, {0x0148, 611}, {0x0149,   0}, {0x014A, 723},
    {0x014B, 611}, {0x014C, 778}, {0x014D, 611}, {0x014E,   0},
    {0x0150, 778}, {0x0151, 611}, {0x0152,1000}, {0x0153, 944},
    {0x0154, 722}, {0x0155, 389}, {0x0156, 722}, {0x0157, 389},
    {0x0158, 722}, {0x0159, 389}, {0x015A, 667}, {0x015B, 556},
    {0x015C,   0}, {0x015E, 667}, {0x015F, 556}, {0x0160, 667},
    {0x0161, 556}, {0x0162, 611}, {0x0163, 333}, {0x0164, 611},
    {0x0165, 479}, {0x0166, 611}, {0x0167, 333}, {0x0168, 722},
    {0x0169, 611}, {0x016A, 722}, {0x016B, 611}, {0x016C,   0},
    {0x016E, 722}, {0x016F, 611}, {0x0170, 722}, {0x0171, 611},
    {0x0172, 722}, {0x0173, 611}, {0x0174,   0}, {0x0178, 667},
    {0x0179, 611}, {0x017A, 500}, {0x017B, 611}, {0x017C, 500},
    {0x017D, 611}, {0x017E, 500}, {0x017F,   0}, {0x0192, 556},
    {0x0193,   0}, {0x0218, 750}, {0x021A, 611}, {0x021B, 333},
    {0x021C,   0}, {0x02C6, 333}, {0x02C8,   0}, {0x02D8, 333},
    {0x02DA,   0}, {0x02DB, 333}, {0x02DE,   0}, {0x2013, 556},
    {0x2014,1000}, {0x2016,   0}, {0x2018, 278}, {0x201B,   0},
    {0x201C, 500}, {0x201F,   0}, {0x2020, 556}, {0x2022, 350},
    {0x2023,   0}, {0x2026,1000}, {0x2027,   0}, {0x2030,1000},
    {0x2031,   0}, {0x2039, 333}, {0x203B,   0}, {0x20AC, 556},
    {0x20AD,   0}, {0x2122,1000}, {0x2123,   0}, {0x2202, 494},
    {0x2203,   0}, {0x2211, 713}, {0x2212, 584}, {0x2213,   0},
    {0x221A, 549}, {0x221B,   0}, {0x2260, 549}, {0x2261,   0},
    {0x2264, 549}, {0x2266,   0}, {0x25CA, 494}, {0x25CB,   0},
    {0xF6C3, 750}, {0xF6C4,   0}, {0xFB01, 611}, {0xFB03,   0},
    {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_06 =
{
    "Helvetica-Bold",
    262176L,
    fnt_Type1,
    cc_none,
    0,
    0,
    -628,
    -376,
    2000,
    1010,
    -106,
    105,
    718,
    532,
    718,
    -207,
    166,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    269,
    fnt_glyph_width_06,
    0,
    NULL,

};

/* -------- Generated from ARIALI.TTF -------- */

static fnt_interwidth fnt_glyph_width_07[268] =
{
    {0x0000,   0}, {0x0020, 278}, {0x0022, 355}, {0x0023, 556},
    {0x0025, 889}, {0x0026, 667}, {0x0027, 191}, {0x0028, 333},
    {0x002A, 389}, {0x002B, 584}, {0x002C, 278}, {0x002D, 333},
    {0x002E, 278}, {0x0030, 556}, {0x003A, 278}, {0x003C, 584},
    {0x003F, 556}, {0x0040,1015}, {0x0041, 667}, {0x0043, 722},
    {0x0045, 667}, {0x0046, 611}, {0x0047, 778}, {0x0048, 722},
    {0x0049, 278}, {0x004A, 500}, {0x004B, 667}, {0x004C, 556},
    {0x004D, 833}, {0x004E, 722}, {0x004F, 778}, {0x0050, 667},
    {0x0051, 778}, {0x0052, 722}, {0x0053, 667}, {0x0054, 611},
    {0x0055, 722}, {0x0056, 667}, {0x0057, 944}, {0x0058, 667},
    {0x005A, 611}, {0x005B, 278}, {0x005E, 469}, {0x005F, 556},
    {0x0060, 333}, {0x0061, 556}, {0x0063, 500}, {0x0064, 556},
    {0x0066, 278}, {0x0067, 556}, {0x0069, 222}, {0x006B, 500},
    {0x006C, 222}, {0x006D, 833}, {0x006E, 556}, {0x0072, 333},
    {0x0073, 500}, {0x0074, 278}, {0x0075, 556}, {0x0076, 500},
    {0x0077, 722}, {0x0078, 500}, {0x007B, 334}, {0x007C, 260},
    {0x007D, 334}, {0x007E, 584}, {0x007F,   0}, {0x00A0, 278},
    {0x00A1, 333}, {0x00A2, 556}, {0x00A6, 260}, {0x00A7, 556},
    {0x00A8, 333}, {0x00A9, 737}, {0x00AA, 370}, {0x00AB, 556},
    {0x00AC, 584}, {0x00AD, 333}, {0x00AE, 737}, {0x00AF, 552},
    {0x00B0, 400}, {0x00B1, 549}, {0x00B2, 333}, {0x00B5, 576},
    {0x00B6, 537}, {0x00B7, 278}, {0x00B8, 333}, {0x00BA, 365},
    {0x00BB, 556}, {0x00BC, 834}, {0x00BF, 611}, {0x00C0, 667},
    {0x00C6,1000}, {0x00C7, 722}, {0x00C8, 667}, {0x00CC, 278},
    {0x00D0, 722}, {0x00D2, 778}, {0x00D7, 584}, {0x00D8, 778},
    {0x00D9, 722}, {0x00DD, 667}, {0x00DF, 611}, {0x00E0, 556},
    {0x00E6, 889}, {0x00E7, 500}, {0x00E8, 556}, {0x00EC, 278},
    {0x00F0, 556}, {0x00F7, 549}, {0x00F8, 611}, {0x00F9, 556},
    {0x00FD, 500}, {0x00FE, 556}, {0x00FF, 500}, {0x0100, 667},
    {0x0101, 556}, {0x0102, 667}, {0x0103, 556}, {0x0104, 667},
    {0x0105, 556}, {0x0106, 722}, {0x0107, 500}, {0x0108,   0},
    {0x010C, 722}, {0x010D, 500}, {0x010E, 722}, {0x010F, 625},
    {0x0110, 722}, {0x0111, 556}, {0x0112, 667}, {0x0113, 556},
    {0x0114,   0}, {0x0116, 667}, {0x0117, 556}, {0x0118, 667},
    {0x0119, 556}, {0x011A, 667}, {0x011B, 556}, {0x011C,   0},
    {0x011E, 778}, {0x011F, 556}, {0x0120,   0}, {0x0122, 778},
    {0x0123, 556}, {0x0124,   0}, {0x0128, 278}, {0x012C,   0},
    {0x012E, 278}, {0x012F, 222}, {0x0130, 278}, {0x0132,   0},
    {0x0136, 667}, {0x0137, 500}, {0x0139, 556}, {0x013A, 222},
    {0x013B, 556}, {0x013C, 222}, {0x013D, 556}, {0x013E, 281},
    {0x013F,   0}, {0x0141, 556}, {0x0142, 222}, {0x0143, 722},
    {0x0144, 556}, {0x0145, 722}, {0x0146, 556}, {0x0147, 722},
    {0x0148, 556}, {0x0149,   0}, {0x014A, 723}, {0x014B, 556},
    {0x014C, 778}, {0x014D, 556}, {0x014E,   0}, {0x0150, 778},
    {0x0151, 556}, {0x0152,1000}, {0x0153, 944}, {0x0154, 722},
    {0x0155, 333}, {0x0156, 722}, {0x0157, 333}, {0x0158, 722},
    {0x0159, 333}, {0x015A, 667}, {0x015B, 500}, {0x015C,   0},
    {0x015E, 667}, {0x015F, 500}, {0x0160, 667}, {0x0161, 500},
    {0x0162, 611}, {0x0163, 278}, {0x0164, 611}, {0x0165, 354},
    {0x0166, 611}, {0x0167, 278}, {0x0168, 722}, {0x0169, 556},
    {0x016A, 722}, {0x016B, 556}, {0x016C,   0}, {0x016E, 722},
    {0x016F, 556}, {0x0170, 722}, {0x0171, 556}, {0x0172, 722},
    {0x0173, 556}, {0x0174,   0}, {0x0178, 667}, {0x0179, 611},
    {0x017A, 500}, {0x017B, 611}, {0x017C, 500}, {0x017D, 611},
    {0x017E, 500}, {0x017F,   0}, {0x0192, 556}, {0x0193,   0},
    {0x0218, 750}, {0x021A, 611}, {0x021B, 278}, {0x021C,   0},
    {0x02C6, 333}, {0x02C8,   0}, {0x02D8, 333}, {0x02DA,   0},
    {0x02DB, 333}, {0x02DE,   0}, {0x2013, 556}, {0x2014,1000},
    {0x2016,   0}, {0x2018, 222}, {0x201B,   0}, {0x201C, 333},
    {0x201F,   0}, {0x2020, 556}, {0x2022, 350}, {0x2023,   0},
    {0x2026,1000}, {0x2027,   0}, {0x2030,1000}, {0x2031,   0},
    {0x2039, 333}, {0x203B,   0}, {0x20AC, 556}, {0x20AD,   0},
    {0x2122,1000}, {0x2123,   0}, {0x2202, 494}, {0x2203,   0},
    {0x2211, 713}, {0x2212, 584}, {0x2213,   0}, {0x221A, 549},
    {0x221B,   0}, {0x2260, 549}, {0x2261,   0}, {0x2264, 549},
    {0x2266,   0}, {0x25CA, 494}, {0x25CB,   0}, {0xF6C3, 750},
    {0xF6C4,   0}, {0xFB01, 500}, {0xFB03,   0}, {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_07 =
{
    "Helvetica-Oblique",
    96L,
    fnt_Type1,
    cc_none,
    -12,
    0,
    -517,
    -325,
    1082,
    998,
    -106,
    73,
    718,
    523,
    718,
    -207,
    88,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    268,
    fnt_glyph_width_07,
    0,
    NULL,

};

/* -------- Generated from ARIALBI.TTF -------- */

static fnt_interwidth fnt_glyph_width_08[269] =
{
    {0x0000,   0}, {0x0020, 278}, {0x0021, 333}, {0x0022, 474},
    {0x0023, 556}, {0x0025, 889}, {0x0026, 722}, {0x0027, 238},
    {0x0028, 333}, {0x002A, 389}, {0x002B, 584}, {0x002C, 278},
    {0x002D, 333}, {0x002E, 278}, {0x0030, 556}, {0x003A, 333},
    {0x003C, 584}, {0x003F, 611}, {0x0040, 975}, {0x0041, 722},
    {0x0045, 667}, {0x0046, 611}, {0x0047, 778}, {0x0048, 722},
    {0x0049, 278}, {0x004A, 556}, {0x004B, 722}, {0x004C, 611},
    {0x004D, 833}, {0x004E, 722}, {0x004F, 778}, {0x0050, 667},
    {0x0051, 778}, {0x0052, 722}, {0x0053, 667}, {0x0054, 611},
    {0x0055, 722}, {0x0056, 667}, {0x0057, 944}, {0x0058, 667},
    {0x005A, 611}, {0x005B, 333}, {0x005C, 278}, {0x005D, 333},
    {0x005E, 584}, {0x005F, 556}, {0x0060, 333}, {0x0061, 556},
    {0x0062, 611}, {0x0063, 556}, {0x0064, 611}, {0x0065, 556},
    {0x0066, 333}, {0x0067, 611}, {0x0069, 278}, {0x006B, 556},
    {0x006C, 278}, {0x006D, 889}, {0x006E, 611}, {0x0072, 389},
    {0x0073, 556}, {0x0074, 333}, {0x0075, 611}, {0x0076, 556},
    {0x0077, 778}, {0x0078, 556}, {0x007A, 500}, {0x007B, 389},
    {0x007C, 280}, {0x007D, 389}, {0x007E, 584}, {0x007F,   0},
    {0x00A0, 278}, {0x00A1, 333}, {0x00A2, 556}, {0x00A6, 280},
    {0x00A7, 556}, {0x00A8, 333}, {0x00A9, 737}, {0x00AA, 370},
    {0x00AB, 556}, {0x00AC, 584}, {0x00AD, 333}, {0x00AE, 737},
    {0x00AF, 552}, {0x00B0, 400}, {0x00B1, 549}, {0x00B2, 333},
    {0x00B5, 576}, {0x00B6, 556}, {0x00B7, 278}, {0x00B8, 333},
    {0x00BA, 365}, {0x00BB, 556}, {0x00BC, 834}, {0x00BF, 611},
    {0x00C0, 722}, {0x00C6,1000}, {0x00C7, 722}, {0x00C8, 667},
    {0x00CC, 278}, {0x00D0, 722}, {0x00D2, 778}, {0x00D7, 584},
    {0x00D8, 778}, {0x00D9, 722}, {0x00DD, 667}, {0x00DF, 611},
    {0x00E0, 556}, {0x00E6, 889}, {0x00E7, 556}, {0x00EC, 278},
    {0x00F0, 611}, {0x00F7, 549}, {0x00F8, 611}, {0x00FD, 556},
    {0x00FE, 611}, {0x00FF, 556}, {0x0100, 722}, {0x0101, 556},
    {0x0102, 722}, {0x0103, 556}, {0x0104, 722}, {0x0105, 556},
    {0x0106, 722}, {0x0107, 556}, {0x0108,   0}, {0x010C, 722},
    {0x010D, 556}, {0x010E, 722}, {0x010F, 740}, {0x0110, 722},
    {0x0111, 611}, {0x0112, 667}, {0x0113, 556}, {0x0114,   0},
    {0x0116, 667}, {0x0117, 556}, {0x0118, 667}, {0x0119, 556},
    {0x011A, 667}, {0x011B, 556}, {0x011C,   0}, {0x011E, 778},
    {0x011F, 611}, {0x0120,   0}, {0x0122, 778}, {0x0123, 611},
    {0x0124,   0}, {0x0128, 278}, {0x012C,   0}, {0x012E, 278},
    {0x0132,   0}, {0x0136, 722}, {0x0137, 556}, {0x0139, 611},
    {0x013A, 278}, {0x013B, 611}, {0x013C, 278}, {0x013D, 611},
    {0x013E, 396}, {0x013F,   0}, {0x0141, 611}, {0x0142, 278},
    {0x0143, 722}, {0x0144, 611}, {0x0145, 722}, {0x0146, 611},
    {0x0147, 722}, {0x0148, 611}, {0x0149,   0}, {0x014A, 723},
    {0x014B, 611}, {0x014C, 778}, {0x014D, 611}, {0x014E,   0},
    {0x0150, 778}, {0x0151, 611}, {0x0152,1000}, {0x0153, 944},
    {0x0154, 722}, {0x0155, 389}, {0x0156, 722}, {0x0157, 389},
    {0x0158, 722}, {0x0159, 389}, {0x015A, 667}, {0x015B, 556},
    {0x015C,   0}, {0x015E, 667}, {0x015F, 556}, {0x0160, 667},
    {0x0161, 556}, {0x0162, 611}, {0x0163, 333}, {0x0164, 611},
    {0x0165, 479}, {0x0166, 611}, {0x0167, 333}, {0x0168, 722},
    {0x0169, 611}, {0x016A, 722}, {0x016B, 611}, {0x016C,   0},
    {0x016E, 722}, {0x016F, 611}, {0x0170, 722}, {0x0171, 611},
    {0x0172, 722}, {0x0173, 611}, {0x0174,   0}, {0x0178, 667},
    {0x0179, 611}, {0x017A, 500}, {0x017B, 611}, {0x017C, 500},
    {0x017D, 611}, {0x017E, 500}, {0x017F,   0}, {0x0192, 556},
    {0x0193,   0}, {0x0218, 750}, {0x021A, 611}, {0x021B, 333},
    {0x021C,   0}, {0x02C6, 333}, {0x02C8,   0}, {0x02D8, 333},
    {0x02DA,   0}, {0x02DB, 333}, {0x02DE,   0}, {0x2013, 556},
    {0x2014,1000}, {0x2016,   0}, {0x2018, 278}, {0x201B,   0},
    {0x201C, 500}, {0x201F,   0}, {0x2020, 556}, {0x2022, 350},
    {0x2023,   0}, {0x2026,1000}, {0x2027,   0}, {0x2030,1000},
    {0x2031,   0}, {0x2039, 333}, {0x203B,   0}, {0x20AC, 556},
    {0x20AD,   0}, {0x2122,1000}, {0x2123,   0}, {0x2202, 494},
    {0x2203,   0}, {0x2211, 713}, {0x2212, 584}, {0x2213,   0},
    {0x221A, 549}, {0x221B,   0}, {0x2260, 549}, {0x2261,   0},
    {0x2264, 549}, {0x2266,   0}, {0x25CA, 494}, {0x25CB,   0},
    {0xF6C3, 750}, {0xF6C4,   0}, {0xFB01, 611}, {0xFB03,   0},
    {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_08 =
{
    "Helvetica-BoldOblique",
    262240L,
    fnt_Type1,
    cc_none,
    -12,
    0,
    -560,
    -376,
    1157,
    1000,
    -106,
    105,
    718,
    532,
    718,
    -207,
    166,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    269,
    fnt_glyph_width_08,
    0,
    NULL,

};

/* -------- Generated from Symbol.afm -------- */

static fnt_glyphwidth fnt_glyph_width_09[191] =
{
    {0x0020,  32,  250},    {0x0021,  33,  333},    {0x2200,  34,  713},
    {0x0023,  35,  500},    {0x2203,  36,  549},    {0x0025,  37,  833},
    {0x0026,  38,  778},    {0x220b,  39,  439},    {0x0028,  40,  333},
    {0x0029,  41,  333},    {0x2217,  42,  500},    {0x002b,  43,  549},
    {0x002c,  44,  250},    {0x2212,  45,  549},    {0x002e,  46,  250},
    {0x002f,  47,  278},    {0x0030,  48,  500},    {0x0031,  49,  500},
    {0x0032,  50,  500},    {0x0033,  51,  500},    {0x0034,  52,  500},
    {0x0035,  53,  500},    {0x0036,  54,  500},    {0x0037,  55,  500},
    {0x0038,  56,  500},    {0x0039,  57,  500},    {0x003a,  58,  278},
    {0x003b,  59,  278},    {0x003c,  60,  549},    {0x003d,  61,  549},
    {0x003e,  62,  549},    {0x003f,  63,  444},    {0x2245,  64,  549},
    {0x0391,  65,  722},    {0x0392,  66,  667},    {0x03a7,  67,  722},
    {0x0394,  68,  612},    {0x0395,  69,  611},    {0x03a6,  70,  763},
    {0x0393,  71,  603},    {0x0397,  72,  722},    {0x0399,  73,  333},
    {0x03d1,  74,  631},    {0x039a,  75,  722},    {0x039b,  76,  686},
    {0x039c,  77,  889},    {0x039d,  78,  722},    {0x039f,  79,  722},
    {0x03a0,  80,  768},    {0x0398,  81,  741},    {0x03a1,  82,  556},
    {0x03a3,  83,  592},    {0x03a4,  84,  611},    {0x03a5,  85,  690},
    {0x03c2,  86,  439},    {0x03a9,  87,  768},    {0x039e,  88,  645},
    {0x03a8,  89,  795},    {0x0396,  90,  611},    {0x005b,  91,  333},
    {0x2234,  92,  863},    {0x005d,  93,  333},    {0x22a5,  94,  658},
    {0x005f,  95,  500},    {0xf8e5,  96,  500},    {0x03b1,  97,  631},
    {0x03b2,  98,  549},    {0x03c7,  99,  549},    {0x03b4, 100,  494},
    {0x03b5, 101,  439},    {0x03c6, 102,  521},    {0x03b3, 103,  411},
    {0x03b7, 104,  603},    {0x03b9, 105,  329},    {0x03d5, 106,  603},
    {0x03ba, 107,  549},    {0x03bb, 108,  549},    {0x03bc, 109,  576},
    {0x03bd, 110,  521},    {0x03bf, 111,  549},    {0x03c0, 112,  549},
    {0x03b8, 113,  521},    {0x03c1, 114,  549},    {0x03c3, 115,  603},
    {0x03c4, 116,  439},    {0x03c5, 117,  576},    {0x03d6, 118,  713},
    {0x03c9, 119,  686},    {0x03be, 120,  493},    {0x03c8, 121,  686},
    {0x03b6, 122,  494},    {0x007b, 123,  480},    {0x007c, 124,  200},
    {0x007d, 125,  480},    {0x223c, 126,  549},    {0x20ac, 160,  750},
    {0x03d2, 161,  620},    {0x2032, 162,  247},    {0x2264, 163,  549},
    {0x2044, 164,  167},    {0x221e, 165,  713},    {0x0192, 166,  500},
    {0x2663, 167,  753},    {0x2666, 168,  753},    {0x2665, 169,  753},
    {0x2660, 170,  753},    {0x2194, 171, 1042},    {0x2190, 172,  987},
    {0x2191, 173,  603},    {0x2192, 174,  987},    {0x2193, 175,  603},
    {0x00b0, 176,  400},    {0x00b1, 177,  549},    {0x2033, 178,  411},
    {0x2265, 179,  549},    {0x00d7, 180,  549},    {0x221d, 181,  713},
    {0x2202, 182,  494},    {0x2022, 183,  460},    {0x00f7, 184,  549},
    {0x2260, 185,  549},    {0x2261, 186,  549},    {0x2248, 187,  549},
    {0x2026, 188, 1000},    {0xf8e6, 189,  603},    {0xf8e7, 190, 1000},
    {0x21b5, 191,  658},    {0x2135, 192,  823},    {0x2111, 193,  686},
    {0x211c, 194,  795},    {0x2118, 195,  987},    {0x2297, 196,  768},
    {0x2295, 197,  768},    {0x2205, 198,  823},    {0x2229, 199,  768},
    {0x222a, 200,  768},    {0x2283, 201,  713},    {0x2287, 202,  713},
    {0x2284, 203,  713},    {0x2282, 204,  713},    {0x2286, 205,  713},
    {0x2208, 206,  713},    {0x2209, 207,  713},    {0x2220, 208,  768},
    {0x2207, 209,  713},    {0xf6da, 210,  790},    {0xf6d9, 211,  790},
    {0xf6db, 212,  890},    {0x220f, 213,  823},    {0x221a, 214,  549},
    {0x22c5, 215,  250},    {0x00ac, 216,  713},    {0x2227, 217,  603},
    {0x2228, 218,  603},    {0x21d4, 219, 1042},    {0x21d0, 220,  987},
    {0x21d1, 221,  603},    {0x21d2, 222,  987},    {0x21d3, 223,  603},
    {0x25ca, 224,  494},    {0x2329, 225,  329},    {0xf8e8, 226,  790},
    {0xf8e9, 227,  790},    {0xf8ea, 228,  786},    {0x2211, 229,  713},
    {0xf8eb, 230,  384},    {0xf8ec, 231,  384},    {0xf8ed, 232,  384},
    {0xf8ee, 233,  384},    {0xf8ef, 234,  384},    {0xf8f0, 235,  384},
    {0xf8f1, 236,  494},    {0xf8f2, 237,  494},    {0xf8f3, 238,  494},
    {0xf8f4, 239,  494},    {0x232a, 241,  329},    {0x222b, 242,  274},
    {0x2320, 243,  686},    {0xf8f5, 244,  686},    {0x2321, 245,  686},
    {0xf8f6, 246,  384},    {0xf8f7, 247,  384},    {0xf8f8, 248,  384},
    {0xf8f9, 249,  384},    {0xf8fa, 250,  384},    {0xf8fb, 251,  384},
    {0xf8fc, 252,  494},    {0xf8fd, 253,  494},    {0xf8fe, 254,  494},
    {0xf8ff, -1,   790},    {0x0000,  -1,  790}
};

static const fnt_font_metric fnt_font_metric_09 =
{
    "Symbol",		        /* FontName */
    4L,			        /* flags */
    fnt_Type1,                  /* font type */
    cc_none,                    /* Character collection */
    0.0,		        /* ItalicAngle */
    0,				/* isFixedPitch */
    -180,			/* llx */
    -293,			/* lly */
    1090,			/* urx */
    1010,			/* ury */
    -100,			/* UnderlinePosition */
    50,				/* UnderlineThickness */
    700,			/* CapHeight */
    0,			        /* xHeight */
    800,			/* Ascender */
    -200,			/* Descender */
    85,				/* StdVW */
    0,				/* StdHW */

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    0,
    NULL,
    191,
    fnt_glyph_width_09,

};

/* -------- Generated from TIMES.TTF -------- */

static fnt_interwidth fnt_glyph_width_10[271] =
{
    {0x0000,   0}, {0x0020, 250}, {0x0021, 333}, {0x0022, 408},
    {0x0023, 500}, {0x0025, 833}, {0x0026, 778}, {0x0027, 180},
    {0x0028, 333}, {0x002A, 500}, {0x002B, 564}, {0x002C, 250},
    {0x002D, 333}, {0x002E, 250}, {0x002F, 278}, {0x0030, 500},
    {0x003A, 278}, {0x003C, 564}, {0x003F, 444}, {0x0040, 921},
    {0x0041, 722}, {0x0042, 667}, {0x0044, 722}, {0x0045, 611},
    {0x0046, 556}, {0x0047, 722}, {0x0049, 333}, {0x004A, 389},
    {0x004B, 722}, {0x004C, 611}, {0x004D, 889}, {0x004E, 722},
    {0x0050, 556}, {0x0051, 722}, {0x0052, 667}, {0x0053, 556},
    {0x0054, 611}, {0x0055, 722}, {0x0057, 944}, {0x0058, 722},
    {0x005A, 611}, {0x005B, 333}, {0x005C, 278}, {0x005D, 333},
    {0x005E, 469}, {0x005F, 500}, {0x0060, 333}, {0x0061, 444},
    {0x0062, 500}, {0x0063, 444}, {0x0064, 500}, {0x0065, 444},
    {0x0066, 333}, {0x0067, 500}, {0x0069, 278}, {0x006B, 500},
    {0x006C, 278}, {0x006D, 778}, {0x006E, 500}, {0x0072, 333},
    {0x0073, 389}, {0x0074, 278}, {0x0075, 500}, {0x0077, 722},
    {0x0078, 500}, {0x007A, 444}, {0x007B, 480}, {0x007C, 200},
    {0x007D, 480}, {0x007E, 541}, {0x007F,   0}, {0x00A0, 250},
    {0x00A1, 333}, {0x00A2, 500}, {0x00A6, 200}, {0x00A7, 500},
    {0x00A8, 333}, {0x00A9, 760}, {0x00AA, 276}, {0x00AB, 500},
    {0x00AC, 564}, {0x00AD, 333}, {0x00AE, 760}, {0x00AF, 500},
    {0x00B0, 400}, {0x00B1, 549}, {0x00B2, 300}, {0x00B4, 333},
    {0x00B5, 576}, {0x00B6, 453}, {0x00B7, 250}, {0x00B8, 333},
    {0x00B9, 300}, {0x00BA, 310}, {0x00BB, 500}, {0x00BC, 750},
    {0x00BF, 444}, {0x00C0, 722}, {0x00C6, 889}, {0x00C7, 667},
    {0x00C8, 611}, {0x00CC, 333}, {0x00D0, 722}, {0x00D7, 564},
    {0x00D8, 722}, {0x00DE, 556}, {0x00DF, 500}, {0x00E0, 444},
    {0x00E6, 667}, {0x00E7, 444}, {0x00EC, 278}, {0x00F0, 500},
    {0x00F7, 549}, {0x00F8, 500}, {0x0100, 722}, {0x0101, 444},
    {0x0102, 722}, {0x0103, 444}, {0x0104, 722}, {0x0105, 444},
    {0x0106, 667}, {0x0107, 444}, {0x0108,   0}, {0x010C, 667},
    {0x010D, 444}, {0x010E, 722}, {0x010F, 646}, {0x0110, 722},
    {0x0111, 500}, {0x0112, 611}, {0x0113, 444}, {0x0114,   0},
    {0x0116, 611}, {0x0117, 444}, {0x0118, 611}, {0x0119, 444},
    {0x011A, 611}, {0x011B, 444}, {0x011C,   0}, {0x011E, 722},
    {0x011F, 500}, {0x0120,   0}, {0x0122, 722}, {0x0123, 500},
    {0x0124,   0}, {0x0128, 333}, {0x0129, 278}, {0x012A, 333},
    {0x012B, 278}, {0x012C,   0}, {0x012E, 333}, {0x012F, 278},
    {0x0130, 333}, {0x0131, 278}, {0x0132,   0}, {0x0136, 722},
    {0x0137, 500}, {0x0139, 611}, {0x013A, 278}, {0x013B, 611},
    {0x013C, 278}, {0x013D, 611}, {0x013E, 406}, {0x013F,   0},
    {0x0141, 611}, {0x0142, 278}, {0x0143, 722}, {0x0144, 500},
    {0x0145, 722}, {0x0146, 500}, {0x0147, 722}, {0x0148, 500},
    {0x0149,   0}, {0x014A, 702}, {0x014B, 495}, {0x014C, 722},
    {0x014D, 500}, {0x014E,   0}, {0x0150, 722}, {0x0151, 500},
    {0x0152, 889}, {0x0153, 722}, {0x0154, 667}, {0x0155, 333},
    {0x0156, 667}, {0x0157, 333}, {0x0158, 667}, {0x0159, 333},
    {0x015A, 556}, {0x015B, 389}, {0x015C,   0}, {0x015E, 556},
    {0x015F, 389}, {0x0160, 556}, {0x0161, 389}, {0x0162, 611},
    {0x0163, 278}, {0x0164, 611}, {0x0165, 427}, {0x0166, 611},
    {0x0167, 278}, {0x0168, 722}, {0x0169, 500}, {0x016A, 722},
    {0x016B, 500}, {0x016C,   0}, {0x016E, 722}, {0x016F, 500},
    {0x0170, 722}, {0x0171, 500}, {0x0172, 722}, {0x0173, 500},
    {0x0174,   0}, {0x0178, 722}, {0x0179, 611}, {0x017A, 444},
    {0x017B, 611}, {0x017C, 444}, {0x017D, 611}, {0x017E, 444},
    {0x017F,   0}, {0x0192, 500}, {0x0193,   0}, {0x0218, 778},
    {0x021A, 611}, {0x021B, 278}, {0x021C,   0}, {0x02C6, 333},
    {0x02C8,   0}, {0x02D8, 333}, {0x02DA,   0}, {0x02DB, 333},
    {0x02DE,   0}, {0x2013, 500}, {0x2014,1000}, {0x2016,   0},
    {0x2018, 333}, {0x201B,   0}, {0x201C, 444}, {0x201F,   0},
    {0x2020, 500}, {0x2022, 350}, {0x2023,   0}, {0x2026,1000},
    {0x2027,   0}, {0x2030,1000}, {0x2031,   0}, {0x2039, 333},
    {0x203B,   0}, {0x20AC, 500}, {0x20AD,   0}, {0x2122, 980},
    {0x2123,   0}, {0x2202, 494}, {0x2203,   0}, {0x2211, 713},
    {0x2212, 564}, {0x2213,   0}, {0x221A, 549}, {0x221B,   0},
    {0x2260, 549}, {0x2261,   0}, {0x2264, 549}, {0x2266,   0},
    {0x25CA, 494}, {0x25CB,   0}, {0xF6C3, 778}, {0xF6C4,   0},
    {0xFB01, 556}, {0xFB03,   0}, {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_10 =
{
    "Times-Roman",
    32L,
    fnt_Type1,
    cc_none,
    0,
    0,
    -568,
    -307,
    2000,
    1007,
    -109,
    49,
    662,
    450,
    683,
    -217,
    88,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    271,
    fnt_glyph_width_10,
    0,
    NULL,

};

/* -------- Generated from TIMESBD.TTF -------- */

static fnt_interwidth fnt_glyph_width_11[284] =
{
    {0x0000,   0}, {0x0020, 250}, {0x0021, 333}, {0x0022, 555},
    {0x0023, 500}, {0x0025,1000}, {0x0026, 833}, {0x0027, 278},
    {0x0028, 333}, {0x002A, 500}, {0x002B, 570}, {0x002C, 250},
    {0x002D, 333}, {0x002E, 250}, {0x002F, 278}, {0x0030, 500},
    {0x003A, 333}, {0x003C, 570}, {0x003F, 500}, {0x0040, 930},
    {0x0041, 722}, {0x0042, 667}, {0x0043, 722}, {0x0045, 667},
    {0x0046, 611}, {0x0047, 778}, {0x0049, 389}, {0x004A, 500},
    {0x004B, 778}, {0x004C, 667}, {0x004D, 944}, {0x004E, 722},
    {0x004F, 778}, {0x0050, 611}, {0x0051, 778}, {0x0052, 722},
    {0x0053, 556}, {0x0054, 667}, {0x0055, 722}, {0x0057,1000},
    {0x0058, 722}, {0x005A, 667}, {0x005B, 333}, {0x005C, 278},
    {0x005D, 333}, {0x005E, 581}, {0x005F, 500}, {0x0060, 333},
    {0x0061, 500}, {0x0062, 556}, {0x0063, 444}, {0x0064, 556},
    {0x0065, 444}, {0x0066, 333}, {0x0067, 500}, {0x0068, 556},
    {0x0069, 278}, {0x006A, 333}, {0x006B, 556}, {0x006C, 278},
    {0x006D, 833}, {0x006E, 556}, {0x006F, 500}, {0x0070, 556},
    {0x0072, 444}, {0x0073, 389}, {0x0074, 333}, {0x0075, 556},
    {0x0076, 500}, {0x0077, 722}, {0x0078, 500}, {0x007A, 444},
    {0x007B, 394}, {0x007C, 220}, {0x007D, 394}, {0x007E, 520},
    {0x007F,   0}, {0x00A0, 250}, {0x00A1, 333}, {0x00A2, 500},
    {0x00A6, 220}, {0x00A7, 500}, {0x00A8, 333}, {0x00A9, 747},
    {0x00AA, 300}, {0x00AB, 500}, {0x00AC, 570}, {0x00AD, 333},
    {0x00AE, 747}, {0x00AF, 500}, {0x00B0, 400}, {0x00B1, 549},
    {0x00B2, 300}, {0x00B4, 333}, {0x00B5, 576}, {0x00B6, 540},
    {0x00B7, 250}, {0x00B8, 333}, {0x00B9, 300}, {0x00BA, 330},
    {0x00BB, 500}, {0x00BC, 750}, {0x00BF, 500}, {0x00C0, 722},
    {0x00C6,1000}, {0x00C7, 722}, {0x00C8, 667}, {0x00CC, 389},
    {0x00D0, 722}, {0x00D2, 778}, {0x00D7, 570}, {0x00D8, 778},
    {0x00D9, 722}, {0x00DE, 611}, {0x00DF, 556}, {0x00E0, 500},
    {0x00E6, 722}, {0x00E7, 444}, {0x00EC, 278}, {0x00F0, 500},
    {0x00F1, 556}, {0x00F2, 500}, {0x00F7, 549}, {0x00F8, 500},
    {0x00F9, 556}, {0x00FD, 500}, {0x00FE, 556}, {0x00FF, 500},
    {0x0100, 722}, {0x0101, 500}, {0x0102, 722}, {0x0103, 500},
    {0x0104, 722}, {0x0105, 500}, {0x0106, 722}, {0x0107, 444},
    {0x0108,   0}, {0x010C, 722}, {0x010D, 444}, {0x010E, 722},
    {0x010F, 733}, {0x0110, 722}, {0x0111, 556}, {0x0112, 667},
    {0x0113, 444}, {0x0114,   0}, {0x0116, 667}, {0x0117, 444},
    {0x0118, 667}, {0x0119, 444}, {0x011A, 667}, {0x011B, 444},
    {0x011C,   0}, {0x011E, 778}, {0x011F, 500}, {0x0120,   0},
    {0x0122, 778}, {0x0123, 500}, {0x0124,   0}, {0x0128, 389},
    {0x0129, 278}, {0x012A, 389}, {0x012B, 278}, {0x012C,   0},
    {0x012E, 389}, {0x012F, 278}, {0x0130, 389}, {0x0131, 278},
    {0x0132,   0}, {0x0136, 778}, {0x0137, 556}, {0x0139, 667},
    {0x013A, 278}, {0x013B, 667}, {0x013C, 278}, {0x013D, 667},
    {0x013E, 469}, {0x013F,   0}, {0x0141, 667}, {0x0142, 278},
    {0x0143, 722}, {0x0144, 556}, {0x0145, 722}, {0x0146, 556},
    {0x0147, 722}, {0x0148, 556}, {0x0149,   0}, {0x014A, 769},
    {0x014B, 556}, {0x014C, 778}, {0x014D, 500}, {0x014E,   0},
    {0x0150, 778}, {0x0151, 500}, {0x0152,1000}, {0x0153, 722},
    {0x0155, 444}, {0x0156, 722}, {0x0157, 444}, {0x0158, 722},
    {0x0159, 444}, {0x015A, 556}, {0x015B, 389}, {0x015C,   0},
    {0x015E, 556}, {0x015F, 389}, {0x0160, 556}, {0x0161, 389},
    {0x0162, 667}, {0x0163, 333}, {0x0164, 667}, {0x0165, 521},
    {0x0166, 667}, {0x0167, 333}, {0x0168, 722}, {0x0169, 556},
    {0x016A, 722}, {0x016B, 556}, {0x016C,   0}, {0x016E, 722},
    {0x016F, 556}, {0x0170, 722}, {0x0171, 556}, {0x0172, 722},
    {0x0173, 556}, {0x0174,   0}, {0x0178, 722}, {0x0179, 667},
    {0x017A, 444}, {0x017B, 667}, {0x017C, 444}, {0x017D, 667},
    {0x017E, 444}, {0x017F,   0}, {0x0192, 500}, {0x0193,   0},
    {0x0218, 778}, {0x021A, 667}, {0x021B, 333}, {0x021C,   0},
    {0x02C6, 333}, {0x02C8,   0}, {0x02D8, 333}, {0x02DA,   0},
    {0x02DB, 333}, {0x02DE,   0}, {0x2013, 500}, {0x2014,1000},
    {0x2016,   0}, {0x2018, 333}, {0x201B,   0}, {0x201C, 500},
    {0x201F,   0}, {0x2020, 500}, {0x2022, 350}, {0x2023,   0},
    {0x2026,1000}, {0x2027,   0}, {0x2030,1000}, {0x2031,   0},
    {0x2039, 333}, {0x203B,   0}, {0x20AC, 500}, {0x20AD,   0},
    {0x2122,1000}, {0x2123,   0}, {0x2202, 494}, {0x2203,   0},
    {0x2211, 713}, {0x2212, 570}, {0x2213,   0}, {0x221A, 549},
    {0x221B,   0}, {0x2260, 549}, {0x2261,   0}, {0x2264, 549},
    {0x2266,   0}, {0x25CA, 494}, {0x25CB,   0}, {0xF6C3, 778},
    {0xF6C4,   0}, {0xFB01, 556}, {0xFB03,   0}, {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_11 =
{
    "Times-Bold",
    262176L,
    fnt_Type1,
    cc_none,
    0,
    0,
    -558,
    -307,
    2000,
    1026,
    -109,
    95,
    676,
    461,
    683,
    -217,
    166,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    284,
    fnt_glyph_width_11,
    0,
    NULL,

};

/* -------- Generated from TIMESI.TTF -------- */

static fnt_interwidth fnt_glyph_width_12[276] =
{
    {0x0000,   0}, {0x0020, 250}, {0x0021, 333}, {0x0022, 420},
    {0x0023, 500}, {0x0025, 833}, {0x0026, 778}, {0x0027, 214},
    {0x0028, 333}, {0x002A, 500}, {0x002B, 675}, {0x002C, 250},
    {0x002D, 333}, {0x002E, 250}, {0x002F, 278}, {0x0030, 500},
    {0x003A, 333}, {0x003C, 675}, {0x003F, 500}, {0x0040, 920},
    {0x0041, 611}, {0x0043, 667}, {0x0044, 722}, {0x0045, 611},
    {0x0047, 722}, {0x0049, 333}, {0x004A, 444}, {0x004B, 667},
    {0x004C, 556}, {0x004D, 833}, {0x004E, 667}, {0x004F, 722},
    {0x0050, 611}, {0x0051, 722}, {0x0052, 611}, {0x0053, 500},
    {0x0054, 556}, {0x0055, 722}, {0x0056, 611}, {0x0057, 833},
    {0x0058, 611}, {0x0059, 556}, {0x005B, 389}, {0x005C, 278},
    {0x005D, 389}, {0x005E, 422}, {0x005F, 500}, {0x0060, 333},
    {0x0061, 500}, {0x0063, 444}, {0x0064, 500}, {0x0065, 444},
    {0x0066, 278}, {0x0067, 500}, {0x0069, 278}, {0x006B, 444},
    {0x006C, 278}, {0x006D, 722}, {0x006E, 500}, {0x0072, 389},
    {0x0074, 278}, {0x0075, 500}, {0x0076, 444}, {0x0077, 667},
    {0x0078, 444}, {0x007A, 389}, {0x007B, 400}, {0x007C, 275},
    {0x007D, 400}, {0x007E, 541}, {0x007F,   0}, {0x00A0, 250},
    {0x00A1, 389}, {0x00A2, 500}, {0x00A6, 275}, {0x00A7, 500},
    {0x00A8, 333}, {0x00A9, 760}, {0x00AA, 276}, {0x00AB, 500},
    {0x00AC, 675}, {0x00AD, 333}, {0x00AE, 760}, {0x00AF, 500},
    {0x00B0, 400}, {0x00B1, 549}, {0x00B2, 300}, {0x00B4, 333},
    {0x00B5, 576}, {0x00B6, 523}, {0x00B7, 250}, {0x00B8, 333},
    {0x00B9, 300}, {0x00BA, 310}, {0x00BB, 500}, {0x00BC, 750},
    {0x00BF, 500}, {0x00C0, 611}, {0x00C6, 889}, {0x00C7, 667},
    {0x00C8, 611}, {0x00CC, 333}, {0x00D0, 722}, {0x00D1, 667},
    {0x00D2, 722}, {0x00D7, 675}, {0x00D8, 722}, {0x00DD, 556},
    {0x00DE, 611}, {0x00DF, 500}, {0x00E6, 667}, {0x00E7, 444},
    {0x00EC, 278}, {0x00F0, 500}, {0x00F7, 549}, {0x00F8, 500},
    {0x00FD, 444}, {0x00FE, 500}, {0x00FF, 444}, {0x0100, 611},
    {0x0101, 500}, {0x0102, 611}, {0x0103, 500}, {0x0104, 611},
    {0x0105, 500}, {0x0106, 667}, {0x0107, 444}, {0x0108,   0},
    {0x010C, 667}, {0x010D, 444}, {0x010E, 722}, {0x010F, 608},
    {0x0110, 722}, {0x0111, 500}, {0x0112, 611}, {0x0113, 444},
    {0x0114,   0}, {0x0116, 611}, {0x0117, 444}, {0x0118, 611},
    {0x0119, 444}, {0x011A, 611}, {0x011B, 444}, {0x011C,   0},
    {0x011E, 722}, {0x011F, 500}, {0x0120,   0}, {0x0122, 722},
    {0x0123, 500}, {0x0124,   0}, {0x0128, 333}, {0x0129, 278},
    {0x012A, 333}, {0x012B, 278}, {0x012C,   0}, {0x012E, 333},
    {0x012F, 278}, {0x0130, 333}, {0x0131, 278}, {0x0132,   0},
    {0x0136, 667}, {0x0137, 444}, {0x0139, 556}, {0x013A, 278},
    {0x013B, 556}, {0x013C, 278}, {0x013D, 556}, {0x013E, 364},
    {0x013F,   0}, {0x0141, 556}, {0x0142, 278}, {0x0143, 667},
    {0x0144, 500}, {0x0145, 667}, {0x0146, 500}, {0x0147, 667},
    {0x0148, 500}, {0x0149,   0}, {0x014A, 696}, {0x014B, 482},
    {0x014C, 722}, {0x014D, 500}, {0x014E,   0}, {0x0150, 722},
    {0x0151, 500}, {0x0152, 944}, {0x0153, 667}, {0x0154, 611},
    {0x0155, 389}, {0x0156, 611}, {0x0157, 389}, {0x0158, 611},
    {0x0159, 389}, {0x015A, 500}, {0x015B, 389}, {0x015C,   0},
    {0x015E, 500}, {0x015F, 389}, {0x0160, 500}, {0x0161, 389},
    {0x0162, 556}, {0x0163, 278}, {0x0164, 556}, {0x0165, 364},
    {0x0166, 556}, {0x0167, 278}, {0x0168, 722}, {0x0169, 500},
    {0x016A, 722}, {0x016B, 500}, {0x016C,   0}, {0x016E, 722},
    {0x016F, 500}, {0x0170, 722}, {0x0171, 500}, {0x0172, 722},
    {0x0173, 500}, {0x0174,   0}, {0x0178, 556}, {0x017A, 389},
    {0x017B, 556}, {0x017C, 389}, {0x017D, 556}, {0x017E, 389},
    {0x017F,   0}, {0x0192, 500}, {0x0193,   0}, {0x0218, 778},
    {0x021A, 556}, {0x021B, 278}, {0x021C,   0}, {0x02C6, 333},
    {0x02C8,   0}, {0x02D8, 333}, {0x02DA,   0}, {0x02DB, 333},
    {0x02DE,   0}, {0x2013, 500}, {0x2014, 889}, {0x2015,1000},
    {0x2016,   0}, {0x2018, 333}, {0x201B,   0}, {0x201C, 556},
    {0x201F,   0}, {0x2020, 500}, {0x2022, 350}, {0x2023,   0},
    {0x2026, 889}, {0x2027,   0}, {0x2030,1000}, {0x2031,   0},
    {0x2039, 333}, {0x203B,   0}, {0x20AC, 500}, {0x20AD,   0},
    {0x2122, 980}, {0x2123,   0}, {0x2202, 494}, {0x2203,   0},
    {0x2211, 713}, {0x2212, 675}, {0x2213,   0}, {0x221A, 549},
    {0x221B,   0}, {0x2260, 549}, {0x2261,   0}, {0x2264, 549},
    {0x2266,   0}, {0x25CA, 494}, {0x25CB,   0}, {0xF6C3, 778},
    {0xF6C4,   0}, {0xFB01, 500}, {0xFB03,   0}, {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_12 =
{
    "Times-Italic",
    96L,
    fnt_Type1,
    cc_none,
    -16.333,
    0,
    -498,
    -307,
    1120,
    1023,
    -109,
    49,
    653,
    441,
    683,
    -217,
    88,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    276,
    fnt_glyph_width_12,
    0,
    NULL,

};

/* -------- Generated from TIMESBI.TTF -------- */

static fnt_interwidth fnt_glyph_width_13[275] =
{
    {0x0000,   0}, {0x0020, 250}, {0x0021, 389}, {0x0022, 555},
    {0x0023, 500}, {0x0025, 833}, {0x0026, 778}, {0x0027, 278},
    {0x0028, 333}, {0x002A, 500}, {0x002B, 570}, {0x002C, 250},
    {0x002D, 333}, {0x002E, 250}, {0x002F, 278}, {0x0030, 500},
    {0x003A, 333}, {0x003C, 570}, {0x003F, 500}, {0x0040, 832},
    {0x0041, 667}, {0x0044, 722}, {0x0045, 667}, {0x0047, 722},
    {0x0048, 778}, {0x0049, 389}, {0x004A, 500}, {0x004B, 667},
    {0x004C, 611}, {0x004D, 889}, {0x004E, 722}, {0x0050, 611},
    {0x0051, 722}, {0x0052, 667}, {0x0053, 556}, {0x0054, 611},
    {0x0055, 722}, {0x0056, 667}, {0x0057, 889}, {0x0058, 667},
    {0x0059, 611}, {0x005B, 333}, {0x005C, 278}, {0x005D, 333},
    {0x005E, 570}, {0x005F, 500}, {0x0060, 333}, {0x0061, 500},
    {0x0063, 444}, {0x0064, 500}, {0x0065, 444}, {0x0066, 333},
    {0x0067, 500}, {0x0068, 556}, {0x0069, 278}, {0x006B, 500},
    {0x006C, 278}, {0x006D, 778}, {0x006E, 556}, {0x006F, 500},
    {0x0072, 389}, {0x0074, 278}, {0x0075, 556}, {0x0076, 444},
    {0x0077, 667}, {0x0078, 500}, {0x0079, 444}, {0x007A, 389},
    {0x007B, 348}, {0x007C, 220}, {0x007D, 348}, {0x007E, 570},
    {0x007F,   0}, {0x00A0, 250}, {0x00A1, 389}, {0x00A2, 500},
    {0x00A6, 220}, {0x00A7, 500}, {0x00A8, 333}, {0x00A9, 747},
    {0x00AA, 266}, {0x00AB, 500}, {0x00AC, 606}, {0x00AD, 333},
    {0x00AE, 747}, {0x00AF, 500}, {0x00B0, 400}, {0x00B1, 549},
    {0x00B2, 300}, {0x00B4, 333}, {0x00B5, 576}, {0x00B6, 500},
    {0x00B7, 250}, {0x00B8, 333}, {0x00B9, 300}, {0x00BB, 500},
    {0x00BC, 750}, {0x00BF, 500}, {0x00C0, 667}, {0x00C6, 944},
    {0x00C7, 667}, {0x00CC, 389}, {0x00D0, 722}, {0x00D7, 570},
    {0x00D8, 722}, {0x00DD, 611}, {0x00DF, 500}, {0x00E6, 722},
    {0x00E7, 444}, {0x00EC, 278}, {0x00F0, 500}, {0x00F1, 556},
    {0x00F2, 500}, {0x00F7, 549}, {0x00F8, 500}, {0x00F9, 556},
    {0x00FD, 444}, {0x00FE, 500}, {0x00FF, 444}, {0x0100, 667},
    {0x0101, 500}, {0x0102, 667}, {0x0103, 500}, {0x0104, 667},
    {0x0105, 500}, {0x0106, 667}, {0x0107, 444}, {0x0108,   0},
    {0x010C, 667}, {0x010D, 444}, {0x010E, 722}, {0x010F, 749},
    {0x0110, 722}, {0x0111, 500}, {0x0112, 667}, {0x0113, 444},
    {0x0114,   0}, {0x0116, 667}, {0x0117, 444}, {0x0118, 667},
    {0x0119, 444}, {0x011A, 667}, {0x011B, 444}, {0x011C,   0},
    {0x011E, 722}, {0x011F, 500}, {0x0120,   0}, {0x0122, 722},
    {0x0123, 500}, {0x0124,   0}, {0x0128, 389}, {0x0129, 278},
    {0x012A, 389}, {0x012B, 278}, {0x012C,   0}, {0x012E, 389},
    {0x012F, 278}, {0x0130, 389}, {0x0131, 278}, {0x0132,   0},
    {0x0136, 667}, {0x0137, 500}, {0x0139, 611}, {0x013A, 278},
    {0x013B, 611}, {0x013C, 278}, {0x013D, 611}, {0x013E, 521},
    {0x013F,   0}, {0x0141, 611}, {0x0142, 278}, {0x0143, 722},
    {0x0144, 556}, {0x0145, 722}, {0x0146, 556}, {0x0147, 722},
    {0x0148, 556}, {0x0149,   0}, {0x014A, 784}, {0x014B, 541},
    {0x014C, 722}, {0x014D, 500}, {0x014E,   0}, {0x0150, 722},
    {0x0151, 500}, {0x0152, 944}, {0x0153, 722}, {0x0154, 667},
    {0x0155, 389}, {0x0156, 667}, {0x0157, 389}, {0x0158, 667},
    {0x0159, 389}, {0x015A, 556}, {0x015B, 389}, {0x015C,   0},
    {0x015E, 556}, {0x015F, 389}, {0x0160, 556}, {0x0161, 389},
    {0x0162, 611}, {0x0163, 278}, {0x0164, 611}, {0x0165, 531},
    {0x0166, 611}, {0x0167, 278}, {0x0168, 722}, {0x0169, 556},
    {0x016A, 722}, {0x016B, 556}, {0x016C,   0}, {0x016E, 722},
    {0x016F, 556}, {0x0170, 722}, {0x0171, 556}, {0x0172, 722},
    {0x0173, 556}, {0x0174,   0}, {0x0178, 611}, {0x017A, 389},
    {0x017B, 611}, {0x017C, 389}, {0x017D, 611}, {0x017E, 389},
    {0x017F,   0}, {0x0192, 500}, {0x0193,   0}, {0x0218, 778},
    {0x021A, 611}, {0x021B, 278}, {0x021C,   0}, {0x02C6, 333},
    {0x02C8,   0}, {0x02D8, 333}, {0x02DA,   0}, {0x02DB, 333},
    {0x02DE,   0}, {0x2013, 500}, {0x2014,1000}, {0x2016,   0},
    {0x2018, 333}, {0x201B,   0}, {0x201C, 500}, {0x201F,   0},
    {0x2020, 500}, {0x2022, 350}, {0x2023,   0}, {0x2026,1000},
    {0x2027,   0}, {0x2030,1000}, {0x2031,   0}, {0x2039, 333},
    {0x203B,   0}, {0x20AC, 500}, {0x20AD,   0}, {0x2122,1000},
    {0x2123,   0}, {0x2202, 494}, {0x2203,   0}, {0x2211, 713},
    {0x2212, 606}, {0x2213,   0}, {0x221A, 549}, {0x221B,   0},
    {0x2260, 549}, {0x2261,   0}, {0x2264, 549}, {0x2266,   0},
    {0x25CA, 494}, {0x25CB,   0}, {0xF6C3, 778}, {0xF6C4,   0},
    {0xFB01, 556}, {0xFB03,   0}, {0xFFFF,   0}
};


static const fnt_font_metric fnt_font_metric_13 =
{
    "Times-BoldItalic",
    262240L,
    fnt_Type1,
    cc_none,
    -16.333,
    0,
    -547,
    -307,
    1206,
    1032,
    -109,
    95,
    669,
    462,
    683,
    -217,
    166,
    0,

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    275,
    fnt_glyph_width_13,
    0,
    NULL,

};

/* -------- Generated from ZapfDingbats.afm -------- */

static fnt_glyphwidth fnt_glyph_width_14[202] =
{
    {0x0020,  32,  278},    {0x2701,  33,  974},    {0x2702,  34,  961},
    {0x2703,  35,  974},    {0x2704,  36,  980},    {0x260e,  37,  719},
    {0x2706,  38,  789},    {0x2707,  39,  790},    {0x2708,  40,  791},
    {0x2709,  41,  690},    {0x261b,  42,  960},    {0x261e,  43,  939},
    {0x270c,  44,  549},    {0x270d,  45,  855},    {0x270e,  46,  911},
    {0x270f,  47,  933},    {0x2710,  48,  911},    {0x2711,  49,  945},
    {0x2712,  50,  974},    {0x2713,  51,  755},    {0x2714,  52,  846},
    {0x2715,  53,  762},    {0x2716,  54,  761},    {0x2717,  55,  571},
    {0x2718,  56,  677},    {0x2719,  57,  763},    {0x271a,  58,  760},
    {0x271b,  59,  759},    {0x271c,  60,  754},    {0x271d,  61,  494},
    {0x271e,  62,  552},    {0x271f,  63,  537},    {0x2720,  64,  577},
    {0x2721,  65,  692},    {0x2722,  66,  786},    {0x2723,  67,  788},
    {0x2724,  68,  788},    {0x2725,  69,  790},    {0x2726,  70,  793},
    {0x2727,  71,  794},    {0x2605,  72,  816},    {0x2729,  73,  823},
    {0x272a,  74,  789},    {0x272b,  75,  841},    {0x272c,  76,  823},
    {0x272d,  77,  833},    {0x272e,  78,  816},    {0x272f,  79,  831},
    {0x2730,  80,  923},    {0x2731,  81,  744},    {0x2732,  82,  723},
    {0x2733,  83,  749},    {0x2734,  84,  790},    {0x2735,  85,  792},
    {0x2736,  86,  695},    {0x2737,  87,  776},    {0x2738,  88,  768},
    {0x2739,  89,  792},    {0x273a,  90,  759},    {0x273b,  91,  707},
    {0x273c,  92,  708},    {0x273d,  93,  682},    {0x273e,  94,  701},
    {0x273f,  95,  826},    {0x2740,  96,  815},    {0x2741,  97,  789},
    {0x2742,  98,  789},    {0x2743,  99,  707},    {0x2744, 100,  687},
    {0x2745, 101,  696},    {0x2746, 102,  689},    {0x2747, 103,  786},
    {0x2748, 104,  787},    {0x2749, 105,  713},    {0x274a, 106,  791},
    {0x274b, 107,  785},    {0x25cf, 108,  791},    {0x274d, 109,  873},
    {0x25a0, 110,  761},    {0x274f, 111,  762},    {0x2750, 112,  762},
    {0x2751, 113,  759},    {0x2752, 114,  759},    {0x25b2, 115,  892},
    {0x25bc, 116,  892},    {0x25c6, 117,  788},    {0x2756, 118,  784},
    {0x25d7, 119,  438},    {0x2758, 120,  138},    {0x2759, 121,  277},
    {0x275a, 122,  415},    {0x275b, 123,  392},    {0x275c, 124,  392},
    {0x275d, 125,  668},    {0x275e, 126,  668},    {0x2768, 128,  390},
    {0x2769, 129,  390},    {0x276a, 130,  317},    {0x276b, 131,  317},
    {0x276c, 132,  276},    {0x276d, 133,  276},    {0x276e, 134,  509},
    {0x276f, 135,  509},    {0x2770, 136,  410},    {0x2771, 137,  410},
    {0x2772, 138,  234},    {0x2773, 139,  234},    {0x2774, 140,  334},
    {0x2775, 141,  334},    {0x2761, 161,  732},    {0x2762, 162,  544},
    {0x2763, 163,  544},    {0x2764, 164,  910},    {0x2765, 165,  667},
    {0x2766, 166,  760},    {0x2767, 167,  760},    {0x2663, 168,  776},
    {0x2666, 169,  595},    {0x2665, 170,  694},    {0x2660, 171,  626},
    {0x2460, 172,  788},    {0x2461, 173,  788},    {0x2462, 174,  788},
    {0x2463, 175,  788},    {0x2464, 176,  788},    {0x2465, 177,  788},
    {0x2466, 178,  788},    {0x2467, 179,  788},    {0x2468, 180,  788},
    {0x2469, 181,  788},    {0x2776, 182,  788},    {0x2777, 183,  788},
    {0x2778, 184,  788},    {0x2779, 185,  788},    {0x277a, 186,  788},
    {0x277b, 187,  788},    {0x277c, 188,  788},    {0x277d, 189,  788},
    {0x277e, 190,  788},    {0x277f, 191,  788},    {0x2780, 192,  788},
    {0x2781, 193,  788},    {0x2782, 194,  788},    {0x2783, 195,  788},
    {0x2784, 196,  788},    {0x2785, 197,  788},    {0x2786, 198,  788},
    {0x2787, 199,  788},    {0x2788, 200,  788},    {0x2789, 201,  788},
    {0x278a, 202,  788},    {0x278b, 203,  788},    {0x278c, 204,  788},
    {0x278d, 205,  788},    {0x278e, 206,  788},    {0x278f, 207,  788},
    {0x2790, 208,  788},    {0x2791, 209,  788},    {0x2792, 210,  788},
    {0x2793, 211,  788},    {0x2794, 212,  894},    {0x2192, 213,  838},
    {0x2194, 214, 1016},    {0x2195, 215,  458},    {0x2798, 216,  748},
    {0x2799, 217,  924},    {0x279a, 218,  748},    {0x279b, 219,  918},
    {0x279c, 220,  927},    {0x279d, 221,  928},    {0x279e, 222,  928},
    {0x279f, 223,  834},    {0x27a0, 224,  873},    {0x27a1, 225,  828},
    {0x27a2, 226,  924},    {0x27a3, 227,  924},    {0x27a4, 228,  917},
    {0x27a5, 229,  930},    {0x27a6, 230,  931},    {0x27a7, 231,  463},
    {0x27a8, 232,  883},    {0x27a9, 233,  836},    {0x27aa, 234,  836},
    {0x27ab, 235,  867},    {0x27ac, 236,  867},    {0x27ad, 237,  696},
    {0x27ae, 238,  696},    {0x27af, 239,  874},    {0x27b1, 241,  874},
    {0x27b2, 242,  760},    {0x27b3, 243,  946},    {0x27b4, 244,  771},
    {0x27b5, 245,  865},    {0x27b6, 246,  771},    {0x27b7, 247,  888},
    {0x27b8, 248,  967},    {0x27b9, 249,  888},    {0x27ba, 250,  831},
    {0x27bb, 251,  873},    {0x27bc, 252,  927},    {0x27bd, 253,  970},
    {0x27be, 254,  918},

};

static const fnt_font_metric fnt_font_metric_14 =
{
    "ZapfDingbats",		/* FontName */
    4L,			        /* flags */
    fnt_Type1,                  /* font type */
    cc_none,                    /* Character collection */
    0.0,		        /* ItalicAngle */
    0,				/* isFixedPitch */
    -1,			        /* llx */
    -143,			/* lly */
    981,			/* urx */
    820,			/* ury */
    -100,			/* UnderlinePosition */
    50,				/* UnderlineThickness */
    700,			/* CapHeight */
    0,			        /* xHeight */
    800,			/* Ascender */
    -200,			/* Descender */
    90,				/* StdVW */
    0,				/* StdHW */

    FNT_DEFAULT_WIDTH,
    0,
    NULL,
    0,
    NULL,
    202,
    fnt_glyph_width_14,

};

#endif /* PDF_BUILTINMETRIC_SUPPORTED */


/* --------------------- Pre-installed CID fonts ---------------------- */

/* Font descriptors for the pre-installed CID fonts */

static const fnt_font_metric fnt_cid_metrics[] =
{

    /* Acrobat 4 standard fonts */
    /* ---------------------------------------------------------- */
    {
        "HeiseiKakuGo-W5",              /* FontName */
        4L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        -1 * (int) cc_japanese,         /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -92,                            /* llx */
        -250,                           /* lly */
        1010,                           /* urx */
        922,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -221,                           /* Descender */
        114,                            /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "HeiseiMin-W3",                 /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        -1 * (int) cc_japanese,         /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -123,                           /* llx */
        -257,                           /* lly */
        1001,                           /* urx */
        910,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        709,                            /* CapHeight */
        450,                            /* xHeight */
        723,                            /* Ascender */
        -241,                           /* Descender */
        69,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "HYGoThic-Medium",              /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_korean,                /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -6,                             /* llx */
        -145,                           /* lly */
        1003,                           /* urx */
        880,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "HYSMyeongJo-Medium",           /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_korean,                /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -0,                             /* llx */
        -148,                           /* lly */
        1001,                           /* urx */
        880,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "MHei-Medium",                  /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_traditional_chinese,   /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -45,                            /* llx */
        -250,                           /* lly */
        1015,                           /* urx */
        887,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "MSung-Light",                  /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_traditional_chinese,   /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -160,                           /* llx */
        -259,                           /* lly */
        1015,                           /* urx */
        888,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "STSong-Light",                 /* FontName */
        4L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_simplified_chinese,    /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -250,                           /* llx */
        -143,                           /* lly */
        600,                            /* urx */
        857,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        857,                            /* CapHeight */
        599,                            /* xHeight */
        857,                            /* Ascender */
        -143,                           /* Descender */
        91,                             /* StdVW */
        91,                             /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* Acrobat 5 standard fonts */
    /* ---------------------------------------------------------- */
    {
        "HYSMyeongJoStd-Medium-Acro",   /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_korean,                /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -28,                            /* llx */
        -148,                           /* lly */
        1001,                           /* urx */
        880,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "KozMinPro-Regular-Acro",       /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_japanese,              /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -195,                           /* llx */
        -272,                           /* lly */
        1110,                           /* urx */
        1075,                           /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "MSungStd-Light-Acro",          /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_traditional_chinese,   /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -160,                           /* llx */
        -249,                           /* lly */
        1015,                           /* urx */
        1071,                           /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        553,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "STSongStd-Light-Acro",         /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_simplified_chinese,    /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -134,                           /* llx */
        -254,                           /* lly */
        1001,                           /* urx */
        905,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        737,                            /* CapHeight */
        535,                            /* xHeight */
        752,                            /* Ascender */
        -271,                           /* Descender */
        58,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* Acrobat 6 standard fonts */
    /* ---------------------------------------------------------- */
    {
        "AdobeMingStd-Light-Acro",      /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_traditional_chinese,   /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -38,                            /* llx */
        -121,                           /* lly */
        1002,                           /* urx */
        1002,                           /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        731,                            /* CapHeight */
        466,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        71,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "AdobeMyungjoStd-Medium-Acro",  /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_korean,                /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -28,                            /* llx */
        -148,                           /* lly */
        1001,                           /* urx */
        1001,                           /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        719,                            /* CapHeight */
        478,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        109,                            /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "AdobeSongStd-Light-Acro",      /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_simplified_chinese,    /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -134,                           /* llx */
        -254,                           /* lly */
        1001,                           /* urx */
        1001,                           /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        626,                            /* CapHeight */
        416,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        71,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "KozGoPro-Medium-Acro",         /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_japanese,              /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -149,                           /* llx */
        -374,                           /* lly */
        1254,                           /* urx */
        1008,                           /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        763,                            /* CapHeight */
        549,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        109,                            /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* Acrobat 7 standard fonts */
    /* ---------------------------------------------------------- */
    {
        "KozGoPro-Medium",              /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_japanese,              /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -149,                           /* llx */
        -374,                           /* lly */
        1254,                           /* urx */
        1008,                           /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        763,                            /* CapHeight */
        549,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        109,                            /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "KozMinProVI-Regular",          /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_japanese,              /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -437,                           /* llx */
        -340,                           /* lly */
        1144,                           /* urx */
        1317,                           /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        742,                            /* CapHeight */
        503,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        87,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "AdobeMyungjoStd-Medium",       /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_korean,                /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -28,                            /* llx */
        -148,                           /* lly */
        1001,                           /* urx */
        880,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        719,                            /* CapHeight */
        478,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        109,                            /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "AdobeSongStd-Light",           /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_simplified_chinese,    /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -134,                           /* llx */
        -254,                           /* lly */
        1001,                           /* urx */
        905,                            /* ury */
        -100,                           /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        626,                            /* CapHeight */
        416,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        71,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    },

    /* ---------------------------------------------------------- */
    {
        "AdobeMingStd-Light",           /* FontName */
        6L,                             /* Font flags */
        fnt_CIDFontType0,               /* font type */
        (int) cc_traditional_chinese,   /* Character collection */
        0.0,                            /* ItalicAngle */
        pdc_true,                       /* isFixedPitch */
        -38,                            /* llx */
        -121,                           /* lly */
        1002,                           /* urx */
        918,                            /* ury */
        -75,                            /* UnderlinePosition */
        50,                             /* UnderlineThickness */
        731,                            /* CapHeight */
        466,                            /* xHeight */
        880,                            /* Ascender */
        -120,                           /* Descender */
        71,                             /* StdVW */
        0,                              /* StdHW */

        FNT_DEFAULT_CIDWIDTH,
        0,
        NULL,

        0,
        NULL,

        0,
        (fnt_glyphwidth *) NULL,

    }
};

#define FNT_NUM_OF_CIDFONTS      \
        ((int) (sizeof(fnt_cid_metrics)/sizeof(fnt_font_metric)))


#ifdef PDF_CJKFONTWIDTHS_SUPPORTED

/*
 * PDF width arrays for glyph widths indexed by CID
 * of Acrobat CJK standard fonts (see above).
 *
 * Format:
 *
 *   1 font name string,
 *   4 strings for widths
 *  ---
 *   5 (see define FNT_CIDMETRIC_INCR in ft_cid.h)
 *
 * Because of compiler warnings each width block must
 * be divided at least into 4 parts.
 *
 */

static const char *fnt_cid_width_arrays[] =
{
    /*------------------------------------------------------------------------*/
    "HeiseiKakuGo-W5",

    "1[278 278 355 556 556 889 667 191 333 333 389 584 278 333 278\n"
    "278 556 556 556 556 556 556 556 556 556 556 278 278 584 584 584\n"
    "556 1015 667 667 722 722 667 611 778 722 278 500 667 556 833 722\n"
    "778 667 778 722 667 611 722 667 944 667 667 611 278 556 278 469\n"
    "556 333 556 556 500 556 556 278 556 556 222 222 500 222 833 556\n",

    "556 556 556 333 500 278 556 500 722 500 500 500 334 260 334 333\n"
    "1000 278 1000 260 1000 333 556 556 167 1000 1000 556 1000 556 333 333\n"
    "500 500 556 1000 1000 278 1000 350 222 333 1000 556 1000 1000 611]\n"
    "127 137 333\n"
    "140[370 556 778 1000\n",

    "365 889 278 222 611 944 611 584 737 584 737 1000 1000 333 333 556\n"
    "333 834 834 834 667 667 667 667 667 667 722 667 667 667 667 278\n"
    "278 278 278 722 722 778 778 778 778 778 1000 722 722 722 722 667\n"
    "667 556 556 556 556 556 556 500 556 556 556 556 278 278 278 278\n",

    "556 556 556 556 556 556 556 1000 556 556 556 556 500 556 500 667\n"
    "667 611 556 500 1000 500 556]\n"
    "231 632 500\n"
    "8718 8719 500",


    /*------------------------------------------------------------------------*/
    "HeiseiMin-W3",

    "1[250 333 408 500 500 833 778 180 333 333 500 564 250 333 250\n"
    "278 500 500 500 500 500 500 500 500 500 500 278 278 564 564 564\n"
    "444 921 722 667 667 722 611 556 722 722 333 389 722 611 889 722\n"
    "722 556 722 667 556 611 722 722 944 722 722 611 333 500 333 469\n"
    "500 333 444 500 444 500 444 333 500 500 278 278 500 278 778 500\n",

    "500 500 500 333 389 278 500 500 722 500 500 444 480 200 480 333\n"
    "1000 278 1000 200 1000 333 500 500 167 1000 1000 500 1000 500 333 333\n"
    "556 556 500 1000 1000 250 1000 350 333 444 1000 500 1000 1000 444]\n"
    "127 137 333\n",

    "139[889 276 611 722 889\n"
    "310 667 278 278 500 722 500 564 760 564 760 1000 1000 300 300 500\n"
    "300 750 750 750 722 722 722 722 722 722 667 611 611 611 611 333\n"
    "333 333 333 722 722 722 722 722 722 722 1000 722 722 722 722 722\n"
    "556 444 444 444 444 444 444 444 444 444 444 444 278 278 278 278\n",

    "500 500 500 500 500 500 500 1000 500 500 500 500 500 500 500 556\n"
    "722 611 500 389 980 444]\n"
    "230 632 500\n"
    "8718 8719 500",


    /*------------------------------------------------------------------------*/
    "HYGoThic-Medium",

    "1[333 416 416 833 666 916 750 250 416 416 583 833 375 833 375\n"
    "375 583 583 583 583 583 583 583 583 583 583 416 416 833 833 833\n",

    "583 1000 666 708 750 750 666 625 833 750 291 541 708 583 875 750\n"
    "791 666 791 708 666 583 750 625 916 625 625 625 416 375 416 500\n",

    "500 500 583 625 583 625 583 375 625 583 250 250 541 250 916 625\n",

    "625 625 625 333 541 333 583 500 750 500 500 500 500 500 500 750]",


    /*------------------------------------------------------------------------*/
    "HYSMyeongJo-Medium",

    "1[278 278 355 556 556 889 667 222 333 333 389 584 278 333 278\n"
    "278 556 556 556 556 556 556 556 556 556 556 278 278 584 584 584\n",

    "556 1015 667 667 722 722 667 611 778 722 278 500 667 556 833 722\n"
    "778 667 778 722 667 611 722 667 944 667 667 611 278 278 278 469\n",

    "556 222 556 556 500 556 556 278 556 556 222 222 500 222 833 556\n",

    "556 556 556 333 500 278 556 500 722 500 500 500 334 260 334 584]",


    /*------------------------------------------------------------------------*/
    "MHei-Medium", /* identical with HYSMyeongJo-Medium */

    "1[278 278 355 556 556 889 667 222 333 333 389 584 278 333 278\n"
    "278 556 556 556 556 556 556 556 556 556 556 278 278 584 584 584\n",

    "556 1015 667 667 722 722 667 611 778 722 278 500 667 556 833 722\n"
    "778 667 778 722 667 611 722 667 944 667 667 611 278 278 278 469\n",

    "556 222 556 556 500 556 556 278 556 556 222 222 500 222 833 556\n",

    "556 556 556 333 500 278 556 500 722 500 500 500 334 260 334 584]",


    /*------------------------------------------------------------------------*/
    "MSung-Light",

    "1[250 250 408 668 490 875 698 250 240 240 417 667 250 313 250\n"
    "520 500 500 500 500 500 500 500 500 500 500 250 250 667 667 667\n",

    "396 921 677 615 719 760 625 552 771 802 354 354 781 604 927 750\n"
    "823 563 823 729 542 698 771 729 948 771 677 635 344 520 344 469\n",

    "500 250 469 521 427 521 438 271 469 531 250 250 458 240 802 531\n",

    "500 521 521 365 333 292 521 458 677 479 458 427 480 496 480 667]",


    /*------------------------------------------------------------------------*/
    "STSong-Light",

    "1[207 270 342 467 462 797 710 239 374 374 423 605 238 375 238\n"
    "334 462 462 462 462 462 462 462 462 462 462 238 238 605 605 605\n",

    "344 748 684 560 695 739 563 511 729 793 318 312 666 526 896 758\n"
    "772 544 772 628 465 607 753 711 972 647 620 607 374 333 374 606\n",

    "500 239 417 503 427 529 415 264 444 518 241 230 495 228 793 527\n",

    "524 524 504 338 336 277 517 450 652 466 452 407 370 258 370 605]",


    /*------------------------------------------------------------------------*/
    "HYSMyeongJoStd-Medium-Acro",

    "1[333 416 416 833 625 916 833 250 500 500 500 833 291 833 291\n"
    "375 625 625 625 625 625 625 625 625 625 625 333 333 833 833 916\n",

    "500 1000 791 708 708 750 708 666 750 791 375 500 791 666 916 791\n"
    "750 666 750 708 666 791 791 750 1000 708 708 666 500 375 500 500\n",

    "500 333 541 583 541 583 583 375 583 583 291 333 583 291 875 583\n",

    "583 583 583 458 541 375 583 583 833 625 625 500 583 583 583 750]",


    /*------------------------------------------------------------------------*/
    "KozMinPro-Regular-Acro",

    "1[278 299 353 614 614 721 735 216 323 323 449 529 219 306 219\n"
    "453 614 614 614 614 614 614 614 614 614 614 219 219 529 529 529\n"
    "486 744 646 604 617 681 567 537 647 738 320 433 637 566 904 710\n"
    "716 605 716 623 517 601 690 668 990 681 634 578 316 614 316 529\n"
    "500 387 509 566 478 565 503 337 549 580 275 266 544 276 854 579\n"
    "550 578 566 410 444 340 575 512 760 503 529 453 326 380 326 387\n"
    "1000 453 1000 380 1000 299 614 614 265 1000 1000 614 1000 451 291 291\n",

    "588 589 500 1000 1000 219 1000 452 216 353 1000 451 1000 1000 486 387]\n"
    "128 135 387\n"
    "136[387 387 1000 880 448 566 716 903\n"
    "460 805 275 276 550 886 582 529 738 529 738 1000 1000 406 406 575\n"
    "406 934 934 934 646 646 646 646 646 646 617 567 567 567 567 320\n"
    "320 320 320 681 710 716 716 716 716 716 1000 690 690 690 690 634\n"
    "605 509 509 509 509 509 509 478 503 503 503 503 275 275 275 275\n",

    "550 579 550 550 550 550 550 1000 575 575 575 575 529 578 529 517\n"
    "634 578 445 444 842 453 1000 500]\n"
    "323[500 1000 500 1000 500]\n"
    "328 383 500\n"
    "384[500 500 500 500 500 500]\n"
    "9354[614 684 1000 1000 648 899\n",

    "903 509 275 575 503 550 646 320 690 567 716 934 934 934 934 934\n"
    "934 426 426 426 426 426 426 426 426 425 425 425 439 426 426 426\n"
    "426 426 646 567 1000 567 320 1000 320 716 1000 690 690 690 509 503\n"
    "1000 503 275 1000 275 550 1000 575 575 575 513 1000 1000 805 1000 478\n"
    "1000 1000 503 1000 1000 735 1000 1000 426 1000 1000 1000 578 553 512\n"
    "1000 1000 640 594 284]",


    /*------------------------------------------------------------------------*/
    "MSungStd-Light-Acro",

    "1[250 250 408 668 490 875 698 250 240 240 417 667 250 313 250\n"
    "520 500 500 500 500 500 500 500 500 500 500 250 250 667 667 667\n",

    "396 921 677 615 719 760 625 552 771 802 354 354 781 604 927 750\n"
    "823 563 823 729 542 698 771 729 948 771 677 635 344 520 344 469\n",

    "500 250 469 521 427 521 438 271 469 531 250 250 458 240 802 531\n",

    "500 521 521 365 333 292 521 458 677 479 458 427 480 496 480 667]\n"
    "17601 17601 500",


    /*------------------------------------------------------------------------*/
    "STSongStd-Light-Acro",

    "1[207 270 342 467 462 797 710 239 374 374 423 605 238 375 238\n"
    "334 462 462 462 462 462 462 462 462 462 462 238 238 605 605 605\n",

    "344 748 684 560 695 739 563 511 729 793 318 312 666 526 896 758\n"
    "772 544 772 628 465 607 753 711 972 647 620 607 374 333 374 606\n",

    "500 239 417 503 427 529 415 264 444 518 241 230 495 228 793 527\n",

    "524 524 504 338 336 277 517 450 652 466 452 407 370 258 370 605]\n"
    "22353[462 462 1000 1000 500]",


    /*------------------------------------------------------------------------*/
    "AdobeMingStd-Light-Acro",

    "0[1000 251 347 405 739 504 758 825 281 293 294 494 620 251 373 252\n"
    "309 503 503 503 503 504 503 502 503 503 504 251 251 621 621 621\n",

    "405 1042 749 673 679 679 685 671 738 736 333 494 729 696 901 720\n"
    "750 674 746 672 627 769 707 777 887 709 716 616 279 309 277 352\n",

    "575 294 500 511 502 549 494 356 516 550 321 321 510 317 738 533\n"
    "535 545 533 376 443 361 529 526 742 534 576 439 447 262 446 472]\n",

    "96 17600 1000\n"
    "17601[639]\n"
    "17602 18964 1000",


    /*------------------------------------------------------------------------*/
    "AdobeMyungjoStd-Medium-Acro",

    "0[1000 333 416 416 833 625 916 833 250 500 500 500 833 291\n"
    "833 291 375]\n",

    "17 26 625\n"
    "27[333 333 833 833 916 500 1000 791 708 708 750 708 666 750 791 375\n",

    "500 791 666 916 791 750 666 750 708 666 791 791 750 1000 708 708\n"
    "666 500 375 500 500 500 333 541 583 541 583 583 375 583 583 291\n",

    "333 583 291 875 583 583 583 583 458 541 375 583 583 833 625 625\n"
    "500 583 583 583 750 1000 500]\n"
    "98 18351 1000",


    /*------------------------------------------------------------------------*/
    "AdobeSongStd-Light-Acro",

    "0[1000 207 270 342 467 462 797 710 239 374 374 423 605 238 375\n"
    "238 334]\n"
    "17 26 462\n",

    "27[238 238 605 605 605 344 748 684 560 695 739 563 511 729 793 318\n"
    "312 666 526 896 758 772 544 772 628 465 607 753 711 972 647 620\n"
    "607 374 333 374 606 500 239 417 503 427 529 415 264 444 518 241\n",


    "230 495 228 793 527 524 524 504 338 336 277 517 450 652 466 452\n"
    "407 370 258 370 605]\n"
    "96 22352 1000\n",

    "22353[462 462 1000 1000 500]\n"
    "22358 29063 1000",


    /*------------------------------------------------------------------------*/
    "KozGoPro-Medium-Acro",

    "0[1000 224 266 392 551 562 883 677 213 322 322 470 677 247 343\n"
    "245 370]\n"
    "17 26 562\n"
    "27[245 247 677 677 677 447 808 661 602 610 708 535 528 689 703 275\n"
    "404 602 514 871 708 727 585 727 595 539 541 696 619 922 612 591\n"
    "584 322 562 322 677 568 340 532 612 475 608 543 332 603 601 265\n"
    "276 524 264 901 601 590 612 607 367 433 369 597 527 800 511 518\n"
    "468 321 273 321 341 1000 362 1000 273 1000 266 562 562 456 1000 1000\n",

    "562 1000 472 283 283 587 588 568 1000 1000 247 1000 330 239 418 1000\n"
    "472 1000 1000 447 340 340 340 340 340 340 455 340 340 340 340 1136\n"
    "857 384 519 727 952 398 834 264 275 590 918 605 677 769 677 473\n"
    "1000 1000 347 340 599 284 845 845 845 661 661 661 661 661 661 610\n"
    "535 535 535 535 275 275 275 275 715 708 727 727 727 727 727 1000\n"
    "696 696 696 696 591 584 532 532 532 532 532 532 475 543 543 543\n",

    "543 264 264 264 264 584 601 590 590 590 590 590 1000 597 597 597\n"
    "597 518 612 518 539 591 584 446 433 683 468 1000 500]\n"
    "232 322 1000\n"
    "323[500 1000 500 1000]\n"
    "327 389 500\n"
    "390 9353 1000\n"
    "9354[562 753 1000 1000 650 909 909 532 264 597 543 590 661 275 696 535\n",

    "727 845 845 845 845 845 845 375 387 345 369 328 366 364 375 284\n"
    "347 340 387 345 369 328 366 364 661 535 1000 535 275 1000 275 727\n"
    "1000 696 696 696 532 543 1000 543 264 1000 264 590 1000 597 597 597\n"
    "596 1000 1000 834 1000 475 1000 1000 543 1000 1000 759 1000 1000 478\n"
    "1000 1000 1000 602 579 527 1000 1000 509 465 280]\n"
    "9444 15443 1000",


    /*------------------------------------------------------------------------*/
    "KozGoPro-Medium",

    "1[224 266 392 551 562 883 677 213 322 322 470 677 247 343 245 370]\n"
    "17 26 562\n"
    "27[245 247 677 677 677 447 808 661 602 610 708 535 528 689 703\n"
    "275 404 602 514 871 708 727 585 727 595 539 541 696 619 922 612\n"
    "591 584 322 562 322 677 568 340 532 612 475 608 543 332 603 601\n"
    "265 276 524 264 901 601 590 612 607 367 433 369 597 527 800 511\n"
    "518 468 321 273 321 341 241 362 241 273 677 266 562 562 456 562\n"
    "571 562 416 472 283 283 587 588 568 545 545 247 561 330 239 418\n"
    "416 472 1136 1288 447 340 340 340 340 340 340 455 340 340 340 340\n"
    "1136 857 384 519 727 952 398 834 264 275 590 918 605 677 769 677\n"
    "473 361 677 347 340 599 284 845 845 845 661 661 661 661 661 661\n"
    "610 535 535 535 535 275 275 275 275 715 708 727 727 727 727 727\n",

    "677 696 696 696 696 591 584 532 532 532 532 532 532 475 543 543\n"
    "543 543 264 264 264 264 584 601 590 590 590 590 590 677 597 597\n"
    "597 597 518 612 518 539 591 584 446 433 683 468 562]\n"
    "231 632 500\n"
    "8718[500 500]\n"
    "9354[562 753 245 436 650 909 909 532 264 597 543 590 661 275 696\n"
    "535 727 845 845 845 845 845 845 375 387 345 369 328 366 364 375\n"
    "284 347 340 387 345 369 328 366 364 661 535 535 535 275 275 275\n"
    "727 727 696 696 696 532 543 543 543 264 264 264 590 590 597 597\n"
    "597 596 596 596 834 834 475 475 475 543 543 543 759 759 759 478\n"
    "478 478 276 602 579 527 527 527 509 465 280 197 270 359 545 546\n"
    "869 664 188 322 322 469 676 249 343 249 359 545]\n",

    "9461 9469 546\n"
    "9470[249 249 676 676 676 429 791 620 573 581 688 511 504 665 681\n"
    "269 395 572 477 844 677 709 555 709 573 509 515 663 593 898 565\n"
    "562 557 322 546 322 676 567 427 566 571 447 570 498 320 567 577\n"
    "258 254 507 257 870 577 564 572 568 359 409 343 572 500 767 486\n"
    "487 448 322 245 322 427 228 363 228 245 676 269 546 546 442 546\n"
    "559 546 404 465 275 275 562 562 568 533 534 249 550 326 228 404\n"
    "404 464 1136 1250 429 427 427 427 427 427 427 423 427 427 427 427\n"
    "1136 835 396 492 709 923 388 781 258 270 567 858 592 677 765 677\n"
    "443 361 677 358 354 573 343 840 840 840 620 620 620 620 620 620\n"
    "581 511 511 511 511 269 269 269 269 700 677 709 709 709 709 709\n",

    "677 663 663 663 663 562 555 566 566 566 566 566 566 447 498 498\n"
    "498 498 258 258 258 258 562 577 564 564 564 564 564 677 572 572\n"
    "572 572 487 573 487 509 562 557 446 409 735 448 546 546 726 241\n"
    "432 629 868 868 566 258 572 498 564 620 269 663 511 709 840 840\n"
    "840 840 840 840 362 361 355 361 354 363 360 362 343 358 354 361\n"
    "355 362 354 363 360 620 511 511 511 269 269 269 709 709 663 663\n"
    "663 566 498 498 498 258 258 258 564 564 572 572 572]\n"
    "9738 9757 250\n"
    "9758 9778 333\n"
    "12063 12087 500\n",


    /*------------------------------------------------------------------------*/
    "KozMinProVI-Regular",

    "1[278 299 353 614 614 721 735 216 323 323 449 529 219 306 219\n"
    "453]\n"
    "17 26 614\n"
    "27[219 219 529 529 529 486 744 646 604 617 681 567 537 647 738\n"
    "320 433 637 566 904 710 716 605 716 623 517 601 690 668 990 681\n"
    "634 578 316 614 316 529 500 387 509 566 478 565 503 337 549 580\n"
    "275 266 544 276 854 579 550 578 566 410 444 340 575 512 760 503\n"
    "529 453 326 380 326 387 216 453 216 380 529 299 614 614 265 614\n"
    "475 614 353 451 291 291 588 589 500 476 476 219 494 452 216 353\n"
    "353 451]\n"
    "125[1075 486]\n"
    "127 137 387\n"
    "139[880 448 566 716 903 460 805 275 276 550 886 582 529 738 529\n"
    "738 357 529 406 406 575 406 934 934 934 646 646 646 646 646 646\n"
    "617 567 567 567 567 320 320 320 320 681 710 716 716 716 716 716\n"
    "529 690 690 690 690 634 605 509 509 509 509 509 509 478 503 503\n"
    "503 503 275 275 275 275 550 579 550 550 550 550 550 529 575 575\n"
    "575 575 529 578 529 517 634 578 445 444 842 453 614]\n"
    "231 632 500\n"
    "8718[500 500]\n"
    "9354[614 684 216 353 648 899 903 509 275 575 503 550 646 320 690\n"
    "567 716 934 934 934 934 934 934]\n"
    "9377 9384 426\n"
    "9385[425 425 425 439 426 426 426 426 426 646 567 567 567 320 320\n"
    "320 716 716 690 690 690 509 503 503 503 275 275 275 550 550 575\n"
    "575 575 542 542 542 816 816 486 486 486 517 517 517 758 758 758\n"
    "426 426 426 286 597 568 522 522 522 640 611 312 257 281 288 546\n"
    "546 703 705 160 312 305 389 545 200 309 200 438]\n"
    "9460 9469 546\n",

    "9470[200 200 545 545 545 471 744 607 572 563 650 550 516 622 696\n"
    "312 314 603 524 848 665 644 561 645 583 491 566 643 581 872 616\n"
    "537 516 312 546 312 472 464 400 548 530 447 558 460 301 486 564\n"
    "283 258 509 265 834 578 521 554 551 390 410 335 565 476 717 525\n"
    "464 456 312 339 312 400 179 422 177 339 545 281 546 546 248 546\n"
    "491 570 310 440 278 279 556 563 586 403 403 207 500 440 170 307\n"
    "310 440 786 1009 471 367 400 400 400 400 400 400 364 400 365 400\n"
    "1012 849 394 544 644 889 377 744 283 285 521 808 545 504 703 545\n"
    "703 324 504 397 397 557 397 859 859 859 607 607 607 607 607 607\n"
    "562 550 550 550 550 312 312 312 312 662 665 644 644 644 644 644\n"
    "497 643 643 643 643 537 576 548 548 548 548 548 548 446 460 460\n"
    "460 460 283 283 283 283 522 578 521 521 521 521 521 545 565 565\n"
    "565 565 464 540 464 491 537 516 418 410 842 456 546 563 627 196\n"
    "289 560 828 835 548 283 565 460 521 607 312 643 550 644 859 859\n"
    "859 859 859 859]\n"
    "9697 9713 397\n"
    "9714[607 550 550 550 312 312 312 644 644 643 643 643 548 460 460\n"
    "460 283 283 283 521 521 565 565 565]\n"
    "9738 9757 250\n"
    "9758 9778 333\n"
    "12063 12087 500\n"
    "15449[670 810 640 760]\n"
    "15455[980 529 529 529 619 529 891]\n"
    "15464[529 529 529 529 534 534 566 566 530 529 529 529 529 581 529\n"
    "529 533 533 738 853 676 533 882 882 882 716 716 600 529 589 688\n"
    "529 529 559 559 594 619 522 529 468 721 529 529 529 525 529 529\n"
    "661 529 660 564 684 500 790 940 870]\n"
    "15521[630 740 740 900 840 980]\n"
    "15529[900 940 710 870 970]\n"
    "15535[820 930 840 940 850 850 960 960]\n"
    "15545[960 980 940 970 910 950 870 980 980 910 930 820 850 980 950]\n"
    "15562[970 980 980 980]\n"
    "15575[980 990 990 880]\n"
    "15581[960 850 860]\n",

    "15585[840 950 740 870 830 760 890 990 900 870 990 970 980 950 960]\n"
    "15601[850 830 950 930 810 980 910 780 890 760 880 790 870 830 980\n"
    "830 900 900 950 940 950 820 910 930 960 880 930 960 980 920 940\n"
    "920 950 970 980 890 930 860 930 960 990 820 920 960 930 970 760\n"
    "780 920 970 830 950 830 990 990 990 840 890 890 900 940 940 980\n"
    "980 980 970 970 970 960 800 950 820 960 810 950 810 990 730 850\n"
    "880 760 990 910 920 770 870 970 980 840 920 950 810 800 940 950\n"
    "900 960 910 960 960 750 740 860 850 640 690 900 750 740 840 770\n"
    "800 790 730 640 860 760 790]\n"
    "15723[770 780 529 529 934 841 904 854 710 579 575 575 575 575 646\n"
    "387 566 517 517 601 578 578 509 387 313 444 387 444 340 453 387\n"
    "453 623 646 566 617 617 567 681 710 710 716 623 690 601 410 509\n"
    "276 478 478 503 605 565 579 579 550 410 575 340 387 617 647 738\n"
    "433 517 690 478 549 580 266 444 575 869 537 421 364 593 429 310\n"
    "573 594 432 452 462 403 275 286 597 285 526 576 876 575 598 384\n"
    "384 598 725 421 579 578 300 580 664 293 593 517 426 524 530 876\n"
    "564 565 556 775 594 384 384 500 517 414 597 0 238 238 288 558\n"
    "391]\n",

    "15851 15857 421\n"
    "15858 15866 0\n"
    "15867[393]\n"
    "15868 15879 0\n"
    "15880[468 624 624 541 484 367 580 738 635 555 505 546 598 500 447\n"
    "290 474 310 331 220 466 632 976 529 529 882 882 882 446 526 544\n"
    "431 627 500 859 848 834 665 578 565 565 565 565 607 524 491 491\n"
    "566 516 516 548 265 410 410 335 456 456 583 607 524 563 563 550\n"
    "650 665 665 644 583 643 566 390 548 265 447 447 460 558 558 578\n"
    "578 521 390 565 335 563 622 696 314 491 643 447 486 564 258 410\n"
    "565]\n"
    "20317[386 386 458 446 807 677 734 739 563 692 598 514 538 302 575\n"
    "337 616 564 645 645 645 314 314 630 563 563 709 618 689 689 689\n"
    "689 689 990 633 476 499 546 546 546 270 538 272 272 575 405 570\n"
    "757 526 903 669 723 589 589 589 400 400 373 390 732 657 691 613\n"
    "521 628 563 534 505 272 574 331 560 546 619 619 619 306 306 597\n"
    "521 521 662 576 641 641 641 641 641 867 531 445 457 483 483 483\n"
    "279 505 262 262 574 385 561 714 460 1010 601 743 545 545 643]\n",


    /*------------------------------------------------------------------------*/
    "AdobeMyungjoStd-Medium",

    "1[333 416 416 833 625 916 833 250 500 500 500 833 291 833 291\n"
    "375]\n"
    "17 26 625\n",

    "27[333 333 833 833 916 500]\n"
    "34[791 708 708 750 708 666 750 791 375 500 791 666 916 791 750\n",

    "666 750 708 666 791 791 750]\n"
    "57[708 708 666 500 375 500 500 500 333 541 583 541 583 583 375\n",

    "583 583 291 333 583 291 875 583 583 583 583 458 541 375 583 583\n"
    "833 625 625 500 583 583 583 750]\n"
    "97[500]\n"
    "8094 8190 500\n",


    /*------------------------------------------------------------------------*/
    "AdobeSongStd-Light",

    "1[207 270 342 467 462 797 710 239 374 374 423 605 238 375 238\n"
    "334]\n"
    "17 26 462\n",

    "27[238 238 605 605 605 344 748 684 560 695 739 563 511 729 793 \n"
    "318 312 666 526 896 758 772 544 772 628 465 607 753 711 972 647\n",

    "620 607 374 333 374 606 500 239 417 503 427 529 415 264 444 518\n"
    "241 230 495 228 793 527 524 524 504 338 336 277 517 450 652 466\n",

    "452 407 370 258 370 605]\n"
    "814 939 500\n"
    "7712[517 684 723]\n"
    "7716[500]\n"
    "22353[462 462 500 500 500]\n",


    /*------------------------------------------------------------------------*/
    "AdobeMingStd-Light",

    "1[251 347 405 739 504 758 825 281 293 294 494 620 251 373 252\n"
    "309 503 503 503 503 504 503 502 503 503 504 251 251 621 621 621\n",

    "405 1042 749 673 679 679 685 671 738 736 333 494 729 696 901 720\n"
    "750 674 746 672 627 769 707 777 887 709 716 616 279 309 277 352\n",

    "575 294 500 511 502 549 494 356 516 550 321 321 510 317 738 533\n"
    "535 545 533 376 443 361 529 526 742 534 576 439 447 262 446 472]\n",

    "13648 13742 500\n"
    "17601[639]\n"
    "17603[500]\n"
};

#endif /* PDF_CJKFONTWIDTHS_SUPPORTED */

#endif /* FT_COREMETR_H */
