# This is a script for the memoover sensor for gdesklets provided by Psi, that
# acceses the gtodo items (http://gtodo.qballcow.nl/). To use this script you
# should put it as your ~/.gdesklets/memo2.py file (You should probably make a
# backup of the old file just in case.) Also, Change the GTODO_CATEGORY variable
# below to the name of the todo category you want. For bugreports, suggestions,
# or anything related to this script specifically and not the memoover
# sensor/display, then email me.
#				Daniel Brodie (daniel _at_ brodienet _dot_ com)
#
# NOTE: This does noot support the new development version of gtodo!

######## Changelog #######
# - Dont reparse file everytime unless the file was modified. This should
#   provide significant speed improvements to all those who kept the default
#   refresh time to high. - Dosnt work...
#
# - Forgot to get file by expanding ~. This is embaressing :P
#
# - Some general tidyup
#
# - Initial Release (0.1)

#Note from Psi : I have disabled here the code that checks if the file has been modified and have added this ability directly in the sensor

from warnings import warn
from xml.sax import saxutils
from xml.sax import make_parser
from xml.sax.handler import feature_namespaces
import os

# Set to "All" or None (no quotes) for All categories. This is currently buggy though. So keep it to a category
GTODO_CATEGORY="All"
GTODO_XMLFILE=os.path.expanduser("~/.gtodo/todos")

global memo
#~ global gtodo_prev_mtime

#~ try:
	#~ gtodo_prev_mtime
#~ except:
#~ #print "Reloading gtodo xml\n"
	#~ gtodo_prev_mtime=0


def warnFalse (res, msg=""):
	if not res:
		warn ("WARNIMG: %s" % msg)

def warnTrue (res, msg=""):
	if res:
		warn ("WARNIMG: %s" % msg)


class PyTodo (saxutils.DefaultHandler):
	def __init__ (self, category=None):
		self.category = category
		self.memoList = []
		self.inGTodo = 0
		self.currentItem = None
		self.validCategory = 0
		self.inComment = 0
		self.inSummary = 0

	

	def startElement (self, name, attrs):
	
		if name == "gtodo":
#			warnTrue (self.inGTodo, "Already in gtodo")
			self.inGTodo = 1
		elif name == "config":
			pass
		elif name == "category":
#			warnFalse (self.inGTodo, "Not in gtodo for category")
#			warnTrue (self.validCategory, "Already in a valid category")
			
			if ((self.category == None) or (self.category =="All") or (attrs.get("title") == self.category)):
				self.validCategory = 1
		elif name == "item":
#			warnFalse (self.currentItem==None, "Already in an item")
			if self.validCategory:
				self.currentItem = [0,0,0,0]
		elif name == "attribute":
#			warnTrue (self.currentItem==None, "Mot in an item")

			if self.currentItem != None:
				self.currentItem[2] = int(attrs.get("priority")) + 1
				self.currentItem[3] = int(attrs.get("done"))
		elif name == "summary":
#			warnTrue (self.currentItem==None, "Mot in an item")
#			warnTrue (self.inComment, "Already in a comment")
#			warnTrue (self.inSummary, "Already in a summary")
			if self.currentItem != None:
				self.inSummary = 1
				self.currentItem[0] = ""
		elif name == "comment":
#			 warnTrue (self.currentItem==None, "Mot in an item")
#			 warnTrue (self.inComment, "Already in a comment")
#			 warnTrue (self.inSummary, "Already in a summary")
		
			if self.currentItem != None:
				self.inComment = 1
				self.currentItem[1] = ""
		
	def characters (self, ch):
		if self.inSummary:
			self.currentItem[0] += ch
		elif self.inComment:
			self.currentItem[1] += ch
	
	def endElement (self, name):
		if name == "gtodo":
#			warnFalse (self.inGTodo, "Not in gtodo")
			self.inGTodo = 0
		elif name == "config":
			pass
		elif name == "category":
#			warnFalse (self.inGTodo, "Not in gtodo for category")
			
			self.validCategory = 0
		elif name == "item":
#			warnTrue (self.currentItem==None, "Not in an item")
			if self.currentItem != None:
				self.memoList.append(self.currentItem)
				self.currentItem = None
		elif name == "summary":
			self.inSummary = 0
			pass
		elif name =="comment":
			self.inComment = 0
			pass

#~ gtodo_new_mtime = os.stat(GTODO_XMLFILE)[8]
#~ if(gtodo_new_mtime > gtodo_prev_mtime): #This currently dosnt work, it ALWAYS parses it
#print "parsing xml file %d %d\n" % (gtodo_new_mtime, gtodo_prev_mtime)
parser = make_parser()
parser.setFeature(feature_namespaces, 0)
dh = PyTodo(GTODO_CATEGORY)
parser.setContentHandler(dh)
parser.parse(GTODO_XMLFILE)
memo = dh.memoList
#~ else:
#print "already parsed %d %d\n" % (gtodo_new_mtime, gtodo_prev_mtime)
