/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Property;
import org.apache.tools.ant.util.FileUtils;

public class Ant
extends Task {
    private File dir = null;
    private String antFile = null;
    private String target = null;
    private String output = null;
    private boolean inheritAll = true;
    private Vector properties = new Vector();
    private Project newProject;

    public void setInheritAll(boolean bl) {
        this.inheritAll = bl;
    }

    public void init() {
        this.newProject = new Project();
        this.newProject.setJavaVersionProperty();
        this.newProject.addTaskDefinition("property", (Class)this.project.getTaskDefinitions().get("property"));
    }

    private void reinit() {
        this.init();
        int n = 0;
        while (n < this.properties.size()) {
            Property property = (Property)this.properties.elementAt(n);
            Property property2 = (Property)this.newProject.createTask("property");
            property2.setName(property.getName());
            if (property.getValue() != null) {
                property2.setValue(property.getValue());
            }
            if (property.getFile() != null) {
                property2.setFile(property.getFile());
            }
            if (property.getResource() != null) {
                property2.setResource(property.getResource());
            }
            this.properties.setElementAt(property2, n);
            ++n;
        }
    }

    private void initializeProject() {
        Object object;
        Object object2;
        Enumeration enumeration;
        Object object3;
        Object object4;
        Object object5;
        Vector vector = this.project.getBuildListeners();
        int n = 0;
        while (n < vector.size()) {
            this.newProject.addBuildListener((BuildListener)vector.elementAt(n));
            ++n;
        }
        if (this.output != null) {
            try {
                object5 = new PrintStream(new FileOutputStream(this.output));
                object4 = new DefaultLogger();
                ((DefaultLogger)object4).setMessageOutputLevel(2);
                ((DefaultLogger)object4).setOutputPrintStream((PrintStream)object5);
                ((DefaultLogger)object4).setErrorPrintStream((PrintStream)object5);
                this.newProject.addBuildListener((BuildListener)object4);
            }
            catch (IOException iOException) {
                this.log("Ant: Can't set output to " + this.output);
            }
        }
        object5 = this.project.getTaskDefinitions();
        object4 = ((Hashtable)object5).keys();
        while (object4.hasMoreElements()) {
            object3 = (String)object4.nextElement();
            enumeration = (Class)((Hashtable)object5).get(object3);
            this.newProject.addTaskDefinition((String)object3, (Class)((Object)enumeration));
        }
        object3 = this.project.getDataTypeDefinitions();
        enumeration = ((Hashtable)object3).keys();
        while (enumeration.hasMoreElements()) {
            object2 = (String)enumeration.nextElement();
            object = (Class)((Hashtable)object3).get(object2);
            this.newProject.addDataTypeDefinition((String)object2, (Class)object);
        }
        if (this.inheritAll) {
            object2 = this.project.getProperties();
        } else {
            object2 = this.project.getUserProperties();
            this.newProject.setSystemProperties();
        }
        enumeration = ((Hashtable)object2).keys();
        while (enumeration.hasMoreElements()) {
            object = (String)enumeration.nextElement();
            String string = (String)((Hashtable)object2).get(object);
            if (this.inheritAll) {
                this.newProject.setProperty((String)object, string);
                continue;
            }
            this.newProject.setUserProperty((String)object, string);
        }
    }

    protected void handleOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, false);
        } else {
            super.handleOutput(string);
        }
    }

    protected void handleErrorOutput(String string) {
        if (this.newProject != null) {
            this.newProject.demuxOutput(string, true);
        } else {
            super.handleErrorOutput(string);
        }
    }

    public void execute() throws BuildException {
        try {
            Object object;
            if (this.newProject == null) {
                this.reinit();
            }
            if (this.dir == null) {
                this.dir = this.project.getBaseDir();
            }
            this.initializeProject();
            this.newProject.setBaseDir(this.dir);
            this.newProject.setUserProperty("basedir", this.dir.getAbsolutePath());
            Enumeration enumeration = this.properties.elements();
            while (enumeration.hasMoreElements()) {
                object = (Property)enumeration.nextElement();
                ((Property)object).execute();
            }
            if (this.antFile == null) {
                this.antFile = "build.xml";
            }
            object = FileUtils.newFileUtils().resolveFile(this.dir, this.antFile);
            this.antFile = ((File)object).getAbsolutePath();
            this.newProject.setUserProperty("ant.file", this.antFile);
            ProjectHelper.configureProject(this.newProject, new File(this.antFile));
            if (this.target == null) {
                this.target = this.newProject.getDefaultTarget();
            }
            if (this.newProject.getBaseDir().equals(this.project.getBaseDir()) && this.newProject.getProperty("ant.file").equals(this.project.getProperty("ant.file")) && this.getOwningTarget() != null && this.target.equals(this.getOwningTarget().getName())) {
                throw new BuildException("ant task calling its own parent target");
            }
            this.newProject.executeTarget(this.target);
            Object var4_3 = null;
            this.newProject = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            this.newProject = null;
            throw throwable;
        }
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setAntfile(String string) {
        this.antFile = string;
    }

    public void setTarget(String string) {
        this.target = string;
    }

    public void setOutput(String string) {
        this.output = string;
    }

    public Property createProperty() {
        if (this.newProject == null) {
            this.reinit();
        }
        Property property = (Property)this.newProject.createTask("property");
        property.setUserProperty(true);
        this.properties.addElement(property);
        return property;
    }
}

