/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.IOException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.Jar;
import org.apache.tools.ant.types.ZipFileSet;
import org.apache.tools.zip.ZipOutputStream;

public class Ear
extends Jar {
    private File deploymentDescriptor;
    private boolean descriptorAdded;

    public Ear() {
        this.archiveType = "ear";
        this.emptyBehavior = "create";
    }

    public void setEarfile(File file) {
        super.setZipfile(file);
    }

    public void setAppxml(File file) {
        this.deploymentDescriptor = file;
        if (!this.deploymentDescriptor.exists()) {
            throw new BuildException("Deployment descriptor: " + this.deploymentDescriptor + " does not exist.");
        }
        ZipFileSet zipFileSet = new ZipFileSet();
        zipFileSet.setDir(new File(this.deploymentDescriptor.getParent()));
        zipFileSet.setIncludes(this.deploymentDescriptor.getName());
        zipFileSet.setFullpath("META-INF/application.xml");
        super.addFileset(zipFileSet);
    }

    public void addArchives(ZipFileSet zipFileSet) {
        this.log("addArchives called", 4);
        zipFileSet.setPrefix("/");
        super.addFileset(zipFileSet);
    }

    protected void initZipOutputStream(ZipOutputStream zipOutputStream) throws IOException, BuildException {
        if (this.deploymentDescriptor == null) {
            throw new BuildException("appxml attribute is required", this.location);
        }
        super.initZipOutputStream(zipOutputStream);
    }

    protected void zipFile(File file, ZipOutputStream zipOutputStream, String string) throws IOException {
        if (string.equalsIgnoreCase("META-INF/aplication.xml")) {
            if (this.deploymentDescriptor == null || !this.deploymentDescriptor.equals(file) || this.descriptorAdded) {
                this.log("Warning: selected " + this.archiveType + " files include a META-INF/application.xml which will be ignored " + "(please use appxml attribute to " + this.archiveType + " task)", 1);
            } else {
                super.zipFile(file, zipOutputStream, string);
                this.descriptorAdded = true;
            }
        } else {
            super.zipFile(file, zipOutputStream, string);
        }
    }

    protected void cleanUp() {
        this.descriptorAdded = false;
        super.cleanUp();
    }
}

