/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.ExitException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteJava;
import org.apache.tools.ant.taskdefs.LogStreamHandler;
import org.apache.tools.ant.taskdefs.PumpStreamHandler;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Environment;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public class Java
extends Task {
    private CommandlineJava cmdl = new CommandlineJava();
    private boolean fork = false;
    private File dir = null;
    private File out;
    private PrintStream outStream = null;
    private boolean failOnError = false;

    public void execute() throws BuildException {
        int n = -1;
        n = this.executeJava();
        if (n != 0) {
            if (this.failOnError) {
                throw new BuildException("Java returned: " + n, this.location);
            }
            this.log("Java Result: " + n, 0);
        }
    }

    public int executeJava() throws BuildException {
        String string = this.cmdl.getClassname();
        if (string == null && this.cmdl.getJar() == null) {
            throw new BuildException("Classname must not be null.");
        }
        if (!this.fork && this.cmdl.getJar() != null) {
            throw new BuildException("Cannot execute a jar in non-forked mode. Please set fork='true'. ");
        }
        if (this.fork) {
            this.log("Forking " + this.cmdl.toString(), 3);
            return this.run(this.cmdl.getCommandline());
        }
        if (this.cmdl.getVmCommand().size() > 1) {
            this.log("JVM args ignored when same JVM is used.", 1);
        }
        if (this.dir != null) {
            this.log("Working directory ignored when same JVM is used.", 1);
        }
        this.log("Running in same VM " + this.cmdl.getJavaCommand().toString(), 3);
        try {
            this.run(this.cmdl);
            return 0;
        }
        catch (ExitException exitException) {
            return exitException.getStatus();
        }
    }

    public void setClasspath(Path path) {
        this.createClasspath().append(path);
    }

    public Path createClasspath() {
        return this.cmdl.createClasspath(this.project).createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void setJar(File file) throws BuildException {
        if (this.cmdl.getClassname() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command.");
        }
        this.cmdl.setJar(file.getAbsolutePath());
    }

    public void setClassname(String string) throws BuildException {
        if (this.cmdl.getJar() != null) {
            throw new BuildException("Cannot use 'jar' and 'classname' attributes in same command");
        }
        this.cmdl.setClassname(string);
    }

    public void setArgs(String string) {
        this.log("The args attribute is deprecated. Please use nested arg elements.", 1);
        this.cmdl.createArgument().setLine(string);
    }

    public Commandline.Argument createArg() {
        return this.cmdl.createArgument();
    }

    public void setFork(boolean bl) {
        this.fork = bl;
    }

    public void setJvmargs(String string) {
        this.log("The jvmargs attribute is deprecated. Please use nested jvmarg elements.", 1);
        this.cmdl.createVmArgument().setLine(string);
    }

    public Commandline.Argument createJvmarg() {
        return this.cmdl.createVmArgument();
    }

    public void setJvm(String string) {
        this.cmdl.setVm(string);
    }

    public void addSysproperty(Environment.Variable variable) {
        this.cmdl.addSysproperty(variable);
    }

    public void setFailonerror(boolean bl) {
        this.failOnError = bl;
    }

    public void setDir(File file) {
        this.dir = file;
    }

    public void setOutput(File file) {
        this.out = file;
    }

    public void setMaxmemory(String string) {
        this.cmdl.setMaxmemory(string);
    }

    public void setJVMVersion(String string) {
        this.cmdl.setVmversion(string);
    }

    protected void handleOutput(String string) {
        if (this.outStream != null) {
            this.outStream.println(string);
        } else {
            super.handleOutput(string);
        }
    }

    protected void handleErrorOutput(String string) {
        if (this.outStream != null) {
            this.outStream.println(string);
        } else {
            super.handleErrorOutput(string);
        }
    }

    private void run(CommandlineJava commandlineJava) throws BuildException {
        block7: {
            ExecuteJava executeJava = new ExecuteJava();
            executeJava.setJavaCommand(commandlineJava.getJavaCommand());
            executeJava.setClasspath(commandlineJava.getClasspath());
            executeJava.setSystemProperties(commandlineJava.getSystemProperties());
            if (this.out != null) {
                try {
                    try {
                        this.outStream = new PrintStream(new FileOutputStream(this.out));
                        executeJava.execute(this.project);
                    }
                    catch (IOException iOException) {
                        throw new BuildException(iOException, this.location);
                    }
                    Object var5_3 = null;
                    if (this.outStream != null) {
                        this.outStream.close();
                    }
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var5_4 = null;
                    if (this.outStream != null) {
                        this.outStream.close();
                    }
                    throw throwable;
                }
            }
            executeJava.execute(this.project);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int run(String[] stringArray) throws BuildException {
        FileOutputStream fileOutputStream = null;
        try {
            try {
                Execute execute = null;
                if (this.out == null) {
                    execute = new Execute(new LogStreamHandler(this, 2, 1), null);
                } else {
                    fileOutputStream = new FileOutputStream(this.out);
                    execute = new Execute(new PumpStreamHandler(fileOutputStream), null);
                }
                execute.setAntRun(this.project);
                if (this.dir == null) {
                    this.dir = this.project.getBaseDir();
                } else {
                    if (!this.dir.exists()) throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.location);
                    if (!this.dir.isDirectory()) {
                        throw new BuildException(this.dir.getAbsolutePath() + " is not a valid directory", this.location);
                    }
                }
                execute.setWorkingDirectory(this.dir);
                execute.setCommandline(stringArray);
                try {
                    int n = execute.execute();
                    Object var6_7 = null;
                    if (fileOutputStream == null) return n;
                    try {
                        fileOutputStream.close();
                        return n;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return n;
                }
                catch (IOException iOException) {
                    throw new BuildException(iOException, this.location);
                }
            }
            catch (IOException iOException) {
                throw new BuildException(iOException, this.location);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (fileOutputStream == null) throw throwable;
            try {}
            catch (IOException iOException) {
                throw throwable;
            }
            fileOutputStream.close();
            throw throwable;
        }
    }

    protected void run(String string, Vector vector) throws BuildException {
        CommandlineJava commandlineJava = new CommandlineJava();
        commandlineJava.setClassname(string);
        int n = 0;
        while (n < vector.size()) {
            commandlineJava.createArgument().setValue((String)vector.elementAt(n));
            ++n;
        }
        this.run(commandlineJava);
    }

    public void clearArgs() {
        this.cmdl.clearJavaArgs();
    }
}

