/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.PrintStream;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildLogger;

public class RecorderEntry
implements BuildLogger {
    private String filename = null;
    private boolean record = true;
    private int loglevel = 2;
    private PrintStream out = null;
    private long targetStartTime = 0L;
    private static String lSep = System.getProperty("line.separator");

    protected RecorderEntry(String string) {
        this.filename = string;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setRecordState(Boolean bl) {
        if (bl != null) {
            this.record = bl;
        }
    }

    public void buildStarted(BuildEvent buildEvent) {
        this.log("> BUILD STARTED", 4);
    }

    public void buildFinished(BuildEvent buildEvent) {
        this.log("< BUILD FINISHED", 4);
        Throwable throwable = buildEvent.getException();
        if (throwable == null) {
            this.out.println(lSep + "BUILD SUCCESSFUL");
        } else {
            this.out.println(lSep + "BUILD FAILED" + lSep);
            throwable.printStackTrace(this.out);
        }
        this.out.flush();
        this.out.close();
    }

    public void targetStarted(BuildEvent buildEvent) {
        this.log(">> TARGET STARTED -- " + buildEvent.getTarget(), 4);
        this.log(lSep + buildEvent.getTarget().getName() + ":", 2);
        this.targetStartTime = System.currentTimeMillis();
    }

    public void targetFinished(BuildEvent buildEvent) {
        this.log("<< TARGET FINISHED -- " + buildEvent.getTarget(), 4);
        String string = RecorderEntry.formatTime(System.currentTimeMillis() - this.targetStartTime);
        this.log(buildEvent.getTarget() + ":  duration " + string, 3);
        this.out.flush();
    }

    public void taskStarted(BuildEvent buildEvent) {
        this.log(">>> TAST STARTED -- " + buildEvent.getTask(), 4);
    }

    public void taskFinished(BuildEvent buildEvent) {
        this.log("<<< TASK FINISHED -- " + buildEvent.getTask(), 4);
        this.out.flush();
    }

    public void messageLogged(BuildEvent buildEvent) {
        this.log("--- MESSAGE LOGGED", 4);
        StringBuffer stringBuffer = new StringBuffer();
        if (buildEvent.getTask() != null) {
            String string = "[" + buildEvent.getTask().getTaskName() + "]";
            int n = 0;
            while (n < 12 - string.length()) {
                stringBuffer.append(" ");
                ++n;
            }
            stringBuffer.append(string);
        }
        stringBuffer.append(buildEvent.getMessage());
        this.log(stringBuffer.toString(), buildEvent.getPriority());
    }

    private void log(String string, int n) {
        if (this.record && n <= this.loglevel) {
            this.out.println(string);
        }
    }

    public void setMessageOutputLevel(int n) {
        if (n >= 0 && n <= 4) {
            this.loglevel = n;
        }
    }

    public void setOutputPrintStream(PrintStream printStream) {
        this.out = printStream;
    }

    public void setEmacsMode(boolean bl) {
        throw new RuntimeException("Method setEmacsMode() not yet implemented.");
    }

    public void setErrorPrintStream(PrintStream printStream) {
        this.out = printStream;
    }

    private static String formatTime(long l) {
        long l2 = l / 1000L;
        long l3 = l2 / 60L;
        if (l3 > 0L) {
            return Long.toString(l3) + " minute" + (l3 == 1L ? " " : "s ") + Long.toString(l2 % 60L) + " second" + (l2 % 60L == 1L ? "" : "s");
        }
        return Long.toString(l2) + " second" + (l2 % 60L == 1L ? "" : "s");
    }
}

