/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.types;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.types.DataType;

public class FilterSet
extends DataType {
    public static final String DEFAULT_TOKEN_START = "@";
    public static final String DEFAULT_TOKEN_END = "@";
    private String startOfToken = "@";
    private String endOfToken = "@";
    private Vector filters = new Vector();
    static /* synthetic */ Class class$org$apache$tools$ant$types$FilterSet;

    public FilterSet() {
    }

    protected FilterSet(FilterSet filterSet) {
        this.filters = (Vector)filterSet.getFilters().clone();
    }

    protected Vector getFilters() {
        if (this.isReference()) {
            return this.getRef().getFilters();
        }
        return this.filters;
    }

    protected FilterSet getRef() {
        return (FilterSet)this.getCheckedRef(class$org$apache$tools$ant$types$FilterSet == null ? (class$org$apache$tools$ant$types$FilterSet = FilterSet.class$("org.apache.tools.ant.types.FilterSet")) : class$org$apache$tools$ant$types$FilterSet, "filterset");
    }

    public Hashtable getFilterHash() {
        int n = this.getFilters().size();
        Hashtable<String, String> hashtable = new Hashtable<String, String>(n);
        Enumeration enumeration = this.getFilters().elements();
        while (enumeration.hasMoreElements()) {
            Filter filter = (Filter)enumeration.nextElement();
            hashtable.put(filter.getToken(), filter.getValue());
        }
        return hashtable;
    }

    public void setFiltersfile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.readFiltersFromFile(file);
    }

    public void setBeginToken(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.startOfToken = string;
    }

    public String getBeginToken() {
        if (this.isReference()) {
            return this.getRef().getBeginToken();
        }
        return this.startOfToken;
    }

    public void setEndToken(String string) {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        this.endOfToken = string;
    }

    public String getEndToken() {
        if (this.isReference()) {
            return this.getRef().getEndToken();
        }
        return this.endOfToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readFiltersFromFile(File file) throws BuildException {
        if (this.isReference()) {
            throw this.tooManyAttributes();
        }
        if (!file.isFile()) throw new BuildException("Must specify a file not a directory in the filtersfile attribute:" + file);
        this.log("Reading filters from " + file, 3);
        FileInputStream fileInputStream = null;
        try {
            try {
                Properties properties = new Properties();
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                Enumeration<?> enumeration = properties.propertyNames();
                Vector vector = this.getFilters();
                while (enumeration.hasMoreElements()) {
                    String string = (String)enumeration.nextElement();
                    String string2 = properties.getProperty(string);
                    vector.addElement(new Filter(string, string2));
                }
            }
            catch (Exception exception) {
                throw new BuildException("Could not read filters from file: " + file);
            }
            Object var9_9 = null;
            if (fileInputStream == null) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (fileInputStream == null) throw throwable;
            try {
                fileInputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        fileInputStream.close();
        return;
    }

    public String replaceTokens(String string) {
        String string2 = this.getBeginToken();
        String string3 = this.getEndToken();
        int n = string.indexOf(string2);
        if (n > -1) {
            Hashtable hashtable = this.getFilterHash();
            try {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                int n3 = 0;
                String string4 = null;
                String string5 = null;
                while ((n2 = string.indexOf(string3, n + string2.length() + 1)) != -1) {
                    string4 = string.substring(n + string2.length(), n2);
                    stringBuffer.append(string.substring(n3, n));
                    if (hashtable.containsKey(string4)) {
                        string5 = (String)hashtable.get(string4);
                        this.log("Replacing: " + string2 + string4 + string3 + " -> " + string5, 3);
                        stringBuffer.append(string5);
                        n3 = n + string2.length() + string4.length() + string3.length();
                    } else {
                        stringBuffer.append(string2);
                        n3 = n + string2.length();
                    }
                    if ((n = string.indexOf(string2, n3)) > -1) continue;
                }
                stringBuffer.append(string.substring(n3));
                return stringBuffer.toString();
            }
            catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                return string;
            }
        }
        return string;
    }

    public void addFilter(Filter filter) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filters.addElement(filter);
    }

    public FiltersFile createFiltersfile() {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        return new FiltersFile();
    }

    public void addFilter(String string, String string2) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        this.filters.addElement(new Filter(string, string2));
    }

    public void addFilterSet(FilterSet filterSet) {
        if (this.isReference()) {
            throw this.noChildrenAllowed();
        }
        Enumeration enumeration = filterSet.getFilters().elements();
        while (enumeration.hasMoreElements()) {
            this.filters.addElement((Filter)enumeration.nextElement());
        }
    }

    public boolean hasFilters() {
        return this.getFilters().size() > 0;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public class FiltersFile {
        public void setFile(File file) {
            FilterSet.this.readFiltersFromFile(file);
        }
    }

    public static class Filter {
        String token;
        String value;

        public Filter(String string, String string2) {
            this.token = string;
            this.value = string2;
        }

        public Filter() {
        }

        public void setToken(String string) {
            this.token = string;
        }

        public void setValue(String string) {
            this.value = string;
        }

        public String getToken() {
            return this.token;
        }

        public String getValue() {
            return this.value;
        }
    }
}

