/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.cldc.i18n.j2me;

import com.sun.cldc.i18n.StreamReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;

public class GenericReader
extends StreamReader {
    private String enc;
    private int maxBytesPerChar;
    private int id;
    private static int counter = 0;

    public GenericReader(String enc) throws UnsupportedEncodingException {
        this.enc = enc;
        this.maxBytesPerChar = this.checkEncoding(enc);
        this.id = counter++;
        this.registerCleanup();
    }

    public Reader open(InputStream in, String enc) throws UnsupportedEncodingException {
        if (!enc.equals(this.enc)) {
            throw new IllegalArgumentException(enc + " not equals " + this.enc);
        }
        return super.open(in, enc);
    }

    public synchronized int read() throws IOException {
        byte[] bytes = new byte[1];
        int i = 0;
        while (i < this.maxBytesPerChar) {
            int b = this.in.read();
            if (b == -1) {
                if (i == 0) {
                    return -1;
                }
                String message = "Malformed input (Stream ends in the middle of a character)";
                throw new IOException(message);
            }
            bytes[0] = (byte)b;
            char[] c = null;
            try {
                c = this.byteToCharArray(bytes, 1, this.enc, this.id);
                return c[0];
            }
            catch (IOException e) {
                ++i;
            }
        }
        String message = "Malformed input (cannot form character from input stream)";
        throw new IOException(message);
    }

    public synchronized int read(char[] cbuf, int off, int len) throws IOException {
        byte[] bytes = new byte[this.maxBytesPerChar * len];
        int count = this.in.read(bytes);
        if (count == -1) {
            return count;
        }
        char[] c = this.byteToCharArray(bytes, count, this.enc, this.id);
        int charsToCopy = Math.min(len, c.length);
        int i = 0;
        while (i < charsToCopy) {
            cbuf[off + i] = c[i];
            ++i;
        }
        return charsToCopy;
    }

    public int sizeOf(byte[] bytes, int off, int len) {
        try {
            if (off != 0) {
                byte[] temp = new byte[len];
                System.arraycopy(bytes, off, temp, 0, len);
                return this.sizeOf(temp, len, this.enc);
            }
            return this.sizeOf(bytes, len, this.enc);
        }
        catch (IOException e) {
            return -1;
        }
    }

    private native char[] byteToCharArray(byte[] var1, int var2, String var3, int var4) throws IOException;

    private native int sizeOf(byte[] var1, int var2, String var3) throws IOException;

    private native int checkEncoding(String var1) throws UnsupportedEncodingException;

    private native void registerCleanup();
}

