/*
 * Decompiled with CFR 0.152.
 */
package com.sun.kvem.midp.lcdui;

import com.sun.kvem.midp.lcdui.EmulEventHandler;
import com.sun.kvem.midp.lcdui.SpecialKeys;
import com.sun.kvem.midp.lcdui.TextEditorBridge;
import com.sun.midp.lcdui.InputMethodClient;
import com.sun.midp.lcdui.InputMethodHandler;

public class EmulInputMethodHandler
extends InputMethodHandler {
    private static final boolean debug = false;
    private InputMethodClient client;
    private int constraints;
    private char[] buffer = new char[1];
    protected String[] supportedInputModes = new String[]{"LATIN", "LATIN_DIGITS"};

    public void setFocus(boolean focus) {
        if (focus) {
            this.startTextInput();
        } else {
            this.endTextInput();
        }
    }

    public void setInputMethodClient(InputMethodClient client) {
        this.client = client;
        this.constraints = client.getConstraints();
        this.setConstraints(this.constraints);
    }

    private native void setConstraints(int var1);

    private native void startTextInput();

    private native void endTextInput();

    private boolean isCharacterKeyCode(int keyCode) {
        return keyCode >= 32 && keyCode < 65536 || this.isEnterKeyCode(keyCode);
    }

    private boolean isEnterKeyCode(int keyCode) {
        return keyCode == 10 || keyCode == 13;
    }

    private boolean isPassword() {
        return (this.constraints & 0x10000) != 0;
    }

    private int systemKey(int keyCode) {
        return EmulEventHandler.getSystemKeyImpl(keyCode);
    }

    private int gameAction(int keyCode) {
        return EmulEventHandler.getGameActionImpl(keyCode);
    }

    private synchronized boolean keyFired(int keyCode) {
        int caretPosition;
        if (SpecialKeys.isStartEdit(keyCode)) {
            TextEditorBridge.editText(this.client);
            return true;
        }
        int systemKey = this.systemKey(keyCode);
        if (this.isCharacterKeyCode(keyCode)) {
            if (!(this.isPassword() && this.isEnterKeyCode(keyCode) || this.client.getSize() >= this.client.getMaxSize())) {
                this.buffer[0] = (char)keyCode;
                int caretPosition2 = this.client.getCaretPosition();
                this.client.insert(this.buffer, 0, 1, caretPosition2);
                this.client.setCaretPosition(caretPosition2 + 1);
                this.client.repaintContent();
            }
            return true;
        }
        if (systemKey == 4 && (caretPosition = this.client.getCaretPosition()) > 0) {
            this.deleteCharacter(caretPosition);
            this.client.setCaretPosition(caretPosition - 1);
            this.client.repaintContent();
            return true;
        }
        return false;
    }

    private void deleteCharacter(int index) {
        this.client.replace(null, 0, 1, index - 1, index);
    }

    public boolean keyPressed(int keyCode) {
        try {
            return this.keyFired(keyCode);
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public boolean keyReleased(int keyCode) {
        return keyCode >= 32 && keyCode <= 65536;
    }

    public boolean keyRepeated(int keyCode) {
        return this.keyFired(keyCode);
    }

    public void timerWentOff() {
    }

    public void endComposition() {
        this.endTextInput();
    }

    public void clearInputMethodClient(InputMethodClient imcToBeCleared) {
        if (this.client == imcToBeCleared) {
            this.client = null;
        }
    }

    public String[] supportedInputModes() {
        return this.supportedInputModes;
    }
}

