/*
 * Decompiled with CFR 0.152.
 */
package com.sun.midp.io.j2me.storage;

import com.sun.midp.midlet.MIDletSuite;
import com.sun.midp.midlet.Scheduler;
import com.sun.midp.security.SecurityDomain;
import java.io.IOException;
import java.util.Vector;

public class File {
    private static final char[] NUMS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private static String storageRoot = null;

    public static String getStorageRoot() {
        if (storageRoot == null) {
            storageRoot = File.initStorageRoot();
        }
        return storageRoot;
    }

    public static String unicodeToAsciiFilename(String str) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9') {
                sbuf.append(c);
            } else if (c >= 'A' && c <= 'Z') {
                sbuf.append('#');
                sbuf.append(c);
            } else {
                int v = c & 0xFFFF;
                sbuf.append('%');
                sbuf.append(NUMS[(v & 0xF000) >> 12]);
                sbuf.append(NUMS[(v & 0xF00) >> 8]);
                sbuf.append(NUMS[(v & 0xF0) >> 4]);
                sbuf.append(NUMS[(v & 0xF) >> 0]);
            }
            ++i;
        }
        return sbuf.toString();
    }

    public static String asciiFilenameToUnicode(String str) {
        StringBuffer sbuf = new StringBuffer();
        int i = 0;
        while (i < str.length()) {
            char c = str.charAt(i);
            if (c == '%') {
                int v = 0;
                v <<= 4;
                v += File.hexValue(str.charAt(i + 1));
                v <<= 4;
                v += File.hexValue(str.charAt(i + 2));
                v <<= 4;
                v += File.hexValue(str.charAt(i + 3));
                v <<= 4;
                v += File.hexValue(str.charAt(i + 4));
                i += 4;
                sbuf.append((char)(v & 0xFFFF));
            } else if (c != '#') {
                sbuf.append(c);
            }
            ++i;
        }
        return sbuf.toString();
    }

    private static int hexValue(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        return c - 97 + 10;
    }

    public static byte[] toCString(String string) {
        int length = string.length();
        byte[] cString = new byte[length + 1];
        int i = 0;
        while (i < length) {
            cString[i] = (byte)string.charAt(i);
            ++i;
        }
        return cString;
    }

    public File() {
        MIDletSuite midletSuite = Scheduler.getScheduler().getMIDletSuite();
        if (midletSuite != null) {
            midletSuite.checkIfPermitted(9);
        }
    }

    public File(SecurityDomain callerSecurityDomain) {
        callerSecurityDomain.checkIfPermitted(9);
    }

    public synchronized void rename(String oldName, String newName) throws IOException {
        byte[] oldAsciiFilename = File.toCString(oldName);
        byte[] newAsciiFilename = File.toCString(newName);
        File.renameStorage(oldAsciiFilename, newAsciiFilename);
    }

    public synchronized boolean exists(String name) {
        byte[] asciiFilename = File.toCString(name);
        return File.storageExists(asciiFilename);
    }

    public synchronized Vector filenamesThatStartWith(String root) {
        Vector list = new Vector();
        byte[] szRoot = File.toCString(root);
        String filename = File.getFirstFileThatStartsWith(szRoot);
        while (filename != null) {
            list.addElement(filename);
            filename = File.getNextFileThatStartsWith(szRoot);
        }
        return list;
    }

    public synchronized void delete(String name) throws IOException {
        byte[] asciiFilename = File.toCString(name);
        File.deleteStorage(asciiFilename);
    }

    public int getBytesAvailableForFiles() {
        return File.availableStorage();
    }

    private static native String initStorageRoot();

    private static native void renameStorage(byte[] var0, byte[] var1) throws IOException;

    private static native boolean storageExists(byte[] var0);

    private static native void deleteStorage(byte[] var0) throws IOException;

    private static native String getFirstFileThatStartsWith(byte[] var0);

    private static native String getNextFileThatStartsWith(byte[] var0);

    private static native int availableStorage();
}

