/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Date;
import java.util.TimeZone;

public abstract class Calendar {
    public static final int YEAR = 1;
    public static final int MONTH = 2;
    public static final int DATE = 5;
    public static final int DAY_OF_MONTH = 5;
    public static final int DAY_OF_WEEK = 7;
    public static final int AM_PM = 9;
    public static final int HOUR = 10;
    public static final int HOUR_OF_DAY = 11;
    public static final int MINUTE = 12;
    public static final int SECOND = 13;
    public static final int MILLISECOND = 14;
    public static final int SUNDAY = 1;
    public static final int MONDAY = 2;
    public static final int TUESDAY = 3;
    public static final int WEDNESDAY = 4;
    public static final int THURSDAY = 5;
    public static final int FRIDAY = 6;
    public static final int SATURDAY = 7;
    public static final int JANUARY = 0;
    public static final int FEBRUARY = 1;
    public static final int MARCH = 2;
    public static final int APRIL = 3;
    public static final int MAY = 4;
    public static final int JUNE = 5;
    public static final int JULY = 6;
    public static final int AUGUST = 7;
    public static final int SEPTEMBER = 8;
    public static final int OCTOBER = 9;
    public static final int NOVEMBER = 10;
    public static final int DECEMBER = 11;
    public static final int AM = 0;
    public static final int PM = 1;
    private int packed_time = 0;
    private int packed_date = 0;
    private int day_field = 0;
    private int dstOffset = 0;
    private boolean dstSet = false;
    private long time;
    private boolean millisSet;
    private TimeZone zone = TimeZone.getDefault();
    private static final int JAN_1_1_JULIAN_DAY = 1721426;
    private static final int EPOCH_JULIAN_DAY = 2440588;
    private static final int EPOCH_YEAR = 1970;
    private static final int[] NUM_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334};
    private static final int[] LEAP_NUM_DAYS = new int[]{0, 31, 60, 91, 121, 152, 182, 213, 244, 274, 305, 335};
    private static final int ONE_SECOND = 1000;
    private static final int ONE_MINUTE = 60000;
    private static final int ONE_HOUR = 3600000;
    private static final long ONE_DAY = 86400000L;
    private static final long ONE_WEEK = 604800000L;
    private static final long gregorianCutover = -12219292800000L;
    private static final int gregorianCutoverYear = 1582;
    private Date date = null;
    private int hour_12hr = -1;
    private int am_pm_12hr = -1;
    private static String platform = null;
    private static String classRoot = null;

    protected Calendar() {
        if (this.zone == null) {
            throw new RuntimeException("Could not find default timezone");
        }
        this.setTimeInMillis(System.currentTimeMillis());
    }

    public final Date getTime() {
        if (this.date == null) {
            this.date = new Date(this.getTimeInMillis());
            return this.date;
        }
        Date date = this.date;
        synchronized (date) {
            this.date.setTime(this.getTimeInMillis());
            Date date2 = this.date;
            return date2;
        }
    }

    public final void setTime(Date date) {
        this.setTimeInMillis(date.getTime());
    }

    public static synchronized Calendar getInstance() {
        if (platform == null) {
            platform = "j2me";
            classRoot = System.getProperty("microedition.implpath");
            if (classRoot == null) {
                classRoot = "com.sun.cldc";
            }
        }
        try {
            Class clazz = Class.forName(classRoot + ".util." + platform + ".CalendarImpl");
            return (Calendar)clazz.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static synchronized Calendar getInstance(TimeZone zone) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(zone);
        return cal;
    }

    protected long getTimeInMillis() {
        if (!this.millisSet) {
            this.calculateTime();
            this.millisSet = true;
        }
        return this.time;
    }

    protected void setTimeInMillis(long millis) {
        this.millisSet = true;
        this.day_field = 0;
        this.time = millis;
        this.calculateFields();
    }

    public final int get(int field) {
        switch (field) {
            case 1: {
                return this.packed_date >> 9;
            }
            case 2: {
                return this.packed_date >> 5 & 0xF;
            }
            case 5: {
                return this.packed_date & 0x1F;
            }
            case 7: {
                if (this.day_field == 0) {
                    this.getTimeInMillis();
                    this.calculateFields();
                }
                return this.day_field;
            }
            case 11: {
                return this.packed_time >> 22;
            }
            case 10: {
                int hr = (this.packed_time >> 22) % 12;
                return hr == 0 ? 12 : hr;
            }
            case 9: {
                return this.packed_time >> 22 < 12 ? 0 : 1;
            }
            case 12: {
                return this.packed_time >> 16 & 0x3F;
            }
            case 13: {
                return this.packed_time >> 10 & 0x3F;
            }
            case 14: {
                return this.packed_time & 0x3FF;
            }
        }
        throw new ArrayIndexOutOfBoundsException();
    }

    public final void set(int field, int value) {
        this.millisSet = false;
        this.day_field = 0;
        switch (field) {
            case 1: {
                this.packed_date = this.packed_date & 0x1FF | value << 9;
                break;
            }
            case 2: {
                this.packed_date = this.packed_date & 0xFFFFFE1F | (value & 0xF) << 5;
                break;
            }
            case 5: {
                this.packed_date = this.packed_date & 0xFFFFFFE0 | value & 0x1F;
                break;
            }
            case 11: {
                this.packed_time = this.packed_time & 0x3FFFFF | (value %= 24) << 22;
                this.am_pm_12hr = -1;
                this.hour_12hr = -1;
                break;
            }
            case 10: {
                if (value > 12) {
                    value = 12;
                }
                if (this.am_pm_12hr != -1) {
                    if (this.am_pm_12hr == 1) {
                        if (value != 12) {
                            value += 12;
                        }
                    } else if (value == 12) {
                        value = 0;
                    }
                    this.am_pm_12hr = -1;
                    this.hour_12hr = -1;
                } else {
                    this.hour_12hr = value;
                }
                this.packed_time = this.packed_time & 0x3FFFFF | value << 22;
                break;
            }
            case 9: {
                if (this.hour_12hr != -1) {
                    if (value == 1) {
                        if (this.hour_12hr != 12) {
                            this.hour_12hr += 12;
                        }
                    } else if (this.hour_12hr == 12) {
                        this.hour_12hr = 0;
                    }
                    this.packed_time = this.packed_time & 0x3FFFFF | this.hour_12hr << 22;
                    this.am_pm_12hr = -1;
                    this.hour_12hr = -1;
                    break;
                }
                this.am_pm_12hr = value;
                break;
            }
            case 12: {
                this.packed_time = this.packed_time & 0xFFC0FFFF | (value & 0x3F) << 16;
                break;
            }
            case 13: {
                this.packed_time = this.packed_time & 0xFFFF03FF | (value & 0x3F) << 10;
                break;
            }
            case 14: {
                this.packed_time = this.packed_time & 0xFFFFFC00 | value & 0x3FF;
                break;
            }
            default: {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
        this.dstSet = false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Calendar)) {
            return false;
        }
        Calendar that = (Calendar)obj;
        return this.getTimeInMillis() == that.getTimeInMillis() && this.zone.equals(that.zone);
    }

    public boolean before(Object when) {
        return when instanceof Calendar && this.getTimeInMillis() < ((Calendar)when).getTimeInMillis();
    }

    public boolean after(Object when) {
        return when instanceof Calendar && this.getTimeInMillis() > ((Calendar)when).getTimeInMillis();
    }

    public void setTimeZone(TimeZone value) {
        this.zone = value;
        this.getTimeInMillis();
        this.calculateFields();
    }

    public TimeZone getTimeZone() {
        return this.zone;
    }

    private void calculateDstOffset() {
        long days;
        int rawOffset;
        long localMillis;
        int millisInDay;
        if (this.day_field == 0) {
            this.getTimeInMillis();
            this.calculateFields();
        }
        if ((millisInDay = (int)((localMillis = this.time + (long)(rawOffset = this.zone.getRawOffset())) - (days = localMillis / 86400000L) * 86400000L)) < 0) {
            millisInDay = (int)((long)millisInDay + 86400000L);
        }
        this.dstOffset = this.zone.getOffset(1, this.packed_date >> 9, this.packed_date >> 5 & 0xF, this.packed_date & 0x1F, this.day_field, millisInDay) - rawOffset;
        this.dstSet = true;
    }

    private void calculateFields() {
        int rawOffset = this.zone.getRawOffset();
        long localMillis = this.time + (long)rawOffset;
        if (this.time > 0L && localMillis < 0L && rawOffset > 0) {
            localMillis = Long.MAX_VALUE;
        } else if (this.time < 0L && localMillis > 0L && rawOffset < 0) {
            localMillis = Long.MIN_VALUE;
        }
        this.timeToFields(localMillis);
        long days = localMillis / 86400000L;
        int millisInDay = (int)(localMillis - days * 86400000L);
        if (millisInDay < 0) {
            millisInDay = (int)((long)millisInDay + 86400000L);
        }
        this.dstOffset = this.zone.getOffset(1, this.packed_date >> 9, this.packed_date >> 5 & 0xF, this.packed_date & 0x1F, this.day_field, millisInDay) - rawOffset;
        this.dstSet = true;
        if ((long)(millisInDay += this.dstOffset) >= 86400000L) {
            long dstMillis = localMillis + (long)this.dstOffset;
            millisInDay = (int)((long)millisInDay - 86400000L);
            if (localMillis > 0L && dstMillis < 0L && this.dstOffset > 0) {
                dstMillis = Long.MAX_VALUE;
            } else if (localMillis < 0L && dstMillis > 0L && this.dstOffset < 0) {
                dstMillis = Long.MIN_VALUE;
            }
            this.timeToFields(dstMillis);
        }
        this.packed_time = this.packed_time & 0xFFFFFC00 | millisInDay % 1000;
        this.packed_time = this.packed_time & 0xFFFF03FF | (millisInDay /= 1000) % 60 << 10;
        this.packed_time = this.packed_time & 0xFFC0FFFF | (millisInDay /= 60) % 60 << 16;
        this.packed_time = this.packed_time & 0xF83FFFFF | ((millisInDay /= 60) & 0x1F) << 22;
    }

    private final void timeToFields(long theTime) {
        int march1;
        boolean isLeap;
        int dayOfYear;
        int year_field;
        if (theTime >= -12219292800000L) {
            long gregorianEpochDay = Calendar.millisToJulianDay(theTime) - 1721426L;
            int[] rem = new int[1];
            int n400 = Calendar.floorDivide(gregorianEpochDay, 146097, rem);
            int n100 = Calendar.floorDivide(rem[0], 36524, rem);
            int n4 = Calendar.floorDivide(rem[0], 1461, rem);
            int n1 = Calendar.floorDivide(rem[0], 365, rem);
            year_field = 400 * n400 + 100 * n100 + 4 * n4 + n1;
            dayOfYear = rem[0];
            if (n100 == 4 || n1 == 4) {
                dayOfYear = 365;
            } else {
                ++year_field;
            }
            isLeap = (year_field & 3) == 0 && (year_field % 100 != 0 || year_field % 400 == 0);
            this.day_field = (int)((gregorianEpochDay + 1L) % 7L);
        } else {
            long julianEpochDay = Calendar.millisToJulianDay(theTime) - 1721424L;
            year_field = (int)Calendar.floorDivide(4L * julianEpochDay + 1464L, 1461L);
            long january1 = 365 * (year_field - 1) + Calendar.floorDivide(year_field - 1, 4);
            dayOfYear = (int)(julianEpochDay - january1);
            isLeap = (year_field & 3) == 0;
            this.day_field = (int)((julianEpochDay - 1L) % 7L);
        }
        int correction = 0;
        int n = march1 = isLeap ? 60 : 59;
        if (dayOfYear >= march1) {
            correction = isLeap ? 1 : 2;
        }
        int month_field = (12 * (dayOfYear + correction) + 6) / 367;
        int date_field = dayOfYear - (isLeap ? LEAP_NUM_DAYS[month_field] : NUM_DAYS[month_field]) + 1;
        this.day_field += this.day_field < 0 ? 8 : 1;
        this.packed_date = year_field << 9;
        this.packed_date |= ((month_field += 0) & 0xF) << 5;
        this.packed_date |= date_field & 0x1F;
    }

    private void calculateTime() {
        long julianDay;
        long millis;
        int year_field = this.packed_date >> 9;
        boolean isGregorian = year_field >= 1582;
        if (isGregorian != (millis = Calendar.julianDayToMillis(julianDay = this.calculateJulianDay(isGregorian, year_field))) >= -12219292800000L && julianDay != -106749550580L) {
            julianDay = this.calculateJulianDay(!isGregorian, year_field);
            millis = Calendar.julianDayToMillis(julianDay);
        }
        int millisInDay = 0;
        millisInDay += this.packed_time >> 22 & 0x1F;
        millisInDay *= 60;
        millisInDay += this.packed_time >> 16 & 0x3F;
        millisInDay *= 60;
        millisInDay += this.packed_time >> 10 & 0x3F;
        millisInDay *= 1000;
        int zoneOffset = this.zone.getRawOffset();
        this.dstOffset = 0;
        int[] normalizedMillisInDay = new int[1];
        Calendar.floorDivide(millis += (long)(millisInDay += this.packed_time & 0x3FF), 86400000, normalizedMillisInDay);
        int dow = Calendar.julianDayToDayOfWeek(julianDay);
        this.dstOffset = this.zone.getOffset(1, this.packed_date >> 9, this.packed_date >> 5 & 0xF, this.packed_date & 0x1F, dow, normalizedMillisInDay[0]) - zoneOffset;
        this.dstSet = true;
        this.time = millis - (long)zoneOffset - (long)this.dstOffset;
    }

    private final long calculateJulianDay(boolean isGregorian, int year) {
        int month = 0;
        long millis = 0L;
        month = this.packed_date >> 5 & 0xF;
        if (month < 0 || month > 11) {
            int[] rem = new int[1];
            year += Calendar.floorDivide(month, 12, rem);
            month = rem[0];
        }
        boolean isLeap = year % 4 == 0;
        int y = year - 1;
        long julianDay = 365L * (long)y + (long)Calendar.floorDivide(y, 4) + 1721423L;
        if (isGregorian) {
            isLeap = isLeap && (year % 100 != 0 || year % 400 == 0);
            julianDay += (long)(Calendar.floorDivide(y, 400) - Calendar.floorDivide(y, 100) + 2);
        }
        julianDay += isLeap ? (long)LEAP_NUM_DAYS[month] : (long)NUM_DAYS[month];
        return julianDay += (long)(this.packed_date & 0x1F);
    }

    private static final long millisToJulianDay(long millis) {
        return 2440588L + Calendar.floorDivide(millis, 86400000L);
    }

    private static final long julianDayToMillis(long julian) {
        return (julian - 2440588L) * 86400000L;
    }

    private static final int julianDayToDayOfWeek(long julian) {
        int dayOfWeek;
        return dayOfWeek + ((dayOfWeek = (int)((julian + 1L) % 7L)) < 0 ? 8 : 1);
    }

    private static final long floorDivide(long numerator, long denominator) {
        return numerator >= 0L ? numerator / denominator : (numerator + 1L) / denominator - 1L;
    }

    private static final int floorDivide(int numerator, int denominator) {
        return numerator >= 0 ? numerator / denominator : (numerator + 1) / denominator - 1;
    }

    private static final int floorDivide(int numerator, int denominator, int[] remainder) {
        if (numerator >= 0) {
            remainder[0] = numerator % denominator;
            return numerator / denominator;
        }
        int quotient = (numerator + 1) / denominator - 1;
        remainder[0] = numerator - quotient * denominator;
        return quotient;
    }

    private static final int floorDivide(long numerator, int denominator, int[] remainder) {
        if (numerator >= 0L) {
            remainder[0] = (int)(numerator % (long)denominator);
            return (int)(numerator / (long)denominator);
        }
        int quotient = (int)((numerator + 1L) / (long)denominator - 1L);
        remainder[0] = (int)(numerator - (long)(quotient * denominator));
        return quotient;
    }
}

