/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Choice;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.Layout;
import javax.microedition.lcdui.List;
import javax.microedition.lcdui.Screen;
import javax.microedition.lcdui.StringLayout;

public class ChoiceGroup
extends Item
implements Choice {
    private int choiceType;
    private int numOfEls;
    private int selectedIndex = -1;
    private int hilightedIndex = -1;
    private boolean[] selEls;
    private int height;
    private static final Image CKBX_OFF_IMG;
    private static final Image CKBX_ON_IMG;
    private static final int CKBX_WIDTH = 10;
    private static final Image RD_OFF_IMG;
    private static final Image RD_ON_IMG;
    private static final int RD_WIDTH = 11;

    public ChoiceGroup(String label, int choiceType) {
        this(label, choiceType, new String[0], null);
    }

    public ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements) {
        this(label, choiceType, stringElements, imageElements, false);
    }

    ChoiceGroup(String label, int choiceType, String[] stringElements, Image[] imageElements, boolean implicitAllowed) {
        super(label, stringElements.length + 1);
        if (imageElements != null && stringElements.length != imageElements.length) {
            throw new IllegalArgumentException();
        }
        if (!(choiceType == 2 || choiceType == 1 || choiceType == 3 && implicitAllowed)) {
            throw new IllegalArgumentException();
        }
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.choiceType = choiceType;
            this.numOfEls = stringElements.length;
            switch (choiceType) {
                case 2: {
                    this.selEls = new boolean[this.numOfEls];
                    int i = 0;
                    while (i < this.numOfEls) {
                        this.selEls[i] = false;
                        ++i;
                    }
                    break;
                }
                case 1: 
                case 3: {
                    if (this.numOfEls <= 0) break;
                    this.selectedIndex = 0;
                }
            }
            int i = 0;
            while (i < this.numOfEls) {
                Image img = imageElements == null ? null : imageElements[i];
                this.checkNull(stringElements[i], img);
                boolean offset = choiceType == 3 && img == null;
                this.layouts[i + 1] = new IaSLayout(stringElements[i], img, Screen.CONTENT_FONT, offset);
                ++i;
            }
        }
    }

    public int size() {
        return this.numOfEls;
    }

    public String getString(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            String string = ((IaSLayout)this.layouts[elementNum + 1]).getString();
            return string;
        }
    }

    public Image getImage(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            Image image = ((IaSLayout)this.layouts[elementNum + 1]).getImage();
            return image;
        }
    }

    public int append(String stringPart, Image imagePart) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkNull(stringPart, imagePart);
            int n = this.insertImpl(this.numOfEls, stringPart, imagePart);
            return n;
        }
    }

    public void insert(int elementNum, String stringElement, Image imageElement) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            if (elementNum < 0 || elementNum > this.numOfEls) {
                throw new IndexOutOfBoundsException();
            }
            this.checkNull(stringElement, imageElement);
            this.insertImpl(elementNum, stringElement, imageElement);
        }
    }

    public void delete(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            int deletedHeight = 0;
            if (this.initLayoutDone()) {
                deletedHeight = -this.layouts[elementNum + 1].getHeight();
                this.height += deletedHeight;
            }
            if (elementNum != this.numOfEls - 1) {
                System.arraycopy(this.layouts, elementNum + 2, this.layouts, elementNum + 1, this.numOfEls - elementNum - 1);
                if (this.choiceType == 2) {
                    System.arraycopy(this.selEls, elementNum + 1, this.selEls, elementNum, this.numOfEls - elementNum - 1);
                }
            }
            this.layouts[this.numOfEls] = null;
            if (this.choiceType == 2) {
                this.selEls[this.numOfEls - 1] = false;
            }
            --this.numOfEls;
            if (this.numOfEls == 0) {
                this.selectedIndex = -1;
                this.hilightedIndex = -1;
            } else {
                if (elementNum < this.hilightedIndex) {
                    --this.hilightedIndex;
                } else if (elementNum == this.hilightedIndex && this.hilightedIndex == this.numOfEls) {
                    this.hilightedIndex = this.numOfEls - 1;
                }
                if (this.choiceType != 2) {
                    if (elementNum < this.selectedIndex) {
                        --this.selectedIndex;
                    } else if (elementNum == this.selectedIndex && this.selectedIndex == this.numOfEls) {
                        this.selectedIndex = this.numOfEls - 1;
                    }
                }
            }
            int firstIndexY = this.layouts[0].getHeight();
            int hilightedIndexY = this.hilightedIndex == -1 ? 0 : this.getYpos(0, firstIndexY, this.hilightedIndex);
            Screen owner = this.getOwner();
            if (owner != null) {
                owner.contentChanged(null, 0, hilightedIndexY, deletedHeight);
            }
        }
    }

    public void set(int elementNum, String stringPart, Image imagePart) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            this.checkNull(stringPart, imagePart);
            this.setImpl(elementNum, stringPart, imagePart);
        }
    }

    public boolean isSelected(int elementNum) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            boolean bl = this.choiceType == 2 ? this.selEls[elementNum] : this.selectedIndex == elementNum;
            return bl;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public int getSelectedFlags(boolean[] selectedArray_return) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            int i;
            this.checkFlag(selectedArray_return);
            int selectedNum = 0;
            if (this.choiceType == 2) {
                System.arraycopy(this.selEls, 0, selectedArray_return, 0, this.numOfEls);
                i = 0;
                while (i < this.numOfEls) {
                    if (this.selEls[i]) {
                        ++selectedNum;
                    }
                    ++i;
                }
                int i2 = this.numOfEls;
                while (i2 < selectedArray_return.length) {
                    selectedArray_return[i2] = false;
                    ++i2;
                }
            } else {
                i = 0;
                while (i < selectedArray_return.length) {
                    selectedArray_return[i] = false;
                    ++i;
                }
                if (this.selectedIndex != -1) {
                    selectedArray_return[this.selectedIndex] = true;
                    selectedNum = 1;
                }
            }
            int n = selectedNum;
            return n;
        }
    }

    public void setSelectedIndex(int elementNum, boolean selected) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkIndex(elementNum);
            Screen owner = this.getOwner();
            switch (this.choiceType) {
                case 3: {
                    this.hilightedIndex = elementNum;
                }
                case 1: {
                    if (this.selectedIndex == elementNum && !selected) {
                        return;
                    }
                    int oldSelected = this.selectedIndex;
                    this.selectedIndex = elementNum;
                    if (owner == null || !owner.isShown()) break;
                    this.repaintElements(oldSelected, this.selectedIndex);
                    break;
                }
                case 2: {
                    this.selEls[elementNum] = selected;
                    if (owner == null || !owner.isShown()) break;
                    this.repaintElements(elementNum, -1);
                }
            }
        }
    }

    public void setSelectedFlags(boolean[] selectedArray) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            this.checkFlag(selectedArray);
            if (this.numOfEls == 0) {
                return;
            }
            if (this.choiceType == 2) {
                System.arraycopy(selectedArray, 0, this.selEls, 0, this.numOfEls);
                this.repaint(0, 0, Display.WIDTH, this.height);
            } else {
                int i = 0;
                while (i < this.numOfEls) {
                    if (selectedArray[i]) break;
                    ++i;
                }
                if (i == this.numOfEls) {
                    i = 0;
                }
                this.setSelectedIndex(i, true);
            }
        }
    }

    public void setLabel(String label) {
        Object object = Display.LCDUILock;
        synchronized (object) {
            super.setLabel(label);
            int deltaHeight = ((StringLayout)this.layouts[0]).setString(label);
            this.height += deltaHeight;
            this.contentChanged(0, 0, deltaHeight);
        }
    }

    void focusChanged() {
        this.repaintElements(this.hilightedIndex, -1);
    }

    int traverse(int dir, int top, int bottom, boolean traversingIn, boolean allowTraverseOut) {
        int hilBottom;
        boolean down;
        boolean bl = down = dir == 6;
        if (this.numOfEls == 0) {
            return Form.traverse(down, top, bottom, this.getHeight(), Screen.CONTENT_HEIGHT, traversingIn, false);
        }
        if (traversingIn) {
            int s = Form.traverse(down, top, bottom, this.getHeight(), Screen.CONTENT_HEIGHT, traversingIn, true);
            if (down) {
                if (bottom + s < this.layouts[1].getHeight()) {
                    return s;
                }
                this.hilightedIndex = 0;
            } else {
                this.hilightedIndex = this.numOfEls - 1;
            }
            if (s == 0) {
                this.repaintElements(this.hilightedIndex, -1);
            }
            return s;
        }
        int hilightedY = this.getYpos(0, this.layouts[0].getHeight(), this.hilightedIndex);
        int hilTop = top - hilightedY;
        int s = Form.traverse(down, hilTop, hilBottom = bottom - hilightedY, this.layouts[this.hilightedIndex + 1].getHeight(), this.layouts[this.hilightedIndex + 1].getLineHeight(), false, true);
        if (s < 0) {
            if (down && this.hilightedIndex == this.numOfEls - 1) {
                return s;
            }
            if (!down && this.hilightedIndex == 0) {
                return Form.traverse(down, top, bottom, this.getHeight(), Screen.CONTENT_HEIGHT, traversingIn, true);
            }
            int oldHilight = this.hilightedIndex--;
            if (down) {
                hilightedY += this.layouts[this.hilightedIndex + 1].getHeight();
                ++this.hilightedIndex;
            } else {
                hilightedY -= this.layouts[this.hilightedIndex + 1].getHeight();
            }
            hilTop = top - hilightedY;
            hilBottom = bottom - hilightedY;
            s = Form.traverse(down, hilTop, hilBottom, this.layouts[this.hilightedIndex + 1].getHeight(), this.layouts[this.hilightedIndex + 1].getLineHeight(), true, true);
            if (this.choiceType == 3) {
                this.selectedIndex = this.hilightedIndex;
            }
            if (this.hilightedIndex != -1 && top <= hilightedY && bottom >= hilightedY + this.layouts[this.hilightedIndex + 1].getHeight()) {
                this.repaintElements(oldHilight, this.hilightedIndex);
                return 0;
            }
        }
        return s;
    }

    boolean takesFocus() {
        return this.numOfEls > 0;
    }

    int initHilight(int vpY, int vpH) {
        if (this.numOfEls > 0) {
            this.hilightedIndex = 0;
            if (this.choiceType == 3) {
                this.selectedIndex = 0;
            }
        }
        return 0;
    }

    boolean select() {
        if (this.numOfEls == 0) {
            return false;
        }
        switch (this.choiceType) {
            case 3: {
                return this.getOwner() instanceof List;
            }
            case 1: {
                if (this.hilightedIndex == this.selectedIndex) {
                    return false;
                }
                this.setSelectedIndex(this.hilightedIndex, true);
                return this.getOwner() instanceof Form;
            }
            case 2: {
                this.setSelectedIndex(this.hilightedIndex, !this.selEls[this.hilightedIndex]);
                return this.getOwner() instanceof Form;
            }
        }
        return false;
    }

    void paint(Graphics g) {
        int translatedY = 0;
        int clipY1 = g.getClipY();
        int clipY2 = clipY1 + g.getClipHeight();
        if (translatedY < clipY2) {
            this.layouts[0].paint(g, true, false);
            int h = this.layouts[0].getHeight();
            g.translate(0, h);
            translatedY += h;
        }
        int imgWidth = 0;
        if (this.choiceType == 1) {
            imgWidth = 11;
        } else if (this.choiceType == 2) {
            imgWidth = 10;
        }
        boolean itemIsInFocus = this.getOwner() instanceof List ? true : this.hasFocus();
        int i = 0;
        while (i < this.numOfEls && translatedY < clipY2) {
            Layout layout = this.layouts[i + 1];
            int h = layout.getHeight();
            if (translatedY + h >= clipY1) {
                boolean inverted;
                boolean bl = inverted = i == this.hilightedIndex && itemIsInFocus;
                if (this.choiceType == 3) {
                    layout.paint(g, true, inverted);
                } else {
                    Image img = null;
                    img = this.choiceType == 1 ? (i == this.selectedIndex ? RD_ON_IMG : RD_OFF_IMG) : (this.selEls[i] ? CKBX_ON_IMG : CKBX_OFF_IMG);
                    g.setColor(Display.ERASE_COLOR);
                    g.fillRect(0, 0, imgWidth + 2, h);
                    g.drawImage(img, 1, (layout.getLineHeight() + 1) / 2, 6);
                    g.translate(imgWidth + 2, 0);
                    layout.paint(g, true, inverted);
                    g.translate(-imgWidth - 2, 0);
                }
            }
            g.translate(0, h);
            translatedY += h;
            ++i;
        }
        g.translate(0, -translatedY);
    }

    int getHeight() {
        return this.height;
    }

    int setWidth(int width) {
        if (width > 0) {
            this.height = this.layouts[0].setWidth(width);
            if (this.choiceType == 1) {
                width -= 13;
            } else if (this.choiceType == 2) {
                width -= 12;
            }
            int i = 0;
            while (i < this.numOfEls) {
                this.height += this.layouts[i + 1].setWidth(width);
                ++i;
            }
        }
        return this.height;
    }

    private void setImpl(int elementNum, String stringPart, Image imagePart) {
        boolean offset;
        boolean bl = offset = this.choiceType == 3 && imagePart == null;
        if (this.initLayoutDone()) {
            int deltaHeight = 0;
            if (this.layouts[elementNum + 1] != null) {
                deltaHeight = -this.layouts[elementNum + 1].getHeight();
            }
            this.layouts[elementNum + 1] = new IaSLayout(stringPart, imagePart, Screen.CONTENT_FONT, offset);
            int w = Display.WIDTH;
            if (this.choiceType == 1) {
                w -= 13;
            } else if (this.choiceType == 2) {
                w -= 12;
            }
            this.height += (deltaHeight += this.layouts[elementNum + 1].setWidth(w));
            this.contentChanged(0, this.getYpos(0, this.layouts[0].getHeight(), elementNum), deltaHeight);
        } else {
            this.layouts[elementNum + 1] = new IaSLayout(stringPart, imagePart, Screen.CONTENT_FONT, offset);
        }
    }

    private int insertImpl(int elementNum, String stringPart, Image imagePart) {
        if (this.numOfEls + 1 == this.layouts.length) {
            Layout[] newLayouts = new Layout[this.layouts.length + 4];
            System.arraycopy(this.layouts, 0, newLayouts, 0, elementNum + 1);
            System.arraycopy(this.layouts, elementNum + 1, newLayouts, elementNum + 2, this.numOfEls - elementNum);
            this.layouts = newLayouts;
        } else {
            System.arraycopy(this.layouts, elementNum + 1, this.layouts, elementNum + 2, this.numOfEls - elementNum);
        }
        if (this.choiceType == 2) {
            if (this.selEls.length == this.numOfEls) {
                boolean[] newSelEls = new boolean[this.numOfEls + 4];
                System.arraycopy(this.selEls, 0, newSelEls, 0, elementNum);
                System.arraycopy(this.selEls, elementNum, newSelEls, elementNum + 1, this.numOfEls - elementNum);
                this.selEls = newSelEls;
            } else {
                System.arraycopy(this.selEls, elementNum, this.selEls, elementNum + 1, this.numOfEls - elementNum);
            }
            this.selEls[elementNum] = false;
        }
        this.layouts[elementNum + 1] = null;
        ++this.numOfEls;
        if (this.choiceType != 2 && (elementNum < this.selectedIndex || this.selectedIndex == -1)) {
            ++this.selectedIndex;
        }
        if (elementNum < this.hilightedIndex || this.hilightedIndex == -1) {
            ++this.hilightedIndex;
        }
        this.setImpl(elementNum, stringPart, imagePart);
        return elementNum;
    }

    private void repaintElements(int first, int second) {
        int itemY;
        if (first == -1 && second == -1) {
            return;
        }
        if (first > second && second != -1 || first == -1) {
            int tmp = first;
            first = second;
            second = tmp;
        }
        int translatedY = this.layouts[0].getHeight();
        Screen owner = this.getOwner();
        int n = itemY = owner instanceof Form ? ((Form)owner).getItemY(this) : 0;
        if (first >= 0 && first < this.numOfEls) {
            translatedY = this.getYpos(0, translatedY, first);
            if (first + 1 == second) {
                owner.repaintContent(0, itemY + translatedY, Display.WIDTH, this.layouts[first + 1].getHeight() + this.layouts[second + 1].getHeight());
                return;
            }
            owner.repaintContent(0, itemY + translatedY, Display.WIDTH, this.layouts[first + 1].getHeight());
        }
        if (second >= 0 && second < this.numOfEls) {
            translatedY = this.getYpos(first, translatedY, second);
            owner.repaintContent(0, itemY + translatedY, Display.WIDTH, this.layouts[second + 1].getHeight());
        }
    }

    private int getYpos(int startIndex, int yPosOfStart, int elementNum) {
        int y = yPosOfStart < 0 ? 0 : yPosOfStart;
        int i = startIndex;
        while (i < elementNum) {
            y += this.layouts[i + 1].getHeight();
            ++i;
        }
        return y;
    }

    private void checkIndex(int elementNum) {
        if (elementNum < 0 || elementNum >= this.numOfEls) {
            throw new IndexOutOfBoundsException();
        }
    }

    private void checkNull(String stringPart, Image imagePart) {
        if (stringPart == null) {
            throw new NullPointerException();
        }
        if (imagePart != null && imagePart.isMutable()) {
            throw new IllegalArgumentException();
        }
    }

    private void checkFlag(boolean[] flag) {
        if (flag == null) {
            throw new NullPointerException();
        }
        if (flag.length < this.numOfEls) {
            throw new IllegalArgumentException();
        }
    }

    static {
        byte[] ckbx_off = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 10, 0, 0, 0, 11, 2, 3, 0, 0, 0, 59, 0, -12, -117, 0, 0, 0, 6, 80, 76, 84, 69, -1, -1, -1, -69, -69, -69, -57, 75, -33, -8, 0, 0, 0, 30, 73, 68, 65, 84, 120, -38, 99, 96, 96, 96, 96, 12, 101, -8, -51, -32, -64, 32, -64, -60, -64, -64, -128, 11, 51, -122, 50, -4, 6, 0, 63, 116, 3, 1, 53, -108, 39, -26, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        byte[] ckbx_on = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 10, 0, 0, 0, 11, 2, 3, 0, 0, 0, 59, 0, -12, -117, 0, 0, 0, 12, 80, 76, 84, 69, -1, -1, -1, -69, -69, -69, 106, 106, 106, 2, 2, 2, 106, -103, 14, -47, 0, 0, 0, 53, 73, 68, 65, 84, 120, -38, 99, 96, 96, 124, -64, -16, -1, -77, 3, -45, 65, -111, 15, 76, 12, 108, 12, 76, 12, -4, 12, 76, 12, 18, 12, 76, -68, 127, 24, -104, 126, 45, 96, 96, -7, -11, -109, -127, -23, -65, 3, 3, -29, 127, -122, -113, 0, 5, 37, 12, -34, 1, -99, -83, 100, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        byte[] rad_off = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 11, 0, 0, 0, 11, 2, 3, 0, 0, 0, -44, -62, -97, -75, 0, 0, 0, 9, 80, 76, 84, 69, -1, -1, -1, -69, -69, -69, 106, 106, 106, -44, 13, -1, -24, 0, 0, 0, 42, 73, 68, 65, 84, 120, -38, 99, 96, 90, -59, -64, 32, -63, 48, -127, 65, -127, 65, -127, 41, -127, -31, 5, 19, 3, 3, 3, 50, 102, 80, 96, 80, 96, -6, -63, 80, -64, -64, -76, -118, 1, 0, 113, 24, 5, 61, 73, -68, -100, 98, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        byte[] rad_on = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10, 0, 0, 0, 13, 73, 72, 68, 82, 0, 0, 0, 11, 0, 0, 0, 11, 2, 3, 0, 0, 0, -44, -62, -97, -75, 0, 0, 0, 12, 80, 76, 84, 69, -1, -1, -1, -69, -69, -69, 106, 106, 106, 2, 2, 2, 106, -103, 14, -47, 0, 0, 0, 50, 73, 68, 65, 84, 120, -38, 5, -63, 65, 13, 0, 32, 12, 4, -63, -19, -11, -117, 1, 18, 68, -100, 10, 52, 19, 94, 72, 64, 17, 101, -122, 44, -44, -29, 98, -52, 89, 77, -102, 40, 2, 85, -95, -73, -63, -104, -63, 37, -117, 15, -40, 119, 10, 41, 78, 26, -79, 59, 0, 0, 0, 0, 73, 69, 78, 68, -82, 66, 96, -126};
        CKBX_OFF_IMG = Image.createImage(ckbx_off, 0, ckbx_off.length);
        CKBX_ON_IMG = Image.createImage(ckbx_on, 0, ckbx_on.length);
        RD_OFF_IMG = Image.createImage(rad_off, 0, rad_off.length);
        RD_ON_IMG = Image.createImage(rad_on, 0, rad_on.length);
    }

    class IaSLayout
    extends StringLayout {
        private Image img;
        private int imgHeight;
        private int imgWidth;
        private int layoutedHeight;
        private int layoutedWidth;

        IaSLayout(String str, Image img, Font font, boolean offset) {
            super(str, font);
            this.img = img;
            if (img != null) {
                this.imgHeight = img.getHeight();
                this.imgWidth = img.getWidth() + 2;
            }
            this.setOffset(offset);
        }

        Image getImage() {
            return this.img;
        }

        public int getWidth() {
            return this.layoutedWidth;
        }

        public int setWidth(int w) {
            if (this.layoutedWidth == w || w < 0) {
                return this.layoutedHeight;
            }
            this.layoutedWidth = w;
            if (this.imgWidth > w / 2) {
                this.layoutedHeight = super.setWidth(w - this.offsetWidth) + this.imgHeight;
            } else {
                int superHeight = super.setWidth(w - this.imgWidth);
                this.layoutedHeight = this.imgHeight;
                if (superHeight > this.layoutedHeight) {
                    this.layoutedHeight = superHeight;
                }
            }
            return this.layoutedHeight;
        }

        public int getHeight() {
            return this.layoutedHeight;
        }

        public void paint(Graphics g, boolean eraseBgrnd, boolean inverted) {
            if (eraseBgrnd) {
                g.setColor(inverted ? 0 : Display.ERASE_COLOR);
                g.fillRect(0, 0, this.layoutedWidth, this.layoutedHeight);
            }
            if (this.img != null) {
                if (this.imgWidth < Display.WIDTH / 2 && this.layoutedHeight <= this.lineHeight) {
                    g.drawImage(this.img, 0, this.lineHeight / 2, 6);
                } else {
                    g.drawImage(this.img, 0, 0, 20);
                }
            }
            int tx = 0;
            int ty = 0;
            if (this.imgWidth > Display.WIDTH / 2) {
                ty = this.imgHeight;
                tx = this.offsetWidth;
            } else {
                tx = this.imgWidth;
            }
            g.translate(tx, ty);
            super.paint(g, false, inverted);
            g.translate(-tx, -ty);
        }
    }
}

