/*
 * Decompiled with CFR 0.152.
 */
package javax.microedition.lcdui;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Policy;

class PassTextPolicy
extends Policy {
    private char[] echoCharLine;
    private int numEchoCharsPerLine;
    private int numLines;
    private static final char ECHO_CHAR = '*';
    private int echoCharWidth;
    private int extraSpace;

    PassTextPolicy(Font f) {
        this(f, 'W');
    }

    PassTextPolicy(Font f, char extraSpaceChar) {
        super(f);
        this.echoCharWidth = f.charWidth('*');
        this.extraSpace = f.charWidth(extraSpaceChar) - this.echoCharWidth;
        if (this.extraSpace < 0) {
            this.extraSpace = 0;
        }
    }

    int setWidth(int width, char[] buf, int numChars, int curPos) {
        this.numEchoCharsPerLine = (width - this.extraSpace) / this.echoCharWidth;
        this.echoCharLine = new char[this.numEchoCharsPerLine];
        int i = 0;
        while (i < this.numEchoCharsPerLine) {
            this.echoCharLine[i] = 42;
            ++i;
        }
        return super.setWidth(width, buf, numChars, curPos);
    }

    int contentChanged(char[] buf, int numChars, int fromPos, int curPos) {
        if (this.width == -1) {
            return 0;
        }
        int oldHeight = this.height;
        this.numLines = (numChars + this.numEchoCharsPerLine - 1) / this.numEchoCharsPerLine;
        this.height = this.numLines * this.lineHeight;
        if (this.height < this.lineHeight) {
            this.height = this.lineHeight;
        }
        this.cursorX = curPos % this.numEchoCharsPerLine * this.echoCharWidth;
        this.cursorY = curPos / this.numEchoCharsPerLine * this.lineHeight;
        if (curPos == numChars && this.cursorX == 0 && this.cursorY > 0) {
            this.cursorX = this.numEchoCharsPerLine * this.echoCharWidth;
            this.cursorY -= this.lineHeight;
        }
        return this.height - oldHeight;
    }

    void paint(Graphics g, char[] buf, int numChars, boolean cursorEnabled, int cursorPos, boolean noCharShow) {
        g.setColor(0);
        g.setFont(this.f);
        if (numChars > 0) {
            boolean echoCharSecWidth = false;
            int y = g.getClipY();
            int yEnd = y + g.getClipHeight();
            int from = 0;
            if (y > 0) {
                from = y / this.lineHeight;
            }
            y = from * this.lineHeight;
            int i = from;
            while (i < this.numLines - 1 && y < yEnd) {
                g.drawChars(this.echoCharLine, 0, this.numEchoCharsPerLine, 0, y, 20);
                ++i;
                y += this.lineHeight;
            }
            int n = numChars % this.numEchoCharsPerLine;
            if (n == 0) {
                n = this.numEchoCharsPerLine;
            }
            if (cursorEnabled || noCharShow) {
                g.drawChars(this.echoCharLine, 0, n, 0, y, 20);
            } else {
                if (n > 1) {
                    g.drawChars(this.echoCharLine, 0, n - 1, 0, y, 20);
                }
                if (this.cursorX > this.echoCharWidth) {
                    g.drawChar(buf[numChars - 1], this.cursorX - this.echoCharWidth, y, 20);
                } else {
                    g.drawChar(buf[numChars - 1], 0, y, 20);
                }
            }
        }
        if (cursorEnabled) {
            g.drawLine(this.cursorX, this.cursorY, this.cursorX, this.cursorY + this.lineHeight);
        }
    }

    int getMaxWidth(int allowedWidth, int maxSize) {
        int w = this.echoCharWidth * maxSize + this.extraSpace;
        if (w < allowedWidth) {
            return w;
        }
        return allowedWidth;
    }
}

