# This is statement is required by the build system to query build info
if __name__ == '__build__':
	raise Exception

import string
__build__ = 44
__version__ = '2.0.0.%d' % __build__
__date__ = string.join(string.split('$Date: 2001/08/27 02:08:41 $')[1:3], ' ')
__author__ = 'Tarn Weisner Burton <twburton@users.sourceforge.net>\nMike C. Fletcher <mcfletch@users.sourceforge.net>'
__doc__ = '''This is PyOpenGL 2.  For information regarding PyOpenGL see:
    http://pyopengl.sourceforge.net

For information on OpenGL see:
    http://www.opengl.org'''
del string
from GL import __numeric_present__, __numeric_support__


def _boolean(x):
	if x:
		return 'Yes'
	return 'No'


def __info():
	import sys
	
	info = []

	info.append(('Platform', sys.platform))
	info.append(('Python Version', sys.version))
	info.append(('Numeric support', _boolean(__numeric_support__)))
	info.append(('Numeric connected', _boolean(__numeric_present__)))

	try:
		import numeric_version
		info.append(('Numeric Version', numeric_version.version))
	except ImportError:
		info.append(('Numeric Version', 'None'))
		pass

	try:
		import Image
		info.append(('PIL Version', Image.VERSION))
	except ImportError:
		info.append(('PIL Version', 'None'))

	try:
		import wxPython
		info.append(('wxPython Version', wxPython.__version__))
	except ImportError:
		info.append(('wxPython Version', 'None'))

	try:
		import pygame
		info.append(('pygame Version', pygame.ver))
	except ImportError:
		info.append(('pygame Version', 'None'))

	try:
		import FXPy
		info.append(('FXPy available', 'Yes'))
	except ImportError:
		info.append(('FXPy available', 'No'))

	return info
		
		