#!/usr/bin/env python

## created 2000/08/01, Rene Liebscher <R.Liebscher@gmx.de>

import distutils, re, sys, string, os

# get the Distutils version, we need at least 1.0.2pre
versions = re.findall(r'(\d+)[.](\d+)(?:[.](\d+))?', distutils.__version__)
version = 0
if len(versions):
	version = 0x10000*int(versions[0][0]) + 0x100*int(versions[0][1])
	if versions[0][2] != '':
		version = version + int(versions[0][2])

if version < 0x010002:
	print 'PyOpenGL setup requires at least version 1.0.2pre of Distutils.'
	print 'Please get the latest version at:'
	print 'http://www.python.org/sigs/distutils-sig/download.html'
	sys.exit(1)

# Add the current directory to the PATH, needed since build_py has to
# execute shadow selectors.
if os.environ.has_key('PATH'):
	path = string.split(os.environ['PATH'], os.pathsep)
else:
	path = []

if os.curdir not in path:
	path.append(os.curdir)
	os.environ['PATH'] = string.join(path, os.pathsep)

from distutils.sysconfig import *
from distutils.core import setup
from distutils.command.build_ext import build_ext
from distutils.command.install import install

from setup.build import build
from setup.util import *
from setup.my_install_data import *
from setup.build_w import build_w
from setup.build_py import build_py
from setup.build_doc import build_doc
from setup.dist import Distribution

#######################################################################
## platform specific stuff
## see config/<platform>.cfg for any configurable options


#######################################################################
## test if we need to build togl

try:
	from setup import togl_setup
	class togl_build(build_ext):
		def run(self):
			build_ext.run(self)
			# togl_build can read instance variables of build_ext
			# for example: compiler, built_temp, force, debug, dry_run, ...
			if self.distribution.BUILD_TOGL:
				togl_setup.togl_build(self, self.distribution.include_dirs, self.distribution.library_dirs, self.distribution.togl_libs)
	class togl_install(install):
		togl_outfiles = None
		def run(self):
			install.run(self)
			# togl_install can read instance variables of install_lib
			# it has to return the filenames of all installed files
			if self.distribution.BUILD_TOGL:
				self.togl_outfiles = togl_setup.togl_install(self) 
		def get_outputs(self):
			if self.togl_outfiles is None:
				self.togl_outfiles = togl_setup.togl_install(self,dry_run=1)
			return install.get_outputs(self) + self.togl_outfiles              
except ImportError:
	# either Tkinter or togl_setup doesn't exist 
	# use original classes
	togl_build = build_ext
	togl_install = install            


setup (name = 'PyOpenGL',
	   version = get_version(),
	   description = 'OpenGL bindings for Python',
	   long_description = 'OpenGL bindings for Python including support for GL extensions, GLU, WGL, GLUT, GLE, and Tk',
	   author = 'PyOpenGL SourceForge group',
	   author_email = 'pyopengl@yahoogroups.com',
	   url = 'http://pyopengl.sourceforge.net',
	   include_dirs = ['src/gle/src'],
	   licence = 'BSD type',
	   ext_package = 'OpenGL',
        options = {'sdist':{'use_defaults':0, 'force_manifest':1},
					'bdist_rpm':{'group':'Development/Languages/Python'}},
        distclass = Distribution,
	   # Overridden command classes
	   cmdclass = {'build':build,
				   'build_w':build_w,
				   'build_doc':build_doc,
#				   'build_clib':build_clib,
				   'build_py':build_py,
				   'build_ext':togl_build,
				   'install':togl_install,
				   # the next line is very important
				   # because we use another format for data_files
				   'install_data': my_install_data},
	   data_files = [Data_Files(
			   base_dir='install_lib',
			   copy_to = 'OpenGL',
			   strip_dirs = 1,
			   template=[
				   # take the whole tree
				   'graft OpenGL',
				   'global-exclude *.py',
				   'global-exclude Cvs/*',
				   'global-exclude CVS/*',
				   ],
			   preserve_path=1
		   )],
	   libraries = [('interface_util', {'sources':['src/interface_util/interface_util.c','src/interface_util/platform.c']}),#, 'include_dirs':[get_python_inc()] + include_dirs, 'macros':define_macros}),
					('GLE', {'sources':['src/gle/src/rot_prince.c',
										'src/gle/src/ex_cut_round.c',
										'src/gle/src/ex_raw.c',
										'src/gle/src/extrude.c',
										'src/gle/src/intersect.c',
										'src/gle/src/qmesh.c',
										'src/gle/src/ex_angle.c',
										'src/gle/src/rotate.c',
										'src/gle/src/round_cap.c',
										'src/gle/src/segment.c',
										'src/gle/src/texgen.c',
										'src/gle/src/urotate.c',
										'src/gle/src/view.c']})])


