#include "../config.h"

const char* GetPlatformExtensionsString()
{
	const char *extensions = NULL;
#ifdef WGL_PLATFORM
	typedef const char* (*T_wglGetExtensionsStringEXT)();
	T_wglGetExtensionsStringEXT wglGetExtensionsStringEXT = (T_wglGetExtensionsStringEXT)wglGetProcAddress("wglGetExtensionsStringEXT");
	SetLastError(0);
	if (wglGetExtensionsStringEXT)
	{
		extensions = (char*)wglGetExtensionsStringEXT();
	}
	else
	{
		typedef const char* (*T_wglGetExtensionsStringARB)(HDC dc);
		T_wglGetExtensionsStringARB wglGetExtensionsStringARB = (T_wglGetExtensionsStringARB)wglGetProcAddress("wglGetExtensionsStringARB");
		SetLastError(0);
		if (wglGetExtensionsStringARB)
		{
			extensions = (char*)wglGetExtensionsStringARB(wglGetCurrentDC());
		}
	}
#endif
	return extensions;
}


void* GetExtProc(const char* name)
{
	void *proc = NULL;
#ifdef WGL_PLATFORM
	proc = wglGetProcAddress(name);
	SetLastError(0);
#elif defined(GLX_PLATFORM) && defined(GLX_ARB_get_proc_address)
	proc = glXGetProcAddressARB(name);
#endif
	return proc;
}
