'''OpenGL extension NV.point_sprite

Overview (from the spec)
	
	Applications such as particle systems usually must use OpenGL quads
	rather than points to render their geometry, since they would like to
	use a custom-drawn texture for each particle, rather than the
	traditional OpenGL round antialiased points, and each fragment in
	a point has the same texture coordinates as every other fragment.
	
	Unfortunately, specifying the geometry for these quads can be quite
	expensive, since it quadruples the amount of geometry required, and
	it may also require the application to do extra processing to compute
	the location of each vertex.
	
	The goal of this extension is to allow such apps to use points rather
	than quads.  When GL_POINT_SPRITE_NV is enabled, the state of point
	antialiasing is ignored.  For each texture unit, the app can then
	specify whether to replace the existing texture coordinates with
	point sprite texture coordinates, which are interpolated across the
	point.  Finally, the app can set a global parameter for the way to
	generate the R coordinate for point sprites; the R coordinate can
	either be zero, the input S coordinate, or the input R coordinate.
	This allows applications to use a 3D texture to represent a point
	sprite that goes through an animation, with filtering between frames,
	for example.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/NV/point_sprite.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_POINT_SPRITE_NV = constant.Constant( 'GL_POINT_SPRITE_NV', 0x8861 )
glget.addGLGetConstant( GL_POINT_SPRITE_NV, (1,) )
GL_COORD_REPLACE_NV = constant.Constant( 'GL_COORD_REPLACE_NV', 0x8862 )
GL_POINT_SPRITE_R_MODE_NV = constant.Constant( 'GL_POINT_SPRITE_R_MODE_NV', 0x8863 )
glget.addGLGetConstant( GL_POINT_SPRITE_R_MODE_NV, (1,) )
glPointParameteriNV = platform.createExtensionFunction( 
	'glPointParameteriNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, constants.GLint,),
	doc = 'glPointParameteriNV( GLenum(pname), GLint(param) ) -> None',
	argNames = ('pname', 'param',),
)

glPointParameterivNV = platform.createExtensionFunction( 
	'glPointParameterivNV', dll=platform.GL,
	resultType=None, 
	argTypes=(constants.GLenum, arrays.GLintArray,),
	doc = 'glPointParameterivNV( GLenum(pname), GLintArray(params) ) -> None',
	argNames = ('pname', 'params',),
)


def glInitPointSpriteNV():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_NV_point_sprite' )
