'''OpenGL extension SUN.global_alpha

Overview (from the spec)
	
	Transparency is done in OpenGL using alpha blending. An alpha value
	of 0.0 is used for fully transparent objects, while an alpha value
	of 1.0 is used for fully opaque objects.  A value of 0.25 is 75%
	transparent, and so on.
	
	OpenGL defines alpha as a component of the vertex color state.
	Whenever a color is set, the alpha component is set along with the
	red, green, and blue components.  This means that transparency
	can't be changed for primitives with per-vertex colors without
	modifying the color of each vertex, replacing the old alpha
	component with the new alpha component.  This can be very expensive
	for objects that are drawn using vertex arrays; it all but
	precludes the use of display lists.
	
	This extension defines a new global alpha attribute that can be
	used to specify an alpha factor that is independent from the alpha
	component of the color value.  The global alpha factor is
	multiplied by the fragment's alpha value after primitive
	rasterization and prior to texture mapping, replacing the
	fragment's alpha value.  The global alpha extension is only
	specified in RGBA mode and must be applied prior to any texture
	mapping operation.  It is enabled by a new GLOBAL_ALPHA flag.
	

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/SUN/global_alpha.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SUN_global_alpha'
GL_GLOBAL_ALPHA_SUN = constant.Constant( 'GL_GLOBAL_ALPHA_SUN', 0x81D9 )
GL_GLOBAL_ALPHA_FACTOR_SUN = constant.Constant( 'GL_GLOBAL_ALPHA_FACTOR_SUN', 0x81DA )
glget.addGLGetConstant( GL_GLOBAL_ALPHA_FACTOR_SUN, (1,) )
glGlobalAlphaFactorbSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactorbSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLbyte,),
	doc = 'glGlobalAlphaFactorbSUN( GLbyte(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactorsSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactorsSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLshort,),
	doc = 'glGlobalAlphaFactorsSUN( GLshort(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactoriSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactoriSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLint,),
	doc = 'glGlobalAlphaFactoriSUN( GLint(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactorfSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactorfSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLfloat,),
	doc = 'glGlobalAlphaFactorfSUN( GLfloat(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactordSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactordSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLdouble,),
	doc = 'glGlobalAlphaFactordSUN( GLdouble(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactorubSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactorubSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLubyte,),
	doc = 'glGlobalAlphaFactorubSUN( GLubyte(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactorusSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactorusSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLushort,),
	doc = 'glGlobalAlphaFactorusSUN( GLushort(factor) ) -> None',
	argNames = ('factor',),
)

glGlobalAlphaFactoruiSUN = platform.createExtensionFunction( 
	'glGlobalAlphaFactoruiSUN', dll=platform.GL,
	extension=EXTENSION_NAME,
	resultType=None, 
	argTypes=(constants.GLuint,),
	doc = 'glGlobalAlphaFactoruiSUN( GLuint(factor) ) -> None',
	argNames = ('factor',),
)


def glInitGlobalAlphaSUN():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( EXTENSION_NAME )
