'''OpenGL extension EXT.framebuffer_blit

Overview (from the spec)
	
	This extension modifies EXT_framebuffer_object by splitting the
	framebuffer object binding point into separate DRAW and READ
	bindings.  This allows copying directly from one framebuffer to
	another.  In addition, a new high performance blit function is
	added to facilitate these blits and perform some data conversion
	where allowed.

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/EXT/framebuffer_blit.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_EXT_framebuffer_blit'
_DEPRECATED = False
GL_READ_FRAMEBUFFER_EXT = constant.Constant( 'GL_READ_FRAMEBUFFER_EXT', 0x8CA8 )
GL_DRAW_FRAMEBUFFER_EXT = constant.Constant( 'GL_DRAW_FRAMEBUFFER_EXT', 0x8CA9 )
GL_READ_FRAMEBUFFER_BINDING_EXT = constant.Constant( 'GL_READ_FRAMEBUFFER_BINDING_EXT', 0x8CAA )
glBlitFramebufferEXT = platform.createExtensionFunction( 
'glBlitFramebufferEXT',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,constants.GLint,constants.GLint,constants.GLint,constants.GLint,constants.GLint,constants.GLint,constants.GLint,constants.GLbitfield,constants.GLenum,),
doc='glBlitFramebufferEXT(GLint(srcX0), GLint(srcY0), GLint(srcX1), GLint(srcY1), GLint(dstX0), GLint(dstY0), GLint(dstX1), GLint(dstY1), GLbitfield(mask), GLenum(filter)) -> None',
argNames=('srcX0','srcY0','srcX1','srcY1','dstX0','dstY0','dstX1','dstY1','mask','filter',),
deprecated=_DEPRECATED,
)


def glInitFramebufferBlitEXT():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
