'''OpenGL extension SGIX.framezoom

Overview (from the spec)
	
	This extension provides a additional way to rasterize geometric
	primitives and pixel rectangles.  The techique is to reduce the
	number of pixels rasterized  and (possibly) the number of depth and
	stencil operations performed per primitive.  Each pixel is zoomed
	up and used to render an N x N block of screen pixels.  The
	implementation is free to choose the number of stencil and z pixels
	that will correspond to each N x N block.
	
	This extension provides an opportunity to the implementation to
	perform expensive raster operations at a reduced resolution,
	increasing performance.  Such operations may include
	texture-mapping, depth & stencil tests, etc.  The hardware should
	be allowed to perform operations that it accelerates at full
	hardware speed.
	
	The visual result will be the same as if a scene were rendered into
	a small window, and then that buffer was copied and zoomed up into
	a large window.
	
	All OpenGL parameters that effect rasterization size will implicitly
	be multipled by N (this includes point size, line width, etc).

The official definition of this extension is available here:
http://oss.sgi.com/projects/ogl-sample/registry/SGIX/framezoom.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
EXTENSION_NAME = 'GL_SGIX_framezoom'
_DEPRECATED = False
GL_FRAMEZOOM_SGIX = constant.Constant( 'GL_FRAMEZOOM_SGIX', 0x818B )
GL_FRAMEZOOM_FACTOR_SGIX = constant.Constant( 'GL_FRAMEZOOM_FACTOR_SGIX', 0x818C )
GL_MAX_FRAMEZOOM_FACTOR_SGIX = constant.Constant( 'GL_MAX_FRAMEZOOM_FACTOR_SGIX', 0x818D )
glFrameZoomSGIX = platform.createExtensionFunction( 
'glFrameZoomSGIX',dll=platform.GL,
extension=EXTENSION_NAME,
resultType=None, 
argTypes=(constants.GLint,),
doc='glFrameZoomSGIX(GLint(factor)) -> None',
argNames=('factor',),
deprecated=_DEPRECATED,
)


def glInitFramezoomSGIX():
    '''Return boolean indicating whether this extension is available'''
    return extensions.hasGLExtension( EXTENSION_NAME )
