/*
	SDL - Simple DirectMedia Layer
	Copyright (C) 1997, 1998, 1999  Sam Lantinga

	This library is free software; you can redistribute it and/or
	modify it under the terms of the GNU Library General Public
	License as published by the Free Software Foundation; either
	version 2 of the License, or (at your option) any later version.

	This library is distributed in the hope that it will be useful,
	but WITHOUT ANY WARRANTY; without even the implied warranty of
	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
	Library General Public License for more details.

	You should have received a copy of the GNU Library General Public
	License along with this library; if not, write to the Free
	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA

	Sam Lantinga
	slouken@devolution.com
*/

#ifdef SAVE_RCSID
static char rcsid =
 "@(#) $Id: SDL_timer.c,v 1.4 2000/02/07 21:45:09 hercules Exp $";
#endif

#include <Types.h>
#include <Timer.h>
#include <OSUtils.h>
#include <Gestalt.h>
#include <Processes.h>

#include <LowMem.h>

#include "SDL_timer.h"

#define ROUND_RESOLUTION(X)	\
	(((X+TIMER_RESOLUTION-1)/TIMER_RESOLUTION)*TIMER_RESOLUTION)
#define MS_PER_TICK	(1000/60)		/* MacOS tick = 1/60 second */

void SDL_StartTicks(void)
{
	/* FIXME: Should we implement a wrapping algorithm, like Win32? */
}

Uint32 SDL_GetTicks(void)
{
	return(LMGetTicks()*MS_PER_TICK);
}

void SDL_Delay(Uint32 ms)
{
	UInt32		unused; /* MJS */
	Delay(ms/MS_PER_TICK, &unused);
}


/* Define an extended task record. */
typedef struct _ExtendedTimerRec
{
	TMTask		     tmTask;
	ProcessSerialNumber  taskPSN;
	SDL_TimerCallback callback;
	Uint32 period;
} ExtendedTimerRec, *ExtendedTimerPtr;

/* Define the interface for a callback function. */
pascal void TimerCallbackProc(TMTaskPtr tmTaskPtr);

static ExtendedTimerRec gExtendedTimerRec;

int SDL_SetTimer(Uint32 ms, SDL_TimerCallback callback)
{
	if(!ms)
	{
		RmvTime((QElemPtr) &gExtendedTimerRec.tmTask);
		return(0);
	}

	/*
	 * Configure the global structure that stores the timing information.
	 */
	gExtendedTimerRec.tmTask.qLink = NULL;
	gExtendedTimerRec.tmTask.qType = 0;
	gExtendedTimerRec.tmTask.tmAddr = NewTimerProc(TimerCallbackProc);
	gExtendedTimerRec.tmTask.tmCount = 0;
	gExtendedTimerRec.tmTask.tmWakeUp = 0;
	gExtendedTimerRec.tmTask.tmReserved = 0;
	GetCurrentProcess(&gExtendedTimerRec.taskPSN);

	/* So we can call (and re-call) the user func */
	gExtendedTimerRec.callback = callback;
	gExtendedTimerRec.period = ROUND_RESOLUTION(ms);

	/* Install the task record */
	InsXTime((QElemPtr) &gExtendedTimerRec.tmTask);

	/* Go! */
	PrimeTime((QElemPtr) &gExtendedTimerRec.tmTask,
	                      gExtendedTimerRec.period);
	return(0);
}

int SDL_TimerInit(void)
{
	/* We don't need a setup? */
	return(0);
}

void SDL_TimerQuit(void)
{
	/* remove the task from the time manager */
	SDL_SetTimer(0, NULL);
}

/* Our Stub routine to set up and then call the real routine. */
pascal void TimerCallbackProc(TMTaskPtr tmTaskPtr)
{
	Uint32 ms;

	WakeUpProcess(&((ExtendedTimerPtr) tmTaskPtr)->taskPSN);

	ms = gExtendedTimerRec.callback(gExtendedTimerRec.period);
	if ( ms ) {
		gExtendedTimerRec.period = ROUND_RESOLUTION(ms);
		PrimeTime((QElemPtr) &gExtendedTimerRec.tmTask,
		                      gExtendedTimerRec.period);
	}
}
