#!/bin/sh

RESSOURCE_PATH=/usr/local/share/SDLcam
BINARY_PATH=/usr/local/bin
FILTER_PATH=/usr/local/lib/SDLcam

mkdir -p $RESSOURCE_PATH
mkdir -p $BINARY_PATH
mkdir -p $FILTER_PATH/filters
mkdir -p $FILTER_PATH/capture

rm -rf $FILTER_PATH/filters/*
rm -rf $FILTER_PATH/capture/*

cp SDLcam $BINARY_PATH
cp LucidaSansRegular.ttf LucidaTypewriterRegular.ttf $RESSOURCE_PATH
cp -f filter/*.so $FILTER_PATH/filters
cp -f capture/*.so $FILTER_PATH/capture
cp -f SDLcam.xml $RESSOURCE_PATH

echo "--------------------------------------------------"
echo "SDLcam has been installed in /usr/local/bin"
echo "filters and input plugins are in /usr/local/lib/SDLcam"
echo "Its ressources files are in /usr/local/share/SDLcam"
echo ""
echo "Please note that you can edit the SDLcam.cfg file and copy it"
echo "in /usr/local/share/SDLcam for global use."
