// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef EasyParser_INCLUDED
#define EasyParser_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "CodingSystem.H"
#include "SgmlParser.H"
#include "UnivCharsetDesc.H"
#include "GrowableVector.H"
#include "ParserOptions.H"
#include "MessageReporter.H"
#include "Boolean.H"

class PosixStorageManager;
class PosixFdStorageManager;
class Portable;

class EasyParser : public MessageReporter {
public:
  EasyParser(const char *codingName = 0);
  virtual ~EasyParser();
  void setCodingSystem(const CodingSystem *);
  void init(int nFiles, char *const *files,
	    Boolean allLinksActivated = 0);
  void addCatalogSysid(const char *);
  void addInclude(const char *); // parameter entity to be defined as INCLUDE
  ParserOptions options;
  SgmlParser &parser();
  const char *messageText(const char *source, int number);
  const CodingSystem *codingSystem() const;
  Portable &portable();
  void activateLinkType(const char *);
private:
  EasyParser(const EasyParser &); // undefined
  void operator=(const EasyParser &); // undefined

  PosixStorageManager *storageManager_;
  PosixFdStorageManager *fdStorageManager_;
  Portable *portable_;
  SgmlParser *parser_;
  const CodingSystem *codingSystem_;
  UnivCharsetDesc systemCharset_;
  GrowableVector<const char *> catalogSysids_;
  GrowableVector<const char *> includes_;
  GrowableVector<const char *> activeLinkTypes_;
  IosOutputCharStream errorStream_;
};

inline
SgmlParser &EasyParser::parser()
{
  return *parser_;
}

inline
const CodingSystem *EasyParser::codingSystem() const
{
  return codingSystem_;
}

inline
Portable &EasyParser::portable()
{
  return *portable_;
}

#endif /* not EasyParser_INCLUDED */
