// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "MessageEventHandler.H"
#include "SgmlParser.H"
#ifdef __GNUG__
#include "Entity.H"
#endif

MessageEventHandler::MessageEventHandler(const SgmlParser *parser,
					 MessageReporter *reporter,
					 unsigned flags)
: parser_(parser), reporter_(reporter), errorCount_(0), flags_(flags)
{
}

void MessageEventHandler::subdocEntity(SubdocEntityEvent *event)
{
  const SubdocEntity *entity = event->entity();
  if (!entity)
    return;
  if (flags_ & parseSubdocs) {
    SgmlParser parser(*parser_, *entity, event->entityOrigin());
    const SgmlParser *oldParser = parser_;
    parser_ = &parser;
    parser.parseAll(*this);
    parser_ = oldParser;
  }
}

void MessageEventHandler::message(MessageEvent *message)
{
  if (message->isError())
    errorCount_++;
  reporter_->reportMessage(*message);
  delete message;
}
