// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef MessageEventHandler_INCLUDED
#define MessageEventHandler_INCLUDED 1

#include "Event.H"
#include "MessageReporter.H"


class OutputCharStream;
class SgmlParser;

class MessageEventHandler : public EventHandler {
public:
  enum { parseSubdocs = 01 };
  MessageEventHandler(const SgmlParser *parser, MessageReporter *reporter,
		      unsigned flags = 0);
  void message(MessageEvent *);
  unsigned errorCount() const;
  void subdocEntity(SubdocEntityEvent *);
private:
  const SgmlParser *parser_;
  MessageReporter *reporter_;
  unsigned errorCount_;
  unsigned flags_;
};

inline
unsigned MessageEventHandler::errorCount() const
{
  return errorCount_;
}

#endif /* not MessageEventHandler_INCLUDED */
