// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef MessageReporter_INCLUDED
#define MessageReporter_INCLUDED 1

#include "types.H"
#include "MessageBuilder.H"
#include "Boolean.H"
#include "OutputCharStream.H"
#include "InputContext.H"
#include "Location.H"

class MessageEvent;

class MessageReporter : private MessageBuilder, public InputContext {
public:
  enum Option {
    openElements = 01,
    openEntities = 02
    };
  MessageReporter(OutputCharStream *);
  void reportMessage(const MessageEvent &);
  void inputContextMessage(const char *source,
			   const Location &,
			   unsigned flags, int number,
			   const MessageArg **args,
			   int nArgs);
  virtual const char *messageText(const char *source, int num) = 0;
  void setCurrentLocation(const Location &);
  void addOption(Option);
private:
  void appendNumber(unsigned long);
  void appendOrdinal(unsigned long);
  void appendChars(const Char *, size_t);
  void appendEntityManagerArg(const EntityManagerMessageArg *);
  void appendFragment(int);
  const ExternalInfo *locationHeader(const Location &loc, Offset &off);
  Boolean printLocation(const ExternalInfo *info, Offset off);
  OutputCharStream &os();

  OutputCharStream *os_;
  Location currentLocation_;	// when used as InputContext
  unsigned options_;
};

inline
OutputCharStream &MessageReporter::os()
{
  return *os_;
}

#endif /* not MessageReporter_INCLUDED */
