// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef OutputCharStream_INCLUDED
#define OutputCharStream_INCLUDED 1

#include "types.H"
#include <stddef.h>
#include "CString.H"

class streambuf;
class OutputCodingSystem;
class Encoder;

class OutputCharStream {
public:
  OutputCharStream();
  virtual ~OutputCharStream();
  OutputCharStream &put(Char);
  OutputCharStream &write(const Char *, size_t);
  virtual void flush() = 0;

  OutputCharStream &operator<<(char);
  OutputCharStream &operator<<(const char *);
  OutputCharStream &operator<<(const CString &);
  OutputCharStream &operator<<(unsigned long);
  OutputCharStream &operator<<(int);
private:
  OutputCharStream(const OutputCharStream &);	// not defined
  void operator=(const OutputCharStream &);	// not defined

  virtual void flushBuf(Char) = 0;
protected:
  Char *ptr_;
  Char *end_;
};

class IosOutputCharStream : public OutputCharStream {
public:
  IosOutputCharStream();
  // the streambuf will not be deleted
  IosOutputCharStream(streambuf *, const OutputCodingSystem *);
  ~IosOutputCharStream();
  void open(streambuf *, const OutputCodingSystem *);
  void flush();
private:
  IosOutputCharStream(const IosOutputCharStream &); // not defined
  void operator=(const IosOutputCharStream &);	    // not defined
  void allocBuf(int bytesPerChar);
  void flushBuf(Char);
  Char *buf_;
  streambuf *byteStream_;
  Encoder *encoder_;
};

class StrOutputCharStream : public OutputCharStream {
public:
  StrOutputCharStream();
  void extractString(CString &);
  void flush();
private:
  void flushBuf(Char);
  void sync(size_t);
  StrOutputCharStream(const StrOutputCharStream &); // not defined
  void operator=(const StrOutputCharStream &);	    // not defined
  CString str_;
};

inline
OutputCharStream &OutputCharStream::put(Char c)
{
  if (ptr_ < end_)
    *ptr_++ = c;
  else
    flushBuf(c);
  return *this;
}

inline
OutputCharStream &OutputCharStream::operator<<(char c)
{
  return put(Char(c));
}

inline
OutputCharStream &OutputCharStream::operator<<(const CString &str)
{
  return write(str.pointer(), str.length());
}

#endif /* not OutputCharStream_INCLUDED */
