// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef RastEventHandler_INCLUDED
#define RastEventHandler_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Event.H"
#include "GrowableVectorD.H"
#include "GrowableVector.H"
#include "Boolean.H"
#include "Vector.H"
#include "CString.H"
#include "types.H"
#include "OutputCharStream.H"
#include "LinkProcess.H"
#include "InputContext.H"

#include <limits.h>
#include <stddef.h>

class AttributeList;
class ExternalDataEntity;
class SubdocEntity;
class ExternalId;
class InternalEntity;
class SgmlParser;

class RastPrintable {
public:
  RastPrintable();
  int operator()(Char c) const;
private:
  char v_[UCHAR_MAX + 1];
};

class RastEventHandler;

class RastLinkProcess : public LinkProcess {
public:
  RastLinkProcess();
  void setHandler(RastEventHandler *);
  Boolean selectLinkRule(const AttributeList **linkAttributes,
			 size_t nLinkAttributes,
			 size_t &selected);
  void moveTo(RastLinkProcess &);
private:
  Boolean selectLinkRulePi(const CString &str,
			   const AttributeList **linkAttributes,
			   size_t nLinkAttributes,
			   size_t &selected);
  Boolean parseNamesValues(const CString &,
			   GrowableVectorD<CString> &names,
			   GrowableVectorD<CString> &values);

  RastLinkProcess(const RastLinkProcess &); // undefined
  void operator=(RastLinkProcess &);	    // undefined
  RastEventHandler *rast_;
};

class RastSubdocState {
public:
  RastSubdocState();
  RastSubdocState(SgmlParser *, RastEventHandler *);
  void init(SgmlParser *, RastEventHandler *);
  void moveTo(RastSubdocState &);
protected:
  SgmlParser *parser_;
  Boolean hadActiveLpdOrDtd_;
  GrowableVectorD<CString> activeLinkTypes_;
  Boolean hadDocumentElement_;
  RastLinkProcess linkProcess_;
  Boolean haveLinkProcess_;
  GrowableVectorD<Owner<SimpleLinkEvent> > simpleLinkEvents_;
  GrowableVector<PackedBoolean> parseSubdocQueue_;
  GrowableVectorD<CString> linkRuleQueue_;
  enum AttributeType {
    dtdAttribute,
    linkAttribute,
    resultAttribute,
    simpleAttribute
    };
  enum { nAttributeType = simpleAttribute + 1 };
  GrowableVectorD<Vector<size_t> > attributeSortOrder_[nAttributeType];
private:
  RastSubdocState(const RastSubdocState &); // undefined
  void operator=(const RastSubdocState &);  // undefined
  friend class RastLinkProcess;
};

class RastEventHandler : public EventHandler, private RastSubdocState,
                         private InputContext {
public:
  RastEventHandler(SgmlParser *, InputContext *);
  void data(DataEvent *);
  void startElement(StartElementEvent *);
  void endElement(EndElementEvent *);
  void pi(PiEvent *);
  void sdataEntity(SdataEntityEvent *);
  void externalDataEntity(ExternalDataEntityEvent *);
  void subdocEntity(SubdocEntityEvent *);
  void sgmlDecl(SgmlDeclEvent *);
  void message(MessageEvent *);
  void simpleLink(SimpleLinkEvent *);
  void complexLink(ComplexLinkEvent *);
  void uselink(UselinkEvent *);
  virtual void truncateOutput();
  void end();
  void setOutputStream(OutputCharStream *os);
  Boolean hadError() const;
protected:
  void inputContextMessage(const char *source,
			   const Location &loc,
			   unsigned flags, int number,
			   const MessageArg **args,
			   int nArgs);
private:
  RastEventHandler(const RastEventHandler &); // undefined
  void operator=(const RastEventHandler &);   // undefined

  enum LineType { dataLine = '|', markupLine = '!' };
  void lines(LineType, const Char *p, size_t length);
  enum { maxLineLength = 60 };
  enum { RS = '\n', RE = '\r', TAB = '\t' };
  static const RastPrintable printable;
  int lineLength_;
  OutputCharStream *os_;
  CString rastParseSubdocYesString_;
  CString rastParseSubdocNoString_;
  CString rastActiveLpdString_;
  CString rastLinkRuleString_;
  enum { sgmlError = 01, piError = 02 };
  unsigned errorFlags_;
  InputContext *ic_;

  int lexCmp(const CString &s1, const CString &s2);
  void flushLine(LineType);
  void attributeInfo(const AttributeList &, AttributeType);
  void externalEntityInfo(const ExternalDataEntity *, AttributeType);
  void subdocEntityInfo(const SubdocEntity *,
			const ResourcePointer<EntityOrigin> &entityOrigin);
  void externalIdInfo(const ExternalId &);
  void internalEntityInfo(const InternalEntity *);
  void queueParseSubdoc(Boolean);
  Boolean parseNextSubdoc();
  Boolean interpretRastPi(const Char *data, size_t dataLength);
  void activeLinks();
  void simpleLinkInfo();
  void impliedSourceLinkRules();
  
  OutputCharStream &os();
  friend class RastLinkProcess;
};

inline
int RastPrintable::operator()(Char c) const
{
  return c <= UCHAR_MAX ? v_[c] : 0;
}

inline
void RastEventHandler::setOutputStream(OutputCharStream *os)
{
  os_ = os;
}

inline
OutputCharStream &RastEventHandler::os()
{
  return *os_;
}

inline
Boolean RastEventHandler::hadError() const
{
  return errorFlags_ != 0;
}

#endif /* not RastEventHandler_INCLUDED */
