// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include <sys/types.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stddef.h>

#include "programName.H"

static
void ewrite(const char *s)
{
  int n = (int)strlen(s);
  while (n > 0) {
    int nw = write(2, s, n);
    if (nw < 0)
      break;
    n -= nw;
    s += nw;
  }
}

static
void outOfMemory()
{
  ewrite(programName);
  ewrite(": out of memory\n");
  exit(1);
}

void *operator new(size_t n)
{
  void *p = malloc(n);
  if (!p)
    outOfMemory();
  return p;
}
