// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "CodingSystem.H"
#include <strstream.h>
#include <string.h>

InputCodingSystem::~InputCodingSystem()
{
}

int InputCodingSystem::minBytesPerChar() const
{
  return 1;
}

CString InputCodingSystem::convertIn(const char *s) const
{
  Decoder *decoder = makeDecoder();
  CString str;
  str.setLength(strlen(s));
  str.setLength(decoder->decode(&str[0], s, strlen(s), &s));
  delete decoder;
  return str;
}

OutputCodingSystem::~OutputCodingSystem()
{
}

int OutputCodingSystem::fixedBytesPerChar() const
{
  return 0;
}

String<char> OutputCodingSystem::convertOut(const CString &str) const
{
  Encoder *encoder = makeEncoder();
  strstreambuf stream;
  CString copy(str);
  encoder->output(copy.pointer(), copy.length(), &stream);
  delete encoder;
  char *s = stream.str();
  String<char> result(s, stream.out_waiting());
  result += '\0';
  delete [] s;
#ifdef __lucid
  // Workaround lcc bug (3.1p2 with -O -XF).
  String<char> temp(result);
  return temp;
#else
  return result;
#endif
}

Decoder::~Decoder()
{
}

Boolean Decoder::convertOffset(unsigned long &) const
{
  return false;
}

Encoder::~Encoder()
{
}

void Encoder::output(Char *s, size_t n, streambuf *sp)
{
  output((const Char *)s, n, sp);
}
