// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef CodingSystem_INCLUDED
#define CodingSystem_INCLUDED 1

#include "types.H"
#include "Boolean.H"
#include "CString.H"

#include <stddef.h>

class Decoder {
public:
  virtual ~Decoder();
  virtual size_t decode(Char *, const char *, size_t, const char **) = 0;
  virtual Boolean convertOffset(unsigned long &offset) const;
};

class streambuf;

class Encoder {
public:
  virtual ~Encoder();
  virtual void output(const Char *, size_t, streambuf *) = 0;
  virtual void output(Char *, size_t, streambuf *);
};

class InputCodingSystem {
public:
  virtual ~InputCodingSystem();
  virtual Decoder *makeDecoder() const = 0;
  // must be > 0
  virtual int minBytesPerChar() const;
  CString convertIn(const char *) const;
};

class OutputCodingSystem {
public:
  virtual ~OutputCodingSystem();
  virtual Encoder *makeEncoder() const = 0;
  virtual int fixedBytesPerChar() const;
  String<char> convertOut(const CString &) const;
};

class CodingSystem : public InputCodingSystem, public OutputCodingSystem {
};

#endif /* not CodingSystem_INCLUDED */
