// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef DescriptorManager_INCLUDED
#define DescriptorManager_INCLUDED 1

#include "Boolean.H"
#include "List.H"

class DescriptorManager;

class DescriptorUser {
public:
  DescriptorUser(DescriptorManager *);
  virtual ~DescriptorUser();
  virtual Boolean suspend();
  void managerDeleted();
  void acquireD();
  void releaseD();
  DescriptorManager *manager() const;
private:
  DescriptorManager *manager_;
};

class DescriptorManager {
public:
  DescriptorManager(int maxD);
  DescriptorManager(const DescriptorManager &);	// undefined
  void operator=(const DescriptorManager &);	// undefined
  ~DescriptorManager();
  void acquireD();
  void releaseD();
  void addUser(DescriptorUser *);
  void removeUser(DescriptorUser *);
private:
  int usedD_;
  int maxD_;
  List<DescriptorUser *> users_;
};

#endif /* not DescriptorManager_INCLUDED */
