// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef ErrnoMessageArg_INCLUDED
#define ErrnoMessageArg_INCLUDED 1

#include "MessageArg.H"
#include "rtti.H"

class ErrnoMessageArg : public EntityManagerMessageArg {
  RTTI_CLASS
public:
  ErrnoMessageArg(int errnum) : errno_(errnum) { }
  MessageArg *copy() const;
  // errno might be a macro so we must use a different name
  int errnum() const;
private:
  int errno_;
};

inline
int ErrnoMessageArg::errnum() const
{
  return errno_;
}

#endif /* not ErrnoMessageArg_INCLUDED */
